/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.blacktie.btadmin.commands;

import java.util.Properties;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jboss.narayana.blacktie.administration.BlacktieAdministration;
import org.jboss.narayana.blacktie.btadmin.Command;
import org.jboss.narayana.blacktie.btadmin.CommandFailedException;
import org.jboss.narayana.blacktie.btadmin.IncompatibleArgsException;

public class Advertise
implements Command {
    private static Logger log = LogManager.getLogger(Advertise.class);
    private String serverName;
    private String serviceName;

    public String getQuickstartUsage() {
        return "<serverName> <serviceName>";
    }

    public void initializeArgs(String[] args) throws IncompatibleArgsException {
        this.serverName = args[0];
        this.serviceName = args[1];
    }

    public void invoke(BlacktieAdministration connection, Properties configuration) throws CommandFailedException {
        Boolean advertise = connection.advertise(this.serverName, this.serviceName);
        if (!advertise.booleanValue()) {
            log.error((Object)"Service could not be advertised");
            throw new CommandFailedException(-1);
        }
        log.info((Object)"Service advertised");
    }
}

