/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.blacktie.btadmin.commands;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jboss.narayana.blacktie.administration.BlacktieAdministration;
import org.jboss.narayana.blacktie.btadmin.Command;
import org.jboss.narayana.blacktie.btadmin.CommandFailedException;
import org.jboss.narayana.blacktie.btadmin.CommandHandler;
import org.jboss.narayana.blacktie.btadmin.IncompatibleArgsException;

public class Help
implements Command {
    private static Logger log = LogManager.getLogger(Help.class);
    private String command;

    public String getQuickstartUsage() {
        return "[command]";
    }

    public void initializeArgs(String[] args) throws IncompatibleArgsException {
        if (args.length > 0) {
            this.command = args[0];
        }
    }

    public void invoke(BlacktieAdministration connection, Properties configuration) throws CommandFailedException {
        ArrayList<String> commands = new ArrayList<String>();
        try {
            Class<?> cls = this.getClass();
            ProtectionDomain pDomain = cls.getProtectionDomain();
            CodeSource cSource = pDomain.getCodeSource();
            URL loc = cSource.getLocation();
            JarFile jar = new JarFile(new File(loc.toURI()));
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry nextElement = entries.nextElement();
                String jarEntry = nextElement.getName();
                if (!jarEntry.matches("org/jboss/narayana/blacktie/btadmin/commands/\\w+.class")) continue;
                String commandName = jarEntry.substring(jarEntry.lastIndexOf(47) + 1, jarEntry.indexOf(46));
                String firstLetter = commandName.substring(0, 1);
                String remainder = commandName.substring(1);
                String capitalized = firstLetter.toLowerCase() + remainder;
                commands.add(capitalized);
            }
            if (commands.size() == 0) {
                log.error((Object)"Could not find any commands");
                throw new CommandFailedException(-1);
            }
        }
        catch (Throwable e) {
            log.debug((Object)"Was not loaded from a jar");
            try {
                Class[] classes = Help.getClasses("org.jboss.narayana.blacktie.btadmin.commands");
                for (int i = 0; i < classes.length; ++i) {
                    String commandName = classes[i].getName().substring(classes[i].getName().lastIndexOf(46) + 1);
                    String firstLetter = commandName.substring(0, 1);
                    String remainder = commandName.substring(1);
                    String capitalized = firstLetter.toLowerCase() + remainder;
                    commands.add(capitalized);
                }
            }
            catch (Throwable e2) {
                log.error((Object)"Could not find any commands");
                throw new CommandFailedException(-1);
            }
        }
        for (int i = 0; i < commands.size(); ++i) {
            if (this.command != null && !this.command.equals(commands.get(i))) continue;
            try {
                Command command = CommandHandler.loadCommand((String)commands.get(i));
                log.info((Object)("Quickstart usage: " + (String)commands.get(i) + " " + command.getQuickstartUsage()));
                continue;
            }
            catch (Exception e) {
                log.error((Object)("Could not get help for command: " + (String)commands.get(i)), (Throwable)e);
                throw new CommandFailedException(-1);
            }
        }
    }

    private static Class[] getClasses(String packageName) throws ClassNotFoundException, IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        assert (classLoader != null);
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = classLoader.getResources(path);
        ArrayList<File> dirs = new ArrayList<File>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            dirs.add(new File(resource.getFile()));
        }
        ArrayList classes = new ArrayList();
        for (File directory : dirs) {
            File[] files;
            for (File file : files = directory.listFiles()) {
                if (!file.getName().endsWith(".class") || file.getName().indexOf(36) >= 0) continue;
                classes.add(Class.forName(packageName + '.' + file.getName().substring(0, file.getName().length() - 6)));
            }
        }
        return classes.toArray(new Class[classes.size()]);
    }
}

