/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jbossts.fileio.xalib.txdirs.dir;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.commons.transaction.file.FileResourceManager;
import org.apache.commons.transaction.file.ResourceManagerException;
import org.jboss.jbossts.fileio.xalib.txdirs.dir.XADir;

public class XADirFile
implements Serializable {
    private transient FileResourceManager freMngr;
    private String curTxId;
    private String curObjId;
    private XADir xadir;
    private String filename;

    public XADirFile(File file, XADir xadir) {
        this.filename = file.getName();
        this.freMngr = xadir.getFreMngr();
        this.curTxId = xadir.getCurTxId();
        this.curObjId = "/" + file.getName();
        this.xadir = xadir;
    }

    public String getName() {
        return this.filename;
    }

    public InputStream readResource() throws ResourceManagerException {
        try {
            String obj = this.freMngr.getStoreDir() + this.curObjId;
            return new FileInputStream(new File(obj));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }

    public OutputStream writeResource() throws ResourceManagerException {
        return this.freMngr.writeResource((Object)this.curTxId, (Object)this.curObjId);
    }

    public synchronized boolean renameTo(File file) {
        String resId = "/" + file.getName();
        try {
            this.freMngr.lockResource((Object)this.curObjId, (Object)this.curTxId, false, false, 0L, true);
            this.freMngr.copyResource((Object)this.curTxId, (Object)this.curObjId, (Object)resId, true);
            this.freMngr.deleteResource((Object)this.curTxId, (Object)this.curObjId);
            this.curObjId = resId;
            this.filename = file.getName();
            return true;
        }
        catch (ResourceManagerException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean createNewFile() {
        try {
            this.freMngr.createResource((Object)this.curTxId, (Object)this.curObjId, false);
            this.xadir.increaseLength();
            return true;
        }
        catch (ResourceManagerException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean delete() {
        try {
            this.freMngr.lockResource((Object)this.curObjId, (Object)this.curTxId, false, false, 0L, true);
            this.freMngr.deleteResource((Object)this.curTxId, (Object)this.curObjId, false);
            this.xadir.decreaseLength();
            return true;
        }
        catch (ResourceManagerException e) {
            e.printStackTrace();
            return false;
        }
    }
}

