/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jbossts.fileio.xalib.txdirs.dir;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.transaction.file.FileResourceManager;
import org.apache.commons.transaction.file.ResourceManagerException;
import org.apache.commons.transaction.file.ResourceManagerSystemException;
import org.apache.commons.transaction.util.CommonsLoggingLogger;
import org.apache.commons.transaction.util.LoggerFacade;
import org.jboss.jbossts.fileio.xalib.txdirs.dir.XADir;

public class XAFileResourceManager
implements XAResource,
Serializable {
    private Xid currentXid;
    private String curTxId;
    private transient FileResourceManager freMngr;
    private boolean recovers;
    private String storeDir;

    public XAFileResourceManager(FileResourceManager freMngr, String curTxId) {
        this.freMngr = freMngr;
        this.curTxId = curTxId;
        this.storeDir = freMngr.getStoreDir();
        this.recovers = false;
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        System.out.println("XAFileResourceManager.prepare(Xid=" + xid + ")");
        try {
            return this.freMngr.prepareTransaction((Object)this.curTxId);
        }
        catch (ResourceManagerException rme) {
            throw new XAException(rme.getMessage());
        }
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        System.out.println("XAFileResourceManager.commit(Xid=" + xid + ", onePhase=" + onePhase + ")");
        if (!xid.equals(this.currentXid)) {
            System.out.println("XAFileResourceManager.commit - wrong Xid!");
        }
        try {
            if (!this.recovers) {
                this.freMngr.commitTransaction((Object)this.curTxId);
            }
        }
        catch (ResourceManagerException rme) {
            throw new XAException(rme.getMessage());
        }
        this.currentXid = null;
    }

    @Override
    public void end(Xid xid, int flags) {
        System.out.println("XAFileResourceManager.end(Xid=" + xid + ", flags=" + flags + ")");
    }

    @Override
    public void forget(Xid xid) {
        System.out.println("XAFileResourceManager.forget(Xid=" + xid + ")");
        if (!xid.equals(this.currentXid)) {
            System.out.println("XAFileResourceManager.forget - wrong Xid!");
        }
        this.currentXid = null;
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        try {
            int timeout = (int)this.freMngr.getTransactionTimeout((Object)this.curTxId) / 1000;
            System.out.println("XAFileResourceManager.getTransactionTimeout() [returning " + timeout + "]");
            return timeout;
        }
        catch (ResourceManagerException rme) {
            throw new XAException(rme.getMessage());
        }
    }

    @Override
    public boolean isSameRM(XAResource xares) throws XAException {
        System.out.println("XAFileResourceManager.isSameRM(xaresMngr=" + xares + ")");
        return false;
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        System.out.println("XAFileResourceManager.recover(flag=" + flag + ")");
        return new Xid[0];
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        System.out.println("XAFileResourceManager.rollback(Xid=" + xid + ")");
        try {
            this.freMngr.rollbackTransaction((Object)this.curTxId);
        }
        catch (ResourceManagerException rme) {
            throw new XAException(rme.getMessage());
        }
        this.currentXid = null;
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        System.out.println("XAFileResourceManager.setTransactionTimeout(timeout=" + seconds + ")");
        try {
            this.freMngr.setTransactionTimeout((Object)this.curTxId, (long)(seconds * 1000));
        }
        catch (ResourceManagerException rme) {
            throw new XAException(rme.getMessage());
        }
        return false;
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        System.out.println("XAFileResourceManager.start(Xid=" + xid + ", flags=" + flags + ")");
        if (this.currentXid != null) {
            System.out.println("XAFileResourceManager.start - wrong Xid!");
            throw new XAException("Current Transaction is: <" + this.currentXid + ">\nCannot start the new Transaction.");
        }
        try {
            this.freMngr.startTransaction((Object)this.curTxId);
        }
        catch (ResourceManagerException rme) {
            throw new XAException(rme.getMessage());
        }
        this.currentXid = xid;
    }

    public Xid getCurrentXid() {
        return this.currentXid;
    }

    private void initFREM() {
        String workDir = this.storeDir + "/" + "txDir_work";
        this.freMngr = new FileResourceManager(this.storeDir, workDir, false, (LoggerFacade)new CommonsLoggingLogger(LogFactory.getLog((String)XADir.class.getName())));
        try {
            this.freMngr.start();
        }
        catch (ResourceManagerSystemException e) {
            e.printStackTrace();
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.recovers = true;
        this.initFREM();
    }
}

