/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jbossts.fileio.xalib.txfiles.file;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.Hashtable;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.jbossts.fileio.DataOutputStream;
import org.jboss.jbossts.fileio.xalib.txfiles.exceptions.DuplicateTransactionsException;
import org.jboss.jbossts.fileio.xalib.txfiles.exceptions.LockRefusedException;
import org.jboss.jbossts.fileio.xalib.txfiles.file.DataRecord;
import org.jboss.jbossts.fileio.xalib.txfiles.file.XAResourceManager;
import org.jboss.jbossts.fileio.xalib.txfiles.locking.XALock;
import org.jboss.jbossts.fileio.xalib.txfiles.locking.XALockManager;
import org.jboss.jbossts.fileio.xalib.txfiles.logging.RecordsLogger;

public class XAFile
implements DataInput,
DataOutput,
Serializable,
Closeable {
    private String filename;
    private String mode;
    private transient RandomAccessFile raf;
    private Hashtable<Long, XAResourceManager> xares;
    private transient XALockManager xaLockManager;
    private transient File loggingFolder;
    private transient File locksFolder;
    private transient boolean transactionsEnabled;

    public XAFile(String filename, String mode, boolean transactionsEnabled) throws IOException {
        this.raf = new RandomAccessFile(filename, mode);
        this.loggingFolder = new File("Logging");
        this.locksFolder = new File("Locks/");
        this.filename = filename;
        this.mode = mode;
        this.transactionsEnabled = transactionsEnabled;
        this.xares = new Hashtable();
        this.initLocksHeld();
        this.prepareFolders();
    }

    private void prepareFolders() {
        if (!this.loggingFolder.exists()) {
            this.loggingFolder.mkdir();
        }
        if (!this.locksFolder.exists()) {
            this.locksFolder.mkdir();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void newTransaction(TransactionManager txnMngr) throws DuplicateTransactionsException, IOException, SystemException, RollbackException {
        if (!this.transactionsEnabled) throw new IllegalStateException("Transactional support is set to be disabled. Enable using the setTransactionsEnabled() method.");
        if (txnMngr.getStatus() != 0) throw new SystemException("The newTransaction() method must be called only when TransactionManager's status is ACTIVE, after the manager has begun.");
        long th_id = Thread.currentThread().getId();
        if (this.xares.containsKey(th_id)) {
            throw new DuplicateTransactionsException("Cannot create a new Transaction. There is already a thread with id=<" + th_id + "> associated with that " + "Transaction.");
        }
        String logName = this.loggingFolder.getPath() + '/' + th_id + '_' + System.nanoTime();
        RecordsLogger log = new RecordsLogger(logName);
        XAResourceManager xareMngr = new XAResourceManager(this, log, th_id);
        this.xares.put(th_id, xareMngr);
        Transaction txn = txnMngr.getTransaction();
        txn.enlistResource((XAResource)xareMngr);
    }

    public RandomAccessFile getRAF() {
        return this.raf;
    }

    @Override
    public void close() throws IOException {
        if (!this.xares.isEmpty()) {
            throw new IOException("Failed to close the file. There are incomplete Transactions.");
        }
        this.raf.close();
        if (this.xaLockManager.obtainHeldLocksWith(null).isEmpty()) {
            this.xaLockManager.deleteFile();
        }
    }

    protected void sync() throws IOException {
        FileDescriptor fd = this.raf.getFD();
        fd.sync();
    }

    public synchronized void flush() throws IOException {
        long curPos = this.raf.getFilePointer();
        this.raf.close();
        this.raf = new RandomAccessFile(this.filename, this.mode);
        this.raf.seek(curPos);
    }

    public void seek(long position) throws IOException {
        this.raf.seek(position);
    }

    public void setTransactionsEnabled(boolean transactionsEnabled) {
        this.transactionsEnabled = transactionsEnabled;
    }

    private String getErrMsg(long th_id) {
        return "Failed to update source file. The thread with id=<" + th_id + "> is not associated with any Transaction";
    }

    protected synchronized void commitUpdates(long position, int recordLength, byte[] data, long th_id) throws IOException {
        if (th_id != -100L && th_id != this.getCurrentThreadId()) {
            throw new IllegalStateException(this.getErrMsg(th_id));
        }
        long curPos = this.raf.getFilePointer();
        this.commitUpdates(position, recordLength, data);
        this.raf.seek(curPos);
    }

    private void commitUpdates(long position, int recordLength, byte[] data) throws IOException {
        this.raf.seek(position);
        this.raf.write(data, 0, recordLength);
    }

    protected synchronized void removeTransaction(Xid xid, boolean recovers) throws IOException {
        if (!recovers) {
            long th_id = this.getCurrentThreadId();
            this.xares.remove(th_id);
        }
        this.xaLockManager.releaseLocks(xid);
    }

    protected void initLocksHeld() throws IOException {
        this.xaLockManager = new XALockManager(this.filename);
    }

    private int acquireLockOn(DataRecord dr, Xid xid, int mode) throws IOException {
        XALock xaLock = new XALock(xid, mode, dr.getStartPosition(), dr.getRecordLength());
        int res = this.xaLockManager.tryLock(xaLock);
        if (res == 1) {
            String msg = "REFUSED:WRITE_LOCK on byte(s): " + dr.getRecordStr();
            if (mode == 0) {
                msg = "REFUSED:READ_LOCK on byte(s): " + dr.getRecordStr();
            }
            throw new LockRefusedException(msg);
        }
        if (res == 0) {
            String msg = "GRANTED:WRITE_LOCK on byte(s): " + dr.getRecordStr();
            if (mode == 0) {
                msg = "GRANTED:READ_LOCK on byte(s): " + dr.getRecordStr();
            }
        }
        return res;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getMode() {
        return this.mode;
    }

    private synchronized int[] readRecord(int len) throws IOException {
        if (this.transactionsEnabled) {
            long curThread = this.getCurrentThreadId();
            XAResourceManager xare = this.xares.get(curThread);
            Hashtable<Long, Integer> updatedBytes = xare.getUpdatedBytes();
            int[] upds = new int[len];
            long startPos = this.raf.getFilePointer();
            for (int i = 0; i < len; ++i) {
                if (updatedBytes.containsKey(startPos)) {
                    upds[i] = updatedBytes.get(startPos++);
                    this.raf.seek(this.raf.getFilePointer() + 1L);
                    continue;
                }
                upds[i] = this.raf.read();
            }
            DataRecord dr = new DataRecord(this.raf.getFilePointer() - (long)len, len, upds);
            this.acquireLockOn(dr, xare.getXid(), 0);
            return upds;
        }
        return this.readDirectlyFromFile(len);
    }

    public int[] readDirectlyFromFile(int len) throws IOException {
        int[] buffer = new int[len];
        for (int b = 0; b < len; ++b) {
            buffer[b] = this.raf.read();
        }
        return buffer;
    }

    @Override
    public boolean readBoolean() throws IOException {
        byte ch = this.readByte();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch != 0;
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public int readUnsignedShort() throws IOException {
        int ch2;
        int[] ints = this.readRecord(2);
        int ch1 = ints[0];
        if ((ch1 | (ch2 = ints[1])) < 0) {
            throw new EOFException();
        }
        return (ch1 << 8) + ch2;
    }

    @Override
    public void readFully(byte[] bytes) throws IOException {
        this.readFully(bytes, 0, bytes.length);
    }

    @Override
    public void readFully(byte[] bytes, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > bytes.length) {
            throw new IndexOutOfBoundsException("bytes.length=" + bytes.length + ", off=" + off + ", len=" + len);
        }
        byte[] bs = XAFile.getBytesFromInts(this.readRecord(len));
        System.arraycopy(bs, 0, bytes, off, len);
    }

    @Override
    public short readShort() throws IOException {
        int ch2;
        int[] ints = this.readRecord(2);
        int ch1 = ints[0];
        if ((ch1 | (ch2 = ints[1])) < 0) {
            throw new EOFException();
        }
        return (short)((ch1 << 8) + ch2);
    }

    @Override
    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public int readInt() throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int[] ints = this.readRecord(4);
        int ch1 = ints[0];
        if ((ch1 | (ch2 = ints[1]) | (ch3 = ints[2]) | (ch4 = ints[3])) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
    }

    @Override
    public int readUnsignedByte() throws IOException {
        byte ch = this.readByte();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch;
    }

    @Override
    public byte readByte() throws IOException {
        int[] ints = this.readRecord(1);
        return ints != null ? (byte)ints[0] : (byte)-1;
    }

    @Override
    public String readLine() throws IOException {
        StringBuffer input = new StringBuffer();
        int c = -1;
        boolean eol = false;
        block4: while (!eol) {
            byte by = this.readByte();
            c = by;
            switch (by) {
                case -1: 
                case 10: {
                    eol = true;
                    continue block4;
                }
                case 13: {
                    eol = true;
                    long cur = this.raf.getFilePointer();
                    if (this.readByte() == 10) continue block4;
                    this.raf.seek(cur);
                    continue block4;
                }
            }
            input.append((char)c);
        }
        if (c == -1 && input.length() == 0) {
            return null;
        }
        return input.toString();
    }

    public int read(byte[] bytes) throws IOException {
        return this.read(bytes, 0, bytes.length);
    }

    public int read(byte[] bytes, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > bytes.length) {
            throw new IndexOutOfBoundsException("bytes.length=" + bytes.length + ", off=" + off + ", len=" + len);
        }
        if (bytes.length == 0) {
            return 0;
        }
        byte[] bs = XAFile.getBytesFromInts(this.readRecord(len));
        System.arraycopy(bs, 0, bytes, off, len);
        return bs.length;
    }

    public String readChars(char[] chars) throws IOException {
        for (int c = 0; c < chars.length; ++c) {
            chars[c] = this.readChar();
        }
        return new String(chars);
    }

    @Override
    public char readChar() throws IOException {
        int ch2;
        int[] ints = this.readRecord(2);
        int ch1 = ints[0];
        if ((ch1 | (ch2 = ints[1])) < 0) {
            throw new EOFException();
        }
        return (char)((ch1 << 8) + ch2);
    }

    @Override
    public long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    @Override
    public void writeLong(long l) throws IOException {
        int[] ls = new int[]{(int)(l >>> 56) & 0xFF, (int)(l >>> 48) & 0xFF, (int)(l >>> 40) & 0xFF, (int)(l >>> 32) & 0xFF, (int)(l >>> 24) & 0xFF, (int)(l >>> 16) & 0xFF, (int)(l >>> 8) & 0xFF, (int)l & 0xFF};
        this.writeRecord(ls);
    }

    @Override
    public void write(int b) throws IOException {
        this.writeRecord(new int[]{b});
    }

    @Override
    public void writeInt(int n) throws IOException {
        int[] ls = new int[]{n >>> 24 & 0xFF, n >>> 16 & 0xFF, n >>> 8 & 0xFF, n & 0xFF};
        this.writeRecord(ls);
    }

    @Override
    public void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    @Override
    public void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    @Override
    public void writeBoolean(boolean b) throws IOException {
        this.write(b ? 1 : 0);
    }

    @Override
    public synchronized void writeByte(int b) throws IOException {
        this.write(b);
    }

    private synchronized void writeRecord(int[] bytes) throws IOException {
        if (this.transactionsEnabled) {
            long curthr = this.getCurrentThreadId();
            XAResourceManager xareMngr = this.xares.get(curthr);
            DataRecord dr = new DataRecord(this.raf.getFilePointer(), bytes.length, bytes);
            int lockRes = this.acquireLockOn(dr, xareMngr.getXid(), 1);
            if (lockRes == 0) {
                xareMngr.addUpdatedBytes(this.raf.getFilePointer(), bytes);
                xareMngr.add2Log(dr);
                this.raf.skipBytes(bytes.length);
            }
        } else {
            this.commitUpdates(this.raf.getFilePointer(), bytes.length, XAFile.getBytesFromInts(bytes));
        }
    }

    @Override
    public void writeShort(int s) throws IOException {
        int[] ss = new int[]{s >>> 8 & 0xFF, s & 0xFF};
        this.writeRecord(ss);
    }

    @Override
    public void write(byte[] bytes, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > bytes.length) {
            throw new IndexOutOfBoundsException("bytes.length=" + bytes.length + ", off=" + off + ", len=" + len);
        }
        byte[] newByteArray = new byte[len];
        System.arraycopy(bytes, off, newByteArray, 0, len);
        this.writeRecord(XAFile.getIntsFromBytes(newByteArray));
    }

    @Override
    public void writeChars(String s) throws IOException {
        int clen = s.length();
        int blen = 2 * clen;
        byte[] b = new byte[blen];
        char[] c = new char[clen];
        s.getChars(0, clen, c, 0);
        int j = 0;
        for (int i = 0; i < clen; ++i) {
            b[j++] = (byte)(c[i] >>> 8);
            b[j++] = (byte)c[i];
        }
        this.write(b, 0, blen);
    }

    @Override
    public void writeChar(int ch) throws IOException {
        int[] chs = new int[]{ch >>> 8 & 0xFF, ch & 0xFF};
        this.writeRecord(chs);
    }

    @Override
    public void writeBytes(String bytes) throws IOException {
        int len = bytes.length();
        byte[] b = bytes.getBytes();
        this.write(b, 0, len);
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public void writeUTF(String str) throws IOException {
        DataOutputStream.writeUTF(str, this);
    }

    public long getFilePointer() throws IOException {
        return this.raf.getFilePointer();
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.raf.skipBytes(n);
    }

    public long length() throws IOException {
        return this.raf.length();
    }

    private long getCurrentThreadId() throws IOException {
        Thread th = Thread.currentThread();
        long th_id = th.getId();
        if (this.xares.isEmpty() || !this.xares.containsKey(th_id)) {
            throw new IOException("There is no thread-transaction association. \nCurrent thread with id=<" + th_id + "> has not been registered " + "with any Transaction. Possibly a read/write operation happens outside " + "the scope of TransactionManager (begin - commit/rollback.) or the " + "\nnewTransaction() method has not been called after the TransactionManager " + "has begun.");
        }
        return th_id;
    }

    protected void initRAF() throws FileNotFoundException {
        this.raf = new RandomAccessFile(this.filename, this.mode);
    }

    protected static byte[] getBytesFromInts(int[] ints) {
        byte[] bytes = new byte[ints.length];
        for (int b = 0; b < ints.length; ++b) {
            bytes[b] = (byte)ints[b];
        }
        return bytes;
    }

    protected static int[] getIntsFromBytes(byte[] bytes) {
        int[] ints = new int[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            ints[i] = bytes[i];
        }
        return ints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.raf != null) {
                this.raf.close();
            }
        }
        finally {
            super.finalize();
        }
    }
}

