/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jbossts.fileio.xalib.txfiles.logging;

import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.LinkedList;
import org.jboss.jbossts.fileio.xalib.txfiles.logging.LogEntry;

public class RecordsLogger
implements Serializable {
    private String filename;
    private transient RandomAccessFile raf;

    public RecordsLogger(String filename) throws IOException {
        this.filename = filename;
        this.raf = new RandomAccessFile(filename, "rw");
    }

    public String getFilename() {
        return this.filename;
    }

    public synchronized LinkedList<LogEntry> readAllRecords() throws IOException {
        this.close();
        this.raf = new RandomAccessFile(this.filename, "r");
        LinkedList<LogEntry> records = new LinkedList<LogEntry>();
        boolean eof = false;
        do {
            try {
                long pos = this.raf.readLong();
                int len = this.raf.readInt();
                byte[] data = new byte[len];
                this.raf.read(data);
                LogEntry le = new LogEntry(pos, len, data);
                records.add(le);
            }
            catch (EOFException eofe) {
                eof = true;
            }
        } while (!eof);
        this.raf.close();
        return records;
    }

    public synchronized void addInfo(LogEntry le) throws IOException {
        this.raf.writeLong(le.getPosition());
        this.raf.writeInt(le.getRecordLength());
        this.raf.write(le.getData());
    }

    public void flush() throws IOException {
        FileDescriptor fd = this.raf.getFD();
        fd.sync();
    }

    public synchronized void close() {
        try {
            if (this.raf != null) {
                this.raf.close();
            }
        }
        catch (IOException ioe) {
            System.out.println("XXXX Error while processing file: " + this.filename + " XXXX");
        }
    }

    public synchronized void delete() {
        new File(this.filename).delete();
    }
}

