/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jbossts.txbridge.inbound;

import com.arjuna.ats.jta.TransactionManager;
import com.arjuna.mw.wst.TxContext;
import com.arjuna.mw.wst11.TransactionManagerFactory;
import com.arjuna.wst.SystemException;
import jakarta.transaction.Transaction;
import jakarta.xml.ws.handler.Handler;
import jakarta.xml.ws.handler.MessageContext;
import org.jboss.jbossts.txbridge.inbound.JaxWSTxInboundBridgeHandler;
import org.jboss.jbossts.txbridge.utils.txbridgeLogger;

public class OptionalJaxWSTxInboundBridgeHandler
implements Handler {
    private final JaxWSTxInboundBridgeHandler delegate = new JaxWSTxInboundBridgeHandler();

    public boolean handleMessage(MessageContext messageContext) {
        Boolean isOutbound;
        if (txbridgeLogger.logger.isTraceEnabled()) {
            txbridgeLogger.logger.trace((Object)"OptionalJaxWSTxInboundBridgeHandler.handleMessage()");
        }
        if ((isOutbound = (Boolean)messageContext.get((Object)"jakarta.xml.ws.handler.message.outbound")) == null) {
            return true;
        }
        if (isOutbound.booleanValue()) {
            return this.handleOutbound(messageContext);
        }
        return this.handleInbound(messageContext);
    }

    public boolean handleFault(MessageContext messageContext) {
        if (txbridgeLogger.logger.isTraceEnabled()) {
            txbridgeLogger.logger.trace((Object)"OptionalJaxWSTxInboundBridgeHandler.handleFault()");
        }
        if (this.isJTATransactionAvailable()) {
            return this.delegate.handleFault(messageContext);
        }
        return true;
    }

    public void close(MessageContext messageContext) {
        if (txbridgeLogger.logger.isTraceEnabled()) {
            txbridgeLogger.logger.trace((Object)"OptionalJaxWSTxInboundBridgeHandler.close()");
        }
    }

    private boolean handleInbound(MessageContext messageContext) {
        if (this.isWSATTransactionAvailable()) {
            return this.delegate.handleInbound(messageContext);
        }
        return true;
    }

    private boolean handleOutbound(MessageContext messageContext) {
        if (this.isJTATransactionAvailable()) {
            return this.delegate.handleOutbound(messageContext);
        }
        return true;
    }

    private boolean isWSATTransactionAvailable() {
        TxContext txContext = null;
        try {
            txContext = TransactionManagerFactory.transactionManager().currentTransaction();
        }
        catch (SystemException systemException) {
            // empty catch block
        }
        return txContext != null;
    }

    private boolean isJTATransactionAvailable() {
        Transaction transaction = null;
        try {
            transaction = TransactionManager.transactionManager().getTransaction();
        }
        catch (jakarta.transaction.SystemException systemException) {
            // empty catch block
        }
        return transaction != null;
    }
}

