/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jdbc;

import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.jdbc.BaseTransactionalDriverXAConnection;
import com.arjuna.ats.internal.jdbc.ConnectionControl;
import com.arjuna.ats.internal.jdbc.ConnectionImple;
import com.arjuna.ats.internal.jdbc.DynamicClass;
import com.arjuna.ats.internal.jdbc.TransactionalDriverXAConnection;
import com.arjuna.ats.jdbc.logging.jdbcLogger;
import com.arjuna.ats.jta.xa.RecoverableXAConnection;
import com.arjuna.common.internal.util.ClassloadingUtility;
import java.sql.SQLException;
import javax.sql.XAConnection;

public class DirectRecoverableConnection
extends BaseTransactionalDriverXAConnection
implements RecoverableXAConnection,
ConnectionControl,
TransactionalDriverXAConnection {
    private String _dynamic;
    private DynamicClass _dynamicConnection;

    public DirectRecoverableConnection() throws SQLException {
        if (jdbcLogger.logger.isTraceEnabled()) {
            jdbcLogger.logger.trace((Object)"DirectRecoverableConnection.DirectRecoverableConnection()");
        }
    }

    public DirectRecoverableConnection(String dbName, String user, String passwd, String dynamic, ConnectionImple conn) throws SQLException {
        if (jdbcLogger.logger.isTraceEnabled()) {
            jdbcLogger.logger.trace((Object)("DirectRecoverableConnection.DirectRecoverableConnection( " + dbName + ", " + user + ", " + passwd + ", " + dynamic + " )"));
        }
        this._dbName = dbName;
        this._user = user;
        this._passwd = passwd;
        this._dynamic = dynamic;
        this._theArjunaConnection = conn;
    }

    public boolean packInto(OutputObjectState os) {
        if (jdbcLogger.logger.isTraceEnabled()) {
            jdbcLogger.logger.trace((Object)"DirectRecoverableConnection.packInto ()");
        }
        try {
            os.packString(this._dbName);
            os.packString(this._user);
            os.packString(this._passwd);
            os.packString(this._dynamic);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean unpackFrom(InputObjectState os) {
        if (jdbcLogger.logger.isTraceEnabled()) {
            jdbcLogger.logger.trace((Object)"DirectRecoverableConnection.unpackFrom ()");
        }
        try {
            this._dbName = os.unpackString();
            this._user = os.unpackString();
            this._passwd = os.unpackString();
            this._dynamic = os.unpackString();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public XAConnection getCurrentConnection() throws SQLException {
        return this._theConnection;
    }

    @Override
    protected void createConnection() throws SQLException {
        if (jdbcLogger.logger.isTraceEnabled()) {
            jdbcLogger.logger.trace((Object)"DirectRecoverableConnection.createConnection");
        }
        if (this._dynamic == null || this._dynamic.equals("")) {
            throw new SQLException(jdbcLogger.i18NLogger.get_dynamicerror());
        }
        try {
            if (this._theDataSource == null) {
                this._dynamicConnection = (DynamicClass)ClassloadingUtility.loadAndInstantiateClass(DynamicClass.class, (String)this._dynamic, null);
                if (this._dynamicConnection == null) {
                    throw new SQLException(jdbcLogger.i18NLogger.get_dynamicerror());
                }
                this._theDataSource = this._dynamicConnection.getDataSource(this._dbName);
            }
            super.createConnection();
        }
        catch (Exception e) {
            jdbcLogger.i18NLogger.warn_connection_problem(e.getMessage(), e);
            SQLException sqlException = new SQLException(e.toString());
            sqlException.initCause(e);
            throw sqlException;
        }
    }
}

