/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jdbc;

import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.internal.jdbc.ConnectionControl;
import com.arjuna.ats.internal.jdbc.ConnectionImple;
import com.arjuna.ats.jdbc.TransactionalDriver;
import com.arjuna.ats.jdbc.logging.jdbcLogger;
import com.arjuna.ats.jta.TransactionManager;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class ConnectionManager {
    private static Set<ConnectionImple> _connections = new HashSet<ConnectionImple>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection create(String dbUrl, Properties info) throws SQLException {
        String user = info.getProperty("user", "");
        String passwd = info.getProperty("password", "");
        String dynamic = info.getProperty("DYNAMIC_CLASS", "");
        String poolConnections = info.getProperty("POOL_CONNECTIONS", "true");
        Object xaDataSource = info.get(TransactionalDriver.XADataSource);
        int maxConnections = Integer.valueOf(info.getProperty("MAXCONNECTIONS", "10"));
        if (dbUrl == null) {
            dbUrl = "";
        }
        boolean poolingEnabled = "true".equalsIgnoreCase(poolConnections);
        ConnectionImple conn = null;
        Set<ConnectionImple> set = _connections;
        synchronized (set) {
            if (poolingEnabled) {
                for (ConnectionImple connectionImple : _connections) {
                    ConnectionControl connControl = connectionImple.connectionControl();
                    jakarta.transaction.TransactionManager tm = TransactionManager.transactionManager();
                    Transaction tx2 = null;
                    Transaction tx1 = connControl.transaction();
                    try {
                        tx2 = tm.getTransaction();
                    }
                    catch (SystemException systemException) {
                        // empty catch block
                    }
                    if (tx1 == null || !tx1.equals(tx2) || !ConnectionManager.isSameConnection(dbUrl, user, passwd, dynamic, xaDataSource, connControl)) continue;
                    try {
                        if (connectionImple.isClosed()) continue;
                        conn = connectionImple;
                        conn.incrementUseCount();
                        break;
                    }
                    catch (Exception ex) {
                        if (arjPropertyManager.getCoreEnvironmentBean().isLogAndRethrow()) {
                            jdbcLogger.i18NLogger.warn_connection_problem(ex.getMessage(), ex);
                        }
                        SQLException sqlException = new SQLException(ex.getMessage());
                        sqlException.initCause(ex);
                        throw sqlException;
                    }
                }
                while (conn == null) {
                    if (conn == null) {
                        for (ConnectionImple con : _connections) {
                            if (con.inUse() || !ConnectionManager.isSameConnection(dbUrl, user, passwd, dynamic, xaDataSource, con.connectionControl())) continue;
                            conn = con;
                            conn.incrementUseCount();
                            break;
                        }
                    }
                    if (conn != null) continue;
                    if (_connections.size() != maxConnections) break;
                    try {
                        _connections.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        jdbcLogger.i18NLogger.warn_connection_problem(interruptedException.getMessage(), interruptedException);
                    }
                }
            }
            if (conn == null) {
                conn = new ConnectionImple(dbUrl, info);
                if (poolingEnabled) {
                    _connections.add(conn);
                }
            }
            return conn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(ConnectionImple conn) {
        Set<ConnectionImple> set = _connections;
        synchronized (set) {
            _connections.remove(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void release(ConnectionImple conn) {
        Set<ConnectionImple> set = _connections;
        synchronized (set) {
            _connections.notify();
        }
    }

    private static boolean isSameConnection(String dbUrl, String user, String passwd, String dynamic, Object xaDataSource, ConnectionControl connControl) {
        return dbUrl.equals(connControl.url()) && user.equals(connControl.user()) && passwd.equals(connControl.password()) && dynamic.equals(connControl.dynamicClass()) && (xaDataSource == null || xaDataSource.equals(connControl.xaDataSource()));
    }
}

