/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.jta.jms;

import javax.jms.Connection;
import javax.jms.JMSException;
import javax.transaction.Synchronization;
import org.jboss.logging.Logger;

public class ConnectionClosingSynchronization
implements Synchronization {
    private static final Logger LOGGER = Logger.getLogger(ConnectionClosingSynchronization.class);
    private final Connection connection;

    public ConnectionClosingSynchronization(Connection connection) {
        this.connection = connection;
    }

    public void beforeCompletion() {
    }

    public void afterCompletion(int status) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("Closing connection " + this.connection));
        }
        try {
            this.connection.close();
        }
        catch (JMSException e) {
            LOGGER.warn((Object)("Failed to close connection " + this.connection + ": " + e.getMessage()));
        }
    }
}

