/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.jta.jms;

import com.arjuna.ats.jta.recovery.XAResourceRecoveryHelper;
import javax.jms.JMSException;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.jms.XASession;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.logging.Logger;

public class JmsXAResourceRecoveryHelper
implements XAResourceRecoveryHelper,
XAResource {
    private static final Logger LOGGER = Logger.getLogger(JmsXAResourceRecoveryHelper.class);
    private final XAConnectionFactory xaConnectionFactory;
    private XAConnection xaConnection;
    private XASession xaSession;
    private XAResource delegate;

    public JmsXAResourceRecoveryHelper(XAConnectionFactory xaConnectionFactory) {
        this.xaConnectionFactory = xaConnectionFactory;
    }

    public boolean initialise(String properties) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("Initialise with properties=" + properties));
        }
        return true;
    }

    public XAResource[] getXAResources() {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("Returning XA resource: " + this));
        }
        return new XAResource[]{this};
    }

    @Override
    public Xid[] recover(int i) throws XAException {
        if (i == 0x1000000) {
            this.connect();
        }
        assert (this.delegate != null) : "Recovery scan has to be started";
        try {
            Xid[] xidArray = this.delegate.recover(i);
            return xidArray;
        }
        finally {
            if (i == 0x800000) {
                this.disconnect();
            }
        }
    }

    @Override
    public void start(Xid xid, int i) throws XAException {
        assert (this.delegate != null) : "Recovery scan has to be started";
        this.delegate.start(xid, i);
    }

    @Override
    public void end(Xid xid, int i) throws XAException {
        assert (this.delegate != null) : "Recovery scan has to be started";
        this.delegate.end(xid, i);
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        assert (this.delegate != null) : "Recovery scan has to be started";
        return this.delegate.prepare(xid);
    }

    @Override
    public void commit(Xid xid, boolean b) throws XAException {
        assert (this.delegate != null) : "Recovery scan has to be started";
        this.delegate.commit(xid, b);
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        assert (this.delegate != null) : "Recovery scan has to be started";
        this.delegate.rollback(xid);
    }

    @Override
    public boolean isSameRM(XAResource xaResource) throws XAException {
        assert (this.delegate != null) : "Recovery scan has to be started";
        return this.delegate.isSameRM(xaResource);
    }

    @Override
    public void forget(Xid xid) throws XAException {
        assert (this.delegate != null) : "Recovery scan has to be started";
        this.delegate.forget(xid);
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        assert (this.delegate != null) : "Recovery scan has to be started";
        return this.delegate.getTransactionTimeout();
    }

    @Override
    public boolean setTransactionTimeout(int i) throws XAException {
        assert (this.delegate != null) : "Recovery scan has to be started";
        return this.delegate.setTransactionTimeout(i);
    }

    private void connect() throws XAException {
        if (this.delegate != null) {
            return;
        }
        try {
            this.xaConnection = this.xaConnectionFactory.createXAConnection();
            this.xaSession = this.xaConnection.createXASession();
            this.delegate = this.xaSession.getXAResource();
        }
        catch (JMSException e) {
            LOGGER.warn((Object)"Failed to create connection", (Throwable)e);
            throw new XAException(e.getMessage());
        }
    }

    private void disconnect() throws XAException {
        try {
            this.xaConnection.close();
        }
        catch (JMSException e) {
            LOGGER.warn((Object)"Failed to close connection", (Throwable)e);
            throw new XAException(e.getMessage());
        }
        finally {
            this.xaConnection = null;
            this.xaSession = null;
            this.delegate = null;
        }
    }
}

