/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.jta.jms;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import javax.jms.XASession;
import org.jboss.narayana.jta.jms.SessionClosingSynchronization;
import org.jboss.narayana.jta.jms.TransactionHelper;

public class SessionProxy
implements Session {
    private static final Logger LOGGER = Logger.getLogger(SessionProxy.class.getName());
    private final XASession xaSession;
    private final TransactionHelper transactionHelper;

    public SessionProxy(XASession xaSession, TransactionHelper transactionHelper) {
        this.xaSession = xaSession;
        this.transactionHelper = transactionHelper;
    }

    public void close() throws JMSException {
        if (this.transactionHelper.isTransactionAvailable()) {
            this.transactionHelper.deregisterXAResource(this.xaSession.getXAResource());
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Delisted " + this.xaSession + " XA resource from the transaction");
            }
            SessionClosingSynchronization synchronization = new SessionClosingSynchronization((Session)this.xaSession);
            this.transactionHelper.registerSynchronization(synchronization);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Registered synchronization to close the session: " + synchronization);
            }
        } else {
            this.xaSession.close();
        }
    }

    public BytesMessage createBytesMessage() throws JMSException {
        return this.xaSession.createBytesMessage();
    }

    public MapMessage createMapMessage() throws JMSException {
        return this.xaSession.createMapMessage();
    }

    public Message createMessage() throws JMSException {
        return this.xaSession.createMessage();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        return this.xaSession.createObjectMessage();
    }

    public ObjectMessage createObjectMessage(Serializable serializable) throws JMSException {
        return this.xaSession.createObjectMessage(serializable);
    }

    public StreamMessage createStreamMessage() throws JMSException {
        return this.xaSession.createStreamMessage();
    }

    public TextMessage createTextMessage() throws JMSException {
        return this.xaSession.createTextMessage();
    }

    public TextMessage createTextMessage(String s) throws JMSException {
        return this.xaSession.createTextMessage(s);
    }

    public boolean getTransacted() throws JMSException {
        return this.xaSession.getTransacted();
    }

    public int getAcknowledgeMode() throws JMSException {
        return this.xaSession.getAcknowledgeMode();
    }

    public void commit() throws JMSException {
        this.xaSession.commit();
    }

    public void rollback() throws JMSException {
        this.xaSession.rollback();
    }

    public void recover() throws JMSException {
        this.xaSession.recover();
    }

    public MessageListener getMessageListener() throws JMSException {
        return this.xaSession.getMessageListener();
    }

    public void setMessageListener(MessageListener messageListener) throws JMSException {
        this.xaSession.setMessageListener(messageListener);
    }

    public void run() {
        this.xaSession.run();
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        return this.xaSession.createProducer(destination);
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        return this.xaSession.createConsumer(destination);
    }

    public MessageConsumer createConsumer(Destination destination, String s) throws JMSException {
        return this.xaSession.createConsumer(destination, s);
    }

    public MessageConsumer createConsumer(Destination destination, String s, boolean b) throws JMSException {
        return this.xaSession.createConsumer(destination, s, b);
    }

    public Queue createQueue(String s) throws JMSException {
        return this.xaSession.createQueue(s);
    }

    public Topic createTopic(String s) throws JMSException {
        return this.xaSession.createTopic(s);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String s) throws JMSException {
        return this.xaSession.createDurableSubscriber(topic, s);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String s, String s1, boolean b) throws JMSException {
        return this.xaSession.createDurableSubscriber(topic, s, s1, b);
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        return this.xaSession.createBrowser(queue);
    }

    public QueueBrowser createBrowser(Queue queue, String s) throws JMSException {
        return this.xaSession.createBrowser(queue, s);
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        return this.xaSession.createTemporaryQueue();
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        return this.xaSession.createTemporaryTopic();
    }

    public void unsubscribe(String s) throws JMSException {
        this.xaSession.unsubscribe(s);
    }
}

