/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.jta.jms;

import javax.jms.JMSException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.jboss.logging.Logger;
import org.jboss.narayana.jta.jms.TransactionHelper;

public class TransactionHelperImpl
implements TransactionHelper {
    private static final Logger LOGGER = Logger.getLogger(TransactionHelperImpl.class);
    private final TransactionManager transactionManager;

    public TransactionHelperImpl(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @Override
    public boolean isTransactionAvailable() throws JMSException {
        try {
            return this.transactionManager.getStatus() != 6;
        }
        catch (SystemException e) {
            LOGGER.warn((Object)"Failed to get transaction status", (Throwable)e);
            throw this.getJmsException("Failed to get transaction status", (Exception)((Object)e));
        }
    }

    @Override
    public void registerSynchronization(Synchronization synchronization) throws JMSException {
        try {
            this.getTransaction().registerSynchronization(synchronization);
        }
        catch (IllegalStateException | RollbackException | SystemException e) {
            LOGGER.warn((Object)"Failed to register synchronization", e);
            throw this.getJmsException("Failed to register synchronization", (Exception)e);
        }
    }

    @Override
    public void registerXAResource(XAResource xaResource) throws JMSException {
        try {
            if (!this.getTransaction().enlistResource(xaResource)) {
                LOGGER.warn((Object)"Failed to enlist XA resource");
                throw this.getJmsException("Failed to enlist XA resource", null);
            }
        }
        catch (IllegalStateException | RollbackException | SystemException e) {
            LOGGER.warn((Object)"Failed to enlist XA resource", e);
            throw this.getJmsException("Failed to enlist XA resource", (Exception)e);
        }
    }

    @Override
    public void deregisterXAResource(XAResource xaResource) throws JMSException {
        try {
            if (!this.getTransaction().delistResource(xaResource, 0x4000000)) {
                LOGGER.warn((Object)"Failed to delist XA resource");
                throw this.getJmsException("Failed to delist XA resource", null);
            }
        }
        catch (IllegalStateException | SystemException e) {
            LOGGER.warn((Object)"Failed to delist XA resource", e);
            throw this.getJmsException("Failed to delist XA resource", (Exception)e);
        }
    }

    private Transaction getTransaction() throws JMSException {
        try {
            return this.transactionManager.getTransaction();
        }
        catch (SystemException e) {
            LOGGER.warn((Object)"Failed to get transaction", (Throwable)e);
            throw this.getJmsException("Failed to get transaction", (Exception)((Object)e));
        }
    }

    private JMSException getJmsException(String message, Exception cause) {
        JMSException jmsException = new JMSException(message);
        jmsException.setLinkedException(cause);
        return jmsException;
    }
}

