/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.jta.jms;

import com.arjuna.ats.jta.logging.jtaLogger;
import com.arjuna.ats.jta.recovery.XAResourceRecoveryHelper;
import javax.jms.JMSException;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.jms.XASession;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class JmsXAResourceRecoveryHelper
implements XAResourceRecoveryHelper,
XAResource {
    private final XAConnectionFactory xaConnectionFactory;
    private final String user;
    private final String pass;
    private XAConnection xaConnection;
    private XASession xaSession;
    private XAResource delegate;

    public JmsXAResourceRecoveryHelper(XAConnectionFactory xaConnectionFactory) {
        this(xaConnectionFactory, null, null);
    }

    public JmsXAResourceRecoveryHelper(XAConnectionFactory xaConnectionFactory, String user, String pass) {
        this.xaConnectionFactory = xaConnectionFactory;
        this.user = user;
        this.pass = pass;
    }

    public boolean initialise(String properties) {
        if (jtaLogger.logger.isTraceEnabled()) {
            jtaLogger.logger.trace((Object)("Initialise with properties=" + properties));
        }
        return true;
    }

    public XAResource[] getXAResources() {
        if (this.connect()) {
            if (jtaLogger.logger.isTraceEnabled()) {
                jtaLogger.logger.trace((Object)("Returning XA resource: " + this));
            }
            return new XAResource[]{this};
        }
        return new XAResource[0];
    }

    @Override
    public Xid[] recover(int i) throws XAException {
        try {
            Xid[] xidArray = this.delegate.recover(i);
            return xidArray;
        }
        finally {
            if (i == 0x800000) {
                this.disconnect();
            }
        }
    }

    @Override
    public void start(Xid xid, int i) throws XAException {
        this.delegate.start(xid, i);
    }

    @Override
    public void end(Xid xid, int i) throws XAException {
        this.delegate.end(xid, i);
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        return this.delegate.prepare(xid);
    }

    @Override
    public void commit(Xid xid, boolean b) throws XAException {
        this.delegate.commit(xid, b);
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        this.delegate.rollback(xid);
    }

    @Override
    public boolean isSameRM(XAResource xaResource) throws XAException {
        return this.delegate.isSameRM(xaResource);
    }

    @Override
    public void forget(Xid xid) throws XAException {
        this.delegate.forget(xid);
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.delegate.getTransactionTimeout();
    }

    @Override
    public boolean setTransactionTimeout(int i) throws XAException {
        return this.delegate.setTransactionTimeout(i);
    }

    private boolean connect() {
        if (this.delegate != null) {
            return true;
        }
        try {
            this.xaConnection = this.createXAConnection();
            this.xaSession = this.xaConnection.createXASession();
            this.delegate = this.xaSession.getXAResource();
        }
        catch (JMSException e) {
            jtaLogger.i18NLogger.warn_failed_to_create_jms_connection((Exception)((Object)e));
            return false;
        }
        return true;
    }

    private void disconnect() {
        try {
            this.xaConnection.close();
        }
        catch (JMSException e) {
            jtaLogger.i18NLogger.warn_failed_to_close_jms_connection(this.xaConnection.toString(), (Exception)((Object)e));
        }
        finally {
            this.xaConnection = null;
            this.xaSession = null;
            this.delegate = null;
        }
    }

    private XAConnection createXAConnection() throws JMSException {
        if (this.user == null && this.pass == null) {
            return this.xaConnectionFactory.createXAConnection();
        }
        return this.xaConnectionFactory.createXAConnection(this.user, this.pass);
    }
}

