/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.recovery.arjunacore;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.RecoveryStore;
import com.arjuna.ats.arjuna.objectstore.StoreManager;
import com.arjuna.ats.arjuna.recovery.RecoveryManager;
import com.arjuna.ats.arjuna.recovery.RecoveryModule;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.internal.arjuna.common.UidHelper;
import com.arjuna.ats.internal.jta.Implementations;
import com.arjuna.ats.internal.jta.recovery.arjunacore.RecoveryXids;
import com.arjuna.ats.internal.jta.recovery.arjunacore.XARecoveryResourceManagerImple;
import com.arjuna.ats.internal.jta.resources.arjunacore.XAResourceRecord;
import com.arjuna.ats.jta.common.jtaPropertyManager;
import com.arjuna.ats.jta.logging.jtaLogger;
import com.arjuna.ats.jta.recovery.SerializableXAResourceDeserializer;
import com.arjuna.ats.jta.recovery.XARecoveryResource;
import com.arjuna.ats.jta.recovery.XARecoveryResourceManager;
import com.arjuna.ats.jta.recovery.XAResourceOrphanFilter;
import com.arjuna.ats.jta.recovery.XAResourceRecovery;
import com.arjuna.ats.jta.recovery.XAResourceRecoveryHelper;
import com.arjuna.ats.jta.utils.XAHelper;
import com.arjuna.ats.jta.utils.XARecoveryResourceHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.tm.XAResourceWrapper;

public class XARecoveryModule
implements RecoveryModule {
    private RecoveryStore _recoveryStore = StoreManager.getRecoveryStore();
    private InputObjectState _uids = new InputObjectState();
    private List<XAResource> _resources;
    private AtomicInteger scanState = new AtomicInteger(ScanStates.IDLE.ordinal());
    private final List<XAResourceRecovery> _xaRecoverers;
    private final Set<XAResourceRecoveryHelper> _xaResourceRecoveryHelpers = new CopyOnWriteArraySet<XAResourceRecoveryHelper>();
    private final List<XAResourceOrphanFilter> _xaResourceOrphanFilters;
    private Hashtable _failures = null;
    private Hashtable<XAResourceRecoveryHelper, XAResource[]> recoveryHelpersXAResource = new Hashtable();
    private Hashtable<XAResource, RecoveryXids> _xidScans = null;
    private XARecoveryResourceManager _recoveryManagerClass = null;
    private String _logName = null;
    private List<SerializableXAResourceDeserializer> _seriablizableXAResourceDeserializers = new ArrayList<SerializableXAResourceDeserializer>();
    private Set<String> contactedJndiNames = new HashSet<String>();
    private static XARecoveryModule registeredXARecoveryModule;

    public XARecoveryModule() {
        this(new XARecoveryResourceManagerImple(), "Local XARecoveryModule");
        Implementations.initialise();
    }

    public Set<String> getContactedJndiNames() {
        return Collections.unmodifiableSet(this.contactedJndiNames);
    }

    public void addXAResourceRecoveryHelper(XAResourceRecoveryHelper xaResourceRecoveryHelper) {
        this._xaResourceRecoveryHelpers.add(xaResourceRecoveryHelper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeXAResourceRecoveryHelper(XAResourceRecoveryHelper xaResourceRecoveryHelper) {
        AtomicInteger atomicInteger = this.scanState;
        synchronized (atomicInteger) {
            this.waitForNotScanState(ScanStates.FIRST_PASS);
            if (!this.getScanState().equals((Object)ScanStates.IDLE) && this.isHelperInUse(xaResourceRecoveryHelper)) {
                this.waitForScanState(ScanStates.IDLE);
            }
            this._xaResourceRecoveryHelpers.remove(xaResourceRecoveryHelper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addXAResourceOrphanFilter(XAResourceOrphanFilter xaResourceOrphanFilter) {
        List<XAResourceOrphanFilter> list2 = this._xaResourceOrphanFilters;
        synchronized (list2) {
            if (!this._xaResourceOrphanFilters.contains(xaResourceOrphanFilter)) {
                this._xaResourceOrphanFilters.add(xaResourceOrphanFilter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeXAResourceOrphanFilter(XAResourceOrphanFilter xaResourceOrphanFilter) {
        List<XAResourceOrphanFilter> list2 = this._xaResourceOrphanFilters;
        synchronized (list2) {
            this._xaResourceOrphanFilters.remove(xaResourceOrphanFilter);
        }
    }

    public void addSerializableXAResourceDeserializer(SerializableXAResourceDeserializer serializableXAResourceDeserializer) {
        this._seriablizableXAResourceDeserializers.add(serializableXAResourceDeserializer);
    }

    public List<SerializableXAResourceDeserializer> getSeriablizableXAResourceDeserializers() {
        return this._seriablizableXAResourceDeserializers;
    }

    @Override
    public synchronized void periodicWorkFirstPass() {
        this.periodicWorkFirstPass(ScanStates.BETWEEN_PASSES);
    }

    private synchronized void periodicWorkFirstPass(ScanStates endState) {
        if (this.getScanState() == ScanStates.BETWEEN_PASSES) {
            this.periodicWorkSecondPass();
        }
        this.setScanState(ScanStates.FIRST_PASS);
        if (jtaLogger.logger.isDebugEnabled()) {
            jtaLogger.logger.debugv("{0} - first pass", (Object)this._logName);
        }
        this.contactedJndiNames.clear();
        this._uids = new InputObjectState();
        try {
            if (!this._recoveryStore.allObjUids(this._recoveryManagerClass.type(), this._uids)) {
                jtaLogger.i18NLogger.warn_recovery_alluids();
            }
        }
        catch (ObjectStoreException e) {
            jtaLogger.i18NLogger.warn_recovery_objstoreerror(e);
        }
        catch (Exception e) {
            jtaLogger.i18NLogger.warn_recovery_periodicfirstpass(this._logName + ".periodicWorkFirstPass", e);
        }
        this._resources = this.resourceInitiatedRecovery();
        this._resources.addAll(this.resourceInitiatedRecoveryForRecoveryHelpers());
        ArrayList<XAResource> resources = new ArrayList<XAResource>(this._resources);
        for (XAResource xaResource : resources) {
            try {
                this.xaRecoveryFirstPass(xaResource);
            }
            catch (Exception ex) {
                jtaLogger.i18NLogger.warn_recovery_getxaresource(ex);
            }
        }
        if (endState != ScanStates.BETWEEN_PASSES) {
            for (XAResource xaResource : resources) {
                try {
                    xaResource.recover(0x800000);
                }
                catch (Exception ex) {
                    jtaLogger.i18NLogger.warn_recovery_getxaresource(ex);
                }
            }
        }
        this.setScanState(endState);
    }

    @Override
    public synchronized void periodicWorkSecondPass() {
        if (this.getScanState() == ScanStates.IDLE) {
            return;
        }
        this.setScanState(ScanStates.SECOND_PASS);
        if (jtaLogger.logger.isDebugEnabled()) {
            jtaLogger.logger.debugv("{0} - second pass", (Object)this._logName);
        }
        try {
            this.transactionInitiatedRecovery();
            if (jtaLogger.logger.isDebugEnabled()) {
                jtaLogger.logger.debug((Object)(this._logName + ".transactionInitiatedRecovery completed"));
            }
            this.bottomUpRecovery();
            if (jtaLogger.logger.isDebugEnabled()) {
                jtaLogger.logger.debug((Object)(this._logName + ".resourceInitiatedRecovery completed"));
            }
        }
        catch (Exception e) {
            jtaLogger.i18NLogger.warn_recovery_periodicsecondpass(this._logName + ".periodicWorkSecondPass", e);
        }
        this.clearAllFailures();
        this.setScanState(ScanStates.IDLE);
    }

    public static XARecoveryModule getRegisteredXARecoveryModule() {
        RecoveryManager recMan;
        Vector<RecoveryModule> recoveryModules;
        if (registeredXARecoveryModule == null && (recoveryModules = (recMan = RecoveryManager.manager()).getModules()) != null) {
            Enumeration<RecoveryModule> modules = recoveryModules.elements();
            while (modules.hasMoreElements()) {
                RecoveryModule m = modules.nextElement();
                if (!(m instanceof XARecoveryModule)) continue;
                registeredXARecoveryModule = (XARecoveryModule)m;
                break;
            }
        }
        return registeredXARecoveryModule;
    }

    public String id() {
        return "XARecoveryModule:" + this._recoveryManagerClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XAResource getNewXAResource(Xid xid) {
        XAResource toReturn = this.getTheKey(xid);
        if (toReturn == null) {
            XARecoveryModule xARecoveryModule = this;
            synchronized (xARecoveryModule) {
                this.periodicWorkFirstPass(ScanStates.IDLE);
                toReturn = this.getTheKey(xid);
            }
        }
        return toReturn;
    }

    private XAResource getTheKey(Xid xid) {
        if (this._xidScans != null) {
            Enumeration<XAResource> keys = this._xidScans.keys();
            while (keys.hasMoreElements()) {
                XAResource theKey = keys.nextElement();
                RecoveryXids xids = this._xidScans.get(theKey);
                if (!xids.contains(xid)) continue;
                return theKey;
            }
        }
        return null;
    }

    public XAResource getNewXAResource(XAResourceRecord xaResourceRecord) {
        return this.getNewXAResource(xaResourceRecord.getXid());
    }

    protected XARecoveryModule(XARecoveryResourceManager recoveryClass, String logName) {
        this._logName = logName;
        this._recoveryManagerClass = recoveryClass;
        if (this._recoveryManagerClass == null) {
            jtaLogger.i18NLogger.warn_recovery_constfail();
        }
        this._xaRecoverers = jtaPropertyManager.getJTAEnvironmentBean().getXaResourceRecoveries();
        this._xaResourceOrphanFilters = jtaPropertyManager.getJTAEnvironmentBean().getXaResourceOrphanFilters();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean transactionInitiatedRecovery() {
        Uid theUid = null;
        while (Uid.nullUid().notEquals(theUid)) {
            try {
                theUid = UidHelper.unpackFrom(this._uids);
                if (!theUid.notEquals(Uid.nullUid()) || this._recoveryStore.currentState(theUid, this._recoveryManagerClass.type()) == -1) continue;
                boolean problem = false;
                XARecoveryResource record = null;
                try {
                    record = this._recoveryManagerClass.getResource(theUid);
                    problem = true;
                    switch (record.recoverable()) {
                        case 12: {
                            int recoveryStatus;
                            if (jtaLogger.logger.isDebugEnabled()) {
                                jtaLogger.logger.debug((Object)("XARecovery attempting recovery of " + theUid));
                            }
                            if ((recoveryStatus = record.recover()) != 1) {
                                if (recoveryStatus == 3) {
                                    problem = false;
                                    jtaLogger.i18NLogger.info_recovery_recoverydelayed(theUid, XARecoveryResourceHelper.stringForm(recoveryStatus));
                                    break;
                                }
                                jtaLogger.i18NLogger.warn_recovery_recoveryfailed(theUid, XARecoveryResourceHelper.stringForm(recoveryStatus));
                                break;
                            }
                            problem = false;
                            break;
                        }
                        case 11: {
                            problem = false;
                            break;
                        }
                        default: {
                            if (!jtaLogger.logger.isDebugEnabled()) break;
                            jtaLogger.logger.debug((Object)("XARecovery " + theUid + " is non-recoverable"));
                            break;
                        }
                    }
                }
                catch (NullPointerException ex) {
                    problem = true;
                }
                catch (Throwable e) {
                    problem = true;
                    jtaLogger.i18NLogger.warn_recovery_recoveryerror(e);
                }
                if (!problem || record == null) continue;
                if (record.getXid() == null) {
                    jtaLogger.i18NLogger.warn_recovery_cannotadd();
                    continue;
                }
                this.addFailure(record.getXid(), record.get_uid());
            }
            catch (IOException e) {
                theUid = Uid.nullUid();
            }
            catch (Throwable e) {
                jtaLogger.i18NLogger.warn_recovery_unexpectedrecoveryerror(e);
                continue;
            }
            break;
        }
        return true;
    }

    private void bottomUpRecovery() {
        for (XAResource xaResource : this._resources) {
            try {
                this.xaRecoverySecondPass(xaResource);
            }
            catch (Exception ex) {
                jtaLogger.i18NLogger.warn_recovery_getxaresource(ex);
            }
        }
        if (this._xidScans != null) {
            HashSet<XAResource> keys = new HashSet<XAResource>(this._xidScans.keySet());
            for (XAResource theKey : keys) {
                RecoveryXids recoveryXids = this._xidScans.get(theKey);
                if (!recoveryXids.isStale()) continue;
                this._xidScans.remove(theKey);
            }
        }
    }

    private final List<XAResource> resourceInitiatedRecovery() {
        ArrayList<XAResource> xaresources = new ArrayList<XAResource>();
        if (this._xaRecoverers.size() > 0) {
            for (int i = 0; i < this._xaRecoverers.size(); ++i) {
                try {
                    XAResourceRecovery ri = this._xaRecoverers.get(i);
                    while (ri.hasMoreResources()) {
                        xaresources.add(ri.getXAResource());
                    }
                    continue;
                }
                catch (Exception ex) {
                    jtaLogger.i18NLogger.warn_recovery_getxaresource(ex);
                }
            }
        }
        return xaresources;
    }

    private List<XAResource> resourceInitiatedRecoveryForRecoveryHelpers() {
        ArrayList<XAResource> xaresources = new ArrayList<XAResource>();
        this.recoveryHelpersXAResource.clear();
        for (XAResourceRecoveryHelper xaResourceRecoveryHelper : this._xaResourceRecoveryHelpers) {
            try {
                XAResource[] xaResources = xaResourceRecoveryHelper.getXAResources();
                if (xaResources == null) continue;
                for (XAResource xaResource : xaResources) {
                    xaresources.add(xaResource);
                }
                this.recoveryHelpersXAResource.put(xaResourceRecoveryHelper, xaResources);
            }
            catch (Exception ex) {
                jtaLogger.i18NLogger.warn_recovery_getxaresource(ex);
            }
        }
        return xaresources;
    }

    private final void xaRecoveryFirstPass(XAResource xares) {
        if (jtaLogger.logger.isDebugEnabled()) {
            jtaLogger.logger.debug((Object)("xarecovery of " + xares));
        }
        Xid[] trans = null;
        try {
            trans = xares.recover(0x1000000);
            if (jtaLogger.logger.isDebugEnabled()) {
                jtaLogger.logger.debug((Object)("Found " + (trans != null ? trans.length : 0) + " xids in doubt"));
            }
            if (jtaLogger.logger.isTraceEnabled()) {
                for (Xid xid : trans) {
                    int i;
                    byte[] globalTransactionId = xid.getGlobalTransactionId();
                    byte[] branchQualifier = xid.getBranchQualifier();
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("< ");
                    stringBuilder.append(xid.getFormatId());
                    stringBuilder.append(", ");
                    stringBuilder.append(globalTransactionId.length);
                    stringBuilder.append(", ");
                    stringBuilder.append(branchQualifier.length);
                    stringBuilder.append(", ");
                    for (i = 0; i < globalTransactionId.length; ++i) {
                        stringBuilder.append(globalTransactionId[i]);
                    }
                    stringBuilder.append(", ");
                    for (i = 0; i < branchQualifier.length; ++i) {
                        stringBuilder.append(branchQualifier[i]);
                    }
                    stringBuilder.append(" >");
                    jtaLogger.logger.debug((Object)("Recovered: " + stringBuilder.toString()));
                }
            }
        }
        catch (XAException e) {
            jtaLogger.i18NLogger.warn_recovery_xarecovery1(this._logName + ".xaRecovery", XAHelper.printXAErrorCode(e), e);
            try {
                xares.recover(0x800000);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._xidScans.remove(xares);
            return;
        }
        RecoveryXids xidsToRecover = null;
        if (this._xidScans == null) {
            this._xidScans = new Hashtable();
        } else {
            this.refreshXidScansForEquivalentXAResourceImpl(xares, trans);
            xidsToRecover = this._xidScans.get(xares);
            if (xidsToRecover == null) {
                Enumeration<RecoveryXids> elements = this._xidScans.elements();
                boolean found = false;
                while (elements.hasMoreElements()) {
                    xidsToRecover = elements.nextElement();
                    if (!xidsToRecover.isSameRM(xares)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    xidsToRecover = null;
                }
            }
        }
        if (xidsToRecover == null) {
            xidsToRecover = new RecoveryXids(xares);
            this._xidScans.put(xares, xidsToRecover);
        }
        xidsToRecover.nextScan(trans);
        this.saveContactedJndiName(xares);
    }

    private void xaRecoverySecondPass(XAResource xares) {
        RecoveryXids xidsToRecover;
        if (jtaLogger.logger.isDebugEnabled()) {
            jtaLogger.logger.debug((Object)("xarecovery second pass of " + xares));
        }
        if ((xidsToRecover = this._xidScans.get(xares)) != null) {
            block16: {
                try {
                    Xid[] xids = xidsToRecover.toRecover();
                    if (xids == null) break block16;
                    if (jtaLogger.logger.isDebugEnabled()) {
                        jtaLogger.logger.debug((Object)("Have " + xids.length + " Xids to recover on this pass."));
                    }
                    for (int j = 0; j < xids.length; ++j) {
                        boolean doForget = false;
                        Uid recordUid = null;
                        boolean foundTransaction = false;
                        while ((recordUid = this.previousFailure(xids[j])) != null || !foundTransaction) {
                            if (recordUid == null) {
                                doForget = this.handleOrphan(xares, xids[j]);
                            } else {
                                foundTransaction = true;
                                XARecoveryResource record = this._recoveryManagerClass.getResource(recordUid, xares);
                                int recoveryStatus = record.recover();
                                if (recoveryStatus != 1) {
                                    jtaLogger.i18NLogger.warn_recovery_failedtorecover(this._logName + ".xaRecovery", XARecoveryResourceHelper.stringForm(recoveryStatus));
                                }
                                this.removeFailure(record.getXid(), record.get_uid());
                            }
                            if (doForget) {
                                try {
                                    xares.forget(xids[j]);
                                }
                                catch (Exception e) {
                                    jtaLogger.i18NLogger.warn_recovery_forgetfailed(this._logName + ".xaRecovery", e);
                                }
                            }
                            if (recordUid != null) continue;
                        }
                    }
                }
                catch (Exception e) {
                    jtaLogger.i18NLogger.warn_recovery_generalrecoveryerror(this._logName + ".xaRecovery", e);
                }
            }
            try {
                if (xares != null) {
                    xares.recover(0x800000);
                }
            }
            catch (XAException e) {
                jtaLogger.i18NLogger.warn_recovery_xarecovery1(this._logName + ".xaRecovery", XAHelper.printXAErrorCode(e), e);
            }
        }
    }

    private boolean handleOrphan(XAResource xares, Xid xid) {
        XAResourceOrphanFilter.Vote votingOutcome = XAResourceOrphanFilter.Vote.LEAVE_ALONE;
        for (XAResourceOrphanFilter filter : this._xaResourceOrphanFilters) {
            XAResourceOrphanFilter.Vote vote = filter.checkXid(xid);
            if (jtaLogger.logger.isDebugEnabled()) {
                jtaLogger.logger.debug((Object)("XAResourceOrphanFilter " + filter.getClass().getName() + " voted " + (Object)((Object)vote)));
            }
            if (vote == XAResourceOrphanFilter.Vote.LEAVE_ALONE) {
                return false;
            }
            if (vote != XAResourceOrphanFilter.Vote.ROLLBACK) continue;
            votingOutcome = vote;
        }
        try {
            if (votingOutcome == XAResourceOrphanFilter.Vote.ROLLBACK) {
                jtaLogger.i18NLogger.info_recovery_rollingback(XAHelper.xidToString(xid));
                xares.rollback(xid);
            }
        }
        catch (XAException e1) {
            jtaLogger.i18NLogger.warn_recovery_xarecovery1(this._logName + ".xaRecovery", XAHelper.printXAErrorCode(e1), e1);
            switch (e1.errorCode) {
                case -3: {
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 100: {
                    return true;
                }
            }
        }
        catch (Exception e2) {
            jtaLogger.i18NLogger.warn_recovery_xarecovery2(this._logName + ".xaRecovery", e2);
        }
        return false;
    }

    private void refreshXidScansForEquivalentXAResourceImpl(XAResource xares, Xid[] xids) {
        HashSet<XAResource> keys = new HashSet<XAResource>(this._xidScans.keySet());
        for (XAResource theKey : keys) {
            RecoveryXids recoveryXids = this._xidScans.get(theKey);
            if (!recoveryXids.updateIfEquivalentRM(xares, xids)) continue;
            this._xidScans.remove(theKey);
            this._xidScans.put(xares, recoveryXids);
            this._resources.remove(theKey);
            if (this._resources.contains(xares)) continue;
            this._resources.add(xares);
        }
    }

    private final Uid previousFailure(Xid xid) {
        if (this._failures == null) {
            return null;
        }
        Enumeration e = this._failures.keys();
        while (e.hasMoreElements()) {
            Xid theXid = (Xid)e.nextElement();
            if (!XAHelper.sameXID(xid, theXid)) continue;
            Vector failureItem = (Vector)this._failures.get(theXid);
            Uid u = (Uid)failureItem.remove(0);
            if (failureItem.size() == 0) {
                this._failures.remove(theXid);
            }
            return u;
        }
        return null;
    }

    private void addFailure(Xid xid, Uid uid) {
        Vector<Uid> failureItem;
        if (this._failures == null) {
            this._failures = new Hashtable();
        }
        if ((failureItem = (Vector<Uid>)this._failures.get(xid)) == null) {
            failureItem = new Vector<Uid>();
            this._failures.put(xid, failureItem);
        }
        failureItem.addElement(uid);
    }

    private void removeFailure(Xid xid, Uid uid) {
        Vector failureItem = (Vector)this._failures.get(xid);
        if (failureItem != null) {
            failureItem.remove(uid);
            if (failureItem.size() == 0) {
                this._failures.remove(xid);
            }
        }
    }

    private void clearAllFailures() {
        if (this._failures != null) {
            this._failures.clear();
        }
    }

    private boolean isHelperInUse(XAResourceRecoveryHelper xaResourceRecoveryHelper) {
        XAResource[] xaResources = this.recoveryHelpersXAResource.get(xaResourceRecoveryHelper);
        if (xaResources != null) {
            for (int i = 0; i < xaResources.length; ++i) {
                RecoveryXids recoveryXids = this._xidScans.get(xaResources[i]);
                if (recoveryXids == null || recoveryXids.size() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    private boolean waitForScanState(ScanStates state) {
        try {
            do {
                this.scanState.wait();
            } while (!this.getScanState().equals((Object)state));
            return true;
        }
        catch (InterruptedException e) {
            tsLogger.logger.warn((Object)("problem waiting for scanLock whilst in state " + state.name()), (Throwable)e);
            return false;
        }
    }

    private boolean waitForNotScanState(ScanStates state) {
        try {
            while (this.getScanState().equals((Object)state)) {
                this.scanState.wait();
            }
            return true;
        }
        catch (InterruptedException e) {
            tsLogger.logger.warn((Object)("problem waiting for scanLock whilst in state " + state.name()), (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setScanState(ScanStates state) {
        AtomicInteger atomicInteger = this.scanState;
        synchronized (atomicInteger) {
            tsLogger.logger.debugf("XARecoveryModule state change %s->%s%n", (Object)this.getScanState(), (Object)state);
            this.scanState.set(state.ordinal());
            this.scanState.notifyAll();
        }
    }

    private ScanStates getScanState() {
        return ScanStates.values()[this.scanState.get()];
    }

    private void saveContactedJndiName(XAResource xaResource) {
        if (!(xaResource instanceof XAResourceWrapper)) {
            return;
        }
        String jndiName = ((XAResourceWrapper)xaResource).getJndiName();
        if (jndiName != null && jndiName.length() > 0) {
            this.contactedJndiNames.add(jndiName);
        }
    }

    private static enum ScanStates {
        IDLE,
        FIRST_PASS,
        BETWEEN_PASSES,
        SECOND_PASS;

    }
}

