import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public class X {
    static final byte[] NEWLN = {'\n'};
    static final byte[] COLON = {':'};
    static final byte[] EOM= {'\0', '\n', '\n'};

    public void send(Message message, OutputStream outputStream) throws IOException {
        synchronized (outputStream) {
            outputStream.write(message.getCommand().getBytes("UTF-8"));
            outputStream.write(NEWLN);

            for (Map.Entry<String, String> header : message.getHeaders().entrySet()) {
                outputStream.write(header.getKey().getBytes());
                outputStream.write(COLON);
                outputStream.write(header.getValue().getBytes());
                outputStream.write(NEWLN);
            }

            outputStream.write(NEWLN);
            outputStream.write(message.getBody());
            outputStream.write(EOM);
        }
    }

    static class Message {
        private String command = "commandName";

        private Map<String, String> headers = new HashMap<>();

        private byte[] body = "body".getBytes();

        Message() {
            headers.put("h1", "h1");
            headers.put("h2", "h2");
        }
        public String getCommand() {
            return command;
        }

        public Map<String,String> getHeaders() {
            return headers;
        }

        public byte[] getBody() {
            return body;
        }
    }

}
