/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jts.orbspecific;

import com.arjuna.ArjunaOTS.ActionControl;
import com.arjuna.ArjunaOTS.ActionControlHelper;
import com.arjuna.ArjunaOTS.ActionControlPOA;
import com.arjuna.ArjunaOTS.ActiveThreads;
import com.arjuna.ArjunaOTS.ActiveTransaction;
import com.arjuna.ArjunaOTS.ArjunaTransaction;
import com.arjuna.ArjunaOTS.ArjunaTransactionHelper;
import com.arjuna.ArjunaOTS.ArjunaTransactionPOATie;
import com.arjuna.ArjunaOTS.BadControl;
import com.arjuna.ArjunaOTS.Destroyed;
import com.arjuna.ArjunaOTS.UidCoordinator;
import com.arjuna.ArjunaOTS.UidCoordinatorHelper;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.BasicAction;
import com.arjuna.ats.internal.jts.ORBManager;
import com.arjuna.ats.internal.jts.orbspecific.coordinator.ArjunaTransactionImple;
import com.arjuna.ats.internal.jts.utils.Helper;
import com.arjuna.ats.jts.logging.jtsLogger;
import java.util.Hashtable;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.SystemException;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.Terminator;
import org.omg.CosTransactions.TerminatorHelper;
import org.omg.CosTransactions.Unavailable;

public class ControlImple
extends ActionControlPOA {
    public static Hashtable allControls = new Hashtable();
    protected Terminator _theTerminator;
    protected Coordinator _theCoordinator;
    protected Control _parentControl;
    protected ArjunaTransactionImple _transactionHandle;
    protected Uid _theUid;
    protected ActionControl _myControl;
    protected ArjunaTransactionPOATie _transactionImpl;
    protected boolean _destroyed;
    private Status _finalStatus = Status.StatusUnknown;

    public ControlImple(Control parentCon, ArjunaTransactionImple parentTran) {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)("ControlImple::ControlImple ( Control parentCon, " + (parentTran != null ? parentTran.get_uid() : Uid.nullUid()) + " )"));
        }
        this._theTerminator = null;
        this._theCoordinator = null;
        this._parentControl = parentCon;
        this._transactionHandle = new ArjunaTransactionImple(this._parentControl, parentTran);
        this._theUid = this._transactionHandle.get_uid();
        this._transactionImpl = null;
        this._myControl = null;
        this._destroyed = false;
        this._transactionHandle.setControlHandle(this);
        this.addControl();
    }

    public void finalize() throws Throwable {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)"ControlImple.finalize ()");
        }
        if (!this._destroyed) {
            try {
                this.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.tidyup();
        this._theTerminator = null;
        this._theCoordinator = null;
        this._theUid = null;
    }

    public Uid get_uid() {
        return this._theUid;
    }

    public final ArjunaTransactionImple getImplHandle() {
        return this._transactionHandle;
    }

    public final synchronized Control getControl() {
        if (this._myControl == null && !this._destroyed) {
            ORBManager.getPOA().objectIsReady(this);
            this._myControl = ActionControlHelper.narrow(ORBManager.getPOA().corbaReference(this));
        }
        return this._myControl;
    }

    @Override
    public Terminator get_terminator() throws SystemException, Unavailable {
        if (this._transactionHandle != null && this._theTerminator == null) {
            this.createTransactionHandle();
        }
        if (this._theTerminator != null) {
            return this._theTerminator;
        }
        throw new Unavailable();
    }

    @Override
    public Coordinator get_coordinator() throws SystemException, Unavailable {
        if (this._transactionHandle != null && this._theCoordinator == null) {
            this.createTransactionHandle();
        }
        if (this._theCoordinator != null) {
            return this._theCoordinator;
        }
        throw new Unavailable();
    }

    public void set_terminator(Terminator terminator) throws SystemException, Unavailable {
        throw new Unavailable();
    }

    public void set_coordinator(Coordinator coordinator) throws SystemException, Unavailable {
        throw new Unavailable();
    }

    @Override
    public Control getParentControl() throws Unavailable, SystemException {
        if (this._parentControl != null) {
            return this._parentControl;
        }
        return null;
    }

    @Override
    public synchronized void destroy() throws ActiveTransaction, ActiveThreads, BadControl, Destroyed, SystemException {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)("Control::destroy called for " + this.get_uid()));
        }
        this.canDestroy();
        try {
            this._destroyed = true;
            this.removeControl();
            if (this._myControl != null) {
                ORBManager.getPOA().shutdownObject(this);
                this._myControl = null;
            }
            if (this._transactionHandle != null) {
                this._transactionHandle.setControlHandle(null);
                this._transactionHandle = null;
            }
            this.tidyup();
        }
        catch (Exception e) {
            throw new BAD_OPERATION("ControlImple " + jtsLogger.i18NLogger.get_orbspecific_destroyfailed() + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ControlImple getParentImple() {
        BasicAction parent;
        BasicAction basicAction = parent = this._transactionHandle != null ? this._transactionHandle.parent() : null;
        if (parent != null) {
            try {
                Hashtable hashtable = allControls;
                synchronized (hashtable) {
                    return (ControlImple)allControls.get(parent.get_uid());
                }
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }

    public String toString() {
        return "ControlImple < " + this.get_uid() + " >";
    }

    public boolean equals(Object obj) {
        return obj instanceof ControlImple && ((ControlImple)obj).get_uid().equals(this.get_uid());
    }

    public Status getFinalStatus() throws IllegalStateException {
        if (this.getImplHandle() != null) {
            throw new IllegalStateException();
        }
        return this._finalStatus;
    }

    protected synchronized void canDestroy() throws ActiveTransaction, ActiveThreads, BadControl, Destroyed, SystemException {
        this.canDestroy(true);
    }

    protected synchronized void canDestroy(boolean force) throws ActiveTransaction, ActiveThreads, BadControl, Destroyed, SystemException {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)("Control::canDestroy ( " + force + " ) called for " + this.get_uid()));
        }
        if (this._destroyed) {
            throw new Destroyed();
        }
        if (this._transactionHandle != null) {
            if (this._transactionHandle.activeThreads() != 0 && !force) {
                if (jtsLogger.logger.isTraceEnabled()) {
                    jtsLogger.logger.trace((Object)("ControlImple::canDestroy for " + this.get_uid() + " - transaction has " + this._transactionHandle.activeThreads() + " active threads."));
                }
                throw new ActiveThreads();
            }
            boolean active = false;
            try {
                active = !force && this._transactionHandle.status() != 8 && this._transactionHandle.status() != 4 && this._transactionHandle.status() != 7;
            }
            catch (Exception e) {
                active = true;
            }
            if (active) {
                if (jtsLogger.logger.isTraceEnabled()) {
                    jtsLogger.logger.trace((Object)("Control::canDestroy for " + this.get_uid() + " - transaction active."));
                }
                throw new ActiveTransaction();
            }
        }
    }

    protected ControlImple(Coordinator coordinator, Terminator terminator) {
        this(coordinator, terminator, null, null);
    }

    protected ControlImple(Coordinator coordinator, Terminator terminator, Uid uid) {
        this(coordinator, terminator, null, uid);
    }

    protected ControlImple(Coordinator coordinator, Terminator terminator, Control parentControl, Uid uid) {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)("ControlImple::ControlImple (Coordinator, Terminator, Control, " + uid + " )"));
        }
        this._theTerminator = terminator;
        this._theCoordinator = coordinator;
        this._parentControl = parentControl;
        this._transactionHandle = null;
        this._transactionImpl = null;
        this._myControl = null;
        this._destroyed = false;
        if (uid == null) {
            UidCoordinator uidCoord = Helper.getUidCoordinator(coordinator);
            if (uidCoord != null) {
                try {
                    this._theUid = Helper.getUid(uidCoord);
                }
                catch (Exception e) {
                    this._theUid = new Uid();
                }
                uidCoord = null;
            } else {
                this._theUid = new Uid();
            }
        } else {
            this._theUid = uid;
        }
        this.duplicateTransactionHandle(coordinator, terminator);
        this.addControl();
    }

    protected ControlImple() {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)"ControlImple::ControlImple ()");
        }
        this._theTerminator = null;
        this._theCoordinator = null;
        this._parentControl = null;
        this._transactionHandle = null;
        this._theUid = Uid.nullUid();
        this._transactionImpl = null;
        this._myControl = null;
        this._destroyed = false;
    }

    protected final void createTransactionHandle() {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)"ControlImple::createTransactionHandle ()");
        }
        this._transactionImpl = new ArjunaTransactionPOATie(this._transactionHandle);
        ORBManager.getPOA().objectIsReady(this._transactionImpl);
        ArjunaTransaction transactionReference = ArjunaTransactionHelper.narrow(ORBManager.getPOA().corbaReference(this._transactionImpl));
        this._theCoordinator = UidCoordinatorHelper.narrow(transactionReference);
        this._theTerminator = TerminatorHelper.narrow(transactionReference);
        transactionReference = null;
    }

    protected final void duplicateTransactionHandle(Coordinator coord, Terminator term) {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)"ControlImple::duplicateTransactionHandle ()");
        }
        this._theCoordinator = coord;
        this._theTerminator = term;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addControl() {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)"ControlImple::addControl ()");
        }
        try {
            Hashtable hashtable = allControls;
            synchronized (hashtable) {
                allControls.put(this.get_uid(), this);
            }
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeControl() {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)"ControlImple::removeControl ()");
        }
        try {
            Hashtable hashtable = allControls;
            synchronized (hashtable) {
                allControls.remove(this.get_uid());
            }
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    protected final void tidyup() {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)"ControlImple::tidyup ()");
        }
        this._myControl = null;
        this._parentControl = null;
        try {
            if (this._transactionImpl != null) {
                this._finalStatus = this._transactionImpl.get_status();
                ORBManager.getPOA().shutdownObject(this._transactionImpl);
                this._transactionHandle = null;
                this._transactionImpl = null;
            }
        }
        catch (Exception e) {
            jtsLogger.i18NLogger.warn_orbspecific_tidyfail("ControlImple.tidyup", e);
        }
    }
}

