/*
 * JBoss, Home of Professional Open Source
 * Copyright 2020, Red Hat, Inc. and/or its affiliates,
 * and individual contributors as indicated by the @author tags.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2020,
 * @author JBoss, by Red Hat.
 */
package com.arjuna.ats.internal.jta.recovery.arjunacore;

import javax.transaction.xa.XAResource;
import java.util.Objects;

public class NameScopedXAResource implements NameScopedElement {

    private final XAResource xaResource;
    private final String jndiName;

    public NameScopedXAResource(XAResource xaResource, String jndiName) {
        this.xaResource = xaResource;
        this.jndiName = jndiName;
    }

    public XAResource getXaResource() {
        return xaResource;
    }

    @Override
    public String getJndiName() {
        return jndiName;
    }

    @Override
    public boolean isSameName(NameScopedElement other) {
        return jndiName != null && jndiName.equals(other.getJndiName());
    }

    @Override
    public boolean isAnonymous() {
        return jndiName == null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        NameScopedXAResource that = (NameScopedXAResource) o;
        return xaResource.equals(that.xaResource) &&
                Objects.equals(jndiName, that.jndiName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(xaResource, jndiName);
    }

    @Override
    public String toString() {
        return "NameScopedXAResource{" +
                "xaResource=" + xaResource +
                ", jndiName='" + jndiName + '\'' +
                '}';
    }
}