/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.transaction.arjunacore;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
import com.arjuna.ats.arjuna.coordinator.ActionStatus;
import com.arjuna.ats.arjuna.coordinator.BasicAction;
import com.arjuna.ats.arjuna.coordinator.TransactionReaper;
import com.arjuna.ats.arjuna.exceptions.FatalError;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.internal.arjuna.abstractrecords.LastResourceRecord;
import com.arjuna.ats.internal.jta.resources.arjunacore.CommitMarkableResourceRecord;
import com.arjuna.ats.internal.jta.resources.arjunacore.SynchronizationImple;
import com.arjuna.ats.internal.jta.resources.arjunacore.XAOnePhaseResource;
import com.arjuna.ats.internal.jta.resources.arjunacore.XAResourceRecord;
import com.arjuna.ats.internal.jta.resources.arjunacore.XAResourceRecordWrappingPlugin;
import com.arjuna.ats.internal.jta.transaction.arjunacore.AtomicAction;
import com.arjuna.ats.internal.jta.utils.XAUtils;
import com.arjuna.ats.internal.jta.utils.arjunacore.StatusConverter;
import com.arjuna.ats.internal.jta.xa.TxInfo;
import com.arjuna.ats.jta.common.JTAEnvironmentBean;
import com.arjuna.ats.jta.common.jtaPropertyManager;
import com.arjuna.ats.jta.exceptions.InactiveTransactionException;
import com.arjuna.ats.jta.exceptions.InvalidTerminationStateException;
import com.arjuna.ats.jta.logging.jtaLogger;
import com.arjuna.ats.jta.resources.LastResourceCommitOptimisation;
import com.arjuna.ats.jta.utils.JTAHelper;
import com.arjuna.ats.jta.utils.XAHelper;
import com.arjuna.ats.jta.xa.XAModifier;
import com.arjuna.ats.jta.xa.XidImple;
import com.arjuna.common.internal.util.propertyservice.BeanPopulator;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.tm.ConnectableResource;
import org.jboss.tm.XAResourceWrapper;

public class TransactionImple
implements Transaction,
com.arjuna.ats.jta.transaction.Transaction {
    protected com.arjuna.ats.arjuna.AtomicAction _theTransaction;
    private Hashtable _resources;
    private Hashtable _duplicateResources;
    private int _suspendCount;
    private final boolean _xaTransactionTimeoutEnabled;
    private Map _txLocalResources;
    private Throwable _rollbackOnlyCallerStacktrace;
    private static final boolean XA_TRANSACTION_TIMEOUT_ENABLED = jtaPropertyManager.getJTAEnvironmentBean().isXaTransactionTimeoutEnabled();
    private static final Class LAST_RESOURCE_OPTIMISATION_INTERFACE = jtaPropertyManager.getJTAEnvironmentBean().getLastResourceOptimisationInterface();
    protected static final XAResourceRecordWrappingPlugin _xaResourceRecordWrappingPlugin = jtaPropertyManager.getJTAEnvironmentBean().getXAResourceRecordWrappingPlugin();
    private static final ConcurrentHashMap _transactions;
    private static final List<String> commitMarkableResourceJNDINames;

    public TransactionImple(int timeout) {
        this._theTransaction = new AtomicAction();
        this._theTransaction.begin(timeout);
        this._resources = new Hashtable();
        this._duplicateResources = new Hashtable();
        this._suspendCount = 0;
        this._xaTransactionTimeoutEnabled = TransactionImple.getXATransactionTimeoutEnabled();
        this._txLocalResources = Collections.synchronizedMap(new HashMap());
    }

    public boolean equals(Object obj) {
        if (jtaLogger.logger.isTraceEnabled()) {
            jtaLogger.logger.trace((Object)"TransactionImple.equals");
        }
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof TransactionImple) {
            try {
                TransactionImple tx2 = (TransactionImple)obj;
                return tx2.get_uid().equals(this._theTransaction.get_uid());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public int hashCode() {
        if (this._theTransaction == null) {
            return -1;
        }
        return this._theTransaction.get_uid().hashCode();
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException, IllegalStateException {
        if (jtaLogger.logger.isTraceEnabled()) {
            jtaLogger.logger.trace((Object)"TransactionImple.commit");
        }
        if (this._theTransaction != null) {
            switch (this._theTransaction.status()) {
                case 0: 
                case 3: {
                    break;
                }
                default: {
                    throw new IllegalStateException(jtaLogger.i18NLogger.get_transaction_arjunacore_inactive(this._theTransaction.get_uid()));
                }
            }
            if (!this.endSuspendedRMs()) {
                this._theTransaction.preventCommit();
            }
            int status = this._theTransaction.end(true);
            TransactionImple.removeTransaction(this);
            switch (status) {
                case 6: 
                case 7: {
                    break;
                }
                case 13: {
                    throw this.addSuppressedThrowables(new HeuristicMixedException());
                }
                case 14: {
                    throw this.addSuppressedThrowables(new HeuristicMixedException());
                }
                case 4: 
                case 11: {
                    RollbackException rollbackException = new RollbackException(jtaLogger.i18NLogger.get_transaction_arjunacore_commitwhenaborted());
                    if (this._theTransaction.getDeferredThrowable() != null) {
                        rollbackException.initCause(this._theTransaction.getDeferredThrowable());
                    }
                    throw this.addSuppressedThrowables(rollbackException);
                }
                default: {
                    throw new IllegalStateException(jtaLogger.i18NLogger.get_transaction_arjunacore_invalidstate());
                }
            }
        } else {
            throw new IllegalStateException(jtaLogger.i18NLogger.get_transaction_arjunacore_inactive());
        }
    }

    <T extends Exception> T addSuppressedThrowables(T e) {
        for (Throwable t : this._theTransaction.getDeferredThrowables()) {
            e.addSuppressed(t);
        }
        return e;
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        if (jtaLogger.logger.isTraceEnabled()) {
            jtaLogger.logger.trace((Object)"TransactionImple.rollback");
        }
        if (this._theTransaction != null) {
            boolean endSuspendedFailed;
            switch (this._theTransaction.status()) {
                case 0: 
                case 3: {
                    break;
                }
                default: {
                    throw new IllegalStateException(jtaLogger.i18NLogger.get_transaction_arjunacore_inactive(this._theTransaction.get_uid()));
                }
            }
            boolean bl = endSuspendedFailed = !this.endSuspendedRMs();
            if (endSuspendedFailed) {
                jtaLogger.i18NLogger.warn_transaction_arjunacore_endsuspendfailed1();
            }
            int outcome = this._theTransaction.cancel();
            TransactionImple.removeTransaction(this);
            switch (outcome) {
                case 2: 
                case 4: {
                    break;
                }
                default: {
                    throw new IllegalStateException(jtaLogger.i18NLogger.get_transaction_arjunacore_rollbackstatus() + ActionStatus.stringForm(outcome));
                }
            }
            if (endSuspendedFailed) {
                throw new IllegalStateException(jtaLogger.i18NLogger.get_transaction_arjunacore_endsuspendfailed2());
            }
        } else {
            throw new IllegalStateException(jtaLogger.i18NLogger.get_transaction_arjunacore_inactive());
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        block8: {
            block6: {
                block7: {
                    if (jtaLogger.logger.isTraceEnabled()) {
                        jtaLogger.logger.trace((Object)"TransactionImple.setRollbackOnly");
                    }
                    if (this._theTransaction == null) break block6;
                    if (this._theTransaction.preventCommit()) break block7;
                    switch (this.getStatus()) {
                        case 4: 
                        case 9: {
                            break block8;
                        }
                        case 2: 
                        case 7: {
                            throw new InvalidTerminationStateException(jtaLogger.i18NLogger.get_transaction_arjunacore_invalidstate());
                        }
                        default: {
                            throw new InactiveTransactionException(jtaLogger.i18NLogger.get_transaction_arjunacore_inactive(this._theTransaction.get_uid()));
                        }
                    }
                }
                if (this._rollbackOnlyCallerStacktrace == null) {
                    this._rollbackOnlyCallerStacktrace = new Throwable("setRollbackOnly called from:");
                }
                break block8;
            }
            throw new IllegalStateException(jtaLogger.i18NLogger.get_transaction_arjunacore_inactive());
        }
    }

    public int getStatus() throws SystemException {
        int status = 6;
        if (this._theTransaction != null) {
            status = StatusConverter.convert(this._theTransaction.status());
        }
        if (jtaLogger.logger.isTraceEnabled()) {
            jtaLogger.logger.trace((Object)("TransactionImple.getStatus: " + JTAHelper.stringForm(status)));
        }
        return status;
    }

    public void registerSynchronization(Synchronization sync) throws RollbackException, IllegalStateException, SystemException {
        if (jtaLogger.logger.isTraceEnabled()) {
            jtaLogger.logger.trace((Object)("TransactionImple.registerSynchronization - Class: " + sync.getClass() + " HashCode: " + sync.hashCode() + " toString: " + sync));
        }
        if (sync == null) {
            throw new SystemException("TransactionImple.registerSynchronization - " + jtaLogger.i18NLogger.get_transaction_arjunacore_nullparam());
        }
        this.registerSynchronizationImple(new SynchronizationImple(sync, false));
    }

    void registerSynchronizationImple(SynchronizationImple synchronizationImple) throws RollbackException, IllegalStateException, SystemException {
        if (this._theTransaction != null) {
            if (this._theTransaction.addSynchronization(synchronizationImple) != 2) {
                int status = this._theTransaction.status();
                switch (status) {
                    case 3: 
                    case 4: {
                        throw new RollbackException(jtaLogger.i18NLogger.get_transaction_arjunacore_syncwhenaborted());
                    }
                    case 8: {
                        throw new IllegalStateException(jtaLogger.i18NLogger.get_transaction_arjunacore_inactive(this._theTransaction.get_uid()));
                    }
                }
                throw new IllegalStateException(jtaLogger.i18NLogger.get_transaction_arjunacore_syncsnotallowed() + ActionStatus.stringForm(status));
            }
        } else {
            throw new IllegalStateException(jtaLogger.i18NLogger.get_transaction_arjunacore_inactive());
        }
    }

    public boolean enlistResource(XAResource xaRes) throws RollbackException, IllegalStateException, SystemException {
        return this.enlistResource(xaRes, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean enlistResource(XAResource xaRes, Object[] params) throws RollbackException, IllegalStateException, SystemException {
        if (jtaLogger.logger.isTraceEnabled()) {
            jtaLogger.logger.trace((Object)("TransactionImple.enlistResource ( " + xaRes + " )"));
        }
        if (xaRes == null) {
            throw new SystemException("TransactionImple.enlistResource - " + jtaLogger.i18NLogger.get_transaction_arjunacore_nullres());
        }
        int status = this.getStatus();
        switch (status) {
            case 1: {
                throw new RollbackException("TransactionImple.enlistResource - " + jtaLogger.i18NLogger.get_transaction_arjunacore_invalidstate());
            }
            case 0: {
                break;
            }
            default: {
                throw new IllegalStateException(jtaLogger.i18NLogger.get_transaction_arjunacore_inactive());
            }
        }
        XAModifier theModifier = null;
        if (params != null && params.length >= 2 && params[1] instanceof XAModifier) {
            theModifier = (XAModifier)params[1];
        }
        try {
            block44: {
                TxInfo info = null;
                try {
                    TransactionImple transactionImple = this;
                    synchronized (transactionImple) {
                        info = (TxInfo)this._resources.get(xaRes);
                        if (info == null) {
                            info = (TxInfo)this._duplicateResources.get(xaRes);
                        }
                    }
                    if (info == null) break block44;
                    switch (info.getState()) {
                        case 2: {
                            int xaStartResume = theModifier == null ? 0x8000000 : theModifier.xaStartParameters(0x8000000);
                            xaRes.start(info.xid(), xaStartResume);
                            info.setState(0);
                            TransactionImple transactionImple2 = this;
                            synchronized (transactionImple2) {
                                --this._suspendCount;
                            }
                            return true;
                        }
                        case 0: {
                            return true;
                        }
                        case 1: {
                            int xaStartJoin = theModifier == null ? 0x200000 : theModifier.xaStartParameters(0x200000);
                            xaRes.start(info.xid(), xaStartJoin);
                            info.setState(0);
                            return true;
                        }
                    }
                    throw new IllegalStateException("TransactionImple.enlistResource - " + jtaLogger.i18NLogger.get_transaction_arjunacore_illresstate() + ":" + info.getState());
                }
                catch (IllegalStateException ex) {
                    throw ex;
                }
                catch (XAException exp) {
                    if (info != null) {
                        info.setState(3);
                    }
                    jtaLogger.i18NLogger.warn_transaction_arjunacore_enlisterror("TransactionImple.enlistResource", XAHelper.printXAErrorCode(exp));
                    return false;
                }
            }
            Xid xid = null;
            TxInfo existingRM = this.isNewRM(xaRes);
            if (existingRM == null) {
                boolean branchRequired = true;
                TransactionImple transactionImple = this;
                synchronized (transactionImple) {
                    if (this._resources.size() == 0) {
                        branchRequired = true;
                    }
                }
                xid = this.createXid(branchRequired, theModifier, xaRes);
                boolean associatedWork = false;
                int retry = 20;
                while (!associatedWork) {
                    try {
                        int timeout;
                        if (this._xaTransactionTimeoutEnabled && (timeout = this._theTransaction.getTimeout()) > 0) {
                            try {
                                xaRes.setTransactionTimeout(timeout);
                            }
                            catch (XAException te) {
                                jtaLogger.i18NLogger.warn_transaction_arjunacore_timeouterror("TransactionImple.enlistResource", XAHelper.xidToString(xid), XAHelper.printXAErrorCode(te), te);
                            }
                        }
                        int xaStartNormal = theModifier == null ? 0 : theModifier.xaStartParameters(0);
                        AbstractRecord abstractRecord = this.createRecord(xaRes, params, xid);
                        if (abstractRecord != null) {
                            xaRes.start(xid, xaStartNormal);
                            if (this._theTransaction.add(abstractRecord) == 2) {
                                this._resources.put(xaRes, new TxInfo(xid));
                                return true;
                            }
                            abstractRecord.topLevelAbort();
                        }
                        this.markRollbackOnly();
                        return false;
                    }
                    catch (XAException e) {
                        if (e.errorCode == -8 || e.errorCode == -3) {
                            if (retry > 0) {
                                xid = this.createXid(true, theModifier, xaRes);
                            }
                        } else {
                            jtaLogger.i18NLogger.warn_transaction_arjunacore_enliststarterror("TransactionImple.enlistResource", XAHelper.xidToString(xid), XAHelper.printXAErrorCode(e), e);
                            this.markRollbackOnly();
                            throw e;
                        }
                        if (--retry >= 0) continue;
                        jtaLogger.i18NLogger.warn_transaction_arjunacore_enliststarterror("TransactionImple.enlistResource", XAHelper.xidToString(xid), XAHelper.printXAErrorCode(e), e);
                        this.markRollbackOnly();
                        throw new SystemException("TransactionImple.enlistResource - XAResource.start " + jtaLogger.i18NLogger.get_transaction_arjunacore_couldnotregister() + ": " + xid);
                    }
                }
            } else {
                xid = existingRM.xid();
                try {
                    int xaStartJoin = theModifier == null ? 0x200000 : theModifier.xaStartParameters(0x200000);
                    xaRes.start(xid, xaStartJoin);
                }
                catch (XAException ex) {
                    jtaLogger.i18NLogger.warn_transaction_arjunacore_xastart("TransactionImple.enlistResource - xa_start ", XAHelper.xidToString(xid), XAHelper.printXAErrorCode(ex), ex);
                    this.markRollbackOnly();
                    throw ex;
                }
                this._duplicateResources.put(xaRes, new TxInfo(xid));
                return true;
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.markRollbackOnly();
            return false;
        }
    }

    private AbstractRecord createRecord(XAResource xaRes, Object[] params, Xid xid) {
        if (xaRes instanceof LastResourceCommitOptimisation || LAST_RESOURCE_OPTIMISATION_INTERFACE != null && LAST_RESOURCE_OPTIMISATION_INTERFACE.isInstance(xaRes)) {
            String jndiName;
            if (xaRes instanceof ConnectableResource && commitMarkableResourceJNDINames.contains(jndiName = ((XAResourceWrapper)xaRes).getJndiName())) {
                try {
                    return new CommitMarkableResourceRecord(this, (ConnectableResource)xaRes, xid, this._theTransaction);
                }
                catch (IllegalStateException | RollbackException | SystemException e) {
                    tsLogger.logger.warn((Object)"Could not register synchronization for CommitMarkableResourceRecord", e);
                    return null;
                }
            }
            return new LastResourceRecord(new XAOnePhaseResource(xaRes, xid, params));
        }
        return new XAResourceRecord(this, xaRes, xid, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delistResource(XAResource xaRes, int flags) throws IllegalStateException, SystemException {
        if (jtaLogger.logger.isTraceEnabled()) {
            jtaLogger.logger.trace((Object)("TransactionImple.delistResource ( " + xaRes + ", " + flags + " )"));
        }
        if (xaRes == null) {
            throw new SystemException("TransactionImple.delistResource - " + jtaLogger.i18NLogger.get_transaction_arjunacore_nullres());
        }
        int status = this.getStatus();
        switch (status) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw new IllegalStateException(jtaLogger.i18NLogger.get_transaction_arjunacore_inactive());
            }
        }
        TxInfo info = null;
        try {
            TransactionImple transactionImple = this;
            synchronized (transactionImple) {
                info = (TxInfo)this._resources.get(xaRes);
                if (info == null) {
                    info = (TxInfo)this._duplicateResources.get(xaRes);
                }
            }
            if (info == null) {
                jtaLogger.i18NLogger.warn_transaction_arjunacore_unknownresource("TransactionImple.delistResource");
                return false;
            }
            boolean optimizedRollback = false;
            try {
                if (status == 1 && XAUtils.canOptimizeDelist(xaRes)) {
                    xaRes.end(info.xid(), 0x20000000);
                    xaRes.rollback(info.xid());
                    info.setState(4);
                    optimizedRollback = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            switch (info.getState()) {
                case 0: {
                    if ((flags & 0x4000000) != 0) {
                        xaRes.end(info.xid(), 0x4000000);
                        info.setState(1);
                        break;
                    }
                    if ((flags & 0x2000000) != 0) {
                        xaRes.end(info.xid(), 0x2000000);
                        info.setState(2);
                        TransactionImple transactionImple2 = this;
                        synchronized (transactionImple2) {
                            ++this._suspendCount;
                            break;
                        }
                    }
                    xaRes.end(info.xid(), 0x20000000);
                    info.setState(3);
                    break;
                }
                case 2: {
                    if ((flags & 0x4000000) != 0) {
                        if (XAUtils.mustEndSuspendedRMs(xaRes)) {
                            xaRes.start(info.xid(), 0x8000000);
                        }
                        xaRes.end(info.xid(), 0x4000000);
                        info.setState(1);
                        TransactionImple transactionImple3 = this;
                        synchronized (transactionImple3) {
                            --this._suspendCount;
                            break;
                        }
                    }
                    if ((flags & 0x2000000) != 0) {
                        throw new IllegalStateException("TransactionImple.delistResource - " + jtaLogger.i18NLogger.get_transaction_arjunacore_ressuspended());
                    }
                    xaRes.end(info.xid(), 0x20000000);
                    info.setState(3);
                    TransactionImple transactionImple4 = this;
                    synchronized (transactionImple4) {
                        --this._suspendCount;
                        break;
                    }
                }
                default: {
                    if (optimizedRollback) break;
                    throw new IllegalStateException("TransactionImple.delistResource - " + jtaLogger.i18NLogger.get_transaction_arjunacore_illresstate() + ":" + info.getState());
                }
            }
            info = null;
            return true;
        }
        catch (IllegalStateException ex) {
            throw ex;
        }
        catch (XAException exp) {
            if (info != null) {
                info.setState(3);
            }
            this.markRollbackOnly();
            jtaLogger.i18NLogger.warn_transaction_arjunacore_delistresource("TransactionImple.delistResource", XAHelper.printXAErrorCode(exp), exp);
            return false;
        }
        catch (Exception e) {
            jtaLogger.i18NLogger.warn_transaction_arjunacore_delistgeneral("TransactionImple.delistResource", e);
            this.markRollbackOnly();
            return false;
        }
    }

    @Override
    public final Uid get_uid() {
        return this._theTransaction.get_uid();
    }

    @Override
    public final Xid getTxId() {
        Xid res = this.baseXid();
        if (res == null) {
            res = new XidImple(this._theTransaction);
        }
        return res;
    }

    public String toString() {
        if (this._theTransaction == null) {
            return "TransactionImple < ac, NoTransaction >";
        }
        return "TransactionImple < ac, " + this._theTransaction + " >";
    }

    @Override
    public int getXAResourceState(XAResource xaRes) {
        int state = 5;
        if (xaRes != null) {
            TxInfo info = (TxInfo)this._resources.get(xaRes);
            if (info == null) {
                info = (TxInfo)this._duplicateResources.get(xaRes);
            }
            if (info != null) {
                state = info.getState();
            }
        }
        return state;
    }

    public void setXAResourceState(XAResource xaRes, int state) {
        if (xaRes != null) {
            TxInfo info = (TxInfo)this._resources.get(xaRes);
            if (info == null) {
                info = (TxInfo)this._duplicateResources.get(xaRes);
            }
            if (info != null) {
                info.setState(state);
            }
        }
    }

    public static final TransactionImple getTransaction() {
        Uid txid;
        TransactionImple tx2 = null;
        BasicAction current = BasicAction.Current();
        if (current != null && (tx2 = (TransactionImple)_transactions.get(txid = current.get_uid())) == null) {
            tx2 = new TransactionImple(current);
        }
        return tx2;
    }

    public static final TransactionImple getTransaction(Uid id) {
        try {
            if (id != null) {
                return (TransactionImple)_transactions.get(id);
            }
            return null;
        }
        catch (Exception e) {
            return new TransactionImple(null);
        }
    }

    @Override
    public Object getTxLocalResource(Object key) {
        return this._txLocalResources.get(key);
    }

    @Override
    public void putTxLocalResource(Object key, Object value) {
        this._txLocalResources.put(key, value);
    }

    @Override
    public boolean isAlive() {
        try {
            if (this._theTransaction != null) {
                return _transactions.containsKey(this.get_uid());
            }
            return false;
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    protected TransactionImple() {
        this(null);
    }

    protected TransactionImple(BasicAction curr) {
        try {
            this._theTransaction = curr == null ? (com.arjuna.ats.arjuna.AtomicAction)BasicAction.Current() : (com.arjuna.ats.arjuna.AtomicAction)curr;
        }
        catch (ClassCastException ex) {
            jtaLogger.i18NLogger.warn_transaction_arjunacore_notatomicaction();
        }
        if (this._theTransaction != null) {
            this._resources = new Hashtable();
            this._duplicateResources = new Hashtable();
            this._txLocalResources = Collections.synchronizedMap(new HashMap());
        } else {
            this._resources = null;
            this._duplicateResources = null;
        }
        this._suspendCount = 0;
        this._xaTransactionTimeoutEnabled = TransactionImple.getXATransactionTimeoutEnabled();
    }

    final com.arjuna.ats.arjuna.AtomicAction getAtomicAction() {
        return this._theTransaction;
    }

    protected void commitAndDisassociate() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException, IllegalStateException {
        block21: {
            if (jtaLogger.logger.isTraceEnabled()) {
                jtaLogger.logger.trace((Object)"TransactionImple.commitAndDisassociate");
            }
            try {
                if (this._theTransaction != null) {
                    switch (this._theTransaction.status()) {
                        case 2: 
                        case 4: {
                            this._theTransaction.abort();
                            throw this.addSuppressedThrowables(new RollbackException(jtaLogger.i18NLogger.get_transaction_arjunacore_inactive(this._theTransaction.get_uid())));
                        }
                        case 6: 
                        case 7: {
                            this._theTransaction.commit(true);
                            return;
                        }
                    }
                    Throwable preexistingRollbackOnlyCallerStacktrace = this._rollbackOnlyCallerStacktrace;
                    switch (this._theTransaction.commit(true)) {
                        case 6: 
                        case 7: {
                            break;
                        }
                        case 13: {
                            throw this.addSuppressedThrowables(new HeuristicMixedException());
                        }
                        case 14: {
                            throw this.addSuppressedThrowables(new HeuristicMixedException());
                        }
                        case 2: 
                        case 4: 
                        case 11: {
                            RollbackException rollbackException = this.addSuppressedThrowables(new RollbackException(jtaLogger.i18NLogger.get_transaction_arjunacore_commitwhenaborted()));
                            if (preexistingRollbackOnlyCallerStacktrace != null) {
                                rollbackException.initCause(preexistingRollbackOnlyCallerStacktrace);
                            } else if (this._theTransaction.getDeferredThrowable() != null) {
                                rollbackException.initCause(this._theTransaction.getDeferredThrowable());
                            } else if (this._rollbackOnlyCallerStacktrace != null) {
                                rollbackException.initCause(this._rollbackOnlyCallerStacktrace);
                            }
                            throw rollbackException;
                        }
                        default: {
                            throw this.addSuppressedThrowables(new InvalidTerminationStateException(jtaLogger.i18NLogger.get_transaction_arjunacore_invalidstate()));
                        }
                    }
                    break block21;
                }
                throw this.addSuppressedThrowables(new IllegalStateException(jtaLogger.i18NLogger.get_transaction_arjunacore_inactive()));
            }
            finally {
                TransactionImple.removeTransaction(this);
            }
        }
    }

    protected Xid baseXid() {
        return null;
    }

    protected void rollbackAndDisassociate() throws IllegalStateException, SecurityException, SystemException {
        if (jtaLogger.logger.isTraceEnabled()) {
            jtaLogger.logger.trace((Object)"TransactionImple.rollbackAndDisassociate");
        }
        try {
            boolean statusIsValid = false;
            if (this._theTransaction != null) {
                if (this._theTransaction.status() == 0 || this._theTransaction.status() == 3) {
                    statusIsValid = true;
                }
                int outcome = this._theTransaction.abort();
                switch (outcome) {
                    case 2: 
                    case 4: {
                        statusIsValid = true;
                        break;
                    }
                    default: {
                        throw new InactiveTransactionException(jtaLogger.i18NLogger.get_transaction_arjunacore_rollbackstatus() + ActionStatus.stringForm(outcome));
                    }
                }
            }
            if (this._theTransaction == null || !statusIsValid) {
                throw new IllegalStateException(jtaLogger.i18NLogger.get_transaction_arjunacore_inactive());
            }
        }
        finally {
            TransactionImple.removeTransaction(this);
        }
    }

    protected boolean endSuspendedRMs() {
        boolean result = true;
        if (this._suspendCount > 0) {
            TxInfo info;
            XAResource xaRes;
            Enumeration el = this._resources.keys();
            if (el != null) {
                try {
                    while (el.hasMoreElements()) {
                        xaRes = (XAResource)el.nextElement();
                        info = (TxInfo)this._resources.get(xaRes);
                        if (info.getState() != 2) continue;
                        if (XAUtils.mustEndSuspendedRMs(xaRes)) {
                            xaRes.start(info.xid(), 0x8000000);
                        }
                        xaRes.end(info.xid(), 0x4000000);
                        info.setState(1);
                    }
                }
                catch (XAException ex) {
                    jtaLogger.i18NLogger.warn_transaction_arjunacore_xaenderror(ex);
                    result = false;
                }
            }
            if ((el = this._duplicateResources.keys()) != null) {
                try {
                    while (el.hasMoreElements()) {
                        xaRes = (XAResource)el.nextElement();
                        info = (TxInfo)this._duplicateResources.get(xaRes);
                        if (info.getState() != 2) continue;
                        if (XAUtils.mustEndSuspendedRMs(xaRes)) {
                            xaRes.start(info.xid(), 0x8000000);
                        }
                        xaRes.end(info.xid(), 0x4000000);
                        info.setState(1);
                    }
                }
                catch (XAException ex) {
                    jtaLogger.i18NLogger.warn_transaction_arjunacore_xaenderror(ex);
                    result = false;
                }
            }
            this._suspendCount = 0;
        }
        return result;
    }

    private final boolean threadIsActive(XAResource xaRes) {
        Thread t = Thread.currentThread();
        try {
            TxInfo info;
            XAResource x;
            Enumeration el = this._resources.keys();
            if (el != null) {
                while (el.hasMoreElements()) {
                    x = (XAResource)el.nextElement();
                    if (!x.isSameRM(xaRes) || (info = (TxInfo)this._resources.get(x)).thread() != t) continue;
                    return true;
                }
            }
            if ((el = this._duplicateResources.keys()) != null) {
                while (el.hasMoreElements()) {
                    x = (XAResource)el.nextElement();
                    if (!x.isSameRM(xaRes) || (info = (TxInfo)this._resources.get(x)).thread() != t) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            jtaLogger.i18NLogger.warn_transaction_arjunacore_threadexception(e);
            throw new FatalError(e.toString(), e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final TxInfo isNewRM(XAResource xaRes) {
        try {
            TransactionImple transactionImple = this;
            synchronized (transactionImple) {
                XAResource x;
                Enumeration el = this._resources.keys();
                if (el != null) {
                    while (el.hasMoreElements()) {
                        x = (XAResource)el.nextElement();
                        if (!x.isSameRM(xaRes)) continue;
                        return (TxInfo)this._resources.get(x);
                    }
                }
                if ((el = this._duplicateResources.keys()) != null) {
                    while (el.hasMoreElements()) {
                        x = (XAResource)el.nextElement();
                        if (!x.isSameRM(xaRes)) continue;
                        return (TxInfo)this._duplicateResources.get(x);
                    }
                }
            }
        }
        catch (XAException ex) {
            jtaLogger.i18NLogger.warn_transaction_arjunacore_newtmerror("TransactionImple.isNewRM", XAHelper.printXAErrorCode(ex), ex);
            throw new FatalError(ex.toString(), ex);
        }
        catch (Exception e) {
            jtaLogger.i18NLogger.warn_transaction_arjunacore_newtmerror("TransactionImple.isNewRM", "-", e);
            throw new FatalError(e.toString(), e);
        }
        return null;
    }

    protected Xid createXid(boolean branch, XAModifier theModifier, XAResource xaResource) throws IOException, ObjectStoreException {
        int eisName = 0;
        if (branch && _xaResourceRecordWrappingPlugin != null) {
            eisName = _xaResourceRecordWrappingPlugin.getEISName(xaResource);
        }
        Xid xid = new XidImple(this._theTransaction.get_uid(), branch, (Integer)eisName);
        if (theModifier != null) {
            try {
                xid = theModifier.createXid(xid);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return xid;
    }

    private final void markRollbackOnly() {
        try {
            this.setRollbackOnly();
        }
        catch (Exception ex) {
            jtaLogger.i18NLogger.warn_transaction_arjunacore_markrollback("TransactionImple.markRollbackOnly", this._theTransaction.toString());
        }
    }

    protected static final void putTransaction(TransactionImple tx2) {
        _transactions.put(tx2.get_uid(), tx2);
    }

    protected static final void removeTransaction(TransactionImple tx2) {
        _transactions.remove(tx2.get_uid());
    }

    private static boolean getXATransactionTimeoutEnabled() {
        return XA_TRANSACTION_TIMEOUT_ENABLED;
    }

    public static Map<Uid, Transaction> getTransactions() {
        return Collections.unmodifiableMap(_transactions);
    }

    @Override
    public Map<XAResource, TxInfo> getResources() {
        return Collections.unmodifiableMap(this._resources);
    }

    @Override
    public int getTimeout() {
        return this._theTransaction.getTimeout();
    }

    @Override
    public long getRemainingTimeoutMills() {
        return TransactionReaper.transactionReaper().getRemainingTimeoutMills(this._theTransaction);
    }

    @Override
    public Map<Uid, String> getSynchronizations() {
        if (this._theTransaction != null) {
            return this._theTransaction.getSynchronizations();
        }
        return Collections.EMPTY_MAP;
    }

    static {
        if (LAST_RESOURCE_OPTIMISATION_INTERFACE == null) {
            jtaLogger.i18NLogger.warn_transaction_arjunacore_lastResourceOptimisationInterface(jtaPropertyManager.getJTAEnvironmentBean().getLastResourceOptimisationInterfaceClassName());
        }
        _transactions = new ConcurrentHashMap();
        commitMarkableResourceJNDINames = BeanPopulator.getDefaultInstance(JTAEnvironmentBean.class).getCommitMarkableResourceJNDINames();
    }
}

