/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.transaction.arjunacore.jca;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.TxControl;
import com.arjuna.ats.arjuna.objectstore.RecoveryStore;
import com.arjuna.ats.arjuna.objectstore.StoreManager;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.internal.arjuna.common.UidHelper;
import com.arjuna.ats.internal.jta.recovery.arjunacore.XARecoveryModule;
import com.arjuna.ats.internal.jta.resources.spi.XATerminatorExtensions;
import com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionImple;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.SubordinateTransaction;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.SubordinationManager;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.TransactionImporter;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.TransactionImporterImple;
import com.arjuna.ats.internal.jta.transaction.arjunacore.subordinate.jca.SubordinateAtomicAction;
import com.arjuna.ats.jta.exceptions.UnexpectedConditionException;
import com.arjuna.ats.jta.logging.jtaLogger;
import com.arjuna.ats.jta.xa.XATxConverter;
import com.arjuna.ats.jta.xa.XidImple;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import javax.resource.spi.XATerminator;
import javax.transaction.HeuristicCommitException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.jboss.tm.ExtendedJBossXATerminator;
import org.jboss.tm.TransactionImportResult;

public class XATerminatorImple
implements XATerminator,
XATerminatorExtensions,
ExtendedJBossXATerminator {
    private boolean _recoveryStarted = false;
    private static final Xid[] NO_XIDS = new Xid[0];

    public void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            SubordinateTransaction tx2 = SubordinationManager.getTransactionImporter().getImportedTransaction(xid);
            if (tx2 == null) {
                throw new XAException(-5);
            }
            if (tx2.activated()) {
                if (onePhase) {
                    tx2.doOnePhaseCommit();
                } else if (!tx2.doCommit()) {
                    throw new XAException(-7);
                }
            } else {
                throw new XAException(4);
            }
            SubordinationManager.getTransactionImporter().removeImportedTransaction(xid);
        }
        catch (RollbackException e) {
            SubordinationManager.getTransactionImporter().removeImportedTransaction(xid);
            XAException xaException = new XAException(100);
            xaException.initCause(e);
            throw xaException;
        }
        catch (XAException ex) {
            if (ex.errorCode != 4) {
                SubordinationManager.getTransactionImporter().removeImportedTransaction(xid);
            }
            throw ex;
        }
        catch (HeuristicRollbackException ex) {
            XAException xaException = new XAException(6);
            xaException.initCause(ex);
            throw xaException;
        }
        catch (HeuristicMixedException ex) {
            XAException xaException = new XAException(5);
            xaException.initCause(ex);
            throw xaException;
        }
        catch (HeuristicCommitException ex) {
            XAException xaException = new XAException(7);
            xaException.initCause(ex);
            throw xaException;
        }
        catch (IllegalStateException ex) {
            SubordinationManager.getTransactionImporter().removeImportedTransaction(xid);
            XAException xaException = new XAException(-4);
            xaException.initCause(ex);
            throw xaException;
        }
        catch (SystemException ex) {
            SubordinationManager.getTransactionImporter().removeImportedTransaction(xid);
            XAException xaException = new XAException(-3);
            xaException.initCause(ex);
            throw xaException;
        }
    }

    public void forget(Xid xid) throws XAException {
        try {
            SubordinateTransaction tx2 = SubordinationManager.getTransactionImporter().getImportedTransaction(xid);
            if (tx2 == null) {
                throw new XAException(-5);
            }
            tx2.doForget();
        }
        catch (Exception ex) {
            XAException xaException = new XAException(-3);
            xaException.initCause(ex);
            throw xaException;
        }
        finally {
            SubordinationManager.getTransactionImporter().removeImportedTransaction(xid);
        }
    }

    public int prepare(Xid xid) throws XAException {
        SubordinateTransaction tx2 = null;
        try {
            tx2 = SubordinationManager.getTransactionImporter().getImportedTransaction(xid);
        }
        catch (XAException xae) {
            if (xae.errorCode == 100) {
                SubordinationManager.getTransactionImporter().removeImportedTransaction(xid);
            }
            throw xae;
        }
        if (tx2 == null) {
            throw new XAException(-5);
        }
        switch (tx2.doPrepare()) {
            case 2: {
                SubordinationManager.getTransactionImporter().removeImportedTransaction(xid);
                return 3;
            }
            case 1: {
                Throwable initCause = null;
                int xaExceptionCode = 100;
                try {
                    tx2.doRollback();
                }
                catch (HeuristicCommitException e) {
                    initCause = e;
                    xaExceptionCode = -3;
                }
                catch (HeuristicMixedException e) {
                    initCause = e;
                    xaExceptionCode = -3;
                }
                catch (SystemException e) {
                    initCause = e;
                    xaExceptionCode = -3;
                }
                catch (HeuristicRollbackException e) {
                    initCause = e;
                    xaExceptionCode = -3;
                }
                SubordinationManager.getTransactionImporter().removeImportedTransaction(xid);
                XAException xaException = new XAException(xaExceptionCode);
                if (initCause != null) {
                    xaException.initCause(initCause);
                }
                throw xaException;
            }
            case 0: {
                return 0;
            }
            case 11: {
                throw new XAException(-4);
            }
        }
        throw new XAException(104);
    }

    public Xid[] recover(int flag) throws XAException {
        switch (flag) {
            case 0x1000000: {
                if (this._recoveryStarted) {
                    throw new XAException(-6);
                }
                this._recoveryStarted = true;
                if (XARecoveryModule.getRegisteredXARecoveryModule() == null) break;
                XARecoveryModule.getRegisteredXARecoveryModule().periodicWorkFirstPass();
                break;
            }
            case 0x800000: {
                if (this._recoveryStarted) {
                    this._recoveryStarted = false;
                    if (XARecoveryModule.getRegisteredXARecoveryModule() != null) {
                        XARecoveryModule.getRegisteredXARecoveryModule().periodicWorkSecondPass();
                    }
                } else {
                    throw new XAException(-6);
                }
                return null;
            }
            case 0: {
                if (this._recoveryStarted) break;
            }
            default: {
                throw new XAException(-6);
            }
        }
        return this.doRecover(null, null);
    }

    public Xid[] doRecover(Xid xid, String parentNodeName) throws XAException {
        Xid[] indoubt;
        block12: {
            indoubt = null;
            try {
                RecoveryStore recoveryStore = StoreManager.getRecoveryStore();
                InputObjectState states = new InputObjectState();
                if (!recoveryStore.allObjUids(SubordinateAtomicAction.getType(), states) || !states.notempty()) break block12;
                Stack<Xid> values = new Stack<Xid>();
                boolean finished = false;
                do {
                    Uid uid = null;
                    try {
                        uid = UidHelper.unpackFrom(states);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        finished = true;
                    }
                    if (uid.notEquals(Uid.nullUid())) {
                        String loadedXidSubordinateNodeName;
                        XidImple loadedXid;
                        SubordinateAtomicAction saa;
                        if (parentNodeName != null) {
                            saa = new SubordinateAtomicAction(uid, true);
                            loadedXid = (XidImple)saa.getXid();
                            if (loadedXid == null || loadedXid.getFormatId() != 131077 || ((loadedXidSubordinateNodeName = XATxConverter.getSubordinateNodeName(loadedXid.getXID())) != null || loadedXidSubordinateNodeName != TxControl.getXANodeName()) && !loadedXidSubordinateNodeName.equals(TxControl.getXANodeName()) || !parentNodeName.equals(saa.getParentNodeName())) continue;
                            if (jtaLogger.logger.isDebugEnabled()) {
                                jtaLogger.logger.debug((Object)("Found record for " + saa));
                            }
                            values.push(loadedXid);
                            continue;
                        }
                        if (xid == null) {
                            com.arjuna.ats.internal.jta.transaction.arjunacore.subordinate.jca.TransactionImple tx2 = (com.arjuna.ats.internal.jta.transaction.arjunacore.subordinate.jca.TransactionImple)SubordinationManager.getTransactionImporter().recoverTransaction(uid);
                            if (tx2 == null) continue;
                            values.push(tx2.baseXid());
                            continue;
                        }
                        saa = new SubordinateAtomicAction(uid, true);
                        loadedXid = (XidImple)saa.getXid();
                        if (loadedXid == null || loadedXid.getFormatId() != 131077) continue;
                        loadedXidSubordinateNodeName = XATxConverter.getSubordinateNodeName(loadedXid.getXID());
                        if (!XATxConverter.getSubordinateNodeName(new XidImple(xid).getXID()).equals(loadedXidSubordinateNodeName) || !Arrays.equals(loadedXid.getGlobalTransactionId(), xid.getGlobalTransactionId())) continue;
                        if (jtaLogger.logger.isDebugEnabled()) {
                            jtaLogger.logger.debug((Object)("Found record for " + saa));
                        }
                        com.arjuna.ats.internal.jta.transaction.arjunacore.subordinate.jca.TransactionImple tx3 = (com.arjuna.ats.internal.jta.transaction.arjunacore.subordinate.jca.TransactionImple)SubordinationManager.getTransactionImporter().recoverTransaction(uid);
                        values.push(loadedXid);
                        continue;
                    }
                    finished = true;
                } while (!finished);
                if (values.size() > 0) {
                    int index = 0;
                    indoubt = new Xid[values.size()];
                    while (!values.empty()) {
                        indoubt[index] = (Xid)values.pop();
                        ++index;
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return indoubt;
    }

    public boolean isRecoveryByNodeOrXidSupported() {
        return true;
    }

    public void rollback(Xid xid) throws XAException {
        SubordinateTransaction tx2 = null;
        try {
            tx2 = SubordinationManager.getTransactionImporter().getImportedTransaction(xid);
        }
        catch (XAException xae) {
            if (xae.errorCode == 100) {
                SubordinationManager.getTransactionImporter().removeImportedTransaction(xid);
                return;
            }
            throw xae;
        }
        try {
            if (tx2 == null) {
                throw new XAException(-5);
            }
            if (!tx2.activated()) {
                throw new XAException(4);
            }
            tx2.doRollback();
            SubordinationManager.getTransactionImporter().removeImportedTransaction(xid);
        }
        catch (XAException ex) {
            if (ex.errorCode != 4) {
                SubordinationManager.getTransactionImporter().removeImportedTransaction(xid);
            }
            throw ex;
        }
        catch (HeuristicRollbackException ex) {
            XAException xaException = new XAException(6);
            xaException.initCause(ex);
            throw xaException;
        }
        catch (HeuristicCommitException ex) {
            XAException xaException = new XAException(7);
            xaException.initCause(ex);
            throw xaException;
        }
        catch (HeuristicMixedException ex) {
            XAException xaException = new XAException(5);
            xaException.initCause(ex);
            throw xaException;
        }
        catch (IllegalStateException ex) {
            SubordinationManager.getTransactionImporter().removeImportedTransaction(xid);
            XAException xaException = new XAException(-4);
            xaException.initCause(ex);
            throw xaException;
        }
        catch (SystemException ex) {
            SubordinationManager.getTransactionImporter().removeImportedTransaction(xid);
            throw new XAException(-3);
        }
    }

    @Override
    public boolean beforeCompletion(Xid xid) throws SystemException {
        try {
            SubordinateTransaction tx2 = SubordinationManager.getTransactionImporter().getImportedTransaction(xid);
            if (tx2 == null) {
                throw new UnexpectedConditionException();
            }
            return tx2.doBeforeCompletion();
        }
        catch (Exception ex) {
            UnexpectedConditionException e = new UnexpectedConditionException();
            e.initCause(ex);
            throw e;
        }
    }

    public Transaction getTransaction(Xid xid) throws XAException {
        Object transaction = com.arjuna.ats.internal.jta.transaction.arjunacore.subordinate.jca.TransactionImple.getTransaction(new XidImple(xid).getTransactionUid());
        if (transaction == null) {
            transaction = SubordinationManager.getTransactionImporter().getImportedTransaction(xid);
        }
        return transaction;
    }

    public TransactionImportResult importTransaction(Xid xid, int timeoutIfNew) throws XAException {
        return SubordinationManager.getTransactionImporter().importRemoteTransaction(xid, timeoutIfNew);
    }

    public SubordinateTransaction getImportedTransaction(Xid xid) throws XAException {
        TransactionImporter transactionImporter = SubordinationManager.getTransactionImporter();
        return transactionImporter.getImportedTransaction(xid);
    }

    public Transaction getTransactionById(Object id) {
        if (id instanceof Uid) {
            return com.arjuna.ats.internal.jta.transaction.arjunacore.subordinate.jca.TransactionImple.getTransaction((Uid)id);
        }
        return null;
    }

    public Object getCurrentTransactionId() {
        TransactionImple transaction = com.arjuna.ats.internal.jta.transaction.arjunacore.subordinate.jca.TransactionImple.getTransaction();
        if (transaction == null) {
            return null;
        }
        return transaction.get_uid();
    }

    public void removeImportedTransaction(Xid xid) throws XAException {
        SubordinationManager.getTransactionImporter().removeImportedTransaction(xid);
    }

    public Xid[] getXidsToRecoverForParentNode(boolean recoverInFlight, String parentNodeName, int recoveryFlags) throws XAException {
        Xid[] inDoubtTransactions;
        XATerminator xaTerminator;
        Set<Xid> inFlightXids;
        TransactionImporter transactionImporter;
        HashSet<Xid> xidsToRecover = new HashSet<Xid>();
        if (recoverInFlight && (transactionImporter = SubordinationManager.getTransactionImporter()) instanceof TransactionImporterImple && (inFlightXids = ((TransactionImporterImple)transactionImporter).getInflightXids(parentNodeName)) != null) {
            xidsToRecover.addAll(inFlightXids);
        }
        if ((xaTerminator = SubordinationManager.getXATerminator()) instanceof XATerminatorImple) {
            inDoubtTransactions = ((XATerminatorImple)xaTerminator).doRecover(null, parentNodeName);
            if (inDoubtTransactions != null) {
                xidsToRecover.addAll(Arrays.asList(inDoubtTransactions));
            }
        } else {
            inDoubtTransactions = xaTerminator.recover(recoveryFlags);
            if (inDoubtTransactions != null) {
                xidsToRecover.addAll(Arrays.asList(inDoubtTransactions));
            }
        }
        return xidsToRecover.toArray(NO_XIDS);
    }
}

