/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.jta.cdi.transactional;

import com.arjuna.ats.jta.cdi.TransactionExtension;
import com.arjuna.ats.jta.common.jtaPropertyManager;
import com.arjuna.ats.jta.logging.jtaLogger;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.security.AccessController;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.inject.Intercepted;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.interceptor.InvocationContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.Transactional;
import org.jboss.tm.usertx.UserTransactionOperationsProvider;

public abstract class TransactionalInterceptorBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Inject
    transient BeanManager beanManager;
    @Inject
    private TransactionExtension extension;
    @Inject
    @Intercepted
    private Bean<?> interceptedBean;
    private static TransactionManager transactionManager;
    private final boolean userTransactionAvailable;

    protected TransactionalInterceptorBase(boolean userTransactionAvailable) {
        this.userTransactionAvailable = userTransactionAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(InvocationContext ic) throws Exception {
        TransactionManager tm = this.getTransactionManager();
        Transaction tx2 = tm.getTransaction();
        boolean previousUserTransactionAvailability = this.setUserTransactionAvailable(this.userTransactionAvailable);
        try {
            Object object = this.doIntercept(tm, tx2, ic);
            return object;
        }
        finally {
            this.resetUserTransactionAvailability(previousUserTransactionAvailability);
        }
    }

    protected abstract Object doIntercept(TransactionManager var1, Transaction var2, InvocationContext var3) throws Exception;

    private Transactional getTransactional(InvocationContext ic) {
        if (this.interceptedBean != null) {
            Transactional transactionalMethod;
            AnnotatedType<?> currentAnnotatedType = this.extension.getBeanToAnnotatedTypeMapping().get(this.interceptedBean);
            AnnotatedMethod currentAnnotatedMethod = null;
            for (AnnotatedMethod methodInSearch : currentAnnotatedType.getMethods()) {
                if (!methodInSearch.getJavaMember().equals(ic.getMethod())) continue;
                currentAnnotatedMethod = methodInSearch;
                break;
            }
            if ((transactionalMethod = this.getTransactionalAnnotationRecursive(currentAnnotatedMethod.getAnnotations())) != null) {
                return transactionalMethod;
            }
            Transactional transactionalExtension = this.getTransactionalAnnotationRecursive(currentAnnotatedType.getAnnotations());
            if (transactionalExtension != null) {
                return transactionalExtension;
            }
            for (Class stereotype : this.interceptedBean.getStereotypes()) {
                Transactional transactionalAnn = stereotype.getAnnotation(Transactional.class);
                if (transactionalAnn == null) continue;
                return transactionalAnn;
            }
        } else {
            Transactional transactional = ic.getMethod().getAnnotation(Transactional.class);
            if (transactional != null) {
                return transactional;
            }
            Class<?> targetClass = ic.getTarget().getClass();
            transactional = targetClass.getAnnotation(Transactional.class);
            if (transactional != null) {
                return transactional;
            }
        }
        throw new RuntimeException(jtaLogger.i18NLogger.get_expected_transactional_annotation());
    }

    private Transactional getTransactionalAnnotationRecursive(Annotation ... annotationsOnMember) {
        if (annotationsOnMember == null) {
            return null;
        }
        HashSet<Class<? extends Annotation>> stereotypeAnnotations = new HashSet<Class<? extends Annotation>>();
        for (Annotation annotation : annotationsOnMember) {
            if (annotation.annotationType().equals(Transactional.class)) {
                return (Transactional)annotation;
            }
            if (!this.beanManager.isStereotype(annotation.annotationType())) continue;
            stereotypeAnnotations.add(annotation.annotationType());
        }
        Iterator iterator = stereotypeAnnotations.iterator();
        if (iterator.hasNext()) {
            Class stereotypeAnnotation = (Class)iterator.next();
            return this.getTransactionalAnnotationRecursive(this.beanManager.getStereotypeDefinition(stereotypeAnnotation));
        }
        return null;
    }

    private Transactional getTransactionalAnnotationRecursive(Set<Annotation> annotationsOnMember) {
        return this.getTransactionalAnnotationRecursive(annotationsOnMember.toArray(new Annotation[annotationsOnMember.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invokeInOurTx(InvocationContext ic, TransactionManager tm) throws Exception {
        tm.begin();
        Transaction tx2 = tm.getTransaction();
        try {
            Object object = ic.proceed();
            return object;
        }
        catch (Exception e) {
            this.handleException(ic, e, tx2);
        }
        finally {
            this.endTransaction(tm, tx2);
        }
        throw new RuntimeException("UNREACHABLE");
    }

    protected Object invokeInCallerTx(InvocationContext ic, Transaction tx2) throws Exception {
        try {
            return ic.proceed();
        }
        catch (Exception e) {
            this.handleException(ic, e, tx2);
            throw new RuntimeException("UNREACHABLE");
        }
    }

    protected Object invokeInNoTx(InvocationContext ic) throws Exception {
        return ic.proceed();
    }

    protected void handleException(InvocationContext ic, Exception e, Transaction tx2) throws Exception {
        Transactional transactional = this.getTransactional(ic);
        for (Class dontRollbackOnClass : transactional.dontRollbackOn()) {
            if (!dontRollbackOnClass.isAssignableFrom(e.getClass())) continue;
            throw e;
        }
        for (Class rollbackOnClass : transactional.rollbackOn()) {
            if (!rollbackOnClass.isAssignableFrom(e.getClass())) continue;
            tx2.setRollbackOnly();
            throw e;
        }
        if (e instanceof RuntimeException) {
            tx2.setRollbackOnly();
            throw e;
        }
        throw e;
    }

    protected void endTransaction(TransactionManager tm, Transaction tx2) throws Exception {
        if (tx2 != tm.getTransaction()) {
            throw new RuntimeException(jtaLogger.i18NLogger.get_wrong_tx_on_thread());
        }
        if (tx2.getStatus() == 1) {
            tm.rollback();
        } else {
            tm.commit();
        }
    }

    protected boolean setUserTransactionAvailable(boolean available) {
        UserTransactionOperationsProvider userTransactionProvider = jtaPropertyManager.getJTAEnvironmentBean().getUserTransactionOperationsProvider();
        boolean previousUserTransactionAvailability = userTransactionProvider.getAvailability();
        this.setAvailability(userTransactionProvider, available);
        return previousUserTransactionAvailability;
    }

    protected void resetUserTransactionAvailability(boolean previousUserTransactionAvailability) {
        UserTransactionOperationsProvider userTransactionProvider = jtaPropertyManager.getJTAEnvironmentBean().getUserTransactionOperationsProvider();
        this.setAvailability(userTransactionProvider, previousUserTransactionAvailability);
    }

    protected TransactionManager getTransactionManager() {
        if (transactionManager == null) {
            try {
                InitialContext initialContext = new InitialContext();
                transactionManager = (TransactionManager)initialContext.lookup(jtaPropertyManager.getJTAEnvironmentBean().getTransactionManagerJNDIContext());
            }
            catch (NamingException e) {
                throw new ContextNotActiveException(jtaLogger.i18NLogger.get_could_not_lookup_tm(), (Throwable)e);
            }
        }
        return transactionManager;
    }

    private void setAvailability(UserTransactionOperationsProvider userTransactionProvider, boolean available) {
        if (System.getSecurityManager() == null) {
            userTransactionProvider.setAvailability(available);
        } else {
            AccessController.doPrivileged(() -> {
                userTransactionProvider.setAvailability(available);
                return null;
            });
        }
    }
}

