/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jts.orbspecific.javaidl.recoverycoordinators;

import com.arjuna.ats.internal.jts.orbspecific.recovery.recoverycoordinators.GenericRecoveryCoordinator;
import com.arjuna.ats.internal.jts.orbspecific.recovery.recoverycoordinators.RecoveryCoordinatorId;
import com.arjuna.ats.jts.logging.jtsLogger;
import java.nio.charset.StandardCharsets;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CosTransactions.NotPrepared;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.Status;
import org.omg.PortableServer.Current;
import org.omg.PortableServer.CurrentHelper;

public class JavaIdlRCDefaultServant
extends GenericRecoveryCoordinator {
    private ORB _ourOrb;
    static byte[] RCObjectId = null;

    JavaIdlRCDefaultServant(ORB orb) {
        this._ourOrb = orb;
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug((java.lang.Object)"JavaIdlRCDefaultServant(orb)");
        }
    }

    @Override
    public Status replay_completion(Resource res) throws SystemException, NotPrepared {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug((java.lang.Object)"JavaIdlRCDefaultServant::replay_completion)");
        }
        try {
            Object obj = this._ourOrb.resolve_initial_references("POACurrent");
            Current poa_current = CurrentHelper.narrow((Object)obj);
            byte[] objectId = poa_current.get_object_id();
            String objectIdString = new String(objectId, StandardCharsets.UTF_8);
            String poaName = poa_current.get_POA().the_name();
            if (objectIdString.startsWith(poaName)) {
                int index = poaName.length();
                if (objectIdString.length() > index) {
                    ++index;
                }
                objectIdString = objectIdString.substring(index);
            }
            RecoveryCoordinatorId recovCoId = RecoveryCoordinatorId.reconstruct(objectIdString);
            if (jtsLogger.logger.isDebugEnabled()) {
                jtsLogger.logger.debug((java.lang.Object)("JavaIdlDefaultServant replay_completion for Id " + String.valueOf(recovCoId)));
            }
            return GenericRecoveryCoordinator.replay_completion(recovCoId, res);
        }
        catch (NotPrepared exp) {
            throw exp;
        }
        catch (Exception ex) {
            jtsLogger.i18NLogger.warn_orbspecific_recoverycoordinators_RCDefaultServant_3(this.getClass().getName(), ex);
            return Status.StatusUnknown;
        }
    }
}

