/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.jbossatx.jta;

import com.arjuna.ats.arjuna.recovery.RecoveryManager;
import com.arjuna.ats.arjuna.recovery.RecoveryModule;
import com.arjuna.ats.internal.jbossatx.jta.XAResourceRecoveryHelperWrapper;
import com.arjuna.ats.internal.jta.recovery.arjunacore.XARecoveryModule;
import com.arjuna.ats.jbossatx.logging.jbossatxLogger;
import com.arjuna.ats.jta.recovery.XAResourceRecoveryHelper;
import com.arjuna.common.util.ConfigurationInfo;
import org.jboss.tm.XAResourceRecovery;
import org.jboss.tm.XAResourceRecoveryRegistry;

public class RecoveryManagerService
implements XAResourceRecoveryRegistry {
    private RecoveryManager _recoveryManager;

    public void create() throws Exception {
        String tag = ConfigurationInfo.getSourceId();
        jbossatxLogger.i18NLogger.info_jta_RecoveryManagerService_create(tag);
        RecoveryManager.delayRecoveryManagerThread();
        this._recoveryManager = RecoveryManager.manager();
    }

    public void destroy() {
    }

    public void start() {
        jbossatxLogger.i18NLogger.info_jta_RecoveryManagerService_start();
        this._recoveryManager.initialize();
        this._recoveryManager.startRecoveryManagerThread();
    }

    public void stop() throws Exception {
        jbossatxLogger.i18NLogger.info_jta_RecoveryManagerService_stop();
        this._recoveryManager.terminate();
    }

    public void addXAResourceRecovery(XAResourceRecovery xaResourceRecovery) {
        if (this._recoveryManager == null) {
            throw new IllegalStateException(jbossatxLogger.i18NLogger.get_jta_RecoveryManagerService_norecoverysystem());
        }
        XARecoveryModule xaRecoveryModule = null;
        for (RecoveryModule recoveryModule : this._recoveryManager.getModules()) {
            if (!(recoveryModule instanceof XARecoveryModule)) continue;
            xaRecoveryModule = (XARecoveryModule)recoveryModule;
            break;
        }
        if (xaRecoveryModule == null) {
            throw new IllegalStateException(jbossatxLogger.i18NLogger.get_jta_RecoveryManagerService_norecoverymodule());
        }
        xaRecoveryModule.addXAResourceRecoveryHelper((XAResourceRecoveryHelper)new XAResourceRecoveryHelperWrapper(xaResourceRecovery));
    }

    public void removeXAResourceRecovery(XAResourceRecovery xaResourceRecovery) {
        if (this._recoveryManager == null) {
            throw new IllegalStateException(jbossatxLogger.i18NLogger.get_jta_RecoveryManagerService_norecoverysystem());
        }
        XARecoveryModule xaRecoveryModule = null;
        for (RecoveryModule recoveryModule : this._recoveryManager.getModules()) {
            if (!(recoveryModule instanceof XARecoveryModule)) continue;
            xaRecoveryModule = (XARecoveryModule)recoveryModule;
            break;
        }
        if (xaRecoveryModule == null) {
            throw new IllegalStateException(jbossatxLogger.i18NLogger.get_jta_RecoveryManagerService_norecoverymodule());
        }
        xaRecoveryModule.removeXAResourceRecoveryHelper((XAResourceRecoveryHelper)new XAResourceRecoveryHelperWrapper(xaResourceRecovery));
    }
}

