/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.lra.client;

import io.narayana.lra.Current;
import io.narayana.lra.LRAConstants;
import io.narayana.lra.LRAData;
import io.narayana.lra.logging.LRALogger;
import java.io.Closeable;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.enterprise.context.RequestScoped;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.eclipse.microprofile.lra.annotation.AfterLRA;
import org.eclipse.microprofile.lra.annotation.Compensate;
import org.eclipse.microprofile.lra.annotation.Complete;
import org.eclipse.microprofile.lra.annotation.Forget;
import org.eclipse.microprofile.lra.annotation.LRAStatus;
import org.eclipse.microprofile.lra.annotation.Status;
import org.eclipse.microprofile.lra.annotation.ws.rs.Leave;

@RequestScoped
public class NarayanaLRAClient
implements Closeable {
    public static final String LRA_COORDINATOR_URL_KEY = "lra.coordinator.url";
    private static final String START_PATH = "/start";
    private static final String LEAVE_PATH = "/%s/remove";
    private static final String STATUS_PATH = "/%s/status";
    private static final String CLOSE_PATH = "/%s/close";
    private static final String CANCEL_PATH = "/%s/cancel";
    private static final String LINK_TEXT = "Link";
    private static final long CLIENT_TIMEOUT = Long.getLong("lra.internal.client.timeout", 10L);
    private static final long START_TIMEOUT = Long.getLong("lra.internal.client.timeout.start", CLIENT_TIMEOUT);
    private static final long JOIN_TIMEOUT = Long.getLong("lra.internal.client.timeout.join", CLIENT_TIMEOUT);
    private static final long END_TIMEOUT = Long.getLong("lra.internal.client.end.timeout", CLIENT_TIMEOUT);
    private static final long LEAVE_TIMEOUT = Long.getLong("lra.internal.client.leave.timeout", CLIENT_TIMEOUT);
    private static final long QUERY_TIMEOUT = Long.getLong("lra.internal.client.query.timeout", CLIENT_TIMEOUT);
    private URI coordinatorUrl;

    public NarayanaLRAClient() {
        this(System.getProperty(LRA_COORDINATOR_URL_KEY, "http://localhost:8080/lra-coordinator"));
    }

    public NarayanaLRAClient(String protocol, String host, int port, String coordinatorPath) {
        this.coordinatorUrl = UriBuilder.fromPath((String)coordinatorPath).scheme(protocol).host(host).port(port).build(new Object[0]);
    }

    public NarayanaLRAClient(URI coordinatorUrl) {
        this.coordinatorUrl = coordinatorUrl;
    }

    public NarayanaLRAClient(String coordinatorUrl) {
        try {
            this.coordinatorUrl = new URI(coordinatorUrl);
        }
        catch (URISyntaxException use) {
            throw new IllegalStateException("Cannot convert the provided coordinator url String " + coordinatorUrl + " to URL format", use);
        }
    }

    public void setCurrentLRA(URI lraId) {
        try {
            this.coordinatorUrl = LRAConstants.getLRACoordinatorUrl((URI)lraId);
        }
        catch (IllegalStateException e) {
            LRALogger.i18nLogger.error_invalidLraIdFormatToConvertToCoordinatorUrl(lraId.toASCIIString(), (Throwable)e);
            this.throwGenericLRAException(lraId, Response.Status.BAD_REQUEST.getStatusCode(), e.getClass().getName() + ":" + e.getMessage(), null);
        }
    }

    public List<LRAData> getAllLRAs() {
        try (Client client = null;){
            client = this.getClient();
            Response response = (Response)client.target(this.coordinatorUrl).request().header("Narayana-LRA-API-version", (Object)"1.0").async().get().get(QUERY_TIMEOUT, TimeUnit.SECONDS);
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                LRALogger.logger.debugf("Error getting all LRAs from the coordinator, response status: %d", response.getStatus());
                throw new WebApplicationException(response);
            }
            List list = (List)response.readEntity((GenericType)new GenericType<List<LRAData>>(){});
            return list;
        }
    }

    public URI startLRA(String clientID) throws WebApplicationException {
        return this.startLRA(clientID, 0L);
    }

    private URI startLRA(String clientID, Long timeout) throws WebApplicationException {
        return this.startLRA(clientID, timeout, ChronoUnit.SECONDS);
    }

    private URI startLRA(String clientID, Long timeout, ChronoUnit unit) throws WebApplicationException {
        return this.startLRA(this.getCurrent(), clientID, timeout, unit);
    }

    public URI startLRA(URI parentLRA, String clientID, Long timeout, ChronoUnit unit) throws WebApplicationException {
        return this.startLRA(parentLRA, clientID, timeout, unit, true);
    }

    public URI startLRA(URI parentLRA, String clientID, Long timeout, ChronoUnit unit, boolean verbose) throws WebApplicationException {
        Client client = null;
        Response response = null;
        if (clientID == null) {
            clientID = "";
        }
        if (timeout == null) {
            timeout = 0L;
        } else if (timeout < 0L) {
            this.throwGenericLRAException(parentLRA, Response.Status.BAD_REQUEST.getStatusCode(), "Invalid timeout value: " + timeout, null);
            return null;
        }
        if (unit == null) {
            unit = ChronoUnit.SECONDS;
        }
        this.lraTracef("startLRA for client %s with parent %s", clientID, parentLRA);
        try {
            String encodedParentLRA = parentLRA == null ? "" : URLEncoder.encode(parentLRA.toString(), StandardCharsets.UTF_8.name());
            client = this.getClient();
            response = (Response)client.target(this.coordinatorUrl).path(START_PATH).queryParam("ClientID", new Object[]{clientID}).queryParam("TimeLimit", new Object[]{Duration.of(timeout, unit).toMillis()}).queryParam("ParentLRA", new Object[]{encodedParentLRA}).request().header("Narayana-LRA-API-version", (Object)"1.0").async().post(null).get(START_TIMEOUT, TimeUnit.SECONDS);
            if (this.isUnexpectedResponseStatus(response, Response.Status.CREATED)) {
                String responseEntity;
                String string = responseEntity = response.hasEntity() ? (String)response.readEntity(String.class) : "";
                if (verbose) {
                    LRALogger.i18nLogger.error_lraCreationUnexpectedStatus(response.getStatus(), responseEntity);
                }
                this.throwGenericLRAException(null, response.getStatus(), "LRA start returned an unexpected status code: " + response.getStatus() + ", response '" + responseEntity + "'", null);
                URI uRI = null;
                return uRI;
            }
            URI lra = URI.create(response.getHeaderString("Location"));
            this.lraTrace(lra, "startLRA returned");
            Current.push((URI)lra);
            URI uRI = lra;
            return uRI;
        }
        catch (UnsupportedEncodingException uee) {
            if (verbose) {
                LRALogger.i18nLogger.error_invalidFormatToEncodeParentUri(parentLRA, (Throwable)uee);
            }
            this.throwGenericLRAException(null, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Cannot connect to the LRA coordinator: " + this.coordinatorUrl + " as provided parent LRA URL '" + parentLRA + "' is not in URL format (" + uee.getClass().getName() + ":" + uee.getCause().getMessage() + ")", uee);
            URI uRI = null;
            return uRI;
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new WebApplicationException("start LRA client request timed out, try again later", (Throwable)e, Response.Status.SERVICE_UNAVAILABLE.getStatusCode());
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }

    public void cancelLRA(URI lraId) throws WebApplicationException {
        this.endLRA(lraId, false);
    }

    public void closeLRA(URI lraId) throws WebApplicationException {
        this.endLRA(lraId, true);
    }

    public URI joinLRA(URI lraId, Long timeLimit, URI compensateUri, URI completeUri, URI forgetUri, URI leaveUri, URI afterUri, URI statusUri, String compensatorData) throws WebApplicationException {
        return this.enlistCompensator(lraId, timeLimit, "", compensateUri, completeUri, forgetUri, leaveUri, afterUri, statusUri, compensatorData);
    }

    public URI joinLRA(URI lraId, Long timeLimit, URI participantUri, String compensatorData) throws WebApplicationException {
        this.validateURI(participantUri, false, "Invalid participant URL: %s");
        StringBuilder linkHeaderValue = NarayanaLRAClient.makeLink(new StringBuilder(), null, "participant", participantUri.toASCIIString());
        return this.enlistCompensator(lraId, timeLimit, linkHeaderValue.toString(), compensatorData);
    }

    public void leaveLRA(URI lraId, String body) throws WebApplicationException {
        try (Client client = null;){
            client = this.getClient();
            Response response = (Response)client.target(this.coordinatorUrl).path(String.format(LEAVE_PATH, LRAConstants.getLRAUid((URI)lraId))).request().header("Narayana-LRA-API-version", (Object)"1.0").async().put(body == null ? Entity.text((Object)"") : Entity.text((Object)body)).get(LEAVE_TIMEOUT, TimeUnit.SECONDS);
            if (Response.Status.OK.getStatusCode() != response.getStatus()) {
                LRALogger.i18nLogger.error_lraLeaveUnexpectedStatus(response.getStatus(), response.hasEntity() ? (String)response.readEntity(String.class) : "");
                this.throwGenericLRAException(null, response.getStatus(), "Leaving LRA " + lraId + " from coordinator " + this.coordinatorUrl + " finished with unexpected response code: " + response.getStatusInfo(), null);
            }
        }
    }

    public static Map<String, String> getTerminationUris(Class<?> compensatorClass, UriInfo uriInfo, Long timeout) {
        HashMap<String, String> paths = new HashMap<String, String>();
        boolean[] asyncTermination = new boolean[]{false};
        URI baseUri = uriInfo.getBaseUri();
        List matchedURIs = uriInfo.getMatchedURIs();
        int matchedURI = matchedURIs.size() > 1 ? 1 : 0;
        String uriPrefix = baseUri + (String)matchedURIs.get(matchedURI);
        String timeoutValue = timeout != null ? Long.toString(timeout) : "0";
        Arrays.stream(compensatorClass.getMethods()).forEach(method -> {
            Path pathAnnotation = method.getAnnotation(Path.class);
            if (pathAnnotation != null) {
                if (NarayanaLRAClient.checkMethod(paths, method, "compensate", pathAnnotation, (Annotation)method.getAnnotation(Compensate.class), uriPrefix) != 0) {
                    paths.put("TimeLimit", timeoutValue);
                    if (NarayanaLRAClient.isAsyncCompletion(method)) {
                        asyncTermination[0] = true;
                    }
                }
                if (NarayanaLRAClient.checkMethod(paths, method, "complete", pathAnnotation, (Annotation)method.getAnnotation(Complete.class), uriPrefix) != 0) {
                    paths.put("TimeLimit", timeoutValue);
                    if (NarayanaLRAClient.isAsyncCompletion(method)) {
                        asyncTermination[0] = true;
                    }
                }
                NarayanaLRAClient.checkMethod(paths, method, "status", pathAnnotation, (Annotation)method.getAnnotation(Status.class), uriPrefix);
                NarayanaLRAClient.checkMethod(paths, method, "forget", pathAnnotation, (Annotation)method.getAnnotation(Forget.class), uriPrefix);
                NarayanaLRAClient.checkMethod(paths, method, "leave", pathAnnotation, (Annotation)method.getAnnotation(Leave.class), uriPrefix);
                NarayanaLRAClient.checkMethod(paths, method, "after", pathAnnotation, (Annotation)method.getAnnotation(AfterLRA.class), uriPrefix);
            }
        });
        if (asyncTermination[0] && !paths.containsKey("status") && !paths.containsKey("forget")) {
            LRALogger.i18nLogger.error_asyncTerminationBeanMissStatusAndForget(compensatorClass);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"LRA participant class with asynchronous termination but no @Status or @Forget annotations").build());
        }
        StringBuilder linkHeaderValue = new StringBuilder();
        if (paths.size() != 0) {
            paths.forEach((k, v) -> NarayanaLRAClient.makeLink(linkHeaderValue, null, k, v));
            paths.put(LINK_TEXT, linkHeaderValue.toString());
        }
        return paths;
    }

    public static boolean isAsyncCompletion(Method method) {
        if (method.isAnnotationPresent(Complete.class) || method.isAnnotationPresent(Compensate.class)) {
            Annotation[][] annotationArray = method.getParameterAnnotations();
            int n = annotationArray.length;
            for (int i = 0; i < n; ++i) {
                Annotation[] ann;
                for (Annotation an : ann = annotationArray[i]) {
                    if (!Suspended.class.isAssignableFrom(an.annotationType())) continue;
                    LRALogger.logger.warn((Object)"JAX-RS @Suspended annotation is untested");
                    return true;
                }
            }
        }
        return false;
    }

    private static int checkMethod(Map<String, String> paths, Method method, String rel, Path pathAnnotation, Annotation annotationClass, String uriPrefix) {
        if (annotationClass == null) {
            return 0;
        }
        for (Annotation annotation : method.getDeclaredAnnotations()) {
            String name = annotation.annotationType().getName();
            if (!name.equals(GET.class.getName()) && !name.equals(PUT.class.getName()) && !name.equals(POST.class.getName()) && !name.equals(DELETE.class.getName())) continue;
            String pathValue = pathAnnotation.value();
            pathValue = pathValue.startsWith("/") ? pathValue : "/" + pathValue;
            String url = String.format("%s%s?%s=%s", uriPrefix, pathValue, "method", name);
            paths.put(rel, url);
            break;
        }
        return 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LRAStatus getStatus(URI uri) throws WebApplicationException {
        URL lraId;
        Client client = null;
        try {
            lraId = uri.toURL();
        }
        catch (MalformedURLException mue) {
            this.throwGenericLRAException(null, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Could not convert LRA to a URL : " + mue.getClass().getName() + ":" + mue.getMessage(), mue);
            return null;
        }
        try {
            client = this.getClient();
            Response response = (Response)client.target(this.coordinatorUrl).path(String.format(STATUS_PATH, LRAConstants.getLRAUid((URI)uri))).request().header("Narayana-LRA-API-version", (Object)"1.0").async().get().get(QUERY_TIMEOUT, TimeUnit.SECONDS);
            if (response.getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
                String responseEntity = response.hasEntity() ? (String)response.readEntity(String.class) : "";
                String errorMsg = "The requested LRA it '" + lraId + "' was not found and the status can't be obtained, response content: " + responseEntity;
                throw new NotFoundException(errorMsg, Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errorMsg).build());
            }
            if (response.getStatus() == Response.Status.NO_CONTENT.getStatusCode()) {
                LRAStatus responseEntity = LRAStatus.Active;
                return responseEntity;
            }
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                LRALogger.i18nLogger.error_invalidStatusCode(this.coordinatorUrl, response.getStatus(), lraId);
                this.throwGenericLRAException(uri, response.getStatus(), "LRA coordinator returned an invalid status code", null);
            }
            if (!response.hasEntity()) {
                LRALogger.i18nLogger.error_noContentOnGetStatus(this.coordinatorUrl, lraId);
                this.throwGenericLRAException(uri, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "LRA coordinator#getStatus returned 200 OK but no content: lra: " + lraId, null);
            }
            try {
                LRAStatus responseEntity = NarayanaLRAClient.fromString((String)response.readEntity(String.class));
                return responseEntity;
            }
            catch (IllegalArgumentException iae) {
                try {
                    LRALogger.i18nLogger.error_invalidArgumentOnStatusFromCoordinator(this.coordinatorUrl, lraId, (Throwable)iae);
                    this.throwGenericLRAException(uri, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "LRA coordinator returned an invalid status", iae);
                    if (client == null) return null;
                }
                catch (InterruptedException | ExecutionException | TimeoutException e) {
                    throw new WebApplicationException("get LRA status client request timed out, try again later", Response.Status.SERVICE_UNAVAILABLE.getStatusCode());
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                client.close();
                return null;
            }
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }

    private static LRAStatus fromString(String status) {
        if (status == null) {
            throw new IllegalArgumentException("The status parameter is null");
        }
        return LRAStatus.valueOf((String)status);
    }

    private static StringBuilder makeLink(StringBuilder b, String uriPrefix, String key, String value) {
        if (value == null) {
            return b;
        }
        String terminationUri = uriPrefix == null ? value : String.format("%s%s", uriPrefix, value);
        Link link = Link.fromUri((String)terminationUri).title(key + " URI").rel(key).type("text/plain").build(new Object[0]);
        if (b.length() != 0) {
            b.append(',');
        }
        return b.append(link);
    }

    private URI enlistCompensator(URI lraUri, Long timelimit, String uriPrefix, URI compensateUri, URI completeUri, URI forgetUri, URI leaveUri, URI afterUri, URI statusUri, String compensatorData) {
        this.validateURI(completeUri, true, "Invalid complete URL: %s");
        this.validateURI(compensateUri, true, "Invalid compensate URL: %s");
        this.validateURI(leaveUri, true, "Invalid status URL: %s");
        this.validateURI(afterUri, true, "Invalid after URL: %s");
        this.validateURI(forgetUri, true, "Invalid forgetUri URL: %s");
        this.validateURI(statusUri, true, "Invalid status URL: %s");
        HashMap<String, URI> terminateURIs = new HashMap<String, URI>();
        terminateURIs.put("compensate", compensateUri);
        terminateURIs.put("complete", completeUri);
        terminateURIs.put("leave", leaveUri);
        terminateURIs.put("after", afterUri);
        terminateURIs.put("status", statusUri);
        terminateURIs.put("forget", forgetUri);
        StringBuilder linkHeaderValue = new StringBuilder();
        terminateURIs.forEach((k, v) -> NarayanaLRAClient.makeLink(linkHeaderValue, uriPrefix, k, v == null ? null : v.toASCIIString()));
        return this.enlistCompensator(lraUri, timelimit, linkHeaderValue.toString(), compensatorData);
    }

    /*
     * Exception decompiling
     */
    private URI enlistCompensator(URI uri, Long timelimit, String linkHeader, String compensatorData) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endLRA(URI lra, boolean confirm) throws WebApplicationException {
        Client client = null;
        Response response = null;
        this.lraTracef(lra, "%s LRA", confirm ? "close" : "compensate");
        try {
            client = this.getClient();
            String lraUid = LRAConstants.getLRAUid((URI)lra);
            try {
                response = (Response)client.target(this.coordinatorUrl).path(confirm ? String.format(CLOSE_PATH, lraUid) : String.format(CANCEL_PATH, lraUid)).request().header("Narayana-LRA-API-version", (Object)"1.0").async().put(Entity.text((Object)"")).get(END_TIMEOUT, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                throw new WebApplicationException("end LRA client request timed out, try again later", Response.Status.SERVICE_UNAVAILABLE.getStatusCode());
            }
            if (this.isUnexpectedResponseStatus(response, Response.Status.OK, Response.Status.ACCEPTED, Response.Status.NOT_FOUND)) {
                String warnMsg = LRALogger.i18nLogger.error_lraTerminationUnexpectedStatus(response.getStatus(), response.hasEntity() ? (String)response.readEntity(String.class) : "");
                LRALogger.logger.warn((Object)warnMsg);
                this.throwGenericLRAException(lra, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), warnMsg, null);
            }
            if (response.getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
                String errorMsg = LRALogger.i18nLogger.get_couldNotCompleteCompensateOnReturnedStatus(confirm ? "close" : "compensate", lra, this.coordinatorUrl, Response.Status.NOT_FOUND.getReasonPhrase());
                LRALogger.logger.info((Object)errorMsg);
                throw new NotFoundException(errorMsg, Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)lra.toASCIIString()).build());
            }
        }
        finally {
            Current.pop((URI)lra);
            if (client != null) {
                client.close();
            }
        }
    }

    private void validateURI(URI uri, boolean nullAllowed, String message) {
        if (uri == null) {
            if (!nullAllowed) {
                this.throwGenericLRAException(null, Response.Status.NOT_ACCEPTABLE.getStatusCode(), String.format(message, "null value"), null);
            }
        } else {
            try {
                uri.toURL();
            }
            catch (MalformedURLException mue) {
                this.throwGenericLRAException(null, Response.Status.NOT_ACCEPTABLE.getStatusCode(), String.format(message, mue.getClass().getName() + ":" + mue.getMessage()) + " uri=" + uri, mue);
            }
        }
    }

    private boolean isUnexpectedResponseStatus(Response response, Response.Status ... expected) {
        for (Response.Status anExpected : expected) {
            if (response.getStatus() != anExpected.getStatusCode()) continue;
            return false;
        }
        return true;
    }

    public String getCoordinatorUrl() {
        return this.coordinatorUrl.toString();
    }

    public String getRecoveryUrl() {
        return this.getCoordinatorUrl() + "/" + "recovery";
    }

    public URI getCurrent() {
        return Current.peek();
    }

    private void lraTracef(String reasonFormat, Object ... parameters) {
        if (LRALogger.logger.isTraceEnabled()) {
            LRALogger.logger.tracef(reasonFormat, parameters);
        }
    }

    private void lraTrace(URI lra, String reason) {
        if (LRALogger.logger.isTraceEnabled()) {
            this.lraTracef(lra, reason, (Object[])null);
        }
    }

    private void lraTracef(URI lra, String reasonFormat, Object ... parameters) {
        if (LRALogger.logger.isTraceEnabled()) {
            this.lraTracef(reasonFormat + ", lra id: %s", parameters, lra);
        }
    }

    @Override
    public void close() {
    }

    private void throwGenericLRAException(URI lraId, int statusCode, String message, Throwable cause) throws WebApplicationException {
        String errorMsg = String.format("%s: %s", lraId, message);
        throw new WebApplicationException(errorMsg, cause, Response.status((int)statusCode).entity((Object)errorMsg).build());
    }

    private Client getClient() {
        return ClientBuilder.newClient();
    }
}

