/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.lra.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.narayana.lra.annotation.Compensate;
import io.narayana.lra.annotation.Complete;
import io.narayana.lra.annotation.Forget;
import io.narayana.lra.annotation.Leave;
import io.narayana.lra.annotation.Status;
import io.narayana.lra.annotation.TimeLimit;
import io.narayana.lra.client.Current;
import io.narayana.lra.client.GenericLRAException;
import io.narayana.lra.client.IllegalLRAStateException;
import io.narayana.lra.client.InvalidLRAId;
import io.narayana.lra.client.LRAClientAPI;
import io.narayana.lra.client.LRAStatus;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.RequestScoped;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.ws.rs.Path;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.Response;

@RequestScoped
public class LRAClient
implements LRAClientAPI,
Closeable {
    public static final String LRA_HTTP_HEADER = "X-lra";
    public static final String LRA_HTTP_RECOVERY_HEADER = "X-lra-recovery";
    public static final String COORDINATOR_PATH_NAME = "lra-coordinator";
    public static final String RECOVERY_COORDINATOR_PATH_NAME = "lra-recovery-coordinator";
    public static final String CORRDINATOR_HOST_PROP = "lra.http.host";
    public static final String CORRDINATOR_PORT_PROP = "lra.http.port";
    public static final String COMPLETE = "complete";
    public static final String COMPENSATE = "compensate";
    public static final String STATUS = "status";
    public static final String LEAVE = "leave";
    public static final String FORGET = "forget";
    public static final String TIMELIMIT_PARAM_NAME = "TimeLimit";
    public static final String CLIENT_ID_PARAM_NAME = "ClientID";
    public static final String PARENT_LRA_PARAM_NAME = "ParentLRA";
    public static final long DEFAULT_TIMEOUT_MILLIS = 0L;
    private static final String startLRAUrl = "/start";
    private static final String getAllLRAsUrl = "/";
    private static final String getRecoveringLRAsUrl = "/recovery";
    private static final String getActiveLRAsUrl = "/active";
    private static final String isActiveUrlFormat = "/%s";
    private static final String isCompletedUrlFormat = "/completed/%s";
    private static final String isCompensatedUrlFormat = "/compensated/%s";
    private static final String confirmFormat = "/%s/close";
    private static final String compensateFormat = "/%s/cancel";
    private static final String leaveFormat = "/%s/remove";
    private static final String renewFormat = "/%s/renew";
    private static final String MISSING_ANNOTATION_FORMAT = "Cannot enlist resource class %s: annotated with LRA but is missing one or more of {@Complete. @Compensate, @Status}";
    private static Boolean isTrace = Boolean.getBoolean("trace");
    private WebTarget target;
    private URI base;
    private Client client;
    private boolean isUseable;
    private boolean connectionInUse;
    private Map<URL, List<String>> responseDataMap;

    public LRAClient() throws URISyntaxException {
        this("http", System.getProperty(CORRDINATOR_HOST_PROP, "localhost"), Integer.getInteger(CORRDINATOR_PORT_PROP, 8080));
    }

    public LRAClient(String host, int port) throws URISyntaxException {
        this("http", host, port);
    }

    public LRAClient(String scheme, String host, int port) throws URISyntaxException {
        this.init(scheme, host, port);
    }

    public LRAClient(URL coordinatorUrl) throws MalformedURLException, URISyntaxException {
        this.init(coordinatorUrl);
    }

    private void init(URL coordinatorUrl) throws URISyntaxException {
        this.init(coordinatorUrl.getProtocol(), coordinatorUrl.getHost(), coordinatorUrl.getPort());
    }

    private void init(String scheme, String host, int port) throws URISyntaxException {
        if (this.client == null) {
            this.client = ClientBuilder.newClient();
        }
        this.base = new URI(scheme, null, host, port, "/lra-coordinator", null, null);
        this.target = this.client.target(this.base);
        this.isUseable = true;
        if (this.responseDataMap == null) {
            this.postConstruct();
        } else {
            this.responseDataMap.clear();
        }
    }

    public boolean isUseable() {
        return this.isUseable;
    }

    @PostConstruct
    public void postConstruct() {
        this.responseDataMap = new HashMap<URL, List<String>>();
    }

    @PreDestroy
    public void preDestroy() {
        this.isUseable = false;
    }

    public static URL lraToURL(String lraId) {
        return LRAClient.lraToURL(lraId, "Invalid LRA id");
    }

    public static URL lraToURL(String lraId, String message) {
        try {
            return new URL(lraId);
        }
        catch (MalformedURLException e) {
            throw new GenericLRAException(null, Response.Status.BAD_REQUEST.getStatusCode(), String.format("%s: %s", message, lraId), e);
        }
    }

    public static String encodeURL(URL lraId, String message) {
        try {
            return URLEncoder.encode(lraId.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new GenericLRAException(lraId, Response.Status.BAD_REQUEST.getStatusCode(), String.format("%s: %s", message, lraId), e);
        }
    }

    public static String getLRAId(String lraId) {
        return lraId == null ? null : lraId.replaceFirst(".*/([^/?]+).*", "$1");
    }

    public URL toURL(String lraId) throws InvalidLRAId {
        try {
            return new URL(lraId);
        }
        catch (MalformedURLException e) {
            throw new InvalidLRAId(lraId, "Invalid syntax", e);
        }
    }

    private WebTarget getTarget() {
        this.client.close();
        this.client = ClientBuilder.newClient();
        return this.client.target(this.base);
    }

    @Override
    public void setCurrentLRA(URL coordinatorUrl) {
        try {
            this.init(coordinatorUrl);
        }
        catch (URISyntaxException e) {
            throw new GenericLRAException(coordinatorUrl, Response.Status.BAD_REQUEST.getStatusCode(), e.getMessage(), e);
        }
    }

    public URL startLRA(String clientID) throws GenericLRAException {
        return this.startLRA(clientID, 0L);
    }

    @Override
    public URL startLRA(String clientID, Long timeout) throws GenericLRAException {
        return this.startLRA(null, clientID, timeout, TimeUnit.MILLISECONDS);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public URL startLRA(URL parentLRA, String clientID, Long timeout, TimeUnit unit) throws GenericLRAException {
        Response response = null;
        if (clientID == null) {
            clientID = "";
        }
        if (timeout == null) {
            timeout = 0L;
        } else if (timeout < 0L) {
            throw new GenericLRAException(parentLRA, Response.Status.BAD_REQUEST.getStatusCode(), "Invalid timeout value: " + timeout, null);
        }
        this.lraTrace(String.format("startLRA for client %s with parent %s", clientID, parentLRA), null);
        try {
            String encodedParentLRA = parentLRA == null ? "" : URLEncoder.encode(parentLRA.toString(), "UTF-8");
            this.aquireConnection();
            response = this.getTarget().path(startLRAUrl).queryParam(TIMELIMIT_PARAM_NAME, new Object[]{unit.toMillis(timeout)}).queryParam(CLIENT_ID_PARAM_NAME, new Object[]{clientID}).queryParam(PARENT_LRA_PARAM_NAME, new Object[]{encodedParentLRA}).request().post(Entity.text((Object)""));
            this.assertEquals(response, response.getStatus(), Response.Status.CREATED.getStatusCode(), "LRA start returned an unexpected status code: %d versus %d");
            Object lraObject = response.getHeaders().getFirst((Object)LRA_HTTP_HEADER);
            this.assertNotNull(lraObject, "LRA is null");
            URL lra = new URL(URLDecoder.decode(lraObject.toString(), "UTF-8"));
            this.lraTrace("startLRA returned", lra);
            Current.push(lra);
            this.releaseConnection(response);
            return lra;
        }
        catch (UnsupportedEncodingException | MalformedURLException e) {
            try {
                throw new GenericLRAException(null, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), e.getMessage(), e);
                catch (Exception e2) {
                    if (e2.getCause() == null) throw new GenericLRAException(null, Response.Status.SERVICE_UNAVAILABLE.getStatusCode(), e2.getMessage(), e2);
                    if (!ConnectException.class.equals(e2.getCause().getClass())) throw new GenericLRAException(null, Response.Status.SERVICE_UNAVAILABLE.getStatusCode(), e2.getMessage(), e2);
                    throw new GenericLRAException(null, Response.Status.SERVICE_UNAVAILABLE.getStatusCode(), "Cannont connect to an LRA coordinator: " + e2.getCause().getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                this.releaseConnection(response);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renewTimeLimit(URL lraId, long limit, TimeUnit unit) {
        Response response = null;
        this.lraTrace(String.format("renew time limit to %s s of LRA", unit.toSeconds(limit)), lraId);
        try {
            this.aquireConnection();
            response = this.getTarget().path(String.format(renewFormat, LRAClient.getLRAId(lraId.toString()))).queryParam(TIMELIMIT_PARAM_NAME, new Object[]{unit.toMillis(limit)}).request().header(LRA_HTTP_HEADER, (Object)lraId).put(Entity.text((Object)""));
            if (Response.Status.OK.getStatusCode() != response.getStatus()) {
                throw new GenericLRAException(lraId, response.getStatus(), "", null);
            }
            this.releaseConnection(response);
        }
        catch (Throwable throwable) {
            this.releaseConnection(response);
            throw throwable;
        }
    }

    @Override
    public String cancelLRA(URL lraId) throws GenericLRAException {
        return this.endLRA(lraId, false);
    }

    @Override
    public String closeLRA(URL lraId) throws GenericLRAException {
        return this.endLRA(lraId, true);
    }

    public String joinLRAWithLinkHeader(URL lraUrl, Long timelimit, String linkHeader, String compensatorData) throws GenericLRAException {
        this.lraTrace(String.format("joining LRA with compensator link: %s", linkHeader), lraUrl);
        return this.enlistCompensator(lraUrl, timelimit, linkHeader, compensatorData);
    }

    @Override
    public String joinLRA(URL lraId, Long timelimit, String compensatorUrl, String compensatorData) throws GenericLRAException {
        this.lraTrace(String.format("joining LRA with compensator %s", compensatorUrl), lraId);
        return this.enlistCompensator(lraId, timelimit, "", String.format("%s/compensate", compensatorUrl), String.format("%s/complete", compensatorUrl), String.format("%s/forget", compensatorUrl), String.format("%s/leave", compensatorUrl), String.format("%s/status", compensatorUrl), compensatorData);
    }

    private String toExternalForm(URL url) {
        return url == null ? null : url.toExternalForm();
    }

    @Override
    public String joinLRA(URL lraId, Long timelimit, URL compensateUrl, URL completeUrl, URL forgetUrl, URL leaveUrl, URL statusUrl, String compensatorData) throws GenericLRAException {
        return this.enlistCompensator(lraId, timelimit, "", this.toExternalForm(compensateUrl), this.toExternalForm(completeUrl), this.toExternalForm(forgetUrl), this.toExternalForm(leaveUrl), this.toExternalForm(statusUrl), compensatorData);
    }

    @Override
    public String joinLRA(URL lraId, Class<?> resourceClass, URI baseUri, String compensatorData) throws GenericLRAException {
        long timeLimit;
        Map<String, String> terminateURIs = LRAClient.getTerminationUris(resourceClass, baseUri, false);
        String timeLimitStr = terminateURIs.get(TIMELIMIT_PARAM_NAME);
        long l = timeLimit = timeLimitStr == null ? 0L : Long.valueOf(timeLimitStr);
        if (terminateURIs.containsKey("Link")) {
            return this.joinLRAWithLinkHeader(lraId, timeLimit, terminateURIs.get("Link"), compensatorData);
        }
        return null;
    }

    @Override
    public URL updateCompensator(URL recoveryUrl, URL compensateUrl, URL completeUrl, URL forgetUrl, URL leaveUrl, URL statusUrl, String compensatorData) throws GenericLRAException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void leaveLRA(URL lraId, String compensatorUrl) throws GenericLRAException {
        Response response = null;
        this.lraTrace("leaving LRA", lraId);
        try {
            this.aquireConnection();
            response = this.getTarget().path(String.format(leaveFormat, LRAClient.getLRAId(lraId.toString()))).request().header(LRA_HTTP_HEADER, (Object)lraId).put(Entity.entity((Object)compensatorUrl, (String)"text/plain"));
            if (Response.Status.OK.getStatusCode() != response.getStatus()) {
                throw new GenericLRAException(lraId, response.getStatus(), "", null);
            }
            this.releaseConnection(response);
        }
        catch (Throwable throwable) {
            this.releaseConnection(response);
            throw throwable;
        }
    }

    @Override
    public List<LRAStatus> getAllLRAs() throws GenericLRAException {
        return this.getLRAs(getAllLRAsUrl);
    }

    @Override
    public List<LRAStatus> getActiveLRAs() throws GenericLRAException {
        return this.getLRAs(getActiveLRAsUrl);
    }

    @Override
    public List<LRAStatus> getRecoveringLRAs() throws GenericLRAException {
        return this.getLRAs(getRecoveringLRAsUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<LRAStatus> getLRAs(String getUrl) {
        Response response = null;
        try {
            this.aquireConnection();
            response = this.getTarget().path(getUrl).request().get();
            if (!response.hasEntity()) {
                throw new GenericLRAException(null, response.getStatus(), "missing entity body", null);
            }
            ArrayList<LRAStatus> actions = new ArrayList<LRAStatus>();
            String lras = (String)response.readEntity(String.class);
            JsonReader reader = Json.createReader((Reader)new StringReader(lras));
            JsonArray ja = reader.readArray();
            ja.forEach(jsonValue -> actions.add(this.toLRAStatus((JsonObject)jsonValue)));
            ArrayList<LRAStatus> arrayList = actions;
            this.releaseConnection(response);
            return arrayList;
        }
        catch (Throwable throwable) {
            this.releaseConnection(response);
            throw throwable;
        }
    }

    private LRAStatus toLRAStatus(JsonObject jo) {
        try {
            return new LRAStatus(jo.getString("lraId"), jo.getString("clientId"), jo.getBoolean(COMPLETE), jo.getBoolean("compensated"), jo.getBoolean("recovering"), jo.getBoolean("active"), jo.getBoolean("topLevel"));
        }
        catch (Exception e) {
            System.out.printf("Error parsing json LRAStatus", new Object[0]);
            return new LRAStatus(jo.getString("lraId"), jo.getString("lraId"), jo.getBoolean(COMPLETE), jo.getBoolean("compensated"), jo.getBoolean("recovering"), jo.getBoolean("active"), jo.getBoolean("topLevel"));
        }
    }

    @Override
    public Boolean isActiveLRA(URL lraId) throws GenericLRAException {
        return this.getStatus(lraId, isActiveUrlFormat);
    }

    @Override
    public Boolean isCompensatedLRA(URL lraId) throws GenericLRAException {
        return this.getStatus(lraId, isCompensatedUrlFormat);
    }

    @Override
    public Boolean isCompletedLRA(URL lraId) throws GenericLRAException {
        return this.getStatus(lraId, isCompletedUrlFormat);
    }

    public static Map<String, String> getTerminationUris(Class<?> compensatorClass, URI baseUri, boolean validate) {
        HashMap<String, String> paths = new HashMap<String, String>();
        Path resourcePathAnnotation = compensatorClass.getAnnotation(Path.class);
        String resourcePath = resourcePathAnnotation == null ? getAllLRAsUrl : resourcePathAnnotation.value();
        String uriPrefix = String.format("%s:%s%s", baseUri.getScheme(), baseUri.getSchemeSpecificPart(), resourcePath.substring(1)).replaceAll("/$", "");
        int[] validCnt = new int[]{0};
        Arrays.stream(compensatorClass.getMethods()).forEach(method -> {
            Path pathAnnotation = method.getAnnotation(Path.class);
            if (pathAnnotation != null) {
                if (LRAClient.checkMethod(paths, COMPENSATE, pathAnnotation, (Annotation)method.getAnnotation(Compensate.class), uriPrefix) != 0) {
                    validCnt[0] = validCnt[0] + 1;
                    TimeLimit timeLimit = method.getAnnotation(TimeLimit.class);
                    if (timeLimit != null) {
                        paths.put(TIMELIMIT_PARAM_NAME, Long.toString(timeLimit.unit().toMillis(timeLimit.limit())));
                    }
                }
                validCnt[0] = validCnt[0] + LRAClient.checkMethod(paths, COMPLETE, pathAnnotation, (Annotation)method.getAnnotation(Complete.class), uriPrefix);
                LRAClient.checkMethod(paths, STATUS, pathAnnotation, (Annotation)method.getAnnotation(Status.class), uriPrefix);
                LRAClient.checkMethod(paths, FORGET, pathAnnotation, (Annotation)method.getAnnotation(Forget.class), uriPrefix);
                LRAClient.checkMethod(paths, LEAVE, pathAnnotation, (Annotation)method.getAnnotation(Leave.class), uriPrefix);
            }
        });
        if (validate && validCnt[0] == 1) {
            throw new GenericLRAException(null, Response.Status.BAD_REQUEST.getStatusCode(), String.format(MISSING_ANNOTATION_FORMAT, compensatorClass.getName()), null);
        }
        StringBuilder linkHeaderValue = new StringBuilder();
        if (paths.size() != 0) {
            paths.forEach((k, v) -> LRAClient.makeLink(linkHeaderValue, null, k, v));
            paths.put("Link", linkHeaderValue.toString());
        }
        return paths;
    }

    private static int checkMethod(Map<String, String> paths, String rel, Path pathAnnotation, Annotation annotationClass, String uriPrefix) {
        if (annotationClass == null) {
            return 0;
        }
        paths.put(rel, uriPrefix + pathAnnotation.value());
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean getStatus(URL lraId, String statusFormat) {
        Response response = null;
        try {
            this.aquireConnection();
            response = this.getTarget().path(STATUS).path(String.format(statusFormat, LRAClient.getLRAId(lraId.toString()))).request().get();
            Boolean bl = Boolean.valueOf((String)response.readEntity(String.class));
            this.releaseConnection(response);
            return bl;
        }
        catch (Throwable throwable) {
            this.releaseConnection(response);
            throw throwable;
        }
    }

    private static StringBuilder makeLink(StringBuilder b, String uriPrefix, String key, String value) {
        if (value == null) {
            return b;
        }
        String terminationUri = uriPrefix == null ? value : String.format("%s%s", uriPrefix, value);
        Link link = Link.fromUri((String)terminationUri).title(key + " URI").rel(key).type("text/plain").build(new Object[0]);
        if (b.length() != 0) {
            b.append(',');
        }
        return b.append(link);
    }

    private String enlistCompensator(URL lraUrl, long timelimit, String uriPrefix, String compensateUrl, String completeUrl, String forgetUrl, String leaveUrl, String statusUrl, String compensatorData) {
        this.validateURL(completeUrl, false, "Invalid complete URL: %s");
        this.validateURL(compensateUrl, false, "Invalid compensate URL: %s");
        this.validateURL(leaveUrl, true, "Invalid status URL: %s");
        this.validateURL(forgetUrl, true, "Invalid forgetUrl URL: %s");
        this.validateURL(statusUrl, true, "Invalid status URL: %s");
        HashMap<String, String> terminateURIs = new HashMap<String, String>();
        terminateURIs.put(COMPENSATE, compensateUrl);
        terminateURIs.put(COMPLETE, completeUrl);
        terminateURIs.put(LEAVE, leaveUrl);
        terminateURIs.put(STATUS, statusUrl);
        terminateURIs.put(FORGET, forgetUrl);
        StringBuilder linkHeaderValue = new StringBuilder();
        terminateURIs.forEach((k, v) -> LRAClient.makeLink(linkHeaderValue, uriPrefix, k, v));
        return this.enlistCompensator(lraUrl, timelimit, linkHeaderValue.toString(), compensatorData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String enlistCompensator(URL lraUrl, long timelimit, String linkHeader, String compensatorData) {
        Response response = null;
        if (timelimit < 0L) {
            timelimit = 0L;
        }
        try {
            response = this.getTarget().path(LRAClient.getLRAId(lraUrl.toString())).queryParam(TIMELIMIT_PARAM_NAME, new Object[]{timelimit}).request().header("Link", (Object)linkHeader).header(LRA_HTTP_HEADER, (Object)lraUrl).put(Entity.entity((Object)(compensatorData == null ? linkHeader : compensatorData), (String)"text/plain"));
            if (response.getStatus() == Response.Status.PRECONDITION_FAILED.getStatusCode()) {
                throw new IllegalLRAStateException(lraUrl.toString(), "Too late to join with this LRA", null);
            }
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                this.lraTrace(String.format("enlist in LRA failed (%d)", response.getStatus()), lraUrl);
                throw new GenericLRAException(lraUrl, response.getStatus(), "unable to register compensator", null);
            }
            String string = (String)response.readEntity(String.class);
            this.releaseConnection(response);
            return string;
        }
        catch (Throwable throwable) {
            this.releaseConnection(response);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String endLRA(URL lra, boolean confirm) throws GenericLRAException {
        String string;
        String confirmUrl = String.format(confirm ? confirmFormat : compensateFormat, LRAClient.getLRAId(lra.toString()));
        Response response = null;
        this.lraTrace(String.format("%s LRA", confirm ? "close" : COMPENSATE), lra);
        try {
            response = this.getTarget().path(confirmUrl).request().put(Entity.text((Object)""));
            this.assertEquals(response, Response.Status.OK.getStatusCode(), response.getStatus(), "LRA finished with an unexpected status code: " + response.getStatus());
            String responseData = (String)response.readEntity(String.class);
            this.setResponseData(lra, responseData);
            string = responseData;
            this.releaseConnection(response);
        }
        catch (Throwable throwable) {
            this.releaseConnection(response);
            Current.pop(lra);
            URL nextLRA = Current.peek();
            if (nextLRA != null) {
                try {
                    this.init(nextLRA);
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            throw throwable;
        }
        Current.pop(lra);
        URL nextLRA = Current.peek();
        if (nextLRA != null) {
            try {
                this.init(nextLRA);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return string;
    }

    private void validateURL(String url, boolean nullAllowed, String message) {
        if (url == null) {
            if (!nullAllowed) {
                throw new GenericLRAException(null, Response.Status.NOT_ACCEPTABLE.getStatusCode(), String.format(message, "null value"), null);
            }
        } else {
            try {
                new URL(url);
            }
            catch (MalformedURLException e) {
                throw new GenericLRAException(null, Response.Status.NOT_ACCEPTABLE.getStatusCode(), String.format(message, e.getMessage()), e);
            }
        }
    }

    private void assertNotNull(Object lra, String message) {
        if (lra == null) {
            throw new GenericLRAException(null, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), message, null);
        }
    }

    private void assertEquals(Response response, Object expected, Object actual, String messageFormat) {
        if (!actual.equals(expected)) {
            throw new GenericLRAException(null, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), String.format(messageFormat, expected, actual), null);
        }
    }

    public String getUrl() {
        return this.base.toString();
    }

    @Override
    public URL getCurrent() {
        return Current.peek();
    }

    private void lraTrace(String reason, URL lra) {
        if (isTrace.booleanValue()) {
            System.out.printf("LRAClient: %s: lra: %s%n", reason, lra == null ? "null" : lra);
        }
    }

    @Override
    public void close() {
        this.client.close();
        if (this.responseDataMap != null) {
            this.responseDataMap.clear();
        }
    }

    private void aquireConnection() {
        if (this.connectionInUse) {
            System.out.printf("LRAClient: trying to aquire an in use connection", new Object[0]);
            throw new GenericLRAException(null, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "LRAClient: trying to aquire an in use connection", null);
        }
        this.connectionInUse = true;
    }

    private void releaseConnection(Response response) {
        if (response != null) {
            response.close();
        }
        this.connectionInUse = false;
    }

    private void setResponseData(URL lraId, String responseData) {
        if (responseData == null || responseData.isEmpty()) {
            return;
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            List<Object> compensatorData = Arrays.asList((Object[])mapper.readValue(responseData, String[].class));
            if (this.responseDataMap.containsKey(lraId)) {
                this.responseDataMap.get(lraId).addAll(compensatorData);
            } else {
                this.responseDataMap.put(lraId, compensatorData);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<String> getResponseData(URL lraId) {
        return this.responseDataMap.containsKey(lraId) ? this.responseDataMap.get(lraId) : Collections.emptyList();
    }
}

