/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.lra.client;

import java.net.URL;
import javax.ws.rs.WebApplicationException;

public class GenericLRAException
extends WebApplicationException {
    private final String lraId;
    private final int statusCode;

    public GenericLRAException(URL lraId, int statusCode, String message, Throwable cause) {
        this(lraId == null ? null : lraId.toString(), statusCode, message, cause);
    }

    public GenericLRAException(int statusCode, String message) {
        super(message);
        this.lraId = null;
        this.statusCode = statusCode;
    }

    public GenericLRAException(URL lraId, int statusCode) {
        this.lraId = lraId == null ? null : lraId.toString();
        this.statusCode = statusCode;
    }

    public GenericLRAException(URL lraId, int statusCode, String message) {
        super(String.format("%s, lra id: %s", message, lraId));
        this.lraId = lraId == null ? null : lraId.toString();
        this.statusCode = statusCode;
    }

    public GenericLRAException(int statusCode, String message, Throwable cause) {
        super(message, cause);
        this.lraId = null;
        this.statusCode = statusCode;
    }

    public GenericLRAException(String lraId, int statusCode, String message, Throwable cause) {
        super(String.format("%s, lra id: %s", message, lraId), cause);
        this.lraId = lraId;
        this.statusCode = statusCode;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getLraId() {
        return this.lraId;
    }
}

