/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.lra.client;

import java.net.URL;

public class LRAInfo {
    private Exception jsonParseError;
    private String lraId;
    private String clientId;
    private boolean isComplete;
    private boolean isCompensated;
    private boolean isRecovering;
    private boolean isActive;
    private boolean isTopLevel;

    public LRAInfo(String lraId) {
        this.lraId = lraId;
    }

    public LRAInfo(URL lraId) {
        this.lraId = lraId.toString();
    }

    public LRAInfo(String lraId, String clientId, boolean isComplete, boolean isCompensated, boolean isRecovering, boolean isActive, boolean isTopLevel) {
        this.lraId = lraId;
        this.clientId = clientId;
        this.isComplete = isComplete;
        this.isCompensated = isCompensated;
        this.isRecovering = isRecovering;
        this.isActive = isActive;
        this.isTopLevel = isTopLevel;
        this.jsonParseError = null;
    }

    public LRAInfo(Exception e) {
        this.jsonParseError = e;
        this.lraId = "JSON Parse Error: " + e.getMessage();
        this.clientId = e.getMessage();
        this.isComplete = false;
        this.isCompensated = false;
        this.isRecovering = false;
        this.isActive = false;
        this.isTopLevel = false;
    }

    public String getLraId() {
        return this.lraId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public boolean isCompensated() {
        return this.isCompensated;
    }

    public boolean isRecovering() {
        return this.isRecovering;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isTopLevel() {
        return this.isTopLevel;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LRAInfo)) {
            return false;
        }
        LRAInfo lraStatus = (LRAInfo)o;
        return this.getLraId().equals(lraStatus.getLraId());
    }

    public int hashCode() {
        return this.getLraId().hashCode();
    }
}

