/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.lra.client;

import io.narayana.lra.annotation.Compensate;
import io.narayana.lra.annotation.CompensatorStatus;
import io.narayana.lra.annotation.Complete;
import io.narayana.lra.annotation.Forget;
import io.narayana.lra.annotation.Leave;
import io.narayana.lra.annotation.Status;
import io.narayana.lra.annotation.TimeLimit;
import io.narayana.lra.client.Current;
import io.narayana.lra.client.GenericLRAException;
import io.narayana.lra.client.IllegalLRAStateException;
import io.narayana.lra.client.InvalidLRAIdException;
import io.narayana.lra.client.LRAClient;
import io.narayana.lra.client.LRAInfo;
import io.narayana.lra.logging.LRALogger;
import java.io.Closeable;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.RequestScoped;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.ws.rs.Path;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

@RequestScoped
public class NarayanaLRAClient
implements LRAClient,
Closeable {
    public static final String LRA_HTTP_HEADER = "Long-Running-Action";
    public static final String LRA_HTTP_RECOVERY_HEADER = "Long-Running-Action-Recovery";
    public static final String COORDINATOR_PATH_NAME = "lra-coordinator";
    public static final String RECOVERY_COORDINATOR_PATH_NAME = "lra-recovery-coordinator";
    public static final String CORRDINATOR_HOST_PROP = "lra.http.host";
    public static final String CORRDINATOR_PORT_PROP = "lra.http.port";
    public static final String COMPLETE = "complete";
    public static final String COMPENSATE = "compensate";
    public static final String STATUS = "status";
    public static final String LEAVE = "leave";
    public static final String FORGET = "forget";
    public static final String TIMELIMIT_PARAM_NAME = "TimeLimit";
    public static final String CLIENT_ID_PARAM_NAME = "ClientID";
    public static final String PARENT_LRA_PARAM_NAME = "ParentLRA";
    public static final String STATUS_PARAM_NAME = "Status";
    public static final long DEFAULT_TIMEOUT_MILLIS = 0L;
    private static final String startLRAUrl = "/start";
    private static final String getAllLRAsUrl = "/";
    private static final String getRecoveringLRAsUrl = "?status=Compensating";
    private static final String getActiveLRAsUrl = "?status=";
    private static final String confirmFormat = "/%s/close";
    private static final String compensateFormat = "/%s/cancel";
    private static final String leaveFormat = "/%s/remove";
    private static final String renewFormat = "/%s/renew";
    private static final String MISSING_ANNOTATION_FORMAT = "Cannot enlist resource class %s: annotated with LRA but is missing one or more of {@Complete. @Compensate, @Status}";
    private static Boolean isTrace = Boolean.getBoolean("trace");
    private WebTarget target;
    private URI base;
    private Client client;
    private boolean isUseable;
    private boolean connectionInUse;
    private Map<URL, String> responseDataMap;

    public NarayanaLRAClient() throws URISyntaxException {
        this("http", System.getProperty(CORRDINATOR_HOST_PROP, "localhost"), Integer.getInteger(CORRDINATOR_PORT_PROP, 8080));
    }

    public NarayanaLRAClient(String host, int port) throws URISyntaxException {
        this("http", host, port);
    }

    public NarayanaLRAClient(String scheme, String host, int port) throws URISyntaxException {
        this.init(scheme, host, port);
    }

    public NarayanaLRAClient(URL coordinatorUrl) throws MalformedURLException, URISyntaxException {
        this.init(coordinatorUrl);
    }

    private void init(URL coordinatorUrl) throws URISyntaxException {
        this.init(coordinatorUrl.getProtocol(), coordinatorUrl.getHost(), coordinatorUrl.getPort());
    }

    private void init(String scheme, String host, int port) throws URISyntaxException {
        if (this.client == null) {
            this.client = ClientBuilder.newClient();
        }
        this.base = new URI(scheme, null, host, port, "/lra-coordinator", null, null);
        this.target = this.client.target(this.base);
        this.isUseable = true;
        if (this.responseDataMap == null) {
            this.postConstruct();
        } else {
            this.responseDataMap.clear();
        }
    }

    public boolean isUseable() {
        return this.isUseable;
    }

    @PostConstruct
    public void postConstruct() {
        this.responseDataMap = new HashMap<URL, String>();
    }

    @PreDestroy
    public void preDestroy() {
        this.isUseable = false;
    }

    public static URL lraToURL(String lraId) {
        return NarayanaLRAClient.lraToURL(lraId, "Invalid LRA id");
    }

    public static URL lraToURL(String lraId, String errorMessage) {
        try {
            return new URL(lraId);
        }
        catch (MalformedURLException e) {
            LRALogger.i18NLogger.error_urlConstructionFromStringLraId(lraId, e);
            throw new GenericLRAException(lraId, Response.Status.BAD_REQUEST.getStatusCode(), errorMessage, (Throwable)e);
        }
    }

    public static String encodeURL(URL lraId, String errorMessage) {
        try {
            return URLEncoder.encode(lraId.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LRALogger.i18NLogger.error_invalidFormatToEncodeUrl(lraId, e);
            throw new GenericLRAException(lraId, Response.Status.BAD_REQUEST.getStatusCode(), errorMessage, (Throwable)e);
        }
    }

    public static String getLRAId(String lraId) {
        return lraId == null ? null : lraId.replaceFirst(".*/([^/?]+).*", "$1");
    }

    public URL toURL(String lraId) throws InvalidLRAIdException {
        try {
            return new URL(lraId);
        }
        catch (MalformedURLException e) {
            LRALogger.i18NLogger.error_invalidStringFormatOfUrl(lraId, e);
            throw new InvalidLRAIdException(lraId, "Invalid syntax", e);
        }
    }

    private WebTarget getTarget() {
        this.client.close();
        this.client = ClientBuilder.newClient();
        return this.client.target(this.base);
    }

    @Override
    public void setCurrentLRA(URL coordinatorUrl) {
        try {
            this.init(coordinatorUrl);
        }
        catch (URISyntaxException e) {
            LRALogger.i18NLogger.error_invalidCoordinatorUrl(coordinatorUrl, e);
            throw new GenericLRAException(coordinatorUrl, Response.Status.BAD_REQUEST.getStatusCode(), e.getMessage(), (Throwable)e);
        }
    }

    public URL startLRA(String clientID) throws GenericLRAException {
        return this.startLRA(clientID, 0L);
    }

    public URL startLRA(String clientID, Long timeout) throws GenericLRAException {
        return this.startLRA(null, clientID, timeout, TimeUnit.SECONDS);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public URL startLRA(URL parentLRA, String clientID, Long timeout, TimeUnit unit) throws GenericLRAException {
        Response response = null;
        if (clientID == null) {
            clientID = "";
        }
        if (timeout == null) {
            timeout = 0L;
        } else if (timeout < 0L) {
            throw new GenericLRAException(parentLRA, Response.Status.BAD_REQUEST.getStatusCode(), "Invalid timeout value: " + timeout);
        }
        this.lraTracef("startLRA for client %s with parent %s", clientID, parentLRA);
        try {
            String encodedParentLRA = parentLRA == null ? "" : URLEncoder.encode(parentLRA.toString(), "UTF-8");
            this.aquireConnection();
            response = this.getTarget().path(startLRAUrl).queryParam(TIMELIMIT_PARAM_NAME, new Object[]{unit.toMillis(timeout)}).queryParam(CLIENT_ID_PARAM_NAME, new Object[]{clientID}).queryParam(PARENT_LRA_PARAM_NAME, new Object[]{encodedParentLRA}).request().post(Entity.text((Object)""));
            if (!this.isExpectedResponseStatus(response, Response.Status.CREATED)) {
                LRALogger.i18NLogger.error_lraCreationUnexpectedStatus(response.getStatus(), response);
                throw new GenericLRAException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "LRA start returned an unexpected status code: " + response.getStatus());
            }
            Object lraObject = response.getHeaders().getFirst((Object)LRA_HTTP_HEADER);
            if (lraObject == null) {
                LRALogger.i18NLogger.error_nullLraOnCreation(response);
                throw new GenericLRAException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "LRA creation is null");
            }
            URL lra = new URL(URLDecoder.decode(lraObject.toString(), "UTF-8"));
            this.lraTrace(lra, "startLRA returned");
            Current.push(lra);
            this.releaseConnection(response);
            return lra;
        }
        catch (UnsupportedEncodingException | MalformedURLException e) {
            try {
                LRALogger.i18NLogger.error_cannotCreateUrlFromLCoordinatorResponse(response, e);
                throw new GenericLRAException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), e.getMessage(), e);
                catch (Exception e2) {
                    LRALogger.i18NLogger.error_cannotContactLRACoordinator(this.base, e2);
                    if (e2.getCause() == null) throw new GenericLRAException(Response.Status.SERVICE_UNAVAILABLE.getStatusCode(), e2.getMessage(), e2);
                    if (!ConnectException.class.equals(e2.getCause().getClass())) throw new GenericLRAException(Response.Status.SERVICE_UNAVAILABLE.getStatusCode(), e2.getMessage(), e2);
                    throw new GenericLRAException(Response.Status.SERVICE_UNAVAILABLE.getStatusCode(), "Cannot connect to the LRA coordinator: " + this.base + " (" + e2.getCause().getMessage() + ")", e2);
                }
            }
            catch (Throwable throwable) {
                this.releaseConnection(response);
                throw throwable;
            }
        }
    }

    @Override
    public void renewTimeLimit(URL lraId, long limit, TimeUnit unit) {
        Response response = null;
        this.lraTracef(lraId, "renew time limit to %s s of LRA", unit.toSeconds(limit));
        try {
            this.aquireConnection();
            response = this.getTarget().path(String.format(renewFormat, NarayanaLRAClient.getLRAId(lraId.toString()))).queryParam(TIMELIMIT_PARAM_NAME, new Object[]{unit.toMillis(limit)}).request().header(LRA_HTTP_HEADER, (Object)lraId).put(Entity.text((Object)""));
            if (Response.Status.OK.getStatusCode() != response.getStatus()) {
                LRALogger.i18NLogger.error_lraRenewalUnexpectedStatus(response.getStatus(), response);
            }
            throw new GenericLRAException(lraId, response.getStatus(), "", null);
        }
        catch (Throwable throwable) {
            this.releaseConnection(response);
            throw throwable;
        }
    }

    @Override
    public String cancelLRA(URL lraId) throws GenericLRAException {
        return this.endLRA(lraId, false);
    }

    @Override
    public String closeLRA(URL lraId) throws GenericLRAException {
        return this.endLRA(lraId, true);
    }

    public String joinLRAWithLinkHeader(URL lraUrl, Long timelimit, String linkHeader, String compensatorData) throws GenericLRAException {
        this.lraTracef(lraUrl, "joining LRA with participant link: %s", linkHeader);
        return this.enlistCompensator(lraUrl, timelimit, linkHeader, compensatorData);
    }

    @Override
    public String joinLRA(URL lraId, Long timelimit, String compensatorUrl, String compensatorData) throws GenericLRAException {
        this.lraTracef(lraId, "joining LRA with participant %s", compensatorUrl);
        return this.enlistCompensator(lraId, timelimit, "", String.format("%s/compensate", compensatorUrl), String.format("%s/complete", compensatorUrl), String.format("%s/forget", compensatorUrl), String.format("%s/leave", compensatorUrl), String.format("%s/status", compensatorUrl), compensatorData);
    }

    private String toExternalForm(URL url) {
        return url == null ? null : url.toExternalForm();
    }

    @Override
    public String joinLRA(URL lraId, Long timelimit, URL compensateUrl, URL completeUrl, URL forgetUrl, URL leaveUrl, URL statusUrl, String compensatorData) throws GenericLRAException {
        return this.enlistCompensator(lraId, timelimit, "", this.toExternalForm(compensateUrl), this.toExternalForm(completeUrl), this.toExternalForm(forgetUrl), this.toExternalForm(leaveUrl), this.toExternalForm(statusUrl), compensatorData);
    }

    @Override
    public String joinLRA(URL lraId, Class<?> resourceClass, URI baseUri, String compensatorData) throws GenericLRAException {
        long timeLimit;
        Map<String, String> terminateURIs = NarayanaLRAClient.getTerminationUris(resourceClass, baseUri);
        String timeLimitStr = terminateURIs.get(TIMELIMIT_PARAM_NAME);
        long l = timeLimit = timeLimitStr == null ? 0L : Long.valueOf(timeLimitStr);
        if (terminateURIs.containsKey("Link")) {
            return this.joinLRAWithLinkHeader(lraId, timeLimit, terminateURIs.get("Link"), compensatorData);
        }
        return null;
    }

    @Override
    public URL updateCompensator(URL recoveryUrl, URL compensateUrl, URL completeUrl, URL forgetUrl, URL statusUrl, String compensatorData) throws GenericLRAException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void leaveLRA(URL lraId, String compensatorUrl) throws GenericLRAException {
        Response response = null;
        this.lraTracef(lraId, "leaving LRA, compensator url: %s", compensatorUrl);
        try {
            this.aquireConnection();
            response = this.getTarget().path(String.format(leaveFormat, NarayanaLRAClient.getLRAId(lraId.toString()))).request().header(LRA_HTTP_HEADER, (Object)lraId).put(Entity.entity((Object)compensatorUrl, (String)"text/plain"));
            if (Response.Status.OK.getStatusCode() != response.getStatus()) {
                LRALogger.i18NLogger.error_lraLeaveUnexpectedStatus(response.getStatus(), response);
                throw new GenericLRAException(lraId, response.getStatus());
            }
            this.releaseConnection(response);
        }
        catch (Throwable throwable) {
            this.releaseConnection(response);
            throw throwable;
        }
    }

    @Override
    public List<LRAInfo> getAllLRAs() throws GenericLRAException {
        return this.getLRAs(null, null);
    }

    @Override
    public List<LRAInfo> getActiveLRAs() throws GenericLRAException {
        return this.getLRAs(STATUS, "");
    }

    @Override
    public List<LRAInfo> getRecoveringLRAs() throws GenericLRAException {
        return this.getLRAs(STATUS, CompensatorStatus.Compensating.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<LRAInfo> getLRAs(String queryName, String queryValue) {
        Response response = null;
        try {
            this.aquireConnection();
            response = queryName == null ? this.getTarget().request().get() : this.getTarget().queryParam(queryName, new Object[]{queryValue}).request().get();
            if (!response.hasEntity()) {
                throw new GenericLRAException(response.getStatus(), "missing entity body");
            }
            ArrayList<LRAInfo> actions = new ArrayList<LRAInfo>();
            String lras = (String)response.readEntity(String.class);
            JsonReader reader = Json.createReader((Reader)new StringReader(lras));
            JsonArray ja = reader.readArray();
            ja.forEach(jsonValue -> actions.add(this.toLRAInfo((JsonObject)jsonValue)));
            ArrayList<LRAInfo> arrayList = actions;
            this.releaseConnection(response);
            return arrayList;
        }
        catch (Throwable throwable) {
            this.releaseConnection(response);
            throw throwable;
        }
    }

    private LRAInfo toLRAInfo(JsonObject jo) {
        try {
            return new LRAInfo(jo.getString("lraId"), jo.getString("clientId"), jo.getBoolean("completed"), jo.getBoolean("compensated"), jo.getBoolean("recovering"), jo.getBoolean("active"), jo.getBoolean("topLevel"));
        }
        catch (Exception e) {
            LRALogger.i18NLogger.warn_failedParsingStatusFromJson(jo, e);
            return new LRAInfo(e);
        }
    }

    @Override
    public Boolean isActiveLRA(URL lraId) throws GenericLRAException {
        try {
            return !this.getStatus(lraId).isPresent();
        }
        catch (GenericLRAException e) {
            if (e.getStatusCode() == Response.Status.NOT_FOUND.getStatusCode()) {
                return false;
            }
            throw e;
        }
    }

    @Override
    public Boolean isCompensatedLRA(URL lraId) throws GenericLRAException {
        return this.isStatus(lraId, CompensatorStatus.Compensated);
    }

    @Override
    public Boolean isCompletedLRA(URL lraId) throws GenericLRAException {
        return this.isStatus(lraId, CompensatorStatus.Completed);
    }

    public static Map<String, String> getTerminationUris(Class<?> compensatorClass, URI baseUri) {
        HashMap<String, String> paths = new HashMap<String, String>();
        boolean[] asyncTermination = new boolean[]{false};
        Path resourcePathAnnotation = compensatorClass.getAnnotation(Path.class);
        String resourcePath = resourcePathAnnotation == null ? "" : resourcePathAnnotation.value().replaceAll("^/+", "");
        String uriPrefix = String.format("%s:%s%s", baseUri.getScheme(), baseUri.getSchemeSpecificPart(), resourcePath).replaceAll("/$", "");
        Arrays.stream(compensatorClass.getMethods()).forEach(method -> {
            Path pathAnnotation = method.getAnnotation(Path.class);
            if (pathAnnotation != null) {
                if (NarayanaLRAClient.checkMethod(paths, COMPENSATE, pathAnnotation, (Annotation)method.getAnnotation(Compensate.class), uriPrefix) != 0) {
                    TimeLimit timeLimit = method.getAnnotation(TimeLimit.class);
                    if (timeLimit != null) {
                        paths.put(TIMELIMIT_PARAM_NAME, Long.toString(timeLimit.unit().toMillis(timeLimit.limit())));
                    }
                    if (NarayanaLRAClient.isAsyncCompletion(method)) {
                        asyncTermination[0] = true;
                    }
                }
                if (NarayanaLRAClient.checkMethod(paths, COMPLETE, pathAnnotation, (Annotation)method.getAnnotation(Complete.class), uriPrefix) != 0 && NarayanaLRAClient.isAsyncCompletion(method)) {
                    asyncTermination[0] = true;
                }
                NarayanaLRAClient.checkMethod(paths, STATUS, pathAnnotation, (Annotation)method.getAnnotation(Status.class), uriPrefix);
                NarayanaLRAClient.checkMethod(paths, FORGET, pathAnnotation, (Annotation)method.getAnnotation(Forget.class), uriPrefix);
                NarayanaLRAClient.checkMethod(paths, LEAVE, pathAnnotation, (Annotation)method.getAnnotation(Leave.class), uriPrefix);
            }
        });
        if (asyncTermination[0] && !paths.containsKey(STATUS) && !paths.containsKey(FORGET)) {
            LRALogger.i18NLogger.error_asyncTerminationBeanMissStatusAndForget(compensatorClass);
            throw new GenericLRAException(Response.Status.BAD_REQUEST.getStatusCode(), "LRA participant class with asynchronous temination but no @Status or @Forget annotations");
        }
        StringBuilder linkHeaderValue = new StringBuilder();
        if (paths.size() != 0) {
            paths.forEach((k, v) -> NarayanaLRAClient.makeLink(linkHeaderValue, null, k, v));
            paths.put("Link", linkHeaderValue.toString());
        }
        return paths;
    }

    public static boolean isAsyncCompletion(Method method) {
        if (method.isAnnotationPresent(Complete.class) || method.isAnnotationPresent(Compensate.class)) {
            Annotation[][] annotationArray = method.getParameterAnnotations();
            int n = annotationArray.length;
            for (int i = 0; i < n; ++i) {
                Annotation[] ann;
                for (Annotation an : ann = annotationArray[i]) {
                    if (!Suspended.class.getName().equals(an.annotationType().getName())) continue;
                    LRALogger.logger.warn((Object)"JAX-RS @Suspended annotation is untested");
                    return true;
                }
            }
        }
        return false;
    }

    private static int checkMethod(Map<String, String> paths, String rel, Path pathAnnotation, Annotation annotationClass, String uriPrefix) {
        if (annotationClass == null) {
            return 0;
        }
        paths.put(rel, uriPrefix + pathAnnotation.value());
        return 1;
    }

    private boolean isStatus(URL lraId, CompensatorStatus testStatus) {
        Optional<CompensatorStatus> status = this.getStatus(lraId);
        if (!status.isPresent()) {
            return testStatus == null;
        }
        return status.get() == testStatus;
    }

    @Override
    public Optional<CompensatorStatus> getStatus(URL lraId) throws GenericLRAException {
        Response response = null;
        try {
            this.aquireConnection();
            response = this.getTarget().path(NarayanaLRAClient.getLRAId(lraId.toString())).request().accept(new MediaType[]{MediaType.TEXT_PLAIN_TYPE}).get();
        }
        catch (Exception e) {
            this.releaseConnection(null);
            LRALogger.i18NLogger.error_cannotAccesCorrdinatorWhenGettingStatus(this.base, lraId, e);
            throw new GenericLRAException(lraId, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Could not access the LRA coordinator: " + e.getMessage(), (Throwable)e);
        }
        try {
            if (response.getStatus() == Response.Status.NO_CONTENT.getStatusCode()) {
                Optional<CompensatorStatus> optional = Optional.empty();
                return optional;
            }
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                LRALogger.i18NLogger.error_invalidStatusCode(this.base, response.getStatus(), lraId);
                throw new GenericLRAException(lraId, response.getStatus(), "LRA coordinator returned an invalid status code", null);
            }
            if (!response.hasEntity()) {
                LRALogger.i18NLogger.error_noContentOnGetStatus(this.base, lraId);
                throw new GenericLRAException(lraId, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "LRA coordinator#getStatus returned 200 OK but no content");
            }
            try {
                Optional<CompensatorStatus> optional = NarayanaLRAClient.fromString((String)response.readEntity(String.class));
                return optional;
            }
            catch (IllegalArgumentException e) {
                LRALogger.i18NLogger.error_invalidArgumentOnStatusFromCoordinator(this.base, lraId, e);
                throw new GenericLRAException(lraId, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "LRA coordinator returned an invalid status", (Throwable)e);
            }
        }
        finally {
            this.releaseConnection(response);
        }
    }

    private static Optional<CompensatorStatus> fromString(String status) {
        if (status != null) {
            return Optional.of(CompensatorStatus.valueOf((String)status));
        }
        return Optional.empty();
    }

    private static StringBuilder makeLink(StringBuilder b, String uriPrefix, String key, String value) {
        if (value == null) {
            return b;
        }
        String terminationUri = uriPrefix == null ? value : String.format("%s%s", uriPrefix, value);
        Link link = Link.fromUri((String)terminationUri).title(key + " URI").rel(key).type("text/plain").build(new Object[0]);
        if (b.length() != 0) {
            b.append(',');
        }
        return b.append(link);
    }

    private String enlistCompensator(URL lraUrl, long timelimit, String uriPrefix, String compensateUrl, String completeUrl, String forgetUrl, String leaveUrl, String statusUrl, String compensatorData) {
        this.validateURL(completeUrl, true, "Invalid complete URL: %s");
        this.validateURL(compensateUrl, true, "Invalid compensate URL: %s");
        this.validateURL(leaveUrl, true, "Invalid status URL: %s");
        this.validateURL(forgetUrl, true, "Invalid forgetUrl URL: %s");
        this.validateURL(statusUrl, true, "Invalid status URL: %s");
        HashMap<String, String> terminateURIs = new HashMap<String, String>();
        terminateURIs.put(COMPENSATE, compensateUrl);
        terminateURIs.put(COMPLETE, completeUrl);
        terminateURIs.put(LEAVE, leaveUrl);
        terminateURIs.put(STATUS, statusUrl);
        terminateURIs.put(FORGET, forgetUrl);
        StringBuilder linkHeaderValue = new StringBuilder();
        terminateURIs.forEach((k, v) -> NarayanaLRAClient.makeLink(linkHeaderValue, uriPrefix, k, v));
        return this.enlistCompensator(lraUrl, timelimit, linkHeaderValue.toString(), compensatorData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String enlistCompensator(URL lraUrl, long timelimit, String linkHeader, String compensatorData) {
        Response response = null;
        if (timelimit < 0L) {
            timelimit = 0L;
        }
        try {
            response = this.getTarget().path(NarayanaLRAClient.getLRAId(lraUrl.toString())).queryParam(TIMELIMIT_PARAM_NAME, new Object[]{timelimit}).request().header("Link", (Object)linkHeader).header(LRA_HTTP_HEADER, (Object)lraUrl).put(Entity.entity((Object)(compensatorData == null ? linkHeader : compensatorData), (String)"text/plain"));
            if (response.getStatus() == Response.Status.PRECONDITION_FAILED.getStatusCode()) {
                LRALogger.i18NLogger.error_tooLateToJoin(lraUrl, response);
                throw new IllegalLRAStateException(lraUrl.toString(), "Too late to join with this LRA", "enlistCompensator");
            }
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                LRALogger.i18NLogger.error_failedToEnlist(lraUrl, this.base, response.getStatus());
                throw new GenericLRAException(lraUrl, response.getStatus(), "unable to register participant");
            }
            String string = (String)response.readEntity(String.class);
            this.releaseConnection(response);
            return string;
        }
        catch (Throwable throwable) {
            this.releaseConnection(response);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String endLRA(URL lra, boolean confirm) throws GenericLRAException {
        String string;
        String confirmUrl = String.format(confirm ? confirmFormat : compensateFormat, NarayanaLRAClient.getLRAId(lra.toString()));
        Response response = null;
        this.lraTracef(lra, "%s LRA", confirm ? "close" : COMPENSATE);
        try {
            response = this.getTarget().path(confirmUrl).request().put(Entity.text((Object)""));
            if (!this.isExpectedResponseStatus(response, Response.Status.OK, Response.Status.ACCEPTED)) {
                LRALogger.i18NLogger.error_lraTerminationUnexpectedStatus(response.getStatus(), response);
                throw new GenericLRAException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "LRA finished with an unexpected status code: " + response.getStatus());
            }
            String responseData = (String)response.readEntity(String.class);
            this.setResponseData(lra, responseData);
            string = responseData;
            this.releaseConnection(response);
        }
        catch (Throwable throwable) {
            this.releaseConnection(response);
            Current.pop(lra);
            URL nextLRA = Current.peek();
            if (nextLRA != null) {
                try {
                    this.init(nextLRA);
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            throw throwable;
        }
        Current.pop(lra);
        URL nextLRA = Current.peek();
        if (nextLRA != null) {
            try {
                this.init(nextLRA);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return string;
    }

    private void validateURL(String url, boolean nullAllowed, String message) {
        if (url == null) {
            if (!nullAllowed) {
                throw new GenericLRAException(Response.Status.NOT_ACCEPTABLE.getStatusCode(), String.format(message, "null value"));
            }
        } else {
            try {
                new URL(url);
            }
            catch (MalformedURLException e) {
                throw new GenericLRAException(Response.Status.NOT_ACCEPTABLE.getStatusCode(), String.format(message, e.getMessage()), e);
            }
        }
    }

    private boolean isExpectedResponseStatus(Response response, Response.Status ... expected) {
        for (Response.Status anExpected : expected) {
            if (response.getStatus() != anExpected.getStatusCode()) continue;
            return true;
        }
        return false;
    }

    public String getUrl() {
        return this.base.toString();
    }

    @Override
    public URL getCurrent() {
        return Current.peek();
    }

    private void lraTracef(String reasonFormat, Object ... parameters) {
        if (!LRALogger.logger.isTraceEnabled()) {
            return;
        }
        LRALogger.logger.tracef(reasonFormat, parameters);
    }

    private void lraTrace(URL lra, String reason) {
        this.lraTracef(lra, reason, (Object[])null);
    }

    private void lraTracef(URL lra, String reasonFormat, Object ... parameters) {
        Object[] newParams = parameters != null ? Arrays.copyOf(parameters, parameters.length + 1) : new Object[1];
        newParams[newParams.length - 1] = lra;
        this.lraTracef(reasonFormat + ", lra id: %s", newParams);
    }

    @Override
    public void close() {
        this.client.close();
        if (this.responseDataMap != null) {
            this.responseDataMap.clear();
        }
    }

    private void aquireConnection() {
        if (this.connectionInUse) {
            LRALogger.i18NLogger.error_cannotAquireInUseConnection();
            throw new GenericLRAException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "LRAClient: trying to aquire an in use connection");
        }
        this.connectionInUse = true;
    }

    private void releaseConnection(Response response) {
        if (response != null) {
            response.close();
        }
        this.connectionInUse = false;
    }

    private void setResponseData(URL lraId, String responseData) {
        this.responseDataMap.put(lraId, responseData);
    }

    public String getResponseData(URL lraId) {
        return this.responseDataMap.containsKey(lraId) ? this.responseDataMap.get(lraId) : null;
    }
}

