/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.lra.client;

import io.narayana.lra.Current;
import io.narayana.lra.logging.LRALogger;
import java.io.Closeable;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.RequestScoped;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.lra.annotation.AfterLRA;
import org.eclipse.microprofile.lra.annotation.Compensate;
import org.eclipse.microprofile.lra.annotation.Complete;
import org.eclipse.microprofile.lra.annotation.Forget;
import org.eclipse.microprofile.lra.annotation.LRAStatus;
import org.eclipse.microprofile.lra.annotation.Status;
import org.eclipse.microprofile.lra.annotation.ws.rs.Leave;

@RequestScoped
public class NarayanaLRAClient
implements Closeable {
    public static final String LRA_COORDINATOR_HOST_KEY = "lra.http.host";
    public static String LRA_COORDINATOR_PORT_KEY = "lra.http.port";
    public static String LRA_COORDINATOR_PATH_KEY = "lra.coordinator.path";
    public static final long DEFAULT_TIMEOUT_MILLIS = 0L;
    private static final String startLRAUrl = "/start";
    private static final String confirmFormat = "/%s/close";
    private static final String compensateFormat = "/%s/cancel";
    private static final String leaveFormat = "/%s/remove";
    private static final String LINK_TEXT = "Link";
    private URI base;
    private Client client;
    private boolean connectionInUse;
    private static URI defaultCoordinatorURI;

    public static void setDefaultCoordinatorEndpoint(URI lraCoordinatorEndpoint) {
        defaultCoordinatorURI = lraCoordinatorEndpoint;
    }

    public static boolean isInitialised() {
        return defaultCoordinatorURI != null;
    }

    public NarayanaLRAClient() throws URISyntaxException {
        if (defaultCoordinatorURI != null) {
            try {
                this.init(defaultCoordinatorURI);
            }
            catch (MalformedURLException e) {
                throw new URISyntaxException(defaultCoordinatorURI.toString(), e.getMessage());
            }
        } else {
            this.init("http", System.getProperty(LRA_COORDINATOR_HOST_KEY, "localhost"), Integer.getInteger(LRA_COORDINATOR_PORT_KEY, 8080));
        }
    }

    public NarayanaLRAClient(String host, int port) throws URISyntaxException {
        this("http", host, port);
    }

    public NarayanaLRAClient(String scheme, String host, int port) throws URISyntaxException {
        this.init(scheme, host, port);
    }

    public NarayanaLRAClient(URI coordinatorUri) throws MalformedURLException, URISyntaxException {
        this.init(coordinatorUri);
    }

    private void init(URI coordinatorUri) throws URISyntaxException, MalformedURLException {
        this.init(coordinatorUri.toURL().getProtocol(), coordinatorUri.getHost(), coordinatorUri.getPort());
    }

    private void setCoordinatorURI(URI uri) {
        this.base = uri;
    }

    private void init(String scheme, String host, int port) throws URISyntaxException {
        this.setCoordinatorURI(new URI(scheme, null, host, port, "/lra-coordinator", null, null));
    }

    private static String getLRAId(String lraId) {
        return lraId == null ? null : lraId.replaceFirst(".*/([^/?]+).*", "$1");
    }

    private WebTarget getTarget() {
        if (this.client != null) {
            this.client.close();
        }
        this.client = ClientBuilder.newClient();
        return this.client.target(this.base);
    }

    public void setCurrentLRA(URI coordinatorUri) {
        URL url = null;
        try {
            url = coordinatorUri.toURL();
            this.init(coordinatorUri);
        }
        catch (MalformedURLException | URISyntaxException e) {
            LRALogger.i18NLogger.error_invalidCoordinatorUrl(url, (Throwable)e);
            this.throwGenericLRAException(coordinatorUri, Response.Status.BAD_REQUEST.getStatusCode(), e.getMessage());
        }
    }

    public URI startLRA(String clientID) throws WebApplicationException {
        return this.startLRA(clientID, 0L);
    }

    private URI startLRA(String clientID, Long timeout) throws WebApplicationException {
        return this.startLRA(clientID, timeout, ChronoUnit.SECONDS);
    }

    private URI startLRA(String clientID, Long timeout, ChronoUnit unit) throws WebApplicationException {
        return this.startLRA(this.getCurrent(), clientID, timeout, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public URI startLRA(URI parentLRA, String clientID, Long timeout, ChronoUnit unit) throws WebApplicationException {
        Response response = null;
        if (clientID == null) {
            clientID = "";
        }
        if (timeout == null) {
            timeout = 0L;
        } else if (timeout < 0L) {
            this.throwGenericLRAException(parentLRA, Response.Status.BAD_REQUEST.getStatusCode(), "Invalid timeout value: " + timeout);
            return null;
        }
        this.lraTracef("startLRA for client %s with parent %s", clientID, parentLRA);
        try {
            String encodedParentLRA = parentLRA == null ? "" : URLEncoder.encode(parentLRA.toString(), "UTF-8");
            this.aquireConnection();
            response = this.getTarget().path(startLRAUrl).queryParam("TimeLimit", new Object[]{Duration.of(timeout, unit).toMillis()}).queryParam("ClientID", new Object[]{clientID}).queryParam("ParentLRA", new Object[]{encodedParentLRA}).request().post(Entity.text((Object)""));
            if (this.isUnexpectedResponseStatus(response, Response.Status.CREATED)) {
                LRALogger.i18NLogger.error_lraCreationUnexpectedStatus(response.getStatus(), response);
                this.throwGenericLRAException(null, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "LRA start returned an unexpected status code: " + response.getStatus());
                URI uRI = null;
                this.releaseConnection(response);
                return uRI;
            }
            Object lraObject = Current.getLast((List)((List)response.getHeaders().get((Object)"Long-Running-Action")));
            if (lraObject == null) {
                LRALogger.i18NLogger.error_nullLraOnCreation(response);
                this.throwGenericLRAException(null, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "LRA creation is null");
                URI uRI = null;
                this.releaseConnection(response);
                return uRI;
            }
            URI lra = new URI(URLDecoder.decode(lraObject.toString(), "UTF-8"));
            this.lraTrace(lra, "startLRA returned");
            Current.push((URI)lra);
            this.releaseConnection(response);
            return lra;
        }
        catch (UnsupportedEncodingException e) {
            LRALogger.i18NLogger.error_cannotCreateUrlFromLCoordinatorResponse(response, (Throwable)e);
            this.throwGenericLRAException(null, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), e.getMessage());
            URI uRI = null;
            return uRI;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            catch (Exception e2) {
                LRALogger.i18NLogger.error_cannotContactLRACoordinator(this.base, (Throwable)e2);
                if (e2.getCause() != null && ConnectException.class.equals(e2.getCause().getClass())) {
                    this.throwGenericLRAException(null, Response.Status.SERVICE_UNAVAILABLE.getStatusCode(), "Cannot connect to the LRA coordinator: " + this.base + " (" + e2.getCause().getMessage() + ")");
                } else {
                    this.throwGenericLRAException(null, Response.Status.SERVICE_UNAVAILABLE.getStatusCode(), e2.getMessage());
                }
                uRI = null;
                return uRI;
            }
        }
        finally {
            this.releaseConnection(response);
        }
    }

    public void cancelLRA(URI lraId) throws WebApplicationException {
        this.endLRA(lraId, false);
    }

    public void closeLRA(URI lraId) throws WebApplicationException {
        this.endLRA(lraId, true);
    }

    public URI joinLRA(URI lraId, Long timelimit, URI compensateUri, URI completeUri, URI forgetUri, URI leaveUri, URI afterUri, URI statusUri, String compensatorData) throws WebApplicationException {
        return this.enlistCompensator(lraId, timelimit, "", compensateUri, completeUri, forgetUri, leaveUri, afterUri, statusUri, compensatorData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leaveLRA(URI lraId, String body) throws WebApplicationException {
        Response response = null;
        try {
            this.aquireConnection();
            response = this.getTarget().path(String.format(leaveFormat, NarayanaLRAClient.getLRAId(lraId.toString()))).request().header("Long-Running-Action", (Object)lraId).put(Entity.entity((Object)body, (String)"text/plain"));
            if (Response.Status.OK.getStatusCode() != response.getStatus()) {
                LRALogger.i18NLogger.error_lraLeaveUnexpectedStatus(response.getStatus(), response);
                this.throwGenericLRAException(null, response.getStatus(), "");
            }
            this.releaseConnection(response);
        }
        catch (Throwable throwable) {
            this.releaseConnection(response);
            throw throwable;
        }
    }

    public static Map<String, String> getTerminationUris(Class<?> compensatorClass, URI baseUri, String path) {
        HashMap<String, String> paths = new HashMap<String, String>();
        boolean[] asyncTermination = new boolean[]{false};
        String resourcePath = path == null ? "" : path.substring(0, path.lastIndexOf("/"));
        String uriPrefix = String.format("%s:%s%s", baseUri.getScheme(), baseUri.getSchemeSpecificPart(), resourcePath).replaceAll("/$", "");
        Arrays.stream(compensatorClass.getMethods()).forEach(method -> {
            Path pathAnnotation = method.getAnnotation(Path.class);
            if (pathAnnotation != null) {
                if (NarayanaLRAClient.checkMethod(paths, method, "compensate", pathAnnotation, (Annotation)method.getAnnotation(Compensate.class), uriPrefix) != 0) {
                    long timeLimit = method.getAnnotation(Compensate.class).timeLimit();
                    ChronoUnit timeUnit = method.getAnnotation(Compensate.class).timeUnit();
                    paths.put("TimeLimit", Long.toString(Duration.of(timeLimit, timeUnit).toMillis()));
                    if (NarayanaLRAClient.isAsyncCompletion(method)) {
                        asyncTermination[0] = true;
                    }
                }
                if (NarayanaLRAClient.checkMethod(paths, method, "complete", pathAnnotation, (Annotation)method.getAnnotation(Complete.class), uriPrefix) != 0 && NarayanaLRAClient.isAsyncCompletion(method)) {
                    asyncTermination[0] = true;
                }
                NarayanaLRAClient.checkMethod(paths, method, "status", pathAnnotation, (Annotation)method.getAnnotation(Status.class), uriPrefix);
                NarayanaLRAClient.checkMethod(paths, method, "forget", pathAnnotation, (Annotation)method.getAnnotation(Forget.class), uriPrefix);
                NarayanaLRAClient.checkMethod(paths, method, "leave", pathAnnotation, (Annotation)method.getAnnotation(Leave.class), uriPrefix);
                NarayanaLRAClient.checkMethod(paths, method, "after", pathAnnotation, (Annotation)method.getAnnotation(AfterLRA.class), uriPrefix);
            }
        });
        if (asyncTermination[0] && !paths.containsKey("status") && !paths.containsKey("forget")) {
            LRALogger.i18NLogger.error_asyncTerminationBeanMissStatusAndForget(compensatorClass);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"LRA participant class with asynchronous temination but no @Status or @Forget annotations").build());
        }
        StringBuilder linkHeaderValue = new StringBuilder();
        if (paths.size() != 0) {
            paths.forEach((k, v) -> NarayanaLRAClient.makeLink(linkHeaderValue, null, k, v));
            paths.put(LINK_TEXT, linkHeaderValue.toString());
        }
        return paths;
    }

    public static boolean isAsyncCompletion(Method method) {
        if (method.isAnnotationPresent(Complete.class) || method.isAnnotationPresent(Compensate.class)) {
            Annotation[][] annotationArray = method.getParameterAnnotations();
            int n = annotationArray.length;
            for (int i = 0; i < n; ++i) {
                Annotation[] ann;
                for (Annotation an : ann = annotationArray[i]) {
                    if (!Suspended.class.getName().equals(an.annotationType().getName())) continue;
                    LRALogger.logger.warn((Object)"JAX-RS @Suspended annotation is untested");
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isEffectivelyActive(URI lraId) {
        try {
            return this.getStatus(lraId, true) == LRAStatus.Active;
        }
        catch (NotFoundException e) {
            return false;
        }
    }

    private static int checkMethod(Map<String, String> paths, Method method, String rel, Path pathAnnotation, Annotation annotationClass, String uriPrefix) {
        if (annotationClass == null) {
            return 0;
        }
        for (Annotation annotation : method.getDeclaredAnnotations()) {
            String name = annotation.annotationType().getName();
            if (!name.equals(GET.class.getName()) && !name.equals(PUT.class.getName()) && !name.equals(POST.class.getName()) && !name.equals(DELETE.class.getName())) continue;
            String pathValue = pathAnnotation.value();
            pathValue = pathValue.startsWith("/") ? pathValue : "/" + pathValue;
            String url = String.format("%s%s?%s=%s", uriPrefix, pathValue, "method", name);
            paths.put(rel, url);
            break;
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LRAStatus getStatus(URI uri, boolean effectivelyActive) throws WebApplicationException {
        Response response;
        URL lraId;
        try {
            lraId = uri.toURL();
        }
        catch (MalformedURLException e) {
            this.throwGenericLRAException(null, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Could not convert LRA to a URL: " + e.getMessage());
            return null;
        }
        try {
            this.aquireConnection();
            WebTarget target = this.getTarget().path(NarayanaLRAClient.getLRAId(lraId.toString())).path("status");
            if (effectivelyActive) {
                target = target.queryParam("effectivelyActive", new Object[]{true});
            }
            response = target.request().accept(new MediaType[]{MediaType.TEXT_PLAIN_TYPE}).get();
        }
        catch (Exception e) {
            this.releaseConnection(null);
            LRALogger.i18NLogger.error_cannotAccesCorrdinatorWhenGettingStatus(this.base, lraId, (Throwable)e);
            this.throwGenericLRAException(uri, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Could not access the LRA coordinator: " + e.getMessage());
            return null;
        }
        try {
            String responseContent;
            if (response.getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
                responseContent = (String)response.readEntity(String.class);
                throw new NotFoundException("Failed to get status of LRA id " + lraId + (responseContent != null ? ": " + responseContent : ""));
            }
            if (response.getStatus() == Response.Status.NO_CONTENT.getStatusCode()) {
                responseContent = LRAStatus.Active;
                return responseContent;
            }
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                LRALogger.i18NLogger.error_invalidStatusCode(this.base, response.getStatus(), lraId);
                this.throwGenericLRAException(uri, response.getStatus(), "LRA coordinator returned an invalid status code");
            }
            if (!response.hasEntity()) {
                LRALogger.i18NLogger.error_noContentOnGetStatus(this.base, lraId);
                this.throwGenericLRAException(uri, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "LRA coordinator#getStatus returned 200 OK but no content: lra: " + lraId);
            }
            try {
                responseContent = NarayanaLRAClient.fromString((String)response.readEntity(String.class));
                return responseContent;
            }
            catch (IllegalArgumentException e) {
                LRALogger.i18NLogger.error_invalidArgumentOnStatusFromCoordinator(this.base, lraId, (Throwable)e);
                this.throwGenericLRAException(uri, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "LRA coordinator returned an invalid status");
                LRAStatus lRAStatus = null;
                this.releaseConnection(response);
                return lRAStatus;
            }
        }
        finally {
            this.releaseConnection(response);
        }
    }

    private static LRAStatus fromString(String status) {
        if (status == null) {
            throw new IllegalArgumentException("The status parameter is null");
        }
        return LRAStatus.valueOf((String)status);
    }

    private static StringBuilder makeLink(StringBuilder b, String uriPrefix, String key, String value) {
        if (value == null) {
            return b;
        }
        String terminationUri = uriPrefix == null ? value : String.format("%s%s", uriPrefix, value);
        Link link = Link.fromUri((String)terminationUri).title(key + " URI").rel(key).type("text/plain").build(new Object[0]);
        if (b.length() != 0) {
            b.append(',');
        }
        return b.append(link);
    }

    private URI enlistCompensator(URI lraUri, long timelimit, String uriPrefix, URI compensateUri, URI completeUri, URI forgetUri, URI leaveUri, URI afterUri, URI statusUri, String compensatorData) {
        this.validateURI(completeUri, true, "Invalid complete URL: %s");
        this.validateURI(compensateUri, true, "Invalid compensate URL: %s");
        this.validateURI(leaveUri, true, "Invalid status URL: %s");
        this.validateURI(afterUri, true, "Invalid after URL: %s");
        this.validateURI(forgetUri, true, "Invalid forgetUri URL: %s");
        this.validateURI(statusUri, true, "Invalid status URL: %s");
        HashMap<String, URI> terminateURIs = new HashMap<String, URI>();
        terminateURIs.put("compensate", compensateUri);
        terminateURIs.put("complete", completeUri);
        terminateURIs.put("leave", leaveUri);
        terminateURIs.put("after", afterUri);
        terminateURIs.put("status", statusUri);
        terminateURIs.put("forget", forgetUri);
        StringBuilder linkHeaderValue = new StringBuilder();
        terminateURIs.forEach((k, v) -> NarayanaLRAClient.makeLink(linkHeaderValue, uriPrefix, k, v == null ? null : v.toASCIIString()));
        return this.enlistCompensator(lraUri, timelimit, linkHeaderValue.toString(), compensatorData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URI enlistCompensator(URI uri, long timelimit, String linkHeader, String compensatorData) {
        URL lraId;
        Response response = null;
        String responseEntity = null;
        try {
            lraId = uri.toURL();
        }
        catch (MalformedURLException e) {
            this.throwGenericLRAException(null, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Could not convert LRA to a URL: " + e.getMessage());
            return null;
        }
        if (timelimit < 0L) {
            timelimit = 0L;
        }
        response = this.getTarget().path(NarayanaLRAClient.getLRAId(uri.toASCIIString())).queryParam("TimeLimit", new Object[]{timelimit}).request().header(LINK_TEXT, (Object)linkHeader).header("Long-Running-Action", (Object)lraId).put(Entity.entity((Object)(compensatorData == null ? linkHeader : compensatorData), (String)"text/plain"));
        if (response.getStatus() == Response.Status.PRECONDITION_FAILED.getStatusCode()) {
            LRALogger.i18NLogger.error_tooLateToJoin(lraId, response);
            throw new WebApplicationException(lraId + ": Too late to join with this LRA ", Response.Status.PRECONDITION_FAILED);
        }
        if (response.getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
            LRALogger.logger.infof("Failed enlisting to LRA '%s', coordinator '%s' responded with status '%s'", (Object)lraId, (Object)this.base, (Object)Response.Status.NOT_FOUND.getStatusCode());
            throw new WebApplicationException(uri.toASCIIString(), Response.Status.GONE);
        }
        if (response.getStatus() != Response.Status.OK.getStatusCode()) {
            LRALogger.i18NLogger.error_failedToEnlist(lraId, this.base, response.getStatus());
            this.throwGenericLRAException(uri, response.getStatus(), "unable to register participant");
        }
        try {
            responseEntity = ((String)response.readEntity(String.class)).replaceAll("^\"|\"$", "");
            URI e = new URI(responseEntity);
            this.releaseConnection(response);
            return e;
        }
        catch (URISyntaxException e) {
            try {
                LRALogger.logger.infof("join %s returned an invalid recovery URI: %", (Object)lraId, (Object)responseEntity);
                this.throwGenericLRAException(null, Response.Status.SERVICE_UNAVAILABLE.getStatusCode(), "join " + lraId + " returned an invalid recovery URI: " + responseEntity);
                URI uRI = null;
                this.releaseConnection(response);
                return uRI;
            }
            catch (Throwable throwable) {
                this.releaseConnection(response);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endLRA(URI lra, boolean confirm) throws WebApplicationException {
        String confirmUrl = String.format(confirm ? confirmFormat : compensateFormat, NarayanaLRAClient.getLRAId(lra.toString()));
        Response response = null;
        this.lraTracef(lra, "%s LRA", confirm ? "close" : "compensate");
        try {
            response = this.getTarget().path(confirmUrl).request().put(Entity.text((Object)""));
            if (this.isUnexpectedResponseStatus(response, Response.Status.OK, Response.Status.ACCEPTED, Response.Status.NOT_FOUND)) {
                LRALogger.i18NLogger.error_lraTerminationUnexpectedStatus(response.getStatus(), response);
                this.throwGenericLRAException(lra, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "LRA finished with an unexpected status code: " + response.getStatus());
            }
            if (response.getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
                LRALogger.logger.infof("Could not %s LRA '%s': coordinator '%s' responded with status '%s'", new Object[]{confirm ? "close" : "compensate", lra, this.base, Response.Status.NOT_FOUND.getReasonPhrase()});
                throw new NotFoundException(lra.toASCIIString());
            }
            this.releaseConnection(response);
        }
        catch (Throwable throwable) {
            this.releaseConnection(response);
            Current.pop((URI)lra);
            URI nextLRA = Current.peek();
            if (nextLRA != null) {
                try {
                    this.init(nextLRA);
                }
                catch (MalformedURLException | URISyntaxException exception) {
                    // empty catch block
                }
            }
            throw throwable;
        }
        Current.pop((URI)lra);
        URI nextLRA = Current.peek();
        if (nextLRA != null) {
            try {
                this.init(nextLRA);
            }
            catch (MalformedURLException | URISyntaxException exception) {}
        }
    }

    private void validateURI(URI uri, boolean nullAllowed, String message) {
        if (uri == null) {
            if (!nullAllowed) {
                this.throwGenericLRAException(null, Response.Status.NOT_ACCEPTABLE.getStatusCode(), String.format(message, "null value"));
            }
        } else {
            try {
                uri.toURL();
            }
            catch (MalformedURLException e) {
                this.throwGenericLRAException(null, Response.Status.NOT_ACCEPTABLE.getStatusCode(), String.format(message, e.getMessage()) + " uri=" + uri);
            }
        }
    }

    private boolean isUnexpectedResponseStatus(Response response, Response.Status ... expected) {
        for (Response.Status anExpected : expected) {
            if (response.getStatus() != anExpected.getStatusCode()) continue;
            return false;
        }
        return true;
    }

    public String getUrl() {
        return this.base.toString();
    }

    public URI getCurrent() {
        return Current.peek();
    }

    private void lraTracef(String reasonFormat, Object ... parameters) {
        if (!LRALogger.logger.isTraceEnabled()) {
            return;
        }
        LRALogger.logger.tracef(reasonFormat, parameters);
    }

    private void lraTrace(URI lra, String reason) {
        this.lraTracef(lra, reason, (Object[])null);
    }

    private void lraTracef(URI lra, String reasonFormat, Object ... parameters) {
        Object[] newParams = parameters != null ? Arrays.copyOf(parameters, parameters.length + 1) : new Object[1];
        newParams[newParams.length - 1] = lra;
        this.lraTracef(reasonFormat + ", lra id: %s", newParams);
    }

    @Override
    public void close() {
        this.client.close();
    }

    private void aquireConnection() {
        if (this.connectionInUse) {
            LRALogger.i18NLogger.error_cannotAquireInUseConnection();
            this.throwGenericLRAException(null, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "NarayanaLRAClient: trying to aquire an in use connection");
        }
        this.connectionInUse = true;
    }

    private void releaseConnection(Response response) {
        if (response != null) {
            response.close();
        }
        this.connectionInUse = false;
    }

    private void throwGenericLRAException(URI lraId, int statusCode, String message) throws WebApplicationException {
        throw new WebApplicationException(Response.status((int)statusCode).entity((Object)String.format("%s: %s", lraId, message)).build());
    }
}

