/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.lra.client;

import io.narayana.lra.client.Current;
import io.narayana.lra.client.LRAInfoImpl;
import io.narayana.lra.logging.LRALogger;
import java.io.Closeable;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.RequestScoped;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.lra.annotation.Compensate;
import org.eclipse.microprofile.lra.annotation.CompensatorStatus;
import org.eclipse.microprofile.lra.annotation.Complete;
import org.eclipse.microprofile.lra.annotation.Forget;
import org.eclipse.microprofile.lra.annotation.Leave;
import org.eclipse.microprofile.lra.annotation.Status;
import org.eclipse.microprofile.lra.annotation.TimeLimit;
import org.eclipse.microprofile.lra.client.GenericLRAException;
import org.eclipse.microprofile.lra.client.IllegalLRAStateException;
import org.eclipse.microprofile.lra.client.InvalidLRAIdException;
import org.eclipse.microprofile.lra.client.LRAClient;
import org.eclipse.microprofile.lra.client.LRAInfo;

@RequestScoped
public class NarayanaLRAClient
implements LRAClient,
Closeable {
    public static final String COORDINATOR_PATH_NAME = "lra-coordinator";
    public static final String RECOVERY_COORDINATOR_PATH_NAME = "lra-recovery-coordinator";
    public static final String COMPLETE = "complete";
    public static final String COMPENSATE = "compensate";
    public static final String STATUS = "status";
    public static final String LEAVE = "leave";
    public static final String FORGET = "forget";
    public static final String TIMELIMIT_PARAM_NAME = "TimeLimit";
    public static final String CLIENT_ID_PARAM_NAME = "ClientID";
    public static final String PARENT_LRA_PARAM_NAME = "ParentLRA";
    public static final String STATUS_PARAM_NAME = "Status";
    public static final long DEFAULT_TIMEOUT_MILLIS = 0L;
    private static final String startLRAUrl = "/start";
    private static final String recoveryQueryUrl = "/recovery";
    private static final String getAllLRAsUrl = "/";
    private static final String getRecoveringLRAsUrl = "?status=Compensating";
    private static final String getActiveLRAsUrl = "?status=";
    private static final String confirmFormat = "/%s/close";
    private static final String compensateFormat = "/%s/cancel";
    private static final String leaveFormat = "/%s/remove";
    private static final String renewFormat = "/%s/renew";
    private static final String LINK_TEXT = "Link";
    private URI base;
    private URI rcBase;
    private ClientBuilder clientBuilder;
    private Client client;
    private boolean isUseable;
    private boolean connectionInUse;
    private Map<URL, String> responseDataMap;
    private static URI defaultCoordinatorURI;

    public static void setDefaultCoordinatorEndpoint(URI lraCoordinatorEndpoint) {
        defaultCoordinatorURI = lraCoordinatorEndpoint;
    }

    public static void setDefaultRecoveryEndpoint(URI recoveryEndpoint) {
        LRALogger.logger.debugf("LRAClient assuming the LRA coordinator and recovery coordinator are on the same endpoint", new Object[0]);
    }

    public static boolean isInitialised() {
        return defaultCoordinatorURI != null;
    }

    public NarayanaLRAClient() throws URISyntaxException {
        if (defaultCoordinatorURI != null) {
            try {
                this.init(defaultCoordinatorURI.toURL());
            }
            catch (MalformedURLException e) {
                throw new URISyntaxException(defaultCoordinatorURI.toString(), e.getMessage());
            }
        } else {
            this.init("http", System.getProperty("lra.http.host", "localhost"), Integer.getInteger("lra.http.port", 8080));
        }
    }

    public NarayanaLRAClient(String host, int port) throws URISyntaxException {
        this("http", host, port);
    }

    public NarayanaLRAClient(String scheme, String host, int port) throws URISyntaxException {
        this.init(scheme, host, port);
    }

    public NarayanaLRAClient(URL coordinatorUrl) throws MalformedURLException, URISyntaxException {
        this.init(coordinatorUrl);
    }

    private void init(URL coordinatorUrl) throws URISyntaxException {
        this.init(coordinatorUrl.getProtocol(), coordinatorUrl.getHost(), coordinatorUrl.getPort());
    }

    public void connectTimeout(long connect, TimeUnit unit) {
        this.clientBuilder.connectTimeout(connect, unit);
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
    }

    public void readTimeout(long read, TimeUnit unit) {
        this.clientBuilder.readTimeout(read, unit);
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
    }

    public void setCoordinatorURI(URI uri) {
        this.base = uri;
        this.isUseable = true;
        if (this.responseDataMap == null) {
            this.postConstruct();
        } else {
            this.responseDataMap.clear();
        }
    }

    public void setRecoveryCoordinatorURI(URI uri) {
        this.setCoordinatorURI(uri);
    }

    private void init(String scheme, String host, int port) throws URISyntaxException {
        this.clientBuilder = ClientBuilder.newBuilder();
        this.setCoordinatorURI(new URI(scheme, null, host, port, "/lra-coordinator", null, null));
        this.rcBase = new URI(scheme, null, host, port, "/lra-recovery-coordinator", null, null);
    }

    public boolean isUseable() {
        return this.isUseable;
    }

    @PostConstruct
    public void postConstruct() {
        this.responseDataMap = new HashMap<URL, String>();
    }

    @PreDestroy
    public void preDestroy() {
        this.isUseable = false;
    }

    public static URL lraToURL(String lraId) {
        return NarayanaLRAClient.lraToURL(lraId, "Invalid LRA id");
    }

    public static URL lraToURL(String lraId, String errorMessage) {
        try {
            return new URL(lraId);
        }
        catch (MalformedURLException e) {
            LRALogger.i18NLogger.error_urlConstructionFromStringLraId(lraId, e);
            throw new GenericLRAException(null, Response.Status.BAD_REQUEST.getStatusCode(), errorMessage + ": lra=" + lraId, (Throwable)e);
        }
    }

    public static String encodeURL(URL lraId, String errorMessage) {
        try {
            return URLEncoder.encode(lraId.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LRALogger.i18NLogger.error_invalidFormatToEncodeUrl(lraId, e);
            throw new GenericLRAException(lraId, Response.Status.BAD_REQUEST.getStatusCode(), errorMessage, (Throwable)e);
        }
    }

    public static String getLRAId(String lraId) {
        return lraId == null ? null : lraId.replaceFirst(".*/([^/?]+).*", "$1");
    }

    public URL toURL(String lraId) throws InvalidLRAIdException {
        try {
            return new URL(lraId);
        }
        catch (MalformedURLException e) {
            LRALogger.i18NLogger.error_invalidStringFormatOfUrl(lraId, e);
            throw new InvalidLRAIdException(lraId, "Invalid syntax", (Throwable)e);
        }
    }

    private WebTarget getTarget() {
        if (this.client != null) {
            this.client.close();
        }
        this.client = ClientBuilder.newClient();
        return this.client.target(this.base);
    }

    public void setCurrentLRA(URL coordinatorUrl) {
        try {
            this.init(coordinatorUrl);
        }
        catch (URISyntaxException e) {
            LRALogger.i18NLogger.error_invalidCoordinatorUrl(coordinatorUrl, e);
            throw new GenericLRAException(coordinatorUrl, Response.Status.BAD_REQUEST.getStatusCode(), e.getMessage(), (Throwable)e);
        }
    }

    public URL startLRA(String clientID) throws GenericLRAException {
        return this.startLRA(clientID, 0L);
    }

    public URL startLRA(String clientID, Long timeout) throws GenericLRAException {
        return this.startLRA(clientID, timeout, TimeUnit.SECONDS);
    }

    public URL startLRA(String clientID, Long timeout, TimeUnit unit) throws GenericLRAException {
        return this.startLRA(this.getCurrent(), clientID, timeout, unit);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public URL startLRA(URL parentLRA, String clientID, Long timeout, TimeUnit unit) throws GenericLRAException {
        Response response = null;
        if (clientID == null) {
            clientID = "";
        }
        if (timeout == null) {
            timeout = 0L;
        } else if (timeout < 0L) {
            throw new GenericLRAException(parentLRA, Response.Status.BAD_REQUEST.getStatusCode(), "Invalid timeout value: " + timeout, null);
        }
        this.lraTracef("startLRA for client %s with parent %s", clientID, parentLRA);
        try {
            String encodedParentLRA = parentLRA == null ? "" : URLEncoder.encode(parentLRA.toString(), "UTF-8");
            this.aquireConnection();
            response = this.getTarget().path(startLRAUrl).queryParam(TIMELIMIT_PARAM_NAME, new Object[]{unit.toMillis(timeout)}).queryParam(CLIENT_ID_PARAM_NAME, new Object[]{clientID}).queryParam(PARENT_LRA_PARAM_NAME, new Object[]{encodedParentLRA}).request().post(Entity.text((Object)""));
            if (!this.isExpectedResponseStatus(response, Response.Status.CREATED)) {
                LRALogger.i18NLogger.error_lraCreationUnexpectedStatus(response.getStatus(), response);
                throw new GenericLRAException(null, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "LRA start returned an unexpected status code: " + response.getStatus(), null);
            }
            Object lraObject = Current.getLast((List)response.getHeaders().get((Object)"Long-Running-Action"));
            if (lraObject == null) {
                LRALogger.i18NLogger.error_nullLraOnCreation(response);
                throw new GenericLRAException(null, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "LRA creation is null", null);
            }
            URL lra = new URL(URLDecoder.decode(lraObject.toString(), "UTF-8"));
            this.lraTrace(lra, "startLRA returned");
            Current.push(lra);
            this.releaseConnection(response);
            return lra;
        }
        catch (UnsupportedEncodingException | MalformedURLException e) {
            try {
                LRALogger.i18NLogger.error_cannotCreateUrlFromLCoordinatorResponse(response, e);
                throw new GenericLRAException(null, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), e.getMessage(), (Throwable)e);
                catch (Exception e2) {
                    LRALogger.i18NLogger.error_cannotContactLRACoordinator(this.base, e2);
                    if (e2.getCause() == null) throw new GenericLRAException(null, Response.Status.SERVICE_UNAVAILABLE.getStatusCode(), e2.getMessage(), (Throwable)e2);
                    if (!ConnectException.class.equals(e2.getCause().getClass())) throw new GenericLRAException(null, Response.Status.SERVICE_UNAVAILABLE.getStatusCode(), e2.getMessage(), (Throwable)e2);
                    throw new GenericLRAException(null, Response.Status.SERVICE_UNAVAILABLE.getStatusCode(), "Cannot connect to the LRA coordinator: " + this.base + " (" + e2.getCause().getMessage() + ")", (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                this.releaseConnection(response);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LRAInfo getLRAInfo(URL lraId) throws GenericLRAException {
        Response response = null;
        this.lraTracef(lraId, "getLRAInfo for LRA %s", lraId.toExternalForm());
        try {
            this.aquireConnection();
            response = this.getTarget().path(lraId.toString()).request().get();
            if (!response.hasEntity()) {
                throw new GenericLRAException(null, response.getStatus(), "missing entity body for getLRAInfo response", null);
            }
            LRAInfo lRAInfo = (LRAInfo)response.readEntity(LRAInfo.class);
            this.releaseConnection(response);
            return lRAInfo;
        }
        catch (Throwable throwable) {
            this.releaseConnection(response);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renewTimeLimit(URL lraId, long limit, TimeUnit unit) {
        Response response = null;
        this.lraTracef(lraId, "renew time limit to %s s of LRA", unit.toSeconds(limit));
        try {
            this.aquireConnection();
            response = this.getTarget().path(String.format(renewFormat, NarayanaLRAClient.getLRAId(lraId.toString()))).queryParam(TIMELIMIT_PARAM_NAME, new Object[]{unit.toMillis(limit)}).request().header("Long-Running-Action", (Object)lraId).put(Entity.text((Object)""));
            if (Response.Status.OK.getStatusCode() != response.getStatus()) {
                LRALogger.i18NLogger.error_lraRenewalUnexpectedStatus(response.getStatus(), response);
                throw new GenericLRAException(lraId, response.getStatus(), "", null);
            }
            this.releaseConnection(response);
        }
        catch (Throwable throwable) {
            this.releaseConnection(response);
            throw throwable;
        }
    }

    public String cancelLRA(URL lraId) throws GenericLRAException {
        return this.endLRA(lraId, false);
    }

    public String closeLRA(URL lraId) throws GenericLRAException {
        return this.endLRA(lraId, true);
    }

    public String joinLRAWithLinkHeader(URL lraUrl, Long timelimit, String linkHeader, String compensatorData) throws GenericLRAException {
        this.lraTracef(lraUrl, "joining LRA with participant link: %s", linkHeader);
        return this.enlistCompensator(lraUrl, timelimit, linkHeader, compensatorData);
    }

    private String toExternalForm(URL url) {
        return url == null ? null : url.toExternalForm();
    }

    public String joinLRA(URL lraId, Long timelimit, URL compensateUrl, URL completeUrl, URL forgetUrl, URL leaveUrl, URL statusUrl, String compensatorData) throws GenericLRAException {
        return this.enlistCompensator(lraId, timelimit, "", this.toExternalForm(compensateUrl), this.toExternalForm(completeUrl), this.toExternalForm(forgetUrl), this.toExternalForm(leaveUrl), this.toExternalForm(statusUrl), compensatorData);
    }

    public String joinLRA(URL lraId, Class<?> resourceClass, URI baseUri, String compensatorData) throws GenericLRAException {
        long timeLimit;
        Map<String, String> terminateURIs = NarayanaLRAClient.getTerminationUris(resourceClass, baseUri);
        String timeLimitStr = terminateURIs.get(TIMELIMIT_PARAM_NAME);
        long l = timeLimit = timeLimitStr == null ? 0L : Long.valueOf(timeLimitStr);
        if (terminateURIs.containsKey(LINK_TEXT)) {
            return this.joinLRAWithLinkHeader(lraId, timeLimit, terminateURIs.get(LINK_TEXT), compensatorData);
        }
        return null;
    }

    public URL updateCompensator(URL recoveryUrl, URL compensateUrl, URL completeUrl, URL forgetUrl, URL statusUrl, String compensatorData) throws GenericLRAException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leaveLRA(URL lraId, String compensatorUrl) throws GenericLRAException {
        Response response = null;
        this.lraTracef(lraId, "leaving LRA, compensator url: %s", compensatorUrl);
        try {
            this.aquireConnection();
            response = this.getTarget().path(String.format(leaveFormat, NarayanaLRAClient.getLRAId(lraId.toString()))).request().header("Long-Running-Action", (Object)lraId).put(Entity.entity((Object)compensatorUrl, (String)"text/plain"));
            if (Response.Status.OK.getStatusCode() != response.getStatus()) {
                LRALogger.i18NLogger.error_lraLeaveUnexpectedStatus(response.getStatus(), response);
                throw new GenericLRAException(lraId, response.getStatus(), "", null);
            }
            this.releaseConnection(response);
        }
        catch (Throwable throwable) {
            this.releaseConnection(response);
            throw throwable;
        }
    }

    public List<LRAInfo> getAllLRAs() throws GenericLRAException {
        return this.getLRAs(null, null);
    }

    public List<LRAInfo> getActiveLRAs() throws GenericLRAException {
        return this.getLRAs(STATUS, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LRAInfo> getRecoveringLRAs() throws GenericLRAException {
        try (Client rcClient = null;){
            rcClient = ClientBuilder.newClient();
            Response response = rcClient.target(this.rcBase).path(recoveryQueryUrl).request().get();
            if (!response.hasEntity()) {
                throw new GenericLRAException(null, response.getStatus(), "missing entity body", null);
            }
            ArrayList<LRAInfo> actions = new ArrayList<LRAInfo>();
            String lras = (String)response.readEntity(String.class);
            JsonReader reader = Json.createReader((Reader)new StringReader(lras));
            JsonArray ja = reader.readArray();
            ja.forEach(jsonValue -> actions.add(this.toLRAInfo((JsonObject)jsonValue)));
            actions.addAll(this.getLRAs(STATUS, CompensatorStatus.Compensating.name()));
            ArrayList<LRAInfo> arrayList = actions;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<LRAInfo> getLRAs(String queryName, String queryValue) {
        Response response = null;
        try {
            this.aquireConnection();
            response = queryName == null ? this.getTarget().request().get() : this.getTarget().queryParam(queryName, new Object[]{queryValue}).request().get();
            if (!response.hasEntity()) {
                throw new GenericLRAException(null, response.getStatus(), "missing entity body", null);
            }
            ArrayList<LRAInfo> actions = new ArrayList<LRAInfo>();
            String lras = (String)response.readEntity(String.class);
            JsonReader reader = Json.createReader((Reader)new StringReader(lras));
            JsonArray ja = reader.readArray();
            ja.forEach(jsonValue -> actions.add(this.toLRAInfo((JsonObject)jsonValue)));
            ArrayList<LRAInfo> arrayList = actions;
            this.releaseConnection(response);
            return arrayList;
        }
        catch (Throwable throwable) {
            this.releaseConnection(response);
            throw throwable;
        }
    }

    private LRAInfo toLRAInfo(JsonObject jo) {
        try {
            long startTime = jo.getInt("startTime");
            long fini = jo.getInt("finishTime");
            return new LRAInfoImpl(jo.getString("lraId"), jo.getString("clientId"), jo.getString(STATUS), jo.getBoolean(COMPLETE), jo.getBoolean("compensated"), jo.getBoolean("recovering"), jo.getBoolean("active"), jo.getBoolean("topLevel"), startTime, fini);
        }
        catch (Exception e) {
            LRALogger.i18NLogger.warn_failedParsingStatusFromJson(jo, e);
            return new LRAInfoImpl("JSON Parse Error: " + e.getMessage(), e.getMessage(), "Unknown", false, false, false, false, false, LocalDateTime.now().getSecond(), LocalDateTime.now().getSecond());
        }
    }

    public Boolean isActiveLRA(URL lraId) throws GenericLRAException {
        try {
            return !this.getStatus(lraId).isPresent();
        }
        catch (GenericLRAException e) {
            if (e.getStatusCode() == Response.Status.NOT_FOUND.getStatusCode()) {
                return false;
            }
            throw e;
        }
    }

    public Boolean isCompensatedLRA(URL lraId) throws GenericLRAException {
        return this.isStatus(lraId, CompensatorStatus.Compensated);
    }

    public Boolean isCompletedLRA(URL lraId) throws GenericLRAException {
        return this.isStatus(lraId, CompensatorStatus.Completed);
    }

    public static Map<String, String> getTerminationUris(Class<?> compensatorClass, URI baseUri) {
        HashMap<String, String> paths = new HashMap<String, String>();
        boolean[] asyncTermination = new boolean[]{false};
        Path resourcePathAnnotation = compensatorClass.getAnnotation(Path.class);
        String resourcePath = resourcePathAnnotation == null ? "" : resourcePathAnnotation.value().replaceAll("^/+", "");
        String uriPrefix = String.format("%s:%s%s", baseUri.getScheme(), baseUri.getSchemeSpecificPart(), resourcePath).replaceAll("/$", "");
        Arrays.stream(compensatorClass.getMethods()).forEach(method -> {
            Path pathAnnotation = method.getAnnotation(Path.class);
            if (pathAnnotation != null) {
                if (NarayanaLRAClient.checkMethod(paths, COMPENSATE, pathAnnotation, (Annotation)method.getAnnotation(Compensate.class), uriPrefix) != 0) {
                    TimeLimit timeLimit = method.getAnnotation(TimeLimit.class);
                    if (timeLimit != null) {
                        paths.put(TIMELIMIT_PARAM_NAME, Long.toString(timeLimit.unit().toMillis(timeLimit.limit())));
                    }
                    if (NarayanaLRAClient.isAsyncCompletion(method)) {
                        asyncTermination[0] = true;
                    }
                }
                if (NarayanaLRAClient.checkMethod(paths, COMPLETE, pathAnnotation, (Annotation)method.getAnnotation(Complete.class), uriPrefix) != 0 && NarayanaLRAClient.isAsyncCompletion(method)) {
                    asyncTermination[0] = true;
                }
                NarayanaLRAClient.checkMethod(paths, STATUS, pathAnnotation, (Annotation)method.getAnnotation(Status.class), uriPrefix);
                NarayanaLRAClient.checkMethod(paths, FORGET, pathAnnotation, (Annotation)method.getAnnotation(Forget.class), uriPrefix);
                NarayanaLRAClient.checkMethod(paths, LEAVE, pathAnnotation, (Annotation)method.getAnnotation(Leave.class), uriPrefix);
            }
        });
        if (asyncTermination[0] && !paths.containsKey(STATUS) && !paths.containsKey(FORGET)) {
            LRALogger.i18NLogger.error_asyncTerminationBeanMissStatusAndForget(compensatorClass);
            throw new GenericLRAException(null, Response.Status.BAD_REQUEST.getStatusCode(), "LRA participant class with asynchronous temination but no @Status or @Forget annotations", null);
        }
        StringBuilder linkHeaderValue = new StringBuilder();
        if (paths.size() != 0) {
            paths.forEach((k, v) -> NarayanaLRAClient.makeLink(linkHeaderValue, null, k, v));
            paths.put(LINK_TEXT, linkHeaderValue.toString());
        }
        return paths;
    }

    public static boolean isAsyncCompletion(Method method) {
        if (method.isAnnotationPresent(Complete.class) || method.isAnnotationPresent(Compensate.class)) {
            Annotation[][] annotationArray = method.getParameterAnnotations();
            int n = annotationArray.length;
            for (int i = 0; i < n; ++i) {
                Annotation[] ann;
                for (Annotation an : ann = annotationArray[i]) {
                    if (!Suspended.class.getName().equals(an.annotationType().getName())) continue;
                    LRALogger.logger.warn((Object)"JAX-RS @Suspended annotation is untested");
                    return true;
                }
            }
        }
        return false;
    }

    private static int checkMethod(Map<String, String> paths, String rel, Path pathAnnotation, Annotation annotationClass, String uriPrefix) {
        if (annotationClass == null) {
            return 0;
        }
        paths.put(rel, uriPrefix + pathAnnotation.value());
        return 1;
    }

    private boolean isStatus(URL lraId, CompensatorStatus testStatus) {
        Optional<CompensatorStatus> status = this.getStatus(lraId);
        if (!status.isPresent()) {
            return testStatus == null;
        }
        return status.get() == testStatus;
    }

    public Optional<CompensatorStatus> getStatus(URL lraId) throws GenericLRAException {
        Response response = null;
        try {
            this.aquireConnection();
            response = this.getTarget().path(NarayanaLRAClient.getLRAId(lraId.toString())).request().accept(new MediaType[]{MediaType.TEXT_PLAIN_TYPE}).get();
        }
        catch (Exception e) {
            this.releaseConnection(null);
            LRALogger.i18NLogger.error_cannotAccesCorrdinatorWhenGettingStatus(this.base, lraId, e);
            throw new GenericLRAException(lraId, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Could not access the LRA coordinator: " + e.getMessage(), (Throwable)e);
        }
        try {
            if (response.getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
                throw new NotFoundException();
            }
            if (response.getStatus() == Response.Status.NO_CONTENT.getStatusCode()) {
                Optional<CompensatorStatus> optional = Optional.empty();
                return optional;
            }
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                LRALogger.i18NLogger.error_invalidStatusCode(this.base, response.getStatus(), lraId);
                throw new GenericLRAException(lraId, response.getStatus(), "LRA coordinator returned an invalid status code", null);
            }
            if (!response.hasEntity()) {
                LRALogger.i18NLogger.error_noContentOnGetStatus(this.base, lraId);
                throw new GenericLRAException(lraId, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "LRA coordinator#getStatus returned 200 OK but no content: lra: " + lraId, null);
            }
            try {
                Optional<CompensatorStatus> optional = NarayanaLRAClient.fromString((String)response.readEntity(String.class));
                return optional;
            }
            catch (IllegalArgumentException e) {
                LRALogger.i18NLogger.error_invalidArgumentOnStatusFromCoordinator(this.base, lraId, e);
                throw new GenericLRAException(lraId, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "LRA coordinator returned an invalid status", (Throwable)e);
            }
        }
        finally {
            this.releaseConnection(response);
        }
    }

    private static Optional<CompensatorStatus> fromString(String status) {
        if (status != null) {
            return Optional.of(CompensatorStatus.valueOf((String)status));
        }
        return Optional.empty();
    }

    private static StringBuilder makeLink(StringBuilder b, String uriPrefix, String key, String value) {
        if (value == null) {
            return b;
        }
        String terminationUri = uriPrefix == null ? value : String.format("%s%s", uriPrefix, value);
        Link link = Link.fromUri((String)terminationUri).title(key + " URI").rel(key).type("text/plain").build(new Object[0]);
        if (b.length() != 0) {
            b.append(',');
        }
        return b.append(link);
    }

    private String enlistCompensator(URL lraUrl, long timelimit, String uriPrefix, String compensateUrl, String completeUrl, String forgetUrl, String leaveUrl, String statusUrl, String compensatorData) {
        this.validateURL(completeUrl, true, "Invalid complete URL: %s");
        this.validateURL(compensateUrl, true, "Invalid compensate URL: %s");
        this.validateURL(leaveUrl, true, "Invalid status URL: %s");
        this.validateURL(forgetUrl, true, "Invalid forgetUrl URL: %s");
        this.validateURL(statusUrl, true, "Invalid status URL: %s");
        HashMap<String, String> terminateURIs = new HashMap<String, String>();
        terminateURIs.put(COMPENSATE, compensateUrl);
        terminateURIs.put(COMPLETE, completeUrl);
        terminateURIs.put(LEAVE, leaveUrl);
        terminateURIs.put(STATUS, statusUrl);
        terminateURIs.put(FORGET, forgetUrl);
        StringBuilder linkHeaderValue = new StringBuilder();
        terminateURIs.forEach((k, v) -> NarayanaLRAClient.makeLink(linkHeaderValue, uriPrefix, k, v));
        return this.enlistCompensator(lraUrl, timelimit, linkHeaderValue.toString(), compensatorData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String enlistCompensator(URL lraUrl, long timelimit, String linkHeader, String compensatorData) {
        Response response = null;
        if (timelimit < 0L) {
            timelimit = 0L;
        }
        try {
            response = this.getTarget().path(NarayanaLRAClient.getLRAId(lraUrl.toString())).queryParam(TIMELIMIT_PARAM_NAME, new Object[]{timelimit}).request().header(LINK_TEXT, (Object)linkHeader).header("Long-Running-Action", (Object)lraUrl).put(Entity.entity((Object)(compensatorData == null ? linkHeader : compensatorData), (String)"text/plain"));
            if (response.getStatus() == Response.Status.PRECONDITION_FAILED.getStatusCode()) {
                LRALogger.i18NLogger.error_tooLateToJoin(lraUrl, response);
                throw new IllegalLRAStateException(lraUrl.toString(), "Too late to join with this LRA", "enlistCompensator");
            }
            if (response.getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
                LRALogger.logger.infof("Failed enlisting to LRA '%s', coordinator '%s' responded with status '%s'", (Object)lraUrl, (Object)this.base, (Object)Response.Status.NOT_FOUND.getStatusCode());
                throw new NotFoundException(lraUrl.toExternalForm());
            }
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                LRALogger.i18NLogger.error_failedToEnlist(lraUrl, this.base, response.getStatus());
                throw new GenericLRAException(lraUrl, response.getStatus(), "unable to register participant", null);
            }
            String string = (String)response.readEntity(String.class);
            this.releaseConnection(response);
            return string;
        }
        catch (Throwable throwable) {
            this.releaseConnection(response);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String endLRA(URL lra, boolean confirm) throws GenericLRAException {
        String string;
        String confirmUrl = String.format(confirm ? confirmFormat : compensateFormat, NarayanaLRAClient.getLRAId(lra.toString()));
        Response response = null;
        this.lraTracef(lra, "%s LRA", confirm ? "close" : COMPENSATE);
        try {
            response = this.getTarget().path(confirmUrl).request().put(Entity.text((Object)""));
            if (!this.isExpectedResponseStatus(response, Response.Status.OK, Response.Status.ACCEPTED, Response.Status.NOT_FOUND)) {
                LRALogger.i18NLogger.error_lraTerminationUnexpectedStatus(response.getStatus(), response);
                throw new GenericLRAException(lra, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "LRA finished with an unexpected status code: " + response.getStatus(), null);
            }
            if (response.getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
                LRALogger.logger.infof("Could not %s LRA '%s': coordinator '%s' responded with status '%s'", new Object[]{confirm ? "close" : COMPENSATE, lra, this.base, Response.Status.NOT_FOUND.getReasonPhrase()});
                throw new NotFoundException(lra.toExternalForm());
            }
            String responseData = (String)response.readEntity(String.class);
            this.setResponseData(lra, responseData);
            string = responseData;
            this.releaseConnection(response);
        }
        catch (Throwable throwable) {
            this.releaseConnection(response);
            Current.pop(lra);
            URL nextLRA = Current.peek();
            if (nextLRA != null) {
                try {
                    this.init(nextLRA);
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            throw throwable;
        }
        Current.pop(lra);
        URL nextLRA = Current.peek();
        if (nextLRA != null) {
            try {
                this.init(nextLRA);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return string;
    }

    private void validateURL(String url, boolean nullAllowed, String message) {
        if (url == null) {
            if (!nullAllowed) {
                throw new GenericLRAException(null, Response.Status.NOT_ACCEPTABLE.getStatusCode(), String.format(message, "null value"), null);
            }
        } else {
            try {
                new URL(url);
            }
            catch (MalformedURLException e) {
                throw new GenericLRAException(null, Response.Status.NOT_ACCEPTABLE.getStatusCode(), String.format(message, e.getMessage()) + " url=" + url, (Throwable)e);
            }
        }
    }

    private boolean isExpectedResponseStatus(Response response, Response.Status ... expected) {
        for (Response.Status anExpected : expected) {
            if (response.getStatus() != anExpected.getStatusCode()) continue;
            return true;
        }
        return false;
    }

    public String getUrl() {
        return this.base.toString();
    }

    public URL getCurrent() {
        return Current.peek();
    }

    private void lraTracef(String reasonFormat, Object ... parameters) {
        if (!LRALogger.logger.isTraceEnabled()) {
            return;
        }
        LRALogger.logger.tracef(reasonFormat, parameters);
    }

    private void lraTrace(URL lra, String reason) {
        this.lraTracef(lra, reason, (Object[])null);
    }

    private void lraTracef(URL lra, String reasonFormat, Object ... parameters) {
        Object[] newParams = parameters != null ? Arrays.copyOf(parameters, parameters.length + 1) : new Object[1];
        newParams[newParams.length - 1] = lra;
        this.lraTracef(reasonFormat + ", lra id: %s", newParams);
    }

    @Override
    public void close() {
        this.client.close();
        if (this.responseDataMap != null) {
            this.responseDataMap.clear();
        }
    }

    private void aquireConnection() {
        if (this.connectionInUse) {
            LRALogger.i18NLogger.error_cannotAquireInUseConnection();
            throw new GenericLRAException(null, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "LRAClient: trying to aquire an in use connection", null);
        }
        this.connectionInUse = true;
    }

    private void releaseConnection(Response response) {
        if (response != null) {
            response.close();
        }
        this.connectionInUse = false;
    }

    private void setResponseData(URL lraId, String responseData) {
        this.responseDataMap.put(lraId, responseData);
    }

    public String getResponseData(URL lraId) {
        return this.responseDataMap.containsKey(lraId) ? this.responseDataMap.get(lraId) : null;
    }
}

