/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.lra.client.internal.proxy.nonjaxrs;

import io.narayana.lra.client.internal.proxy.nonjaxrs.ClassPathIndexer;
import io.narayana.lra.client.internal.proxy.nonjaxrs.LRAParticipant;
import io.narayana.lra.client.internal.proxy.nonjaxrs.LRAParticipantRegistry;
import io.narayana.lra.client.internal.proxy.nonjaxrs.jandex.DotNames;
import io.narayana.lra.client.internal.proxy.nonjaxrs.jandex.JandexAnnotationResolver;
import io.narayana.lra.logging.LRALogger;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.util.AnnotationLiteral;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;

public class LRACDIExtension
implements Extension {
    private ClassPathIndexer classPathIndexer = new ClassPathIndexer();
    private Index index;
    private final Map<String, LRAParticipant> participants = new HashMap<String, LRAParticipant>();

    public void observe(@Observes AfterBeanDiscovery event, BeanManager beanManager) throws IOException, ClassNotFoundException {
        this.index = this.classPathIndexer.createIndex();
        List annotations = this.index.getAnnotations(DotName.createSimple((String)"javax.ws.rs.Path"));
        for (AnnotationInstance annotation : annotations) {
            LRAParticipant participant;
            ClassInfo classInfo;
            AnnotationTarget target = annotation.target();
            if (target.kind().equals((Object)AnnotationTarget.Kind.CLASS)) {
                classInfo = target.asClass();
            } else {
                if (!target.kind().equals((Object)AnnotationTarget.Kind.METHOD)) continue;
                classInfo = target.asMethod().declaringClass();
            }
            if ((participant = this.getAsParticipant(classInfo)) == null) continue;
            this.participants.put(participant.getJavaClass().getName(), participant);
            Set participantBeans = beanManager.getBeans(participant.getJavaClass(), new Annotation[]{new AnnotationLiteral<Any>(){}});
            if (!participantBeans.isEmpty()) continue;
            try {
                participant.setInstance(participant.getJavaClass().newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                LRALogger.i18nLogger.error_cannotProcessParticipant(e);
            }
        }
        event.addBean().read(beanManager.createAnnotatedType(LRAParticipantRegistry.class)).beanClass(LRAParticipantRegistry.class).scope(ApplicationScoped.class).createWith(context -> new LRAParticipantRegistry(this.participants));
    }

    private LRAParticipant getAsParticipant(ClassInfo classInfo) throws ClassNotFoundException {
        Class<?> javaClass;
        String className = classInfo.name().toString();
        try {
            javaClass = this.getClass().getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException cnfe) {
            javaClass = Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        if (javaClass.isInterface() || Modifier.isAbstract(javaClass.getModifiers()) || !this.isLRAParticipant(classInfo)) {
            return null;
        }
        LRAParticipant participant = new LRAParticipant(javaClass);
        return participant.hasNonJaxRsMethods() ? participant : null;
    }

    private boolean isLRAParticipant(ClassInfo classInfo) {
        Map<DotName, List<AnnotationInstance>> annotations = JandexAnnotationResolver.getAllAnnotationsFromClassInfoHierarchy(classInfo.name(), this.index);
        if (!annotations.containsKey(DotNames.LRA)) {
            return false;
        }
        if (!annotations.containsKey(DotNames.COMPENSATE) && !annotations.containsKey(DotNames.AFTER_LRA)) {
            throw new IllegalStateException(String.format("%s: %s", classInfo.name(), "The class contains an LRA method and no Compensate or AfterLRA method was found."));
        }
        return true;
    }
}

