/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.lra;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

public class AnnotationResolver {
    public static <T extends Annotation> T resolveAnnotation(Class<T> annotationClass, Method method) {
        T annotation = method.getAnnotation(annotationClass);
        if (annotation != null) {
            return annotation;
        }
        annotation = AnnotationResolver.resolveAnnotationInSuperClass(annotationClass, method, method.getDeclaringClass().getSuperclass());
        if (annotation != null) {
            return annotation;
        }
        annotation = AnnotationResolver.resolveAnnotationInInterfaces(annotationClass, method, method.getDeclaringClass());
        if (annotation != null) {
            return annotation;
        }
        return null;
    }

    public static boolean isAnnotationPresent(Class<? extends Annotation> annotationClass, Method method) {
        return AnnotationResolver.resolveAnnotation(annotationClass, method) != null;
    }

    private static <T extends Annotation> T resolveAnnotationInSuperClass(Class<T> annotationClass, Method method, Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        try {
            Method superclassMethod = clazz.getMethod(method.getName(), method.getParameterTypes());
            T annotation = superclassMethod.getAnnotation(annotationClass);
            return annotation != null ? annotation : AnnotationResolver.resolveAnnotationInSuperClass(annotationClass, method, clazz.getSuperclass());
        }
        catch (NoSuchMethodException e) {
            return AnnotationResolver.resolveAnnotationInSuperClass(annotationClass, method, clazz.getSuperclass());
        }
    }

    private static <T extends Annotation> T resolveAnnotationInInterfaces(Class<T> annotationClass, Method method, Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        for (Class<?> anInterface : clazz.getInterfaces()) {
            try {
                Method interfaceMethod = anInterface.getMethod(method.getName(), method.getParameterTypes());
                T annotation = interfaceMethod.getAnnotation(annotationClass);
                if (annotation == null) continue;
                return annotation;
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        return AnnotationResolver.resolveAnnotationInInterfaces(annotationClass, method, clazz.getSuperclass());
    }
}

