/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.lra.logging;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="LRA")
public interface LraI18nLogger {
    @Message(id=25001, value="LRA created with an unexpected status code: %d, coordinator response '%s'")
    public String error_lraCreationUnexpectedStatus(int var1, String var2);

    @Message(id=25002, value="Leaving LRA: %s, ends with an unexpected status code: %d, coordinator response '%s'")
    public String error_lraLeaveUnexpectedStatus(URI var1, int var2, String var3);

    @Message(id=25003, value="LRA participant class '%s' with asynchronous temination but no @Status or @Forget annotations")
    public String error_asyncTerminationBeanMissStatusAndForget(Class<?> var1);

    @Message(id=25004, value="LRA finished with an unexpected status code: %d, coordinator response '%s'")
    public String error_lraTerminationUnexpectedStatus(int var1, String var2);

    @Message(id=25005, value="LRA coordinator '%s' returned an invalid status code '%s' for LRA '%s'")
    public String error_invalidStatusCode(URI var1, int var2, URL var3);

    @Message(id=25006, value="LRA coordinator '%s' returned no content on #getStatus call for LRA '%s'")
    public String error_noContentOnGetStatus(URI var1, URL var2);

    @Message(id=25007, value="LRA coordinator '%s' returned an invalid status for LRA '%s'")
    public String error_invalidArgumentOnStatusFromCoordinator(URI var1, URL var2, @Cause Throwable var3);

    @Message(id=25008, value="Too late to join with the LRA '%s', coordinator response: '%s'")
    public String error_tooLateToJoin(URL var1, String var2);

    @Message(id=25009, value="Failed enlisting to LRA '%s', coordinator '%s' responded with status '%s'")
    public String error_failedToEnlist(URL var1, URI var2, int var3);

    @Message(id=25010, value="Error when converting String '%s' to URL")
    public String error_invalidStringFormatOfUrl(String var1, @Cause Throwable var2);

    @Message(id=25011, value="Invalid LRA id format to create LRA record from LRA id '%s', link URI '%s' (reason: %s)")
    public String error_invalidFormatToCreateLRAParticipantRecord(String var1, String var2, String var3);

    @Message(id=25012, value="Cannot found compensator url '%s' for lra '%s'")
    public String warn_cannotFoundCompensatorUrl(String var1, String var2);

    @Message(id=25013, value="Could not recreate abstract record '%s'")
    @LogMessage(level=Logger.Level.WARN)
    public void warn_coordinatorNorecordfound(String var1, @Cause Throwable var2);

    @Message(id=25014, value="reason '%s': container request for method '%s': lra: '%s'")
    @LogMessage(level=Logger.Level.WARN)
    public void warn_lraFilterContainerRequest(String var1, String var2, String var3);

    @Message(id=25015, value="LRA participant completion for asynchronous method %s#%s should return %d and not %d")
    @LogMessage(level=Logger.Level.WARN)
    public void warn_lraParticipantqForAsync(String var1, String var2, int var3, int var4);

    @Message(id=25016, value="Cannot get status of nested lra '%s' as outer one '%s' is still active")
    public String error_cannotGetStatusOfNestedLraURI(String var1, URI var2);

    @Message(id=25017, value="Invalid recovery url '%s' to join lra '%s'")
    public String error_invalidRecoveryUrlToJoinLRAURI(String var1, URI var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=25018, value="Invalid format of lra id '%s' to replace compensator '%s'")
    public void error_invalidFormatOfLraIdReplacingCompensatorURI(String var1, String var2, @Cause URISyntaxException var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=25019, value="LRA participant `%s` returned immediate state (Compensating/Completing) from CompletionStage. LRA id: %s")
    public void warn_participantReturnsImmediateStateFromCompletionStage(String var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=25020, value="Cannot process non JAX-RS LRA participant")
    public void error_cannotProcessParticipant(@Cause ReflectiveOperationException var1);

    @Message(id=25021, value="Invalid format of LRA id to be converted to LRA coordinator url, was '%s'")
    public String error_invalidLraIdFormatToConvertToCoordinatorUrl(String var1, @Cause Throwable var2);

    @Message(id=25022, value="Failed enlisting to LRA '%s', coordinator '%s' responded with status '%d (%s)'. Returning '%d (%s)'.")
    public String info_failedToEnlistingLRANotFound(URL var1, URI var2, int var3, String var4, int var5, String var6);

    @Message(id=25023, value="Could not %s LRA '%s': coordinator '%s' responded with status '%s'")
    public String get_couldNotCompleteCompensateOnReturnedStatus(String var1, URI var2, URI var3, String var4);

    @Message(id=25024, value="Error when encoding parent LRA id URL '%s' to String")
    public String error_invalidFormatToEncodeParentUri(URI var1, @Cause Throwable var2);

    @Message(id=25025, value="Unable to process LRA annotations: %s'")
    public String warn_LRAStatusInDoubt(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=25026, value="Unable to remove the failed duplicate failed LRA record (Uid: '%s') (which is already present in the failedLRA record location type: '%s'.) from LRA Record location: '%s'")
    public void warn_UnableToRemoveDuplicateFailedLRAParticipantRecord(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=25027, value="An exception was thrown while moving failed LRA record (Uid: '%s'). Reason: '%s'")
    public void warn_move_lra_record(String var1, String var2);

    @Message(id=25028, value="Demanded API version '%s' is not in the list of the supported versions '%s'. Please, provide the right version for the API.")
    public String get_wrongAPIVersionDemanded(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=25029, value="Cannot notify AfterLRA URL at %s")
    public void warn_cannotNotifyAfterLRAURI(URI var1, @Cause Throwable var2);

    @Message(id=25030, value="%s: Invalid link URI (%s): %s")
    public String error_invalidCompensator(URI var1, String var2, String var3);

    @Message(id=25031, value="%s: Invalid link URI (%s): missing compensator or after LRA callback")
    public String error_missingCompensator(URI var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=25032, value="LRA Record: Cannot save state (reason: %s")
    public void warn_saveState(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=25033, value="LRA Record: Cannot restore state (reason: %s)")
    public void warn_restoreState(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=25034, value="LRA Recovery cannot remove LRA id %s from the object store. The uid segment '%s' is probably invalid.")
    public void warn_cannotRemoveUidRecord(String var1, String var2, @Cause Throwable var3);
}

