/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.lra;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;

public class Current {
    private static final ThreadLocal<Current> lraContexts = new ThreadLocal();
    private final Stack<URI> stack = new Stack();
    private Map<String, Object> state;

    private Current(URI url) {
        this.stack.push(url);
    }

    public static Object putState(String key, Object value) {
        Current current = lraContexts.get();
        if (current != null) {
            return current.updateState(key, value);
        }
        return null;
    }

    public static Object getState(String key) {
        Current current = lraContexts.get();
        if (current != null && current.state != null) {
            return current.state.get(key);
        }
        return null;
    }

    private static String getParents(URI uri) {
        String query = uri.getQuery();
        if (query != null) {
            for (String nvpair : query.split("&")) {
                if (!nvpair.startsWith("ParentLRA=")) continue;
                return nvpair.split("=")[1];
            }
        }
        return null;
    }

    public static URI buildFullLRAUrl(String baseURI, URI parentId) throws URISyntaxException {
        String parents = Current.getParents(parentId);
        String gParent = new URI(parentId.getScheme(), parentId.getAuthority(), parentId.getPath(), null, parentId.getFragment()).toASCIIString();
        if (parents != null) {
            gParent = gParent + parents + ",";
        }
        return UriBuilder.fromUri((String)baseURI).queryParam("ParentLRA", new Object[]{gParent}).build(new Object[0]);
    }

    public static String getFirstParent(URI parent) throws UnsupportedEncodingException {
        String query;
        String string = query = parent == null ? null : parent.getQuery();
        if (query != null) {
            for (String param : query.split("&")) {
                String[] pa;
                if (!param.startsWith("ParentLRA=")) continue;
                String parents = param.split("=", 2)[1];
                if (parents == null || (pa = parents.split(",")).length <= 0) break;
                return URLDecoder.decode(pa[0], "UTF-8");
            }
        }
        return null;
    }

    public Object updateState(String key, Object value) {
        if (this.state == null) {
            this.state = new HashMap<String, Object>();
        }
        return this.state.put(key, value);
    }

    private static void clearContext(Current current) {
        if (current.state != null) {
            current.state.clear();
        }
        lraContexts.set(null);
    }

    public static URI peek() {
        Current current = lraContexts.get();
        return current != null ? current.stack.peek() : null;
    }

    public static URI pop() {
        Current current = lraContexts.get();
        URI lraId = null;
        if (current != null) {
            lraId = current.stack.pop();
            if (current.stack.empty()) {
                Current.clearContext(current);
            }
        }
        return lraId;
    }

    public static boolean pop(URI lra) {
        Current current = lraContexts.get();
        if (current == null || !current.stack.contains(lra)) {
            return false;
        }
        current.stack.remove(lra);
        current.stack.removeIf(nextLRA -> Current.isParentOf(lra, nextLRA));
        if (current.stack.empty()) {
            Current.clearContext(current);
        }
        return true;
    }

    private static boolean isParentOf(URI parent, URI child) {
        String[] params;
        String qs = child.getQuery();
        if (qs == null) {
            return false;
        }
        String theParent = parent.toASCIIString();
        for (String param : params = qs.split("&")) {
            String[] nvp = param.split("=");
            if (nvp.length != 2 || !nvp[0].contains("ParentLRA")) continue;
            try {
                String parentCandidate = URLDecoder.decode(nvp[1], StandardCharsets.UTF_8.name());
                if (!parentCandidate.contains(theParent) && !theParent.contains(parentCandidate)) continue;
                return true;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return false;
    }

    public static void push(URI lraId) {
        Current current = lraContexts.get();
        if (current == null) {
            lraContexts.set(new Current(lraId));
        } else if (!current.stack.contains(lraId)) {
            current.stack.push(lraId);
        }
    }

    public static List<Object> getContexts() {
        Current current = lraContexts.get();
        if (current == null) {
            return new ArrayList<Object>();
        }
        return new ArrayList<Object>(current.stack);
    }

    public static void updateLRAContext(ContainerResponseContext responseContext) {
        URI lraId = Current.peek();
        if (lraId != null) {
            responseContext.getHeaders().put((Object)"Long-Running-Action", Current.getContexts());
        } else {
            responseContext.getHeaders().remove((Object)"Long-Running-Action");
        }
    }

    public static void updateLRAContext(URI lraId, MultivaluedMap<String, String> headers) {
        headers.putSingle((Object)"Long-Running-Action", (Object)lraId.toString());
        Current.push(lraId);
    }

    public static void updateLRAContext(ClientRequestContext context) {
        MultivaluedMap headers = context.getHeaders();
        if (headers.containsKey((Object)"Long-Running-Action")) {
            return;
        }
        URI lraId = Current.peek();
        if (lraId != null) {
            headers.putSingle((Object)"Long-Running-Action", (Object)lraId);
        } else {
            Object lraContext = context.getProperty("Long-Running-Action");
            if (lraContext != null) {
                headers.putSingle((Object)"Long-Running-Action", lraContext);
            } else {
                headers.remove((Object)"Long-Running-Action");
            }
        }
    }

    public static void popAll() {
        lraContexts.set(null);
    }

    public static void clearContext(MultivaluedMap<String, String> headers) {
        headers.remove((Object)"Long-Running-Action");
        Current.popAll();
    }

    public static <T> T getLast(List<T> objects) {
        return objects == null ? null : objects.stream().reduce((a, b) -> b).orElse(null);
    }
}

