package io.narayana.lra.logging;

import java.util.Locale;
import java.io.Serializable;
import java.lang.ReflectiveOperationException;
import java.lang.Throwable;
import java.lang.Class;
import java.lang.String;
import java.net.URISyntaxException;
import org.jboss.logging.Logger;
import java.net.URI;
import java.net.URL;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
public class LraI18nLogger_$logger implements LraI18nLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = LraI18nLogger_$logger.class.getName();
    public LraI18nLogger_$logger(final Logger log) {
        this.log = log;
    }
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String error_lraCreationUnexpectedStatus$str() {
        return "LRA025001: LRA created with an unexpected status code: %d, coordinator response '%s'";
    }
    @Override
    public final String error_lraCreationUnexpectedStatus(final int status, final String response) {
        return String.format(getLoggingLocale(), error_lraCreationUnexpectedStatus$str(), status, response);
    }
    protected String error_lraLeaveUnexpectedStatus$str() {
        return "LRA025002: Leaving LRA: %s, ends with an unexpected status code: %d, coordinator response '%s'";
    }
    @Override
    public final String error_lraLeaveUnexpectedStatus(final URI lra, final int status, final String response) {
        return String.format(getLoggingLocale(), error_lraLeaveUnexpectedStatus$str(), lra, status, response);
    }
    protected String error_asyncTerminationBeanMissStatusAndForget$str() {
        return "LRA025003: LRA participant class '%s' with asynchronous temination but no @Status or @Forget annotations";
    }
    @Override
    public final String error_asyncTerminationBeanMissStatusAndForget(final Class<?> clazz) {
        return String.format(getLoggingLocale(), error_asyncTerminationBeanMissStatusAndForget$str(), clazz);
    }
    protected String error_lraTerminationUnexpectedStatus$str() {
        return "LRA025004: LRA finished with an unexpected status code: %d, coordinator response '%s'";
    }
    @Override
    public final String error_lraTerminationUnexpectedStatus(final int status, final String response) {
        return String.format(getLoggingLocale(), error_lraTerminationUnexpectedStatus$str(), status, response);
    }
    protected String error_invalidStatusCode$str() {
        return "LRA025005: LRA coordinator '%s' returned an invalid status code '%s' for LRA '%s'";
    }
    @Override
    public final String error_invalidStatusCode(final URI coordinator, final int status, final URL lra) {
        return String.format(getLoggingLocale(), error_invalidStatusCode$str(), coordinator, status, lra);
    }
    protected String error_noContentOnGetStatus$str() {
        return "LRA025006: LRA coordinator '%s' returned no content on #getStatus call for LRA '%s'";
    }
    @Override
    public final String error_noContentOnGetStatus(final URI coordinator, final URL lra) {
        return String.format(getLoggingLocale(), error_noContentOnGetStatus$str(), coordinator, lra);
    }
    protected String error_invalidArgumentOnStatusFromCoordinator$str() {
        return "LRA025007: LRA coordinator '%s' returned an invalid status for LRA '%s'";
    }
    @Override
    public final String error_invalidArgumentOnStatusFromCoordinator(final URI coordinator, final URL lra, final Throwable t) {
        return String.format(getLoggingLocale(), error_invalidArgumentOnStatusFromCoordinator$str(), coordinator, lra);
    }
    protected String error_tooLateToJoin$str() {
        return "LRA025008: Too late to join with the LRA '%s', coordinator response: '%s'";
    }
    @Override
    public final String error_tooLateToJoin(final URL lra, final String response) {
        return String.format(getLoggingLocale(), error_tooLateToJoin$str(), lra, response);
    }
    protected String error_failedToEnlist$str() {
        return "LRA025009: Failed enlisting to LRA '%s', coordinator '%s' responded with status '%s'";
    }
    @Override
    public final String error_failedToEnlist(final URL lra, final URI coordinator, final int status) {
        return String.format(getLoggingLocale(), error_failedToEnlist$str(), lra, coordinator, status);
    }
    protected String error_invalidStringFormatOfUrl$str() {
        return "LRA025010: Error when converting String '%s' to URL";
    }
    @Override
    public final String error_invalidStringFormatOfUrl(final String string, final Throwable t) {
        return String.format(getLoggingLocale(), error_invalidStringFormatOfUrl$str(), string);
    }
    protected String error_invalidFormatToCreateLRAParticipantRecord$str() {
        return "LRA025011: Invalid LRA id format to create LRA record from LRA id '%s', link URI '%s' (reason: %s)";
    }
    @Override
    public final String error_invalidFormatToCreateLRAParticipantRecord(final String lraId, final String linkURI, final String reason) {
        return String.format(getLoggingLocale(), error_invalidFormatToCreateLRAParticipantRecord$str(), lraId, linkURI, reason);
    }
    protected String warn_cannotFoundCompensatorUrl$str() {
        return "LRA025012: Cannot found compensator url '%s' for lra '%s'";
    }
    @Override
    public final String warn_cannotFoundCompensatorUrl(final String recoveryUrl, final String lraId) {
        return String.format(getLoggingLocale(), warn_cannotFoundCompensatorUrl$str(), recoveryUrl, lraId);
    }
    @Override
    public final void warn_coordinatorNorecordfound(final String recordType, final Throwable t) {
        log.logf(FQCN, WARN, t, warn_coordinatorNorecordfound$str(), recordType);
    }
    protected String warn_coordinatorNorecordfound$str() {
        return "LRA025013: Could not recreate abstract record '%s'";
    }
    @Override
    public final void warn_lraFilterContainerRequest(final String reason, final String method, final String lra) {
        log.logf(FQCN, WARN, null, warn_lraFilterContainerRequest$str(), reason, method, lra);
    }
    protected String warn_lraFilterContainerRequest$str() {
        return "LRA025014: reason '%s': container request for method '%s': lra: '%s'";
    }
    @Override
    public final void warn_lraParticipantqForAsync(final String clazz, final String method, final int statusCorrect, final int statusWrong) {
        log.logf(FQCN, WARN, null, warn_lraParticipantqForAsync$str(), clazz, method, statusCorrect, statusWrong);
    }
    protected String warn_lraParticipantqForAsync$str() {
        return "LRA025015: LRA participant completion for asynchronous method %s#%s should return %d and not %d";
    }
    protected String error_cannotGetStatusOfNestedLraURI$str() {
        return "LRA025016: Cannot get status of nested lra '%s' as outer one '%s' is still active";
    }
    @Override
    public final String error_cannotGetStatusOfNestedLraURI(final String nestedLraId, final URI lraId) {
        return String.format(getLoggingLocale(), error_cannotGetStatusOfNestedLraURI$str(), nestedLraId, lraId);
    }
    protected String error_invalidRecoveryUrlToJoinLRAURI$str() {
        return "LRA025017: Invalid recovery url '%s' to join lra '%s'";
    }
    @Override
    public final String error_invalidRecoveryUrlToJoinLRAURI(final String recoveryUrl, final URI lraId) {
        return String.format(getLoggingLocale(), error_invalidRecoveryUrlToJoinLRAURI$str(), recoveryUrl, lraId);
    }
    @Override
    public final void error_invalidFormatOfLraIdReplacingCompensatorURI(final String recoveryUrl, final String lraId, final URISyntaxException e) {
        log.logf(FQCN, ERROR, e, error_invalidFormatOfLraIdReplacingCompensatorURI$str(), recoveryUrl, lraId);
    }
    protected String error_invalidFormatOfLraIdReplacingCompensatorURI$str() {
        return "LRA025018: Invalid format of lra id '%s' to replace compensator '%s'";
    }
    @Override
    public final void warn_participantReturnsImmediateStateFromCompletionStage(final String participantId, final String lraId) {
        log.logf(FQCN, WARN, null, warn_participantReturnsImmediateStateFromCompletionStage$str(), participantId, lraId);
    }
    protected String warn_participantReturnsImmediateStateFromCompletionStage$str() {
        return "LRA025019: LRA participant `%s` returned immediate state (Compensating/Completing) from CompletionStage. LRA id: %s";
    }
    @Override
    public final void error_cannotProcessParticipant(final ReflectiveOperationException e) {
        log.logf(FQCN, ERROR, e, error_cannotProcessParticipant$str());
    }
    protected String error_cannotProcessParticipant$str() {
        return "LRA025020: Cannot process non JAX-RS LRA participant";
    }
    protected String error_invalidLraIdFormatToConvertToCoordinatorUrl$str() {
        return "LRA025021: Invalid format of LRA id to be converted to LRA coordinator url, was '%s'";
    }
    @Override
    public final String error_invalidLraIdFormatToConvertToCoordinatorUrl(final String lraId, final Throwable t) {
        return String.format(getLoggingLocale(), error_invalidLraIdFormatToConvertToCoordinatorUrl$str(), lraId);
    }
    protected String info_failedToEnlistingLRANotFound$str() {
        return "LRA025022: Failed enlisting to LRA '%s', coordinator '%s' responded with status '%d (%s)'. Returning '%d (%s)'.";
    }
    @Override
    public final String info_failedToEnlistingLRANotFound(final URL lraId, final URI coordinatorUri, final int coordinatorStatusCode, final String coordinatorStatusMsg, final int returnStatusCode, final String returnStatusMsg) {
        return String.format(getLoggingLocale(), info_failedToEnlistingLRANotFound$str(), lraId, coordinatorUri, coordinatorStatusCode, coordinatorStatusMsg, returnStatusCode, returnStatusMsg);
    }
    protected String get_couldNotCompleteCompensateOnReturnedStatus$str() {
        return "LRA025023: Could not %s LRA '%s': coordinator '%s' responded with status '%s'";
    }
    @Override
    public final String get_couldNotCompleteCompensateOnReturnedStatus(final String actionName, final URI lraId, final URI coordinatorUri, final String status) {
        return String.format(getLoggingLocale(), get_couldNotCompleteCompensateOnReturnedStatus$str(), actionName, lraId, coordinatorUri, status);
    }
    protected String error_invalidFormatToEncodeParentUri$str() {
        return "LRA025024: Error when encoding parent LRA id URL '%s' to String";
    }
    @Override
    public final String error_invalidFormatToEncodeParentUri(final URI parentUri, final Throwable t) {
        return String.format(getLoggingLocale(), error_invalidFormatToEncodeParentUri$str(), parentUri);
    }
    protected String warn_LRAStatusInDoubt$str() {
        return "LRA025025: Unable to process LRA annotations: %s'";
    }
    @Override
    public final String warn_LRAStatusInDoubt(final String reason) {
        return String.format(getLoggingLocale(), warn_LRAStatusInDoubt$str(), reason);
    }
    @Override
    public final void warn_UnableToRemoveDuplicateFailedLRAParticipantRecord(final String failedUid, final String failedLRAType, final String lraType) {
        log.logf(FQCN, WARN, null, warn_UnableToRemoveDuplicateFailedLRAParticipantRecord$str(), failedUid, failedLRAType, lraType);
    }
    protected String warn_UnableToRemoveDuplicateFailedLRAParticipantRecord$str() {
        return "LRA025026: Unable to remove the failed duplicate failed LRA record (Uid: '%s') (which is already present in the failedLRA record location type: '%s'.) from LRA Record location: '%s'";
    }
    @Override
    public final void warn_move_lra_record(final String failedUid, final String exceptionMessage) {
        log.logf(FQCN, WARN, null, warn_move_lra_record$str(), failedUid, exceptionMessage);
    }
    protected String warn_move_lra_record$str() {
        return "LRA025027: An exception was thrown while moving failed LRA record (Uid: '%s'). Reason: '%s'";
    }
    protected String get_wrongAPIVersionDemanded$str() {
        return "LRA025028: Demanded API version '%s' is not in the list of the supported versions '%s'. Please, provide the right version for the API.";
    }
    @Override
    public final String get_wrongAPIVersionDemanded(final String demandedApiVersion, final String supportedVersions) {
        return String.format(getLoggingLocale(), get_wrongAPIVersionDemanded$str(), demandedApiVersion, supportedVersions);
    }
    @Override
    public final void warn_cannotNotifyAfterLRAURI(final URI target, final Throwable t) {
        log.logf(FQCN, WARN, t, warn_cannotNotifyAfterLRAURI$str(), target);
    }
    protected String warn_cannotNotifyAfterLRAURI$str() {
        return "LRA025029: Cannot notify AfterLRA URL at %s";
    }
    protected String error_invalidCompensator$str() {
        return "LRA025030: %s: Invalid link URI (%s): %s";
    }
    @Override
    public final String error_invalidCompensator(final URI id, final String reason, final String linkURI) {
        return String.format(getLoggingLocale(), error_invalidCompensator$str(), id, reason, linkURI);
    }
    protected String error_missingCompensator$str() {
        return "LRA025031: %s: Invalid link URI (%s): missing compensator or after LRA callback";
    }
    @Override
    public final String error_missingCompensator(final URI id, final String linkURI) {
        return String.format(getLoggingLocale(), error_missingCompensator$str(), id, linkURI);
    }
    @Override
    public final void warn_saveState(final String cause) {
        log.logf(FQCN, WARN, null, warn_saveState$str(), cause);
    }
    protected String warn_saveState$str() {
        return "LRA025032: LRA Record: Cannot save state (reason: %s";
    }
    @Override
    public final void warn_restoreState(final String cause) {
        log.logf(FQCN, WARN, null, warn_restoreState$str(), cause);
    }
    protected String warn_restoreState$str() {
        return "LRA025033: LRA Record: Cannot restore state (reason: %s)";
    }
    @Override
    public final void warn_cannotRemoveUidRecord(final String lraId, final String uid, final Throwable t) {
        log.logf(FQCN, WARN, t, warn_cannotRemoveUidRecord$str(), lraId, uid);
    }
    protected String warn_cannotRemoveUidRecord$str() {
        return "LRA025034: LRA Recovery cannot remove LRA id %s from the object store. The uid segment '%s' is probably invalid.";
    }
    @Override
    public final void warn_startLRAFailed(final String message, final Throwable t) {
        log.logf(FQCN, WARN, t, warn_startLRAFailed$str(), message);
    }
    protected String warn_startLRAFailed$str() {
        return "LRA025035: The start LRA call failed with cause: %s";
    }
    @Override
    public final void warn_missingContexts(final String reason, final Throwable t) {
        log.logf(FQCN, WARN, t, warn_missingContexts$str(), reason);
    }
    protected String warn_missingContexts$str() {
        return "LRA025036: CDI Context not available: %s";
    }
    @Override
    public final void warn_unknownParticipant(final String compensator) {
        log.logf(FQCN, WARN, null, warn_unknownParticipant$str(), compensator);
    }
    protected String warn_unknownParticipant$str() {
        return "LRA025037: Participant `%s` is not registered";
    }
    protected String error_participant_data_disallowed$str() {
        return "LRA025038: Invalid participant enlistment with LRA %s: participant data is disabled";
    }
    @Override
    public final String error_participant_data_disallowed(final String lraId) {
        return String.format(getLoggingLocale(), error_participant_data_disallowed$str(), lraId);
    }
    protected String error_invalidArgument$str() {
        return "LRA025039: Invalid argument passed to method: %s";
    }
    @Override
    public final String error_invalidArgument(final String reason) {
        return String.format(getLoggingLocale(), error_invalidArgument$str(), reason);
    }
}
