/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.lra.arquillian;

import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Ignore;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.Parameterized;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.FrameworkField;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;

public class ArquillianParametrized
extends ParentRunner<Arquillian> {
    private List<Arquillian> arquillians = new ArrayList<Arquillian>();
    private final List<FrameworkMethod> ignoredMethods;

    public ArquillianParametrized(Class<?> testClass) throws Throwable {
        super(testClass);
        Parameterized.Parameters parameters = (Parameterized.Parameters)this.getParametersMethod().getAnnotation(Parameterized.Parameters.class);
        this.ignoredMethods = new ArrayList<FrameworkMethod>(this.getTestClass().getAnnotatedMethods(Ignore.class));
        this.createRunnersForParameters(this.allParameters(), parameters.name());
    }

    protected List<Arquillian> getChildren() {
        return this.arquillians;
    }

    protected Description describeChild(Arquillian child) {
        return child.getDescription();
    }

    protected void runChild(Arquillian child, RunNotifier notifier) {
        if (this.ignoredMethods.size() == 1) {
            notifier.fireTestIgnored(this.getDescription());
            return;
        }
        child.run(notifier);
    }

    private Iterable<Object[]> allParameters() throws Throwable {
        Object parameters = this.getParametersMethod().invokeExplosively(null, new Object[0]);
        if (parameters instanceof Iterable) {
            Iterator iter = ((Iterable)parameters).iterator();
            if (iter.hasNext() && !(iter.next() instanceof Object[])) {
                ArrayList<Object[]> multiValue = new ArrayList<Object[]>();
                for (Object parameter : (Iterable)parameters) {
                    multiValue.add(new Object[]{parameter});
                }
                return multiValue;
            }
            return (Iterable)parameters;
        }
        throw this.parametersMethodReturnedWrongType();
    }

    private FrameworkMethod getParametersMethod() throws Exception {
        List methods = this.getTestClass().getAnnotatedMethods(Parameterized.Parameters.class);
        for (FrameworkMethod each : methods) {
            if (!each.isStatic() || !each.isPublic()) continue;
            return each;
        }
        throw new Exception("No public static parameters method on class " + this.getTestClass().getName());
    }

    private void createRunnersForParameters(Iterable<Object[]> allParameters, String namePattern) throws InitializationError, Exception {
        try {
            int i = 0;
            for (Object[] parametersOfSingleTest : allParameters) {
                String name = this.nameFor(namePattern, i, parametersOfSingleTest);
                TestClassEnricher enrichedArquillianRunner = new TestClassEnricher(this.getTestClass().getJavaClass(), parametersOfSingleTest, name);
                this.arquillians.add(enrichedArquillianRunner);
                ++i;
            }
        }
        catch (ClassCastException e) {
            throw this.parametersMethodReturnedWrongType();
        }
    }

    private String nameFor(String namePattern, int index, Object[] parameters) {
        String finalPattern = namePattern.replaceAll("\\{index\\}", Integer.toString(index));
        String name = MessageFormat.format(finalPattern, parameters);
        return "[" + name + "]";
    }

    private Exception parametersMethodReturnedWrongType() throws Exception {
        String className = this.getTestClass().getName();
        String methodName = this.getParametersMethod().getName();
        String message = MessageFormat.format("{0}.{1}() must return an Iterable of arrays.", className, methodName);
        return new Exception(message);
    }

    private List<FrameworkField> getAnnotatedFieldsByParameter() {
        return this.getTestClass().getAnnotatedFields(Parameterized.Parameter.class);
    }

    private boolean fieldsAreAnnotated() {
        return !this.getAnnotatedFieldsByParameter().isEmpty();
    }

    private class TestClassEnricher
    extends Arquillian {
        private final Object[] fParameters;
        private final String fName;

        TestClassEnricher(Class<?> testClass, Object[] fParameters, String fName) throws InitializationError {
            super(testClass);
            this.fParameters = fParameters;
            this.fName = fName;
        }

        public Object createTest() throws Exception {
            if (ArquillianParametrized.this.fieldsAreAnnotated()) {
                return this.createTestUsingFieldInjection();
            }
            return this.createTestUsingConstructorInjection();
        }

        private Object createTestUsingConstructorInjection() throws Exception {
            return this.getTestClass().getOnlyConstructor().newInstance(this.fParameters);
        }

        private Object createTestUsingFieldInjection() throws Exception {
            List annotatedFieldsByParameter = ArquillianParametrized.this.getAnnotatedFieldsByParameter();
            if (annotatedFieldsByParameter.size() != this.fParameters.length) {
                throw new Exception("Wrong number of parameters and @Parameter fields. @Parameter fields counted: " + annotatedFieldsByParameter.size() + ", available parameters: " + this.fParameters.length + ".");
            }
            Object testClassInstance = this.getTestClass().getJavaClass().newInstance();
            for (FrameworkField each : annotatedFieldsByParameter) {
                Field field = each.getField();
                Parameterized.Parameter annotation = field.getAnnotation(Parameterized.Parameter.class);
                int index = annotation.value();
                try {
                    field.set(testClassInstance, this.fParameters[index]);
                }
                catch (IllegalArgumentException iare) {
                    throw new Exception(this.getTestClass().getName() + ": Trying to set " + field.getName() + " with the value " + this.fParameters[index] + " that is not the right type (" + this.fParameters[index].getClass().getSimpleName() + " instead of " + field.getType().getSimpleName() + ").", iare);
                }
            }
            return testClassInstance;
        }

        protected String getName() {
            return this.fName;
        }

        protected String testName(FrameworkMethod method) {
            return method.getName() + this.getName();
        }

        protected void validateConstructor(List<Throwable> errors) {
            this.validateOnlyOneConstructor(errors);
            if (ArquillianParametrized.this.fieldsAreAnnotated()) {
                this.validateZeroArgConstructor(errors);
            }
        }

        protected void validateFields(List<Throwable> errors) {
            super.validateFields(errors);
            if (ArquillianParametrized.this.fieldsAreAnnotated()) {
                List annotatedFieldsByParameter = ArquillianParametrized.this.getAnnotatedFieldsByParameter();
                int[] usedIndices = new int[annotatedFieldsByParameter.size()];
                for (FrameworkField each : annotatedFieldsByParameter) {
                    int index = each.getField().getAnnotation(Parameterized.Parameter.class).value();
                    if (index < 0 || index > annotatedFieldsByParameter.size() - 1) {
                        errors.add(new Exception("Invalid @Parameter value: " + index + ". @Parameter fields counted: " + annotatedFieldsByParameter.size() + ". Please use an index between 0 and " + (annotatedFieldsByParameter.size() - 1) + "."));
                        continue;
                    }
                    int n = index;
                    usedIndices[n] = usedIndices[n] + 1;
                }
                for (int index = 0; index < usedIndices.length; ++index) {
                    int numberOfUse = usedIndices[index];
                    if (numberOfUse == 0) {
                        errors.add(new Exception("@Parameter(" + index + ") is never used."));
                        continue;
                    }
                    if (numberOfUse <= 1) continue;
                    errors.add(new Exception("@Parameter(" + index + ") is used more than once (" + numberOfUse + ")."));
                }
            }
        }
    }
}

