/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.lra.arquillian.deployment;

import io.narayana.lra.arquillian.deployment.Deployment;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.formatter.Formatter;
import org.jboss.shrinkwrap.api.formatter.Formatters;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.resolver.api.maven.ConfigurableMavenResolverSystem;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;

public class WildflyLRACoordinatorDeployment
implements Deployment<WebArchive> {
    private final String DEFAULT_DEPLOYMENT_QUALIFIER = "lra-coordinator";
    private final Logger log = Logger.getLogger(WildflyLRACoordinatorDeployment.class);
    private final String ManifestMF = "Dependencies: org.jboss.jandex, org.jboss.jts export services, org.jboss.logging\n";

    @Override
    public Archive<WebArchive> create(String deploymentName) {
        if (deploymentName == null || deploymentName.isEmpty()) {
            deploymentName = "lra-coordinator";
        }
        String lraVersion = System.getProperty("version.microprofile.lra");
        String projectVersion = System.getProperty("project.version");
        WebArchive war = (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(deploymentName + ".war"))).addAsLibraries(((MavenFormatStage)((MavenStrategyStage)Maven.resolver().resolve(new String[]{"org.eclipse.microprofile.lra:microprofile-lra-api:" + lraVersion, "org.eclipse.microprofile.lra:microprofile-lra-tck:" + lraVersion})).withoutTransitivity()).asFile())).addAsLibraries(((MavenFormatStage)((MavenStrategyStage)((ConfigurableMavenResolverSystem)((ConfigurableMavenResolverSystem)((ConfigurableMavenResolverSystem)Maven.configureResolver().workOffline()).withMavenCentralRepo(false)).withClassPathResolution(true)).resolve(new String[]{"org.jboss.narayana.rts:lra-coordinator-jar:" + projectVersion, "org.jboss.narayana.rts:lra-proxy-api:" + projectVersion, "org.jboss.narayana.rts:narayana-lra:" + projectVersion, "org.jboss.narayana.rts:lra-client:" + projectVersion, "org.jboss.narayana.rts:lra-service-base:" + projectVersion})).withoutTransitivity()).asFile())).addAsManifestResource((Asset)new StringAsset("Dependencies: org.jboss.jandex, org.jboss.jts export services, org.jboss.logging\n"), "MANIFEST.MF")).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        if (this.log.isDebugEnabled()) {
            this.log.debugf("Content of the LRA Coordinator WAR is:%n%s%n", (Object)war.toString((Formatter)Formatters.VERBOSE));
        }
        return war;
    }
}

