/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.lra.arquillian.deployment.scenario;

import io.narayana.lra.arquillian.deployment.WildflyLRACoordinatorDeployment;
import io.narayana.lra.arquillian.deployment.scenario.ScenarioGeneratorBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jboss.arquillian.config.descriptor.api.ContainerDef;
import org.jboss.arquillian.config.descriptor.api.GroupDef;
import org.jboss.arquillian.container.spi.client.deployment.DeploymentDescription;
import org.jboss.arquillian.container.spi.client.deployment.TargetDescription;
import org.jboss.arquillian.container.test.spi.client.deployment.DeploymentScenarioGenerator;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.spec.WebArchive;

public class LRACoordinatorScenarioGenerator
extends ScenarioGeneratorBase
implements DeploymentScenarioGenerator {
    public static final String EXTENSION_NAME = "LRACoordinatorDeployment";
    public static final String EXTENSION_DEPLOYMENT_NAME = "deploymentName";
    public static final String EXTENSION_GROUP_NAME = "groupName";
    public static final String EXTENSION_CONTAINER_NAME = "containerName";
    public static final String EXTENSION_TESTABLE = "testable";

    public List<DeploymentDescription> generate(TestClass testClass) {
        ArrayList<DeploymentDescription> descriptions = new ArrayList<DeploymentDescription>();
        Map<String, String> extensionProperties = this.getExtensionProperties(EXTENSION_NAME);
        if (extensionProperties == null) {
            return new ArrayList<DeploymentDescription>();
        }
        this.checkPropertiesExistence(extensionProperties, EXTENSION_DEPLOYMENT_NAME, EXTENSION_GROUP_NAME, EXTENSION_CONTAINER_NAME, EXTENSION_TESTABLE);
        GroupDef group = this.getGroupWithName(extensionProperties.getOrDefault(EXTENSION_GROUP_NAME, ""));
        ContainerDef container = group != null ? this.getContainerWithName(group, extensionProperties.get(EXTENSION_CONTAINER_NAME)) : this.getContainerWithName(extensionProperties.get(EXTENSION_CONTAINER_NAME));
        if (container == null) {
            String message = String.format("%s: no container was found with name: %s.", EXTENSION_NAME, extensionProperties.get(EXTENSION_CONTAINER_NAME));
            log.error((Object)message);
            throw new RuntimeException(message);
        }
        String containerName = container.getContainerName();
        WebArchive archive = (WebArchive)new WildflyLRACoordinatorDeployment().create(extensionProperties.get(EXTENSION_DEPLOYMENT_NAME));
        DeploymentDescription deploymentDescription = new DeploymentDescription(extensionProperties.get(EXTENSION_DEPLOYMENT_NAME), (Archive)archive).setTarget(new TargetDescription(containerName));
        deploymentDescription.shouldBeTestable(Boolean.parseBoolean(extensionProperties.get(EXTENSION_TESTABLE)));
        deploymentDescription.shouldBeManaged(!container.getMode().equals("manual"));
        descriptions.add(deploymentDescription);
        return descriptions;
    }
}

