/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.lra.arquillian.deployment.scenario;

import io.narayana.lra.arquillian.deployment.Deployment;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.config.descriptor.api.ContainerDef;
import org.jboss.arquillian.config.descriptor.api.ExtensionDef;
import org.jboss.arquillian.config.descriptor.api.GroupDef;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.logging.Logger;

public class ScenarioGeneratorBase {
    static final Logger log = Logger.getLogger(ScenarioGeneratorBase.class);
    @Inject
    Instance<ArquillianDescriptor> arquillianDescriptorInstance;

    Map<String, String> getExtensionProperties(String extensionName) {
        ArquillianDescriptor arquillianDescriptor = (ArquillianDescriptor)this.arquillianDescriptorInstance.get();
        Optional<Map> checkExistence = arquillianDescriptor.getExtensions().stream().filter(x -> x.getExtensionName().equals(extensionName)).map(ExtensionDef::getExtensionProperties).findAny();
        if (!checkExistence.isPresent()) {
            String message = String.format("%s: there is not extension section with name %s defined in the %s file", this.getClass().getSimpleName(), extensionName, System.getProperty("arquillian.xml", "arquillian.xml"));
            log.warn((Object)message);
        }
        return checkExistence.orElse(null);
    }

    void checkPropertiesExistence(Map<String, String> properties, String ... toCheck) {
        Arrays.asList(toCheck).forEach(x -> {
            if (!properties.containsKey(x)) {
                String message = String.format("%s: the property %s is not defined in the extension", ScenarioGeneratorBase.class.getSimpleName(), x);
                log.warn((Object)message);
            }
        });
    }

    Method getDeploymentMethodFromConfiguration(Map<String, String> properties, String deploymentMethodPropertyName) throws ClassNotFoundException, NoSuchMethodException, RuntimeException {
        String property = properties.get(deploymentMethodPropertyName).trim();
        String className = property.substring(0, property.lastIndexOf(46));
        Class<?> clazz = Class.forName(className);
        if (!Deployment.class.isAssignableFrom(clazz)) {
            String message = String.format("%s: the specified class %s for the property %s is not an implementation of the interface Deployment<T>", this.getClass().getSimpleName(), className, deploymentMethodPropertyName);
            log.error((Object)message);
            throw new RuntimeException(message);
        }
        String methodName = property.substring(property.lastIndexOf(46) + 1);
        List methods = Arrays.stream(clazz.getMethods()).filter(x -> x.getName().contains(methodName)).collect(Collectors.toList());
        if (methods.size() != 1) {
            String message = String.format("The specified class %s overloads the method %s", className, methodName);
            log.error((Object)message);
            throw new RuntimeException(message);
        }
        return (Method)methods.get(0);
    }

    ContainerDef getContainerWithName(String containerName) throws RuntimeException {
        ArquillianDescriptor arquillianDescriptor = (ArquillianDescriptor)this.arquillianDescriptorInstance.get();
        List containers = arquillianDescriptor.getContainers().stream().filter(x -> x.getContainerName().equals(containerName)).collect(Collectors.toList());
        if (containers.isEmpty()) {
            String message = String.format("%s: there is not a standalone container with qualifier %s in the %s file!", this.getClass().getSimpleName(), containerName, System.getProperty("arquillian.xml", "arquillian.xml"));
            log.warn((Object)message);
            return null;
        }
        return (ContainerDef)containers.get(0);
    }

    ContainerDef getContainerWithName(GroupDef group, String containerName) throws RuntimeException {
        List containers = group.getGroupContainers().stream().filter(x -> x.getContainerName().equals(containerName)).collect(Collectors.toList());
        if (containers.isEmpty()) {
            String message = String.format("%s: there is not a container with qualifier %s in the group %s defined in the %s file!", this.getClass().getSimpleName(), containerName, group.getGroupName(), System.getProperty("arquillian.xml", "arquillian.xml"));
            log.warn((Object)message);
            return null;
        }
        return (ContainerDef)containers.get(0);
    }

    GroupDef getGroupWithName(String groupName) {
        if (groupName.isEmpty()) {
            return null;
        }
        ArquillianDescriptor arquillianDescriptor = (ArquillianDescriptor)this.arquillianDescriptorInstance.get();
        List groups = arquillianDescriptor.getGroups().stream().filter(x -> x.getGroupName().equals(groupName)).collect(Collectors.toList());
        if (groups.isEmpty()) {
            String message = String.format("%s: there is not a group with qualifier %s in the %s file!", this.getClass().getSimpleName(), groupName, System.getProperty("arquillian.xml", "arquillian.xml"));
            log.warn((Object)message);
            return null;
        }
        return (GroupDef)groups.get(0);
    }
}

