/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.lra.arquillian.spi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.lra.annotation.ws.rs.LRA;
import org.jboss.logging.Logger;

public class LRAAnnotationAdjuster {
    private static final Logger log = Logger.getLogger(LRAAnnotationAdjuster.class);
    private static final String ANNOTATIONS_FIELD_NAME = "annotations";
    private static final String ANNOTATION_DATA_METHOD_NAME = "annotationData";
    private static final String ANNOTATION_CACHE_FIELD_NAME = "annotationCache";
    private static final String ANNOTATION_MAP_FIELD_NAME = "annotationMap";

    static void processWithClass(Class<?> clazz) {
        LRA lraAnnotation = clazz.getDeclaredAnnotation(LRA.class);
        if (lraAnnotation != null) {
            LRAAnnotationAdjuster.adjustLRAAnnotation(clazz, lraAnnotation);
        }
        Arrays.stream(clazz.getMethods()).forEach(method -> {
            LRA lraAnnotationMethod = method.getDeclaredAnnotation(LRA.class);
            if (lraAnnotationMethod != null) {
                LRAAnnotationAdjuster.adjustLRAAnnotation(method, lraAnnotationMethod);
            }
        });
    }

    static void adjustLRAAnnotation(Class<?> clazzToLookFor, LRA originalLRAAnnotation) {
        if (LRAAnnotationAdjuster.doesJDKDefineFieldName(ANNOTATIONS_FIELD_NAME)) {
            try {
                Field annotations = Class.class.getDeclaredField(ANNOTATIONS_FIELD_NAME);
                annotations.setAccessible(true);
                Map map = (Map)annotations.get(clazzToLookFor);
                map.put(LRA.class, new LRAWrapped(originalLRAAnnotation));
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot change annotation " + originalLRAAnnotation + " of class " + clazzToLookFor + " in JDK7 way", e);
            }
        } else if (LRAAnnotationAdjuster.doesJDKDefineMethodName(ANNOTATION_DATA_METHOD_NAME)) {
            try {
                Method method = Class.class.getDeclaredMethod(ANNOTATION_DATA_METHOD_NAME, new Class[0]);
                method.setAccessible(true);
                Object annotationData = method.invoke(clazzToLookFor, new Object[0]);
                Field annotations = annotationData.getClass().getDeclaredField(ANNOTATIONS_FIELD_NAME);
                annotations.setAccessible(true);
                Map map = (Map)annotations.get(annotationData);
                log.debugf("Adjusting LRA annotation %s for class %s%n", (Object)originalLRAAnnotation, (Object)clazzToLookFor.getName());
                map.put(LRA.class, new LRAWrapped(originalLRAAnnotation));
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot change annotation " + originalLRAAnnotation + " of class " + clazzToLookFor + " in JDK8 way", e);
            }
        } else if (LRAAnnotationAdjuster.doesJDKDefineFieldName(ANNOTATION_CACHE_FIELD_NAME)) {
            try {
                Field cacheField = Class.class.getDeclaredField(ANNOTATION_CACHE_FIELD_NAME);
                cacheField.setAccessible(true);
                Object cache = cacheField.get(clazzToLookFor);
                Class<?> cacheClass = cache.getClass();
                Field mapField = cacheClass.getDeclaredField(ANNOTATION_MAP_FIELD_NAME);
                mapField.setAccessible(true);
                Map annotationMap = (Map)mapField.get(cache);
                annotationMap.put(LRA.class, new LRAWrapped(originalLRAAnnotation));
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot change annotation " + originalLRAAnnotation + " of class " + clazzToLookFor + " in JDK OpenJ9 way", e);
            }
        } else {
            log.warnf("Cannot adjust the timeout value of the %s annotation of class %s. The processing of %s is skipped.", (Object)originalLRAAnnotation, clazzToLookFor, (Object)LRAAnnotationAdjuster.class.getName());
        }
    }

    static void adjustLRAAnnotation(Method method, LRA originalLRAAnnotation) {
        Map annotations;
        Field field;
        try {
            Class<?> executableClass = Class.forName("java.lang.reflect.Executable");
            field = executableClass.getDeclaredField("declaredAnnotations");
            field.setAccessible(true);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalStateException("Cannot instantiate class java.lang.reflect.Executable", cnfe);
        }
        catch (NoSuchFieldException nsfe) {
            throw new IllegalStateException("Cannot find field 'declaredAnnotations' under instantiate class java.lang.reflect.Executable", nsfe);
        }
        try {
            annotations = (Map)field.get(method);
        }
        catch (IllegalAccessException iae) {
            throw new IllegalStateException("Cannnot access field 'declaredAnnotations' of the method instance " + method, iae);
        }
        log.debugf("Adjusting LRA annotation %s for method %s of class %s%n", (Object)originalLRAAnnotation, (Object)method, (Object)method.getDeclaringClass().getName());
        annotations.put(LRA.class, new LRAWrapped(originalLRAAnnotation));
    }

    private static boolean doesJDKDefineFieldName(String fieldName) {
        try {
            Class.class.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException ignore) {
            return false;
        }
        return true;
    }

    private static boolean doesJDKDefineMethodName(String methodName) {
        try {
            Class.class.getDeclaredMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException ignore) {
            return false;
        }
        return true;
    }

    private static class LRAWrapped
    implements LRA {
        private static final String TIMEOUT_FACTOR_PROPERTY = "lra.tck.timeout.factor";
        private final LRA wrapped;

        LRAWrapped(LRA lraInstance) {
            this.wrapped = lraInstance;
        }

        public LRA.Type value() {
            return this.wrapped.value();
        }

        public long timeLimit() {
            return this.getTimeout(this.wrapped.timeLimit());
        }

        public ChronoUnit timeUnit() {
            return this.wrapped.timeUnit();
        }

        public boolean end() {
            return this.wrapped.end();
        }

        public Response.Status.Family[] cancelOnFamily() {
            return this.wrapped.cancelOnFamily();
        }

        public Response.Status[] cancelOn() {
            return this.wrapped.cancelOn();
        }

        public boolean equals(Object obj) {
            return this.wrapped.equals(obj);
        }

        public int hashCode() {
            return this.wrapped.hashCode();
        }

        public String toString() {
            return this.wrapped.toString();
        }

        public Class<? extends Annotation> annotationType() {
            return this.wrapped.annotationType();
        }

        private long getTimeout(long originalTimeout) {
            if (originalTimeout <= 0L) {
                return 0L;
            }
            String timeoutFactorString = System.getProperty(TIMEOUT_FACTOR_PROPERTY, "1.0");
            double timeoutFactor = Double.parseDouble(timeoutFactorString);
            if (timeoutFactor <= 0.0) {
                return originalTimeout;
            }
            return (long)Math.ceil((double)originalTimeout * timeoutFactor);
        }
    }
}

