/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.lra.arquillian.spi;

import io.narayana.lra.LRAConstants;
import io.narayana.lra.arquillian.spi.LRAAnnotationAdjuster;
import java.net.URI;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.eclipse.microprofile.lra.tck.service.spi.LRARecoveryService;
import org.jboss.logging.Logger;

public class NarayanaLRARecovery
implements LRARecoveryService {
    private static final Logger log;

    public void waitForCallbacks(URI lraId) {
    }

    public boolean waitForEndPhaseReplay(URI lraId) {
        if (!this.recoverLRAs(lraId)) {
            return this.recoverLRAs(lraId);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean recoverLRAs(URI lraId) {
        try (Client recoveryCoordinatorClient = ClientBuilder.newClient();){
            URI lraCoordinatorUri = LRAConstants.getLRACoordinatorUrl((URI)lraId);
            URI recoveryCoordinatorUri = UriBuilder.fromUri((URI)lraCoordinatorUri).path("recovery").build(new Object[0]);
            WebTarget recoveryTarget = recoveryCoordinatorClient.target(recoveryCoordinatorUri);
            Response response = recoveryTarget.request().get();
            String json = (String)response.readEntity(String.class);
            response.close();
            if (json.contains(lraId.toASCIIString())) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    static {
        String[] resourceClassNames;
        log = Logger.getLogger(NarayanaLRARecovery.class);
        for (String resourceClassName : resourceClassNames = new String[]{"org.eclipse.microprofile.lra.tck.participant.api.LraResource", "org.eclipse.microprofile.lra.tck.participant.api.RecoveryResource"}) {
            try {
                Class<?> clazz = Class.forName(resourceClassName);
                LRAAnnotationAdjuster.processWithClass(clazz);
            }
            catch (ClassNotFoundException e) {
                log.debugf("Cannot load class %s to adjust LRA annotation on the class", (Object)resourceClassName);
            }
        }
    }
}

