/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.lra.filter;

import io.narayana.lra.AnnotationResolver;
import io.narayana.lra.Current;
import io.narayana.lra.client.NarayanaLRAClient;
import io.narayana.lra.client.internal.proxy.nonjaxrs.LRAParticipant;
import io.narayana.lra.client.internal.proxy.nonjaxrs.LRAParticipantRegistry;
import io.narayana.lra.logging.LRALogger;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;
import org.eclipse.microprofile.lra.annotation.AfterLRA;
import org.eclipse.microprofile.lra.annotation.Compensate;
import org.eclipse.microprofile.lra.annotation.Complete;
import org.eclipse.microprofile.lra.annotation.Forget;
import org.eclipse.microprofile.lra.annotation.LRAStatus;
import org.eclipse.microprofile.lra.annotation.Status;
import org.eclipse.microprofile.lra.annotation.ws.rs.LRA;
import org.eclipse.microprofile.lra.annotation.ws.rs.Leave;

@Provider
public class ServerLRAFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final String CANCEL_ON_FAMILY_PROP = "CancelOnFamily";
    private static final String CANCEL_ON_PROP = "CancelOn";
    private static final String TERMINAL_LRA_PROP = "terminateLRA";
    private static final String SUSPENDED_LRA_PROP = "suspendLRA";
    private static final String NEW_LRA_PROP = "newLRA";
    private static final String ABORT_WITH_PROP = "abortWith";
    private static final Pattern START_END_QUOTES_PATTERN = Pattern.compile("^\"|\"$");
    private static final long DEFAULT_TIMEOUT_MILLIS = 0L;
    @Context
    protected ResourceInfo resourceInfo;
    @Inject
    private LRAParticipantRegistry lraParticipantRegistry;
    private NarayanaLRAClient lraClient;

    private boolean isTxInvalid(ContainerRequestContext containerRequestContext, LRA.Type type, URI lraId, boolean shouldNotBeNull, ArrayList<Progress> progress) {
        if (lraId == null && shouldNotBeNull) {
            this.abortWith(containerRequestContext, null, Response.Status.PRECONDITION_FAILED.getStatusCode(), type.name() + " but no tx", progress);
            return true;
        }
        if (lraId != null && !shouldNotBeNull) {
            this.abortWith(containerRequestContext, lraId.toASCIIString(), Response.Status.PRECONDITION_FAILED.getStatusCode(), type.name() + " but found tx", progress);
            return true;
        }
        return false;
    }

    public void filter(ContainerRequestContext containerRequestContext) {
        URI lraId;
        Object lraContext;
        boolean endAnnotation;
        Method method = this.resourceInfo.getResourceMethod();
        MultivaluedMap headers = containerRequestContext.getHeaders();
        LRA.Type type = null;
        LRA transactional = (LRA)AnnotationResolver.resolveAnnotation(LRA.class, (Method)method);
        URI newLRA = null;
        Long timeout = null;
        URI suspendedLRA = null;
        URI incommingLRA = null;
        boolean isLongRunning = false;
        boolean requiresActiveLRA = false;
        ArrayList<Progress> progress = null;
        if (transactional == null) {
            transactional = method.getDeclaringClass().getDeclaredAnnotation(LRA.class);
        }
        if (transactional != null) {
            type = transactional.value();
            isLongRunning = !transactional.end();
            Response.Status.Family[] cancel0nFamily = transactional.cancelOnFamily();
            Response.Status[] cancel0n = transactional.cancelOn();
            if (cancel0nFamily.length != 0) {
                containerRequestContext.setProperty(CANCEL_ON_FAMILY_PROP, (Object)cancel0nFamily);
            }
            if (cancel0n.length != 0) {
                containerRequestContext.setProperty(CANCEL_ON_PROP, (Object)cancel0n);
            }
            if (transactional.timeLimit() != 0L) {
                timeout = Duration.of(transactional.timeLimit(), transactional.timeUnit()).toMillis();
            }
        }
        boolean bl = endAnnotation = AnnotationResolver.isAnnotationPresent(Complete.class, (Method)method) || AnnotationResolver.isAnnotationPresent(Compensate.class, (Method)method) || AnnotationResolver.isAnnotationPresent(Leave.class, (Method)method) || AnnotationResolver.isAnnotationPresent(Status.class, (Method)method) || AnnotationResolver.isAnnotationPresent(Forget.class, (Method)method) || AnnotationResolver.isAnnotationPresent(AfterLRA.class, (Method)method);
        if (headers.containsKey((Object)"Long-Running-Action")) {
            try {
                incommingLRA = new URI((String)Current.getLast((List)((List)headers.get((Object)"Long-Running-Action"))));
            }
            catch (URISyntaxException e) {
                String msg = String.format("header %s contains an invalid URL %s", "Long-Running-Action", Current.getLast((List)((List)headers.get((Object)"Long-Running-Action"))));
                this.abortWith(containerRequestContext, null, Response.Status.PRECONDITION_FAILED.getStatusCode(), msg, null);
                return;
            }
            if (AnnotationResolver.isAnnotationPresent(Leave.class, (Method)method)) {
                Map terminateURIs = NarayanaLRAClient.getTerminationUris((Class)this.resourceInfo.getResourceClass(), (UriInfo)containerRequestContext.getUriInfo(), (Long)timeout);
                String compensatorId = (String)terminateURIs.get("Link");
                if (compensatorId == null) {
                    this.abortWith(containerRequestContext, incommingLRA.toASCIIString(), Response.Status.BAD_REQUEST.getStatusCode(), "Missing complete or compensate annotations", null);
                    return;
                }
                try {
                    this.getLRAClient().leaveLRA(incommingLRA, compensatorId);
                    progress = this.updateProgress(progress, ProgressStep.Left, null);
                }
                catch (WebApplicationException e) {
                    progress = this.updateProgress(progress, ProgressStep.LeaveFailed, e.getMessage());
                    this.abortWith(containerRequestContext, incommingLRA.toASCIIString(), e.getResponse().getStatus(), e.getMessage(), progress);
                    return;
                }
                catch (ProcessingException e) {
                    progress = this.updateProgress(progress, ProgressStep.LeaveFailed, e.getMessage());
                    this.abortWith(containerRequestContext, incommingLRA.toASCIIString(), Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), e.getMessage(), progress);
                    return;
                }
            }
        }
        if (type == null) {
            if (!endAnnotation) {
                Current.clearContext((MultivaluedMap)headers);
            }
            if (incommingLRA != null) {
                Current.push(incommingLRA);
                containerRequestContext.setProperty(SUSPENDED_LRA_PROP, (Object)incommingLRA);
            }
            return;
        }
        if (!headers.containsKey((Object)"Long-Running-Action") && (lraContext = containerRequestContext.getProperty("Long-Running-Action")) != null) {
            incommingLRA = (URI)lraContext;
        }
        if (endAnnotation && incommingLRA == null) {
            return;
        }
        if (incommingLRA != null) {
            try {
                headers.putSingle((Object)"Long-Running-Action-Parent", (Object)Current.getFirstParent((URI)incommingLRA));
            }
            catch (UnsupportedEncodingException e) {
                this.abortWith(containerRequestContext, incommingLRA.toASCIIString(), Response.Status.PRECONDITION_FAILED.getStatusCode(), String.format("incoming LRA %s contains an invalid parent: %s", incommingLRA, e.getMessage()), progress);
                return;
            }
        }
        switch (type) {
            case MANDATORY: {
                if (this.isTxInvalid(containerRequestContext, type, incommingLRA, true, progress)) {
                    return;
                }
                lraId = incommingLRA;
                requiresActiveLRA = true;
                break;
            }
            case NEVER: {
                if (this.isTxInvalid(containerRequestContext, type, incommingLRA, false, progress)) {
                    return;
                }
                lraId = null;
                break;
            }
            case NOT_SUPPORTED: {
                suspendedLRA = incommingLRA;
                lraId = null;
                break;
            }
            case NESTED: 
            case REQUIRED: {
                if (incommingLRA != null) {
                    if (type == LRA.Type.NESTED) {
                        headers.putSingle((Object)"Long-Running-Action-Parent", (Object)incommingLRA.toASCIIString());
                        suspendedLRA = incommingLRA;
                        if (progress == null) {
                            progress = new ArrayList();
                        }
                        if ((newLRA = (lraId = this.startLRA(containerRequestContext, incommingLRA, method, timeout, progress))) != null) break;
                        return;
                    }
                    lraId = incommingLRA;
                    requiresActiveLRA = true;
                    break;
                }
                if (progress == null) {
                    progress = new ArrayList<Progress>();
                }
                if ((newLRA = (lraId = this.startLRA(containerRequestContext, null, method, timeout, progress))) != null) break;
                return;
            }
            case REQUIRES_NEW: {
                suspendedLRA = incommingLRA;
                if (progress == null) {
                    progress = new ArrayList();
                }
                if ((newLRA = (lraId = this.startLRA(containerRequestContext, null, method, timeout, progress))) != null) break;
                return;
            }
            case SUPPORTS: {
                lraId = incommingLRA;
                break;
            }
            default: {
                lraId = incommingLRA;
            }
        }
        if (lraId == null) {
            Current.clearContext((MultivaluedMap)headers);
            if (suspendedLRA != null) {
                containerRequestContext.setProperty(SUSPENDED_LRA_PROP, (Object)suspendedLRA);
            }
            return;
        }
        if (!isLongRunning) {
            containerRequestContext.setProperty(TERMINAL_LRA_PROP, (Object)lraId);
        }
        Current.updateLRAContext((URI)lraId, (MultivaluedMap)headers);
        if (newLRA != null) {
            if (suspendedLRA != null) {
                containerRequestContext.setProperty(SUSPENDED_LRA_PROP, (Object)incommingLRA);
            }
            containerRequestContext.setProperty(NEW_LRA_PROP, (Object)newLRA);
        }
        Current.push((URI)lraId);
        try {
            this.getLRAClient().setCurrentLRA(lraId);
        }
        catch (Exception e) {
            this.abortWith(containerRequestContext, lraId.toASCIIString(), Response.Status.BAD_REQUEST.getStatusCode(), e.getMessage(), progress);
            return;
        }
        if (!endAnnotation) {
            LRAParticipant participant;
            URI baseUri = containerRequestContext.getUriInfo().getBaseUri();
            Map terminateURIs = NarayanaLRAClient.getTerminationUris((Class)this.resourceInfo.getResourceClass(), (UriInfo)containerRequestContext.getUriInfo(), (Long)timeout);
            String timeLimitStr = (String)terminateURIs.get("TimeLimit");
            long timeLimit = timeLimitStr == null ? 0L : Long.parseLong(timeLimitStr);
            LRAParticipant lRAParticipant = participant = this.lraParticipantRegistry != null ? this.lraParticipantRegistry.getParticipant(this.resourceInfo.getResourceClass().getName()) : null;
            if (terminateURIs.containsKey("Link") || participant != null) {
                try {
                    if (participant != null) {
                        participant.augmentTerminationURIs(terminateURIs, baseUri);
                    }
                    URI recoveryUrl = this.getLRAClient().joinLRA(lraId, Long.valueOf(timeLimit), this.toURI((String)terminateURIs.get("compensate")), this.toURI((String)terminateURIs.get("complete")), this.toURI((String)terminateURIs.get("forget")), this.toURI((String)terminateURIs.get("leave")), this.toURI((String)terminateURIs.get("after")), this.toURI((String)terminateURIs.get("status")), null);
                    progress = this.updateProgress(progress, ProgressStep.Joined, null);
                    headers.putSingle((Object)"Long-Running-Action-Recovery", (Object)START_END_QUOTES_PATTERN.matcher(recoveryUrl.toASCIIString()).replaceAll(""));
                }
                catch (WebApplicationException e) {
                    progress = this.updateProgress(progress, ProgressStep.JoinFailed, e.getMessage());
                    this.abortWith(containerRequestContext, lraId.toASCIIString(), e.getResponse().getStatus(), String.format("%s: %s", ((Object)((Object)e)).getClass().getSimpleName(), e.getMessage()), progress);
                }
                catch (URISyntaxException e) {
                    progress = this.updateProgress(progress, ProgressStep.JoinFailed, e.getMessage());
                    this.abortWith(containerRequestContext, lraId.toASCIIString(), Response.Status.BAD_REQUEST.getStatusCode(), String.format("%s %s: %s", lraId, e.getClass().getSimpleName(), e.getMessage()), progress);
                }
                catch (ProcessingException e) {
                    progress = this.updateProgress(progress, ProgressStep.JoinFailed, e.getMessage());
                    this.abortWith(containerRequestContext, lraId.toASCIIString(), Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), String.format("%s %s,", ((Object)((Object)e)).getClass().getSimpleName(), e.getMessage()), progress);
                }
            } else if (requiresActiveLRA && this.getLRAClient().getStatus(lraId) != LRAStatus.Active) {
                Current.clearContext((MultivaluedMap)headers);
                Current.pop((URI)lraId);
                containerRequestContext.removeProperty(SUSPENDED_LRA_PROP);
                if (type == LRA.Type.MANDATORY) {
                    this.abortWith(containerRequestContext, lraId.toASCIIString(), Response.Status.PRECONDITION_FAILED.getStatusCode(), "LRA should have been active: ", progress);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        ArrayList<Progress> progress = (ArrayList<Progress>)ServerLRAFilter.cast(requestContext.getProperty(ABORT_WITH_PROP));
        Object suspendedLRA = requestContext.getProperty(SUSPENDED_LRA_PROP);
        URI current = Current.peek();
        URI toClose = (URI)requestContext.getProperty(TERMINAL_LRA_PROP);
        boolean isCancel = this.isJaxRsCancel(requestContext, responseContext);
        try {
            String failureMessage;
            if (current != null && isCancel) {
                try {
                    if (progress == null || this.progressDoesNotContain(progress, ProgressStep.StartFailed)) {
                        this.getLRAClient().cancelLRA(current);
                        progress = this.updateProgress(progress, ProgressStep.Ended, null);
                    }
                }
                catch (NotFoundException ignore) {
                    progress = this.updateProgress(progress, ProgressStep.Ended, null);
                }
                catch (WebApplicationException e) {
                    progress = this.updateProgress(progress, ProgressStep.CancelFailed, e.getMessage());
                }
                catch (ProcessingException e) {
                    Method method = this.resourceInfo.getResourceMethod();
                    LRALogger.i18nLogger.warn_lraFilterContainerRequest("ProcessingException: " + e.getMessage(), method.getDeclaringClass().getName() + "#" + method.getName(), current.toASCIIString());
                    progress = this.updateProgress(progress, ProgressStep.CancelFailed, e.getMessage());
                    toClose = null;
                }
                finally {
                    if (current.toASCIIString().equals(Current.getLast((List)((List)requestContext.getHeaders().get((Object)"Long-Running-Action"))))) {
                        requestContext.getHeaders().remove((Object)"Long-Running-Action");
                    }
                    if (toClose != null && toClose.toASCIIString().equals(current.toASCIIString())) {
                        toClose = null;
                    }
                }
            }
            if (toClose != null) {
                try {
                    if (progress == null || this.progressDoesNotContain(progress, ProgressStep.StartFailed)) {
                        if (isCancel) {
                            this.getLRAClient().cancelLRA(toClose);
                        } else {
                            this.getLRAClient().closeLRA(toClose);
                        }
                        progress = this.updateProgress(progress, ProgressStep.Ended, null);
                    }
                }
                catch (NotFoundException ignore) {
                    progress = this.updateProgress(progress, ProgressStep.Ended, null);
                }
                catch (ProcessingException | WebApplicationException e) {
                    progress = this.updateProgress(progress, isCancel ? ProgressStep.CancelFailed : ProgressStep.CloseFailed, e.getMessage());
                }
                finally {
                    requestContext.getHeaders().remove((Object)"Long-Running-Action");
                    if (toClose.toASCIIString().equals(Current.getLast((List)((List)requestContext.getHeaders().get((Object)"Long-Running-Action"))))) {
                        requestContext.getHeaders().remove((Object)"Long-Running-Action");
                    }
                }
            }
            if (responseContext.getStatus() == Response.Status.OK.getStatusCode() && this.resourceInfo.getResourceMethod() != null && NarayanaLRAClient.isAsyncCompletion((Method)this.resourceInfo.getResourceMethod())) {
                LRALogger.i18nLogger.warn_lraParticipantqForAsync(this.resourceInfo.getResourceMethod().getDeclaringClass().getName(), this.resourceInfo.getResourceMethod().getName(), Response.Status.ACCEPTED.getStatusCode(), Response.Status.OK.getStatusCode());
            }
            if (progress != null && (failureMessage = this.processLRAOperationFailures(progress)) != null) {
                LRALogger.logger.warn((Object)failureMessage);
                responseContext.setEntity((Object)failureMessage, null, MediaType.TEXT_PLAIN_TYPE);
            }
        }
        finally {
            if (suspendedLRA != null) {
                Current.push((URI)((URI)suspendedLRA));
            }
            Current.updateLRAContext((ContainerResponseContext)responseContext);
            Current.popAll();
        }
    }

    private NarayanaLRAClient getLRAClient() {
        if (this.lraClient == null) {
            this.lraClient = new NarayanaLRAClient();
        }
        return this.lraClient;
    }

    private boolean isJaxRsCancel(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        int status = responseContext.getStatus();
        Response.Status.Family[] cancel0nFamily = (Response.Status.Family[])requestContext.getProperty(CANCEL_ON_FAMILY_PROP);
        Response.Status[] cancel0n = (Response.Status[])requestContext.getProperty(CANCEL_ON_PROP);
        if (cancel0nFamily != null && Arrays.stream(cancel0nFamily).anyMatch(f -> Response.Status.Family.familyOf((int)status) == f)) {
            return true;
        }
        if (cancel0n != null) {
            return Arrays.stream(cancel0n).anyMatch(f -> status == f.getStatusCode());
        }
        return false;
    }

    private String processLRAOperationFailures(ArrayList<Progress> progress) {
        StringJoiner badOps = new StringJoiner(", ");
        StringJoiner goodOps = new StringJoiner(", ");
        StringBuilder code = new StringBuilder("-");
        progress.forEach(p -> {
            if (p.wasSuccessful()) {
                code.insert(0, p.progress.ordinal());
                goodOps.add(String.format("%s (%s)", p.progress.name(), p.progress.status));
            } else {
                code.append(p.progress.ordinal());
                badOps.add(String.format("%s (%s)", p.progress.name(), p.reason));
            }
        });
        if (badOps.length() != 0) {
            return LRALogger.i18nLogger.warn_LRAStatusInDoubt(String.format("%s: %s (%s)", code, badOps, goodOps));
        }
        return null;
    }

    private boolean progressDoesNotContain(ArrayList<Progress> progress, ProgressStep step) {
        return progress.stream().noneMatch(p -> p.progress == step);
    }

    private ArrayList<Progress> updateProgress(ArrayList<Progress> progress, ProgressStep step, String reason) {
        if (progress == null) {
            progress = new ArrayList();
        }
        progress.add(new Progress(step, reason));
        return progress;
    }

    private void abortWith(ContainerRequestContext containerRequestContext, String lraId, int statusCode, String message, Collection<Progress> reasons) {
        containerRequestContext.abortWith(Response.status((int)statusCode).build());
        containerRequestContext.setProperty(ABORT_WITH_PROP, reasons);
        Method method = this.resourceInfo.getResourceMethod();
        LRALogger.i18nLogger.warn_lraFilterContainerRequest(message, method.getDeclaringClass().getName() + "#" + method.getName(), lraId == null ? "context" : lraId);
    }

    private URI toURI(String uri) throws URISyntaxException {
        return uri == null ? null : new URI(uri);
    }

    public static <T extends Collection<?>> T cast(Object obj) {
        return (T)((Collection)obj);
    }

    private URI startLRA(ContainerRequestContext containerRequestContext, URI parentLRA, Method method, Long timeout, ArrayList<Progress> progress) {
        String clientId = method.getDeclaringClass().getName() + "#" + method.getName();
        try {
            URI lra = this.getLRAClient().startLRA(parentLRA, clientId, timeout, ChronoUnit.MILLIS, false);
            this.updateProgress(progress, ProgressStep.Started, null);
            return lra;
        }
        catch (WebApplicationException e) {
            this.updateProgress(progress, ProgressStep.StartFailed, e.getMessage());
            this.abortWith(containerRequestContext, null, e.getResponse().getStatus(), String.format("%s %s", ((Object)((Object)e)).getClass().getSimpleName(), e.getMessage()), progress);
        }
        catch (ProcessingException e) {
            this.updateProgress(progress, ProgressStep.StartFailed, e.getMessage());
            this.abortWith(containerRequestContext, null, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), String.format("%s %s", ((Object)((Object)e)).getClass().getSimpleName(), e.getMessage()), progress);
        }
        return null;
    }

    private static class Progress {
        static EnumSet<ProgressStep> failures = EnumSet.of(ProgressStep.LeaveFailed, ProgressStep.StartFailed, ProgressStep.JoinFailed, ProgressStep.CloseFailed, ProgressStep.CancelFailed);
        ProgressStep progress;
        String reason;

        public Progress(ProgressStep progress, String reason) {
            this.progress = progress;
            this.reason = reason;
        }

        public boolean wasSuccessful() {
            return !failures.contains((Object)this.progress);
        }
    }

    private static enum ProgressStep {
        Left("leave succeeded"),
        LeaveFailed("leave failed"),
        Started("start succeeded"),
        StartFailed("start failed"),
        Joined("join succeeded"),
        JoinFailed("join failed"),
        Ended("end succeeded"),
        CloseFailed("close failed"),
        CancelFailed("cancel failed");

        final String status;

        private ProgressStep(String status) {
            this.status = status;
        }

        public String toString() {
            return this.status;
        }
    }
}

