/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jbossts.star.service;

import com.arjuna.ats.arjuna.AtomicAction;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.objectstore.RecoveryStore;
import com.arjuna.ats.arjuna.objectstore.StoreManager;
import com.arjuna.ats.arjuna.state.InputBuffer;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.internal.arjuna.common.UidHelper;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.jbossts.star.provider.ResourceNotFoundException;
import org.jboss.jbossts.star.provider.TransactionStatusException;
import org.jboss.jbossts.star.resource.RecoveringTransaction;
import org.jboss.jbossts.star.resource.Transaction;
import org.jboss.jbossts.star.util.TxStatus;
import org.jboss.jbossts.star.util.TxSupport;
import org.jboss.jbossts.star.util.media.txstatusext.CoordinatorElement;
import org.jboss.jbossts.star.util.media.txstatusext.TransactionManagerElement;
import org.jboss.jbossts.star.util.media.txstatusext.TransactionStatisticsElement;
import org.jboss.jbossts.star.util.media.txstatusext.TwoPhaseAwareParticipantElement;
import org.jboss.logging.Logger;

@Path(value="/tx/")
public class Coordinator {
    static final String RC_SEGMENT = "recovery-coordinator";
    protected static final Logger log = Logger.getLogger(Coordinator.class);
    private static final String REST_TXN_TYPE = new AtomicAction().type();
    private static Map<String, Transaction> transactions = new ConcurrentHashMap<String, Transaction>();
    private static Map<String, HashMap<String, String>> participants = new ConcurrentHashMap<String, HashMap<String, String>>();
    private static Map<String, RecoveringTransaction> recoveringTransactions = Coordinator.getRecoveringTransactions(transactions);
    private static final AtomicInteger active = new AtomicInteger(0);
    private static final AtomicInteger prepared = new AtomicInteger(0);
    private static final AtomicInteger committed = new AtomicInteger(0);
    private static final AtomicInteger aborted = new AtomicInteger(0);
    private static long age = System.currentTimeMillis();

    @GET
    @Path(value="transaction-manager/")
    @Produces(value={"application/txlist"})
    public Response getAllTransactions(@Context UriInfo info) {
        log.trace((Object)"coordinator: list: transaction-coordinator");
        StringBuilder txns = new StringBuilder();
        String statisticsUri = TxSupport.extractUri((UriInfo)info, (String[])new String[]{"statistics"});
        this.updateTransactions();
        Iterator<String> i = transactions.keySet().iterator();
        while (i.hasNext()) {
            URI uri = TxSupport.getUri((UriInfo)info, (int)info.getPathSegments().size(), (String[])new String[]{i.next()});
            txns.append(uri.toASCIIString());
            if (!i.hasNext()) continue;
            txns.append(",");
        }
        Response.ResponseBuilder builder = Response.ok((Object)txns.toString());
        builder.header("Content-Length", (Object)txns.length());
        TxSupport.setLinkHeader((Response.ResponseBuilder)builder, (String)"Transaction Statistics", (String)"statistics", (String)statisticsUri, (String)"application/txstatusext+xml");
        return builder.build();
    }

    @GET
    @Path(value="transaction-manager/")
    @Produces(value={"application/txstatusext+xml"})
    public TransactionManagerElement getTransactionManagerInfo(@Context UriInfo info) {
        TransactionManagerElement tm = new TransactionManagerElement();
        this.updateTransactions();
        for (String s : transactions.keySet()) {
            URI uri = TxSupport.getUri((UriInfo)info, (int)info.getPathSegments().size(), (String[])new String[]{s});
            tm.addCoordinator(uri.toASCIIString());
        }
        tm.setCreated(new Date(age));
        tm.setStatistics(new TransactionStatisticsElement(active.get(), prepared.get(), committed.get(), aborted.get()));
        return tm;
    }

    @GET
    @Path(value="transaction-manager/statistics")
    @Produces(value={"application/txstatusext+xml"})
    public TransactionStatisticsElement getTransactionStatistics() {
        return new TransactionStatisticsElement(active.get(), prepared.get(), committed.get(), aborted.get());
    }

    @HEAD
    @Path(value="transaction-manager/{id}")
    @Produces(value={"application/txlist"})
    public Response getTransactionURIs(@Context UriInfo info, @PathParam(value="id") String id) {
        log.tracef("coordinator txn head request for txn %s", (Object)id);
        this.getTransaction(id);
        String terminator = "terminator";
        Response.ResponseBuilder builder = Response.ok();
        TxSupport.addLinkHeader((Response.ResponseBuilder)builder, (UriInfo)info, (String)terminator, (String)terminator, (String[])new String[]{terminator});
        TxSupport.addLinkHeader((Response.ResponseBuilder)builder, (UriInfo)info, (String)"durable-participant", (String)"durable-participant", (String[])new String[0]);
        return builder.build();
    }

    @GET
    @Path(value="transaction-manager/{id}")
    @Produces(value={"application/txstatus"})
    public Response getTransactionStatus(@Context UriInfo info, @PathParam(value="id") String id) {
        log.tracef("coordinator: status: transaction-coordinator/%s", (Object)id);
        Transaction txn = this.getTransaction(id);
        Response.ResponseBuilder builder = Response.ok((Object)TxSupport.toStatusContent((String)txn.getStatus()));
        return this.addTransactionHeaders(builder, info, txn, false).build();
    }

    @GET
    @Path(value="transaction-manager/{id}")
    @Produces(value={"application/txstatusext+xml"})
    public Response getTransactionExtStatus(@Context UriInfo info, @PathParam(value="id") String id) {
        log.tracef("coordinator: status: transaction-coordinator/%s", (Object)id);
        Transaction txn = this.getTransaction(id);
        String terminator = "terminator";
        ArrayList<String> enlistmentIds = new ArrayList<String>();
        CoordinatorElement coordinatorElement = txn.toXML();
        String txnURI = TxSupport.getUri((UriInfo)info, (int)info.getPathSegments().size(), (String[])new String[0]).toASCIIString();
        URI terminateURI = TxSupport.getUri((UriInfo)info, (int)info.getPathSegments().size(), (String[])new String[]{terminator});
        URI volatileURI = TxSupport.getUri((UriInfo)info, (int)info.getPathSegments().size(), (String[])new String[]{"volatile-participant"});
        coordinatorElement.setTxnURI(txnURI);
        coordinatorElement.setTerminateURI(terminateURI.toASCIIString());
        coordinatorElement.setDurableParticipantEnlistmentURI(txnURI);
        coordinatorElement.setVolatileParticipantEnlistmentURI(volatileURI.toASCIIString());
        txn.getParticipants(enlistmentIds);
        for (String enlistmentId : enlistmentIds) {
            Map participantInfo = participants.get(enlistmentId);
            String terminatorURI = (String)participantInfo.get("terminator");
            String participantURI = (String)participantInfo.get("participant");
            String recoveryURI = (String)participantInfo.get("recovery");
            TwoPhaseAwareParticipantElement participantElement = new TwoPhaseAwareParticipantElement();
            participantElement.setTerminatorURI(terminatorURI);
            participantElement.setRecoveryURI(recoveryURI);
            participantElement.setResourceURI(participantURI);
            txn.getStatus(participantElement, participantURI);
            coordinatorElement.addTwoPhaseAware(participantElement);
        }
        return this.addTransactionHeaders(Response.ok((Object)coordinatorElement), info, txn, false).build();
    }

    @DELETE
    @Path(value="transaction-manager/{id}")
    public Response deleteTransaction(@PathParam(value="id") String id) {
        return Response.status((int)403).build();
    }

    @HEAD
    @Path(value="transaction-manager/{TxId}/terminator")
    public Response tt1(@PathParam(value="TxId") String txId) {
        return Response.status((int)400).build();
    }

    @GET
    @Path(value="transaction-manager/{TxId}/terminator")
    public Response tt2(@PathParam(value="TxId") String txId) {
        return Response.status((int)400).build();
    }

    @POST
    @Path(value="transaction-manager/{TxId}/terminator")
    public Response tt3(@PathParam(value="TxId") String txId) {
        return Response.status((int)400).build();
    }

    @DELETE
    @Path(value="transaction-manager/{TxId}/terminator")
    public Response tt4(@PathParam(value="TxId") String txId) {
        return Response.status((int)400).build();
    }

    @OPTIONS
    @Path(value="transaction-manager/{TxId}/terminator")
    public Response tt5(@PathParam(value="TxId") String txId) {
        return Response.status((int)400).build();
    }

    private Response.ResponseBuilder addTransactionHeaders(Response.ResponseBuilder builder, UriInfo info, Transaction tx, boolean includeTxId) {
        String uid = tx.get_uid().fileStringForm();
        String terminator = "terminator";
        String participant = "durable-participant";
        String vparticipant = "volatile-participant";
        if (includeTxId) {
            TxSupport.addLinkHeader((Response.ResponseBuilder)builder, (UriInfo)info, (String)terminator, (String)terminator, (String[])new String[]{uid, terminator});
            TxSupport.addLinkHeader((Response.ResponseBuilder)builder, (UriInfo)info, (String)participant, (String)participant, (String[])new String[]{uid});
            TxSupport.addLinkHeader((Response.ResponseBuilder)builder, (UriInfo)info, (String)vparticipant, (String)vparticipant, (String[])new String[]{uid, vparticipant});
        } else {
            TxSupport.addLinkHeader((Response.ResponseBuilder)builder, (UriInfo)info, (String)terminator, (String)terminator, (String[])new String[]{terminator});
            TxSupport.addLinkHeader((Response.ResponseBuilder)builder, (UriInfo)info, (String)participant, (String)participant, (String[])new String[0]);
            TxSupport.addLinkHeader((Response.ResponseBuilder)builder, (UriInfo)info, (String)vparticipant, (String)vparticipant, (String[])new String[]{vparticipant});
        }
        return builder;
    }

    @POST
    @Path(value="transaction-manager/")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response beginTransaction(@Context UriInfo info, @Context HttpHeaders headers, @DefaultValue(value="") String content) {
        log.tracef("coordinator: POST /transaction-manager content: %s", (Object)content);
        Transaction tx = new Transaction(this, "coordinator");
        int timeout = TxSupport.getIntValue((String)content, (String)"timeout", (int)0);
        String uid = tx.get_uid().fileStringForm();
        log.tracef("coordinator: timeout=%d", (Object)timeout);
        transactions.put(uid, tx);
        if (timeout != 0) {
            timeout = timeout < 0 ? 0 : (timeout /= 1000);
        }
        int status = tx.begin(timeout);
        try {
            if (status == 0) {
                active.incrementAndGet();
                URI uri1 = TxSupport.getUri((UriInfo)info, (int)info.getPathSegments().size(), (String[])new String[]{uid});
                Response.ResponseBuilder builder = Response.created((URI)uri1);
                Response response = this.addTransactionHeaders(builder, info, tx, true).build();
                return response;
            }
            try {
                throw new TransactionStatusException("Transaction failed to start: " + status);
            }
            catch (Exception e) {
                log.debugf((Throwable)e, "begin", new Object[0]);
                throw new TransactionStatusException("Transaction failed to start: " + e);
            }
        }
        finally {
            AtomicAction.suspend();
        }
    }

    @PUT
    @Path(value="transaction-manager/{TxId}/terminator")
    public Response terminateTransaction(@PathParam(value="TxId") String txId, @QueryParam(value="fault") @DefaultValue(value="") String fault, String content) {
        String status;
        log.tracef("coordinator: commit: transaction-manager/%s/terminator : content: %s", (Object)txId, (Object)content);
        Transaction tx = this.getTransaction(txId);
        String how = TxSupport.getStringValue((String)content, (String)"txstatus");
        TxStatus currentStatus = tx.getTxStatus();
        if (!currentStatus.isRunning() && !currentStatus.isRollbackOnly()) {
            return Response.status((int)412).build();
        }
        TxStatus txStatus = TxStatus.fromStatus((String)how);
        tx.setFault(fault);
        AtomicAction.resume((AtomicAction)tx);
        switch (txStatus) {
            case TransactionCommitted: {
                prepared.incrementAndGet();
                status = tx.getStatus(tx.commit(true));
                break;
            }
            case TransactionRolledBack: {
                prepared.incrementAndGet();
                status = tx.getStatus(tx.abort());
                break;
            }
            case TransactionRollbackOnly: {
                tx.preventCommit();
                status = tx.getStatus();
                break;
            }
            default: {
                AtomicAction.suspend();
                return Response.status((int)400).build();
            }
        }
        AtomicAction.suspend();
        log.tracef("terminate result: %s", (Object)status);
        int scRes = status.length() == 0 ? 500 : 200;
        return Response.status((int)scRes).entity((Object)TxSupport.toStatusContent((String)status)).build();
    }

    public void removeTxState(int status, Transaction tx, Collection<String> enlistmentIds) {
        String txId = tx.get_uid().fileStringForm();
        transactions.remove(txId);
        prepared.decrementAndGet();
        active.decrementAndGet();
        if (status == 7) {
            committed.incrementAndGet();
        } else if (status == 4) {
            aborted.incrementAndGet();
        }
        if (enlistmentIds == null) {
            Iterator<Map.Entry<String, HashMap<String, String>>> j = participants.entrySet().iterator();
            while (j.hasNext()) {
                Map.Entry<String, HashMap<String, String>> entry = j.next();
                HashMap<String, String> linkHolder = entry.getValue();
                String participantTxId = linkHolder.get("transaction");
                if (!participantTxId.equals(txId)) continue;
                j.remove();
            }
        } else {
            for (String enlistmentId : enlistmentIds) {
                participants.remove(enlistmentId);
            }
        }
    }

    @POST
    @Path(value="transaction-manager/{TxId}")
    public Response enlistParticipant(@HeaderParam(value="Link") String linkHeader, @Context UriInfo info, @PathParam(value="TxId") String txId, String content) {
        String coordinatorId;
        log.tracef("enlistParticipant request uri %s txid:  %s content: %s", (Object)info.getRequestUri(), (Object)txId, (Object)content);
        Transaction tx = transactions.get(txId);
        if (!tx.isRunning()) {
            return Response.status((int)412).build();
        }
        Map links = TxSupport.decodeLinkHeader((String)linkHeader);
        if (links.containsKey("volatile-participant")) {
            tx.addVolatileParticipant((String)links.get("volatile-participant"));
        }
        String participantURI = (String)links.get("participant");
        String terminatorURI = (String)links.get("terminator");
        if (participantURI == null) {
            return Response.status((int)400).entity((Object)"Missing Enlistment Link Header").build();
        }
        String txURI = TxSupport.buildURI((UriBuilder)info.getBaseUriBuilder(), (String[])new String[]{((PathSegment)info.getPathSegments().get(0)).getPath(), ((PathSegment)info.getPathSegments().get(1)).getPath()});
        UriBuilder builder = info.getBaseUriBuilder();
        String recoveryUrlBase = builder.path(((PathSegment)info.getPathSegments().get(0)).getPath()).path(RC_SEGMENT).build(new Object[0]).toString() + '/';
        if (tx.isEnlisted(participantURI)) {
            return Response.status((int)400).entity((Object)"participant is already enlisted").build();
        }
        if (terminatorURI == null) {
            String commitURI = (String)links.get("commit");
            String prepareURI = (String)links.get("prepare");
            String rollbackURI = (String)links.get("rollback");
            String commitOnePhaseURI = (String)links.get("commit-one-phase");
            if (commitURI == null || prepareURI == null || rollbackURI == null) {
                return Response.status((int)400).entity((Object)"Missing TwoPhaseUnawareLink Header").build();
            }
            coordinatorId = tx.enlistParticipant(txURI, participantURI, recoveryUrlBase, commitURI, prepareURI, rollbackURI, commitOnePhaseURI);
        } else {
            coordinatorId = tx.enlistParticipant(txURI, participantURI, recoveryUrlBase, terminatorURI);
        }
        if (coordinatorId == null) {
            return Response.status((int)403).entity((Object)"2PC has started").build();
        }
        links.put("recovery", tx.getRecoveryUrl());
        links.put("transaction", txId);
        participants.put(coordinatorId, new HashMap(links));
        log.debug((Object)("enlisted participant: content=" + content + " in tx " + txId + " Coordinator url base: " + recoveryUrlBase));
        return Response.created((URI)URI.create(tx.getRecoveryUrl())).build();
    }

    @PUT
    @Path(value="transaction-manager/{TxId}/volatile-participant")
    public Response enlistVolatileParticipant(@HeaderParam(value="Link") String linkHeader, @Context UriInfo info, @PathParam(value="TxId") String txId) {
        log.tracef("enlistParticipant request uri %s txid:  %s", (Object)info.getRequestUri(), (Object)txId);
        Transaction tx = transactions.get(txId);
        if (tx.isFinishing()) {
            return Response.status((int)412).build();
        }
        Map links = TxSupport.decodeLinkHeader((String)linkHeader);
        String vparticipantURI = (String)links.get("volatile-participant");
        if (vparticipantURI == null) {
            return Response.status((int)400).entity((Object)"Missing Enlistment Link Header").build();
        }
        tx.addVolatileParticipant(vparticipantURI);
        return Response.ok().build();
    }

    @GET
    @Path(value="recovery-coordinator/{TxId}/{RecCoordId}")
    public Response lookupParticipant(@PathParam(value="TxId") String txId, @PathParam(value="RecCoordId") String enlistmentId) {
        log.tracef("coordinator: lookup: transaction-coordinator: %s/%s", (Object)txId, (Object)enlistmentId);
        HashMap<String, String> p = participants.get(enlistmentId);
        if (p == null) {
            return Response.status((int)404).build();
        }
        String linkHeader = new TxSupport().makeTwoPhaseParticipantLinkHeader(p);
        if (linkHeader == null) {
            return Response.status((int)404).build();
        }
        return Response.ok().header("Link", (Object)linkHeader).build();
    }

    @PUT
    @Path(value="recovery-coordinator/{TxId}/{RecCoordId}")
    public Response replaceParticipant(@HeaderParam(value="Link") String linkHeader, @PathParam(value="TxId") String txId, @PathParam(value="RecCoordId") String enlistmentId) {
        Map links = TxSupport.decodeLinkHeader((String)linkHeader);
        String terminatorUrl = (String)links.get("terminator");
        String participantUrl = (String)links.get("participant");
        if (participantUrl == null) {
            return Response.status((int)400).entity((Object)"Missing Link Header").build();
        }
        log.tracef("coordinator: replace: recovery-coordinator/%s?URL=%s", (Object)enlistmentId, (Object)terminatorUrl);
        this.getTransaction(txId);
        participants.put(enlistmentId, new HashMap(links));
        return Response.status((int)200).build();
    }

    @POST
    @Path(value="recovery-coordinator/{RecCoordId}")
    public Response postParticipant(@PathParam(value="RecCoordId") String enlistmentId) {
        log.tracef("coordinator: replace via Post: recovery-coordinator/%s", (Object)enlistmentId);
        return Response.status((int)401).build();
    }

    @DELETE
    @Path(value="recovery-coordinator/{RecCoordId}")
    public Response deleteParticipant(@PathParam(value="RecCoordId") String enlistmentId) {
        Transaction txn;
        log.tracef("coordinator: participant leaving via Delete: recovery-coordinator/%s", (Object)enlistmentId);
        HashMap<String, String> p = participants.get(enlistmentId);
        if (p == null || (txn = transactions.get(p.get("transaction"))) == null) {
            return Response.status((int)404).build();
        }
        if (txn.forgetParticipant(p.get("participant"))) {
            return Response.status((int)200).build();
        }
        return Response.status((int)409).build();
    }

    private Transaction getTransaction(String txId) {
        Transaction tx = transactions.get(txId);
        if (tx == null) {
            this.updateTransactions();
            tx = transactions.get(txId);
            if (tx == null) {
                throw new ResourceNotFoundException("Transaction id not found");
            }
        }
        return tx;
    }

    private static Set<Uid> getUids(Set<Uid> uids, String type) {
        try {
            RecoveryStore recoveryStore = StoreManager.getRecoveryStore();
            InputObjectState states = new InputObjectState();
            if (recoveryStore.allObjUids(type, states) && states.notempty()) {
                boolean finished = false;
                do {
                    Uid uid;
                    if ((uid = UidHelper.unpackFrom((InputBuffer)states)).notEquals(Uid.nullUid())) {
                        uids.add(uid);
                        continue;
                    }
                    finished = true;
                } while (!finished);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return uids;
    }

    private void updateTransactions() {
        HashMap<String, RecoveringTransaction> txns = new HashMap<String, RecoveringTransaction>(recoveringTransactions);
        for (Uid uid : Coordinator.getUids(new HashSet<Uid>(), REST_TXN_TYPE)) {
            txns.remove(uid.fileStringForm());
        }
        for (String txId : txns.keySet()) {
            recoveringTransactions.remove(txId);
            transactions.remove(txId);
        }
    }

    private static Map<String, RecoveringTransaction> getRecoveringTransactions(Map<String, Transaction> transactions) {
        ConcurrentHashMap<String, RecoveringTransaction> recoveringTransactions = new ConcurrentHashMap<String, RecoveringTransaction>();
        new HashMap();
        for (Uid uid : Coordinator.getUids(new HashSet<Uid>(), REST_TXN_TYPE)) {
            String key = uid.fileStringForm();
            RecoveringTransaction txn = new RecoveringTransaction(uid);
            recoveringTransactions.put(key, txn);
            transactions.put(key, txn);
        }
        return recoveringTransactions;
    }
}

