/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster;

import java.io.IOException;
import java.util.List;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.util.StringManager;
import org.jboss.logging.Logger;
import org.jboss.modcluster.Constants;
import org.jboss.modcluster.JBossWebEventHandler;
import org.jboss.modcluster.Utils;
import org.jboss.modcluster.advertise.AdvertiseListener;
import org.jboss.modcluster.advertise.AdvertiseListenerFactory;
import org.jboss.modcluster.advertise.impl.AdvertiseListenerFactoryImpl;
import org.jboss.modcluster.config.BalancerConfiguration;
import org.jboss.modcluster.config.MCMPHandlerConfiguration;
import org.jboss.modcluster.config.NodeConfiguration;
import org.jboss.modcluster.load.LoadBalanceFactorProvider;
import org.jboss.modcluster.mcmp.AddressPort;
import org.jboss.modcluster.mcmp.MCMPHandler;
import org.jboss.modcluster.mcmp.MCMPRequest;
import org.jboss.modcluster.mcmp.MCMPUtils;

public class DefaultJBossWebEventHandler
implements JBossWebEventHandler {
    static Logger log = Logger.getLogger(DefaultJBossWebEventHandler.class);
    private final StringManager sm = StringManager.getManager((String)Constants.Package);
    private final NodeConfiguration nodeConfig;
    private final BalancerConfiguration balancerConfig;
    private final MCMPHandlerConfiguration mcmpConfig;
    private final MCMPHandler mcmpHandler;
    private final AdvertiseListenerFactory listenerFactory;
    private final LoadBalanceFactorProvider loadBalanceFactorProvider;
    private volatile boolean init;
    private AdvertiseListener advertiseListener;

    public DefaultJBossWebEventHandler(NodeConfiguration nodeConfig, BalancerConfiguration balancerConfig, MCMPHandlerConfiguration mcmpConfig, MCMPHandler mcmpHandler, LoadBalanceFactorProvider loadBalanceFactorProvider) {
        this(nodeConfig, balancerConfig, mcmpConfig, mcmpHandler, loadBalanceFactorProvider, new AdvertiseListenerFactoryImpl());
    }

    protected DefaultJBossWebEventHandler(NodeConfiguration nodeConfig, BalancerConfiguration balancerConfig, MCMPHandlerConfiguration mcmpConfig, MCMPHandler mcmpHandler, LoadBalanceFactorProvider loadBalanceFactorProvider, AdvertiseListenerFactory listenerFactory) {
        this.nodeConfig = nodeConfig;
        this.balancerConfig = balancerConfig;
        this.mcmpConfig = mcmpConfig;
        this.mcmpHandler = mcmpHandler;
        this.loadBalanceFactorProvider = loadBalanceFactorProvider;
        this.listenerFactory = listenerFactory;
    }

    public synchronized void init() {
        List<AddressPort> initialProxies = MCMPUtils.parseProxies(this.mcmpConfig.getProxyList());
        this.mcmpHandler.init(initialProxies);
        Boolean advertise = this.mcmpConfig.getAdvertise();
        if (Boolean.TRUE.equals(advertise) || advertise == null && initialProxies.isEmpty()) {
            this.advertiseListener = this.listenerFactory.createListener(this.mcmpHandler, this.mcmpConfig);
            try {
                this.advertiseListener.start();
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        this.init = true;
    }

    public synchronized void shutdown() {
        this.init = false;
        if (this.advertiseListener != null) {
            try {
                this.advertiseListener.destroy();
            }
            catch (IOException e) {
                log.error((Object)this.sm.getString("modcluster.error.stopListener"), (Throwable)e);
            }
            this.advertiseListener = null;
        }
        this.mcmpHandler.shutdown();
    }

    public void startServer(Server server) {
        this.checkInit();
        for (Service service : server.findServices()) {
            Engine engine = (Engine)service.getContainer();
            this.config(engine);
            for (Container host : engine.findChildren()) {
                for (Container context : host.findChildren()) {
                    this.addContext((Context)context);
                }
            }
        }
    }

    public void stopServer(Server server) {
        this.checkInit();
        for (Service service : server.findServices()) {
            Engine engine = (Engine)service.getContainer();
            this.removeAll(engine);
            for (Container host : engine.findChildren()) {
                for (Container context : host.findChildren()) {
                    this.removeContext((Context)context);
                }
            }
        }
    }

    protected void config(Engine engine) {
        this.config(engine, this.mcmpHandler);
    }

    protected void config(Engine engine, MCMPHandler mcmpHandler) {
        log.debug((Object)this.sm.getString("modcluster.engine.config", (Object)engine.getName()));
        try {
            Utils.establishJvmRouteAndConnectorAddress(engine, mcmpHandler);
            this.jvmRouteEstablished(engine);
            MCMPRequest request = MCMPUtils.createConfigRequest(engine, this.nodeConfig, this.balancerConfig);
            this.mcmpHandler.sendRequest(request);
        }
        catch (Exception e) {
            mcmpHandler.markProxiesInError();
            log.info((Object)this.sm.getString("modcluster.error.addressJvmRoute"), (Throwable)e);
        }
    }

    protected void jvmRouteEstablished(Engine engine) {
    }

    public void addContext(Context context) {
        this.checkInit();
        log.debug((Object)this.sm.getString("modcluster.context.enable", (Object)context.getPath(), (Object)context.getParent().getName()));
        if (Utils.isContextStarted(context)) {
            MCMPRequest request = MCMPUtils.createEnableAppRequest(context);
            this.mcmpHandler.sendRequest(request);
        }
    }

    public void startContext(Context context) {
        this.checkInit();
        log.debug((Object)this.sm.getString("modcluster.context.start", (Object)context.getPath(), (Object)context.getParent().getName()));
        MCMPRequest request = MCMPUtils.createEnableAppRequest(context);
        this.mcmpHandler.sendRequest(request);
    }

    public void stopContext(Context context) {
        this.checkInit();
        log.debug((Object)this.sm.getString("modcluster.context.stop", (Object)context.getPath(), (Object)context.getParent().getName()));
        MCMPRequest request = MCMPUtils.createStopAppRequest(context);
        this.mcmpHandler.sendRequest(request);
    }

    public void removeContext(Context context) {
        this.checkInit();
        log.debug((Object)this.sm.getString("modcluster.context.disable", (Object)context.getPath(), (Object)context.getParent().getName()));
        if (Utils.getJvmRoute(context) != null) {
            MCMPRequest request = MCMPUtils.createRemoveAppRequest(context);
            this.mcmpHandler.sendRequest(request);
        }
    }

    protected void removeAll(Engine engine) {
        log.debug((Object)this.sm.getString("modcluster.engine.stop", (Object)engine.getName()));
        if (engine.getJvmRoute() != null) {
            MCMPRequest request = MCMPUtils.createRemoveAllRequest(engine);
            this.mcmpHandler.sendRequest(request);
        }
    }

    public void status(Engine engine) {
        this.checkInit();
        log.debug((Object)this.sm.getString("modcluster.engine.status", (Object)engine.getName()));
        this.mcmpHandler.status();
        int lbf = this.getLoadBalanceFactor();
        MCMPRequest request = MCMPUtils.createStatusRequest(engine, lbf);
        this.mcmpHandler.sendRequest(request);
    }

    protected int getLoadBalanceFactor() {
        return this.loadBalanceFactorProvider.getLoadBalanceFactor();
    }

    private void checkInit() {
        if (!this.init) {
            throw new IllegalStateException(this.sm.getString("modcluster.error.uninitialized"));
        }
    }
}

