/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Server;
import org.apache.catalina.util.StringManager;
import org.jboss.beans.metadata.api.annotations.Inject;
import org.jboss.beans.metadata.api.model.FromContext;
import org.jboss.ha.framework.interfaces.ClusterNode;
import org.jboss.ha.framework.interfaces.DistributedReplicantManager;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.framework.interfaces.HAServiceKeyProvider;
import org.jboss.ha.framework.interfaces.HASingletonElectionPolicy;
import org.jboss.ha.framework.server.EventFactory;
import org.jboss.ha.framework.server.HAServiceEvent;
import org.jboss.ha.framework.server.HAServiceEventFactory;
import org.jboss.ha.framework.server.HAServiceRpcHandler;
import org.jboss.ha.framework.server.HASingletonImpl;
import org.jboss.modcluster.Constants;
import org.jboss.modcluster.DefaultJBossWebEventHandler;
import org.jboss.modcluster.JBossWebEventHandler;
import org.jboss.modcluster.ModClusterServiceMBean;
import org.jboss.modcluster.Utils;
import org.jboss.modcluster.config.BalancerConfiguration;
import org.jboss.modcluster.config.MCMPHandlerConfiguration;
import org.jboss.modcluster.config.ModClusterConfig;
import org.jboss.modcluster.config.NodeConfiguration;
import org.jboss.modcluster.ha.ClusteredMCMPHandler;
import org.jboss.modcluster.ha.ClusteredMCMPHandlerImpl;
import org.jboss.modcluster.ha.HASingletonAwareResetRequestSource;
import org.jboss.modcluster.ha.HASingletonAwareResetRequestSourceImpl;
import org.jboss.modcluster.ha.ModClusterServiceDRMEntry;
import org.jboss.modcluster.ha.rpc.BooleanGroupRpcResponse;
import org.jboss.modcluster.ha.rpc.ClusteredMCMPHandlerRpcHandler;
import org.jboss.modcluster.ha.rpc.GroupRpcResponse;
import org.jboss.modcluster.ha.rpc.MCMPServerDiscoveryEvent;
import org.jboss.modcluster.ha.rpc.ModClusterServiceRpcHandler;
import org.jboss.modcluster.ha.rpc.ModClusterServiceStateGroupRpcResponse;
import org.jboss.modcluster.ha.rpc.PeerMCMPDiscoveryStatus;
import org.jboss.modcluster.ha.rpc.ResetRequestGroupRpcResponse;
import org.jboss.modcluster.ha.rpc.ResetRequestSourceRpcHandler;
import org.jboss.modcluster.ha.rpc.StringGroupRpcResponse;
import org.jboss.modcluster.ha.rpc.ThrowableGroupRpcResponse;
import org.jboss.modcluster.load.LoadBalanceFactorProvider;
import org.jboss.modcluster.mcmp.AddressPort;
import org.jboss.modcluster.mcmp.MCMPHandler;
import org.jboss.modcluster.mcmp.MCMPRequest;
import org.jboss.modcluster.mcmp.MCMPServer;
import org.jboss.modcluster.mcmp.MCMPServerState;
import org.jboss.modcluster.mcmp.MCMPUtils;
import org.jboss.modcluster.mcmp.ResetRequestSource;
import org.jboss.modcluster.mcmp.impl.DefaultMCMPHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModClusterService
extends HASingletonImpl<HAServiceEvent>
implements JBossWebEventHandler,
ModClusterServiceMBean,
ModClusterServiceRpcHandler<List<?>, MCMPServerState> {
    private static final Class<?>[] CLUSTER_STATUS_COMPLETE_TYPES = new Class[]{Map.class};
    private static final Class<?>[] GET_CLUSTER_COORDINATOR_STATE_TYPES = new Class[]{Set.class};
    final MCMPHandler localHandler;
    final ClusteredMCMPHandler clusteredHandler;
    final HASingletonAwareResetRequestSource resetRequestSource;
    final Map<ClusterNode, MCMPServerDiscoveryEvent> proxyChangeDigest = new HashMap<ClusterNode, MCMPServerDiscoveryEvent>();
    final ModClusterServiceDRMEntry drmEntry;
    final StringManager sm = StringManager.getManager((String)Constants.Package);
    private final RpcHandler rpcHandler;
    private final JBossWebEventHandler eventHandlerDelegate;
    private final String domain;
    private final boolean masterPerDomain;
    volatile int latestLoad;
    volatile int statusCount = 0;
    volatile int processStatusFrequency = 1;

    public ModClusterService(HAPartition partition, ModClusterConfig config, LoadBalanceFactorProvider loadFactorProvider) {
        this(partition, config, loadFactorProvider, null);
    }

    public ModClusterService(HAPartition partition, ModClusterConfig config, LoadBalanceFactorProvider loadFactorProvider, HASingletonElectionPolicy electionPolicy) {
        super((EventFactory)new HAServiceEventFactory());
        assert (partition != null) : this.sm.getString("modcluster.error.iae.null", (Object)"partition");
        assert (loadFactorProvider != null) : this.sm.getString("modcluster.error.iae.null", (Object)"loadFactorProvider");
        assert (config != null) : this.sm.getString("modcluster.error.iae.null", (Object)"config is null");
        this.setHAPartition(partition);
        this.resetRequestSource = new HASingletonAwareResetRequestSourceImpl(config, config, this, (HAServiceKeyProvider)this);
        this.localHandler = new DefaultMCMPHandler(config, this.resetRequestSource);
        this.clusteredHandler = new ClusteredMCMPHandlerImpl(this.localHandler, this, (HAServiceKeyProvider)this);
        this.eventHandlerDelegate = new ClusteredJBossWebEventHandler(config, config, config, this.clusteredHandler, loadFactorProvider);
        this.domain = config.getDomain();
        this.masterPerDomain = config.isMasterPerDomain();
        this.setElectionPolicy(electionPolicy);
        this.drmEntry = new ModClusterServiceDRMEntry(partition.getClusterNode(), null);
        this.rpcHandler = new RpcHandler();
    }

    protected ModClusterService(HAPartition partition, NodeConfiguration nodeConfig, BalancerConfiguration balancerConfig, MCMPHandlerConfiguration mcmpConfig, MCMPHandler localHandler, HASingletonAwareResetRequestSource resetRequestSource, ClusteredMCMPHandler clusteredHandler, LoadBalanceFactorProvider loadFactorProvider, HASingletonElectionPolicy electionPolicy) {
        super((EventFactory)new HAServiceEventFactory());
        assert (partition != null) : this.sm.getString("modcluster.error.iae.null", (Object)"partition");
        assert (localHandler != null) : this.sm.getString("modcluster.error.iae.null", (Object)"localHandler");
        assert (resetRequestSource != null) : this.sm.getString("modcluster.error.iae.null", (Object)"resetRequestSource");
        assert (nodeConfig != null) : this.sm.getString("modcluster.error.iae.null", (Object)"nodeConfig");
        assert (balancerConfig != null) : this.sm.getString("modcluster.error.iae.null", (Object)"balancerConfig");
        assert (clusteredHandler != null) : this.sm.getString("modcluster.error.iae.null", (Object)"clusteredHandler");
        this.setHAPartition(partition);
        this.localHandler = localHandler;
        this.resetRequestSource = resetRequestSource;
        this.clusteredHandler = clusteredHandler;
        this.eventHandlerDelegate = new ClusteredJBossWebEventHandler(nodeConfig, balancerConfig, mcmpConfig, this.clusteredHandler, loadFactorProvider);
        this.domain = nodeConfig.getDomain();
        this.masterPerDomain = mcmpConfig.isMasterPerDomain();
        this.setElectionPolicy(electionPolicy);
        this.drmEntry = new ModClusterServiceDRMEntry(partition.getClusterNode(), null);
        this.rpcHandler = new RpcHandler();
    }

    @Override
    public void addProxy(String host, int port) {
        this.clusteredHandler.addProxy(host, port);
    }

    @Override
    public void removeProxy(String host, int port) {
        this.clusteredHandler.removeProxy(host, port);
    }

    public String getProxyInfo() {
        return this.clusteredHandler.getProxyInfo();
    }

    @Override
    public String getProxyConfiguration() {
        return this.clusteredHandler.getProxyConfiguration();
    }

    @Override
    public void refresh() {
        this.clusteredHandler.markProxiesInError();
    }

    @Override
    public void reset() {
        this.clusteredHandler.reset();
    }

    @Override
    public void init() {
        this.eventHandlerDelegate.init();
    }

    @Override
    public void shutdown() {
        this.eventHandlerDelegate.shutdown();
    }

    @Override
    public void startServer(Server server) {
        this.eventHandlerDelegate.startServer(server);
    }

    @Override
    public void stopServer(Server server) {
        this.eventHandlerDelegate.stopServer(server);
    }

    @Override
    public void addContext(Context context) {
        this.eventHandlerDelegate.addContext(context);
    }

    @Override
    public void startContext(Context context) {
        this.eventHandlerDelegate.startContext(context);
    }

    @Override
    public void stopContext(Context context) {
        this.eventHandlerDelegate.stopContext(context);
    }

    @Override
    public void removeContext(Context context) {
        this.eventHandlerDelegate.removeContext(context);
    }

    @Override
    public void status(Engine engine) {
        this.eventHandlerDelegate.status(engine);
    }

    public String getDomain() {
        return this.domain;
    }

    public int getProcessStatusFrequency() {
        return this.processStatusFrequency;
    }

    public void setProcessStatusFrequency(int processStatusFrequency) {
        this.processStatusFrequency = processStatusFrequency;
    }

    public void startSingleton() {
        this.statusCount = this.processStatusFrequency - 1;
    }

    @Inject(fromContext=FromContext.NAME)
    public void setServiceHAName(String haName) {
        super.setServiceHAName(haName);
    }

    protected HAServiceRpcHandler<HAServiceEvent> getRpcHandler() {
        return this.rpcHandler;
    }

    public String getHAServiceKey() {
        String name = this.getServiceHAName();
        return this.domain != null && this.masterPerDomain ? name + ":" + this.domain : name;
    }

    protected Serializable getReplicant() {
        return this.drmEntry;
    }

    protected List<ClusterNode> getElectionCandidates() {
        List candidates = this.getHAPartition().getDistributedReplicantManager().lookupReplicants(this.getHAServiceKey());
        return this.narrowCandidateList(candidates);
    }

    List<ClusterNode> narrowCandidateList(Collection<ModClusterServiceDRMEntry> candidates) {
        if (candidates == null) {
            return null;
        }
        ArrayList<ClusterNode> narrowed = new ArrayList<ClusterNode>(candidates.size());
        ModClusterServiceDRMEntry champion = null;
        for (ModClusterServiceDRMEntry candidate : candidates) {
            if (champion == null) {
                champion = candidate;
                narrowed.add(candidate.getPeer());
                continue;
            }
            int compFactor = candidate.compareTo(champion);
            if (compFactor < 0) {
                narrowed.clear();
                champion = candidate;
                narrowed.add(candidate.getPeer());
                continue;
            }
            if (compFactor != 0) continue;
            narrowed.add(candidate.getPeer());
        }
        return narrowed;
    }

    @Override
    public void clusterStatusComplete(Map<ClusterNode, PeerMCMPDiscoveryStatus> statuses) {
        try {
            this.callMethodOnPartition("clusterStatusComplete", new Object[]{statuses}, CLUSTER_STATUS_COMPLETE_TYPES);
        }
        catch (Exception e) {
            this.log.error((Object)this.sm.getString("modcluster.error.status.complete"), (Throwable)e);
        }
    }

    @Override
    public List<?> getClusterCoordinatorState(Set<MCMPServerState> masterList) {
        try {
            return this.callMethodOnPartition("getClusterCoordinatorState", new Object[]{masterList}, GET_CLUSTER_COORDINATOR_STATE_TYPES);
        }
        catch (Exception e) {
            throw Utils.convertToUnchecked(e);
        }
    }

    void updateLocalDRM(ModClusterServiceDRMEntry status) {
        try {
            this.getHAPartition().getDistributedReplicantManager().add(this.getHAServiceKey(), (Serializable)status);
        }
        catch (Exception e) {
            throw Utils.convertToUnchecked(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClusteredJBossWebEventHandler
    extends DefaultJBossWebEventHandler {
        private final ModClusterService coord;

        public ClusteredJBossWebEventHandler(NodeConfiguration nodeConfig, BalancerConfiguration balancerConfig, MCMPHandlerConfiguration mcmpConfig, MCMPHandler clusteredHandler, LoadBalanceFactorProvider loadFactorProvider) {
            super(nodeConfig, balancerConfig, mcmpConfig, clusteredHandler, loadFactorProvider);
            this.coord = ModClusterService.this;
        }

        @Override
        public void startServer(Server server) {
            this.coord.resetRequestSource.setJbossWebServer(server);
            super.startServer(server);
        }

        @Override
        protected void config(Engine engine) {
            this.config(engine, this.coord.localHandler);
        }

        @Override
        protected void jvmRouteEstablished(Engine engine) {
            this.coord.drmEntry.addJvmRoute(engine.getJvmRoute());
            this.coord.updateLocalDRM(this.coord.drmEntry);
        }

        @Override
        protected void removeAll(Engine engine) {
            super.removeAll(engine);
            this.coord.drmEntry.removeJvmRoute(engine.getJvmRoute());
            this.coord.updateLocalDRM(this.coord.drmEntry);
        }

        @Override
        public void status(Engine engine) {
            log.debug((Object)this.coord.sm.getString("modcluster.engine.status", (Object)engine.getName()));
            this.coord.latestLoad = this.getLoadBalanceFactor();
            if (this.coord.isMasterNode()) {
                this.coord.statusCount = (this.coord.statusCount + 1) % this.coord.processStatusFrequency;
                if (this.coord.statusCount == 0) {
                    this.updateClusterStatus();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateClusterStatus() {
            Set<MCMPServerState> masterList = null;
            HashMap<ClusterNode, MCMPServerDiscoveryEvent> latestEvents = null;
            HashMap<ClusterNode, ModClusterServiceDRMEntry> nonresponsive = new HashMap<ClusterNode, ModClusterServiceDRMEntry>();
            HashMap<String, Integer> loadBalanceFactors = new HashMap<String, Integer>();
            HashMap<ClusterNode, PeerMCMPDiscoveryStatus> statuses = new HashMap<ClusterNode, PeerMCMPDiscoveryStatus>();
            ArrayList<MCMPRequest> resetRequests = new ArrayList<MCMPRequest>();
            HAPartition partition = this.coord.getHAPartition();
            DistributedReplicantManager drm = partition.getDistributedReplicantManager();
            boolean resync = false;
            do {
                resync = false;
                this.coord.localHandler.status();
                Map<ClusterNode, MCMPServerDiscoveryEvent> map = this.coord.proxyChangeDigest;
                synchronized (map) {
                    masterList = this.coord.localHandler.getProxyStates();
                    latestEvents = new HashMap<ClusterNode, MCMPServerDiscoveryEvent>(this.coord.proxyChangeDigest);
                }
                List replicants = drm.lookupReplicants(this.coord.getHAServiceKey());
                nonresponsive.clear();
                for (ModClusterServiceDRMEntry modClusterServiceDRMEntry : replicants) {
                    nonresponsive.put(modClusterServiceDRMEntry.getPeer(), modClusterServiceDRMEntry);
                }
                nonresponsive.remove(partition.getClusterNode());
                Object responses = this.coord.getClusterCoordinatorState((Set)masterList);
                resetRequests.clear();
                loadBalanceFactors.clear();
                for (String string : this.coord.drmEntry.getJvmRoutes()) {
                    loadBalanceFactors.put(string, this.coord.latestLoad);
                }
                statuses.clear();
                Iterator iterator = responses.iterator();
                while (iterator.hasNext()) {
                    ClusterNode cn;
                    Object e = iterator.next();
                    if (e instanceof ModClusterServiceStateGroupRpcResponse) {
                        ModClusterServiceDRMEntry removed;
                        ModClusterServiceStateGroupRpcResponse mcssgrr = (ModClusterServiceStateGroupRpcResponse)e;
                        cn = mcssgrr.getSender();
                        MCMPServerDiscoveryEvent latestEvent = (MCMPServerDiscoveryEvent)latestEvents.get(cn);
                        for (MCMPServerDiscoveryEvent toCheck : mcssgrr.getUnacknowledgedEvents()) {
                            if (latestEvent != null && latestEvent.getEventIndex() <= toCheck.getEventIndex()) continue;
                            AddressPort ap = toCheck.getMCMPServer();
                            if (toCheck.isAddition()) {
                                this.coord.localHandler.addProxy(ap.getAddress(), ap.getPort());
                            } else {
                                this.coord.localHandler.removeProxy(ap.getAddress(), ap.getPort());
                            }
                            resync = true;
                        }
                        if (resync) continue;
                        statuses.put(cn, new PeerMCMPDiscoveryStatus(cn, mcssgrr.getStates(), latestEvent));
                        List<MCMPRequest> toAdd = mcssgrr.getResetRequests();
                        if (toAdd != null) {
                            resetRequests.addAll(toAdd);
                        }
                        if ((removed = (ModClusterServiceDRMEntry)nonresponsive.remove(cn)) == null) continue;
                        Integer lbf = mcssgrr.getLoadBalanceFactor();
                        for (String jvmRoute : removed.getJvmRoutes()) {
                            loadBalanceFactors.put(jvmRoute, lbf);
                        }
                        continue;
                    }
                    if (e instanceof ThrowableGroupRpcResponse) {
                        ThrowableGroupRpcResponse tgrr = (ThrowableGroupRpcResponse)e;
                        cn = tgrr.getSender();
                        log.warn((Object)this.coord.sm.getString("modcluster.error.rpc.known", (Object)"getClusterCoordinatorState", (Object)cn), tgrr.getValue());
                        continue;
                    }
                    if (e instanceof Throwable) {
                        log.warn((Object)this.coord.sm.getString("modcluster.error.rpc.unknown", (Object)"getClusterCoordinatorState"), (Throwable)e);
                        continue;
                    }
                    log.error((Object)this.coord.sm.getString("modcluster.error.rpc.unexpected", e, (Object)"getClusterCoordinatorState"));
                }
            } while (resync);
            Integer lbf = 0;
            for (Map.Entry entry : nonresponsive.entrySet()) {
                ClusterNode clusterNode = (ClusterNode)entry.getKey();
                statuses.put((ClusterNode)entry.getKey(), new PeerMCMPDiscoveryStatus(clusterNode, null, (MCMPServerDiscoveryEvent)latestEvents.get(clusterNode)));
                for (String jvmRoute : ((ModClusterServiceDRMEntry)entry.getValue()).getJvmRoutes()) {
                    loadBalanceFactors.put(jvmRoute, lbf);
                }
            }
            this.coord.localHandler.sendRequests(resetRequests);
            ArrayList<MCMPRequest> statusRequests = new ArrayList<MCMPRequest>();
            for (Map.Entry entry : loadBalanceFactors.entrySet()) {
                statusRequests.add(MCMPUtils.createStatusRequest((String)entry.getKey(), (int)((Integer)entry.getValue())));
            }
            this.coord.localHandler.sendRequests(statusRequests);
            this.notifyClusterStatusComplete(masterList, statuses);
        }

        private void notifyClusterStatusComplete(Set<MCMPServerState> masterList, Map<ClusterNode, PeerMCMPDiscoveryStatus> statuses) {
            boolean updated;
            HAPartition partition = this.coord.getHAPartition();
            HashSet<ModClusterServiceDRMEntry> allStatuses = new HashSet<ModClusterServiceDRMEntry>(statuses.values());
            DistributedReplicantManager drm = partition.getDistributedReplicantManager();
            ModClusterServiceDRMEntry ourCurrentStatus = (ModClusterServiceDRMEntry)drm.lookupLocalReplicant(this.coord.getHAServiceKey());
            allStatuses.add((PeerMCMPDiscoveryStatus)ourCurrentStatus);
            ClusterNode node = partition.getClusterNode();
            boolean othersFirst = this.coord.narrowCandidateList(allStatuses).contains(node);
            ModClusterServiceDRMEntry newStatus = new ModClusterServiceDRMEntry(node, masterList, this.coord.drmEntry.getJvmRoutes());
            boolean bl = updated = !newStatus.equals(ourCurrentStatus);
            if (othersFirst) {
                this.coord.clusterStatusComplete(statuses);
            }
            if (updated) {
                this.coord.updateLocalDRM(newStatus);
            }
            if (!othersFirst) {
                this.coord.clusterStatusComplete(statuses);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class RpcHandler
    extends HASingletonImpl.RpcHandler
    implements ModClusterServiceRpcHandler<GroupRpcResponse, MCMPServer>,
    ClusteredMCMPHandlerRpcHandler,
    ResetRequestSourceRpcHandler<GroupRpcResponse> {
        private final ModClusterService coord;
        private final GroupRpcResponse SUCCESS;

        protected RpcHandler() {
            super((HASingletonImpl)ModClusterService.this);
            this.coord = ModClusterService.this;
            this.SUCCESS = new GroupRpcResponse(this.coord.getHAPartition().getClusterNode());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public GroupRpcResponse mcmpServerDiscoveryEvent(MCMPServerDiscoveryEvent event) {
            if (!this.coord.isMasterNode()) {
                return null;
            }
            Map<ClusterNode, MCMPServerDiscoveryEvent> map = ModClusterService.this.proxyChangeDigest;
            synchronized (map) {
                AddressPort ap = event.getMCMPServer();
                if (event.isAddition()) {
                    this.coord.localHandler.addProxy(ap.getAddress(), ap.getPort());
                } else {
                    this.coord.localHandler.removeProxy(ap.getAddress(), ap.getPort());
                }
                ModClusterService.this.proxyChangeDigest.put(event.getSender(), event);
                return new GroupRpcResponse(ModClusterService.this.getHAPartition().getClusterNode());
            }
        }

        @Override
        public GroupRpcResponse getClusterCoordinatorState(Set<MCMPServer> masterList) {
            if (this.coord.isMasterNode()) {
                return null;
            }
            Set<MCMPServerState> ourStates = this.coord.clusteredHandler.updateServersFromMasterNode(masterList);
            boolean needReset = this.coord.clusteredHandler.getNeedsResetTransmission();
            Map<String, Set<ResetRequestSource.VirtualHost>> map = Collections.emptyMap();
            List<MCMPRequest> resetRequests = needReset ? this.coord.resetRequestSource.getLocalResetRequests(map) : null;
            ClusterNode node = ModClusterService.this.getHAPartition().getClusterNode();
            List<MCMPServerDiscoveryEvent> events = this.coord.clusteredHandler.getPendingDiscoveryEvents();
            ModClusterServiceStateGroupRpcResponse response = new ModClusterServiceStateGroupRpcResponse(node, this.coord.latestLoad, ourStates, events, resetRequests);
            if (needReset) {
                this.coord.clusteredHandler.recordResetTransmission();
            }
            return response;
        }

        @Override
        public void clusterStatusComplete(Map<ClusterNode, PeerMCMPDiscoveryStatus> statuses) {
            HAPartition partition = this.coord.getHAPartition();
            ClusterNode cn = partition.getClusterNode();
            PeerMCMPDiscoveryStatus newStatus = statuses.get(cn);
            if (newStatus != null) {
                this.coord.clusteredHandler.discoveryEventsReceived(newStatus.getLatestDiscoveryEvent());
                this.coord.clusteredHandler.recordResetSuccess();
                DistributedReplicantManager drm = partition.getDistributedReplicantManager();
                String key = this.coord.getHAServiceKey();
                ModClusterServiceDRMEntry oldStatus = (ModClusterServiceDRMEntry)drm.lookupLocalReplicant(key);
                if (!newStatus.equals(oldStatus)) {
                    try {
                        drm.add(key, (Serializable)new ModClusterServiceDRMEntry(cn, newStatus.getMCMPServerStates(), oldStatus.getJvmRoutes()));
                    }
                    catch (Exception e) {
                        this.coord.log.error((Object)ModClusterService.this.sm.getString("modcluster.error.drm"), (Throwable)e);
                    }
                }
            }
        }

        @Override
        public GroupRpcResponse getProxyConfiguration() {
            if (!this.coord.isMasterNode()) {
                return null;
            }
            ClusterNode node = ModClusterService.this.getHAPartition().getClusterNode();
            String configuration = this.coord.localHandler.getProxyConfiguration();
            return new StringGroupRpcResponse(node, configuration);
        }

        @Override
        public GroupRpcResponse getProxyInfo() {
            if (!this.coord.isMasterNode()) {
                return null;
            }
            ClusterNode node = ModClusterService.this.getHAPartition().getClusterNode();
            String info = this.coord.localHandler.getProxyInfo();
            return new StringGroupRpcResponse(node, info);
        }

        @Override
        public GroupRpcResponse isProxyHealthOK() {
            if (!this.coord.isMasterNode()) {
                return null;
            }
            ClusterNode node = ModClusterService.this.getHAPartition().getClusterNode();
            boolean ok = this.coord.localHandler.isProxyHealthOK();
            return new BooleanGroupRpcResponse(node, ok);
        }

        @Override
        public GroupRpcResponse markProxiesInError() {
            if (!this.coord.isMasterNode()) {
                return null;
            }
            this.coord.localHandler.markProxiesInError();
            return this.SUCCESS;
        }

        @Override
        public GroupRpcResponse reset() {
            if (!this.coord.isMasterNode()) {
                return null;
            }
            this.coord.localHandler.reset();
            return this.SUCCESS;
        }

        @Override
        public GroupRpcResponse sendRequest(MCMPRequest request) {
            if (!this.coord.isMasterNode()) {
                return null;
            }
            this.coord.localHandler.sendRequest(request);
            return this.SUCCESS;
        }

        @Override
        public GroupRpcResponse sendRequests(List<MCMPRequest> requests) {
            if (!this.coord.isMasterNode()) {
                return null;
            }
            this.coord.localHandler.sendRequests(requests);
            return this.SUCCESS;
        }

        @Override
        public GroupRpcResponse getResetRequests(Map<String, Set<ResetRequestSource.VirtualHost>> response) {
            ClusterNode node = ModClusterService.this.getHAPartition().getClusterNode();
            List<MCMPRequest> requests = this.coord.resetRequestSource.getLocalResetRequests(response);
            return new ResetRequestGroupRpcResponse(node, requests);
        }
    }
}

