/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.load.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.modcluster.load.LoadBalanceFactorProvider;
import org.jboss.modcluster.load.impl.DynamicLoadBalanceFactorProviderMBean;
import org.jboss.modcluster.load.metric.LoadContext;
import org.jboss.modcluster.load.metric.LoadMetric;
import org.jboss.modcluster.load.metric.LoadMetricSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicLoadBalanceFactorProvider
implements LoadBalanceFactorProvider,
DynamicLoadBalanceFactorProviderMBean {
    private final Logger log = Logger.getLogger(this.getClass());
    private final Map<LoadMetricSource<LoadContext>, Collection<LoadMetric<LoadContext>>> metrics = new LinkedHashMap<LoadMetricSource<LoadContext>, Collection<LoadMetric<LoadContext>>>();
    private final Map<LoadMetric<LoadContext>, List<Double>> loadHistory = new HashMap<LoadMetric<LoadContext>, List<Double>>();
    private volatile int decayFactor = 2;
    private volatile int history = 9;

    public DynamicLoadBalanceFactorProvider(Set<LoadMetric<LoadContext>> metrics) {
        for (LoadMetric<LoadContext> metric : metrics) {
            LoadMetricSource<LoadContext> source = metric.getSource();
            Collection<LoadMetric<LoadContext>> sourceMetrics = this.metrics.get(source);
            if (sourceMetrics == null) {
                sourceMetrics = new ArrayList<LoadMetric<LoadContext>>();
                this.metrics.put(source, sourceMetrics);
            }
            sourceMetrics.add(metric);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int getLoadBalanceFactor() {
        int totalWeight = 0;
        double totalWeightedLoad = 0.0;
        for (Map.Entry<LoadMetricSource<LoadContext>, Collection<LoadMetric<LoadContext>>> entry : this.metrics.entrySet()) {
            LoadMetricSource<LoadContext> source = entry.getKey();
            Collection<LoadMetric<LoadContext>> metrics = entry.getValue();
            boolean skip = true;
            for (LoadMetric<LoadContext> metric : metrics) {
                skip = skip && metric.getWeight() <= 0;
            }
            if (skip) continue;
            LoadContext context = source.createContext();
            try {
                for (LoadMetric<LoadContext> metric : metrics) {
                    int weight = metric.getWeight();
                    if (weight <= 0) continue;
                    try {
                        List<Double> queue = this.recordLoad(metric, metric.getLoad(context) / metric.getCapacity());
                        totalWeight += weight;
                        totalWeightedLoad += this.average(queue) * (double)weight;
                    }
                    catch (Exception e) {
                        this.log.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
            finally {
                context.close();
            }
        }
        int load = (int)Math.round(100.0 * totalWeightedLoad / (double)totalWeight);
        return 100 - Math.max(0, Math.min(load, 100));
    }

    private List<Double> recordLoad(LoadMetric<LoadContext> metric, double load) {
        List<Double> queue = this.loadHistory.get(metric);
        if (queue == null) {
            queue = new ArrayList<Double>(this.history + 1);
            this.loadHistory.put(metric, queue);
        } else {
            for (int i = queue.size() - 1; i >= this.history; --i) {
                queue.remove(i);
            }
        }
        queue.add(0, new Double(load));
        return queue;
    }

    private double average(List<Double> queue) {
        assert (!queue.isEmpty());
        double totalLoad = 0.0;
        double totalDecay = 0.0;
        double decayFactor = this.decayFactor;
        for (int i = 0; i < queue.size(); ++i) {
            double decay = 1.0 / Math.pow(decayFactor, i);
            totalDecay += decay;
            totalLoad += queue.get(i) * decay;
        }
        return totalLoad / totalDecay;
    }

    @Override
    public int getDecayFactor() {
        return this.decayFactor;
    }

    @Override
    public void setDecayFactor(int decayFactor) {
        this.decayFactor = Math.max(1, decayFactor);
    }

    @Override
    public int getHistory() {
        return this.history;
    }

    @Override
    public void setHistory(int history) {
        this.history = Math.max(0, history);
    }
}

