/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.util.StringManager;
import org.jboss.logging.Logger;
import org.jboss.modcluster.Constants;
import org.jboss.modcluster.ContainerEventHandler;
import org.jboss.modcluster.Utils;
import org.jboss.modcluster.advertise.AdvertiseListener;
import org.jboss.modcluster.advertise.AdvertiseListenerFactory;
import org.jboss.modcluster.config.BalancerConfiguration;
import org.jboss.modcluster.config.MCMPHandlerConfiguration;
import org.jboss.modcluster.config.NodeConfiguration;
import org.jboss.modcluster.load.LoadBalanceFactorProvider;
import org.jboss.modcluster.load.LoadBalanceFactorProviderFactory;
import org.jboss.modcluster.mcmp.MCMPHandler;
import org.jboss.modcluster.mcmp.MCMPRequest;
import org.jboss.modcluster.mcmp.MCMPRequestFactory;
import org.jboss.modcluster.mcmp.ResetRequestSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CatalinaEventHandler
implements ContainerEventHandler<Server, Engine, Context> {
    static final Logger log = Logger.getLogger(CatalinaEventHandler.class);
    private final StringManager sm = StringManager.getManager((String)Constants.Package);
    private final NodeConfiguration nodeConfig;
    private final BalancerConfiguration balancerConfig;
    private final MCMPHandlerConfiguration mcmpConfig;
    private final MCMPHandler mcmpHandler;
    private final ResetRequestSource source;
    private final MCMPRequestFactory requestFactory;
    private final AdvertiseListenerFactory listenerFactory;
    private final LoadBalanceFactorProviderFactory loadBalanceFactorProviderFactory;
    private volatile Server server = null;
    private volatile LoadBalanceFactorProvider loadBalanceFactorProvider;
    private volatile AdvertiseListener advertiseListener;
    private volatile Map<String, Set<String>> excludedContextPaths;

    public CatalinaEventHandler(NodeConfiguration nodeConfig, BalancerConfiguration balancerConfig, MCMPHandlerConfiguration mcmpConfig, MCMPHandler mcmpHandler, ResetRequestSource source, MCMPRequestFactory requestFactory, LoadBalanceFactorProviderFactory loadBalanceFactorProviderFactory, AdvertiseListenerFactory listenerFactory) {
        this.nodeConfig = nodeConfig;
        this.balancerConfig = balancerConfig;
        this.mcmpConfig = mcmpConfig;
        this.mcmpHandler = mcmpHandler;
        this.source = source;
        this.requestFactory = requestFactory;
        this.loadBalanceFactorProviderFactory = loadBalanceFactorProviderFactory;
        this.listenerFactory = listenerFactory;
    }

    @Override
    public Server getServer() {
        return this.server;
    }

    @Override
    public synchronized void init(Server server) {
        List<InetSocketAddress> initialProxies = Utils.parseProxies(this.mcmpConfig.getProxyList());
        this.mcmpHandler.init(initialProxies);
        this.excludedContextPaths = Utils.parseContexts(this.mcmpConfig.getExcludedContexts());
        this.source.init(this.excludedContextPaths);
        this.loadBalanceFactorProvider = this.loadBalanceFactorProviderFactory.createLoadBalanceFactorProvider();
        Boolean advertise = this.mcmpConfig.getAdvertise();
        if (Boolean.TRUE.equals(advertise) || advertise == null && initialProxies.isEmpty()) {
            this.advertiseListener = this.listenerFactory.createListener(this.mcmpHandler, this.mcmpConfig);
            try {
                this.advertiseListener.start();
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        this.server = server;
    }

    @Override
    public synchronized void shutdown() {
        this.server = null;
        if (this.advertiseListener != null) {
            try {
                this.advertiseListener.destroy();
            }
            catch (IOException e) {
                log.error((Object)this.sm.getString("modcluster.error.stopListener"), (Throwable)e);
            }
            this.advertiseListener = null;
        }
        this.mcmpHandler.shutdown();
    }

    @Override
    public void startServer(Server server) {
        this.checkInit();
        for (Service service : server.findServices()) {
            Engine engine = (Engine)service.getContainer();
            this.config(engine);
            for (Container host : engine.findChildren()) {
                for (Container context : host.findChildren()) {
                    this.addContext((Context)context);
                }
            }
        }
    }

    @Override
    public void stopServer(Server server) {
        this.checkInit();
        for (Service service : server.findServices()) {
            Engine engine = (Engine)service.getContainer();
            for (Container host : engine.findChildren()) {
                for (Container context : host.findChildren()) {
                    this.removeContext((Context)context);
                }
            }
            this.removeAll(engine);
        }
    }

    protected void config(Engine engine) {
        this.config(engine, this.mcmpHandler);
    }

    protected void config(Engine engine, MCMPHandler mcmpHandler) {
        log.debug((Object)this.sm.getString("modcluster.engine.config", (Object)engine.getName()));
        try {
            Utils.establishJvmRouteAndConnectorAddress(engine, mcmpHandler);
            this.jvmRouteEstablished(engine);
            MCMPRequest request = this.requestFactory.createConfigRequest(engine, this.nodeConfig, this.balancerConfig);
            this.mcmpHandler.sendRequest(request);
        }
        catch (Exception e) {
            mcmpHandler.markProxiesInError();
            log.info((Object)this.sm.getString("modcluster.error.addressJvmRoute"), (Throwable)e);
        }
    }

    protected void jvmRouteEstablished(Engine engine) {
    }

    @Override
    public void addContext(Context context) {
        this.checkInit();
        if (!this.exclude(context) && Utils.isContextStarted(context)) {
            log.debug((Object)this.sm.getString("modcluster.context.enable", (Object)context.getPath(), (Object)context.getParent().getName()));
            MCMPRequest request = this.requestFactory.createEnableRequest(context);
            this.mcmpHandler.sendRequest(request);
        }
    }

    @Override
    public void startContext(Context context) {
        this.checkInit();
        if (!this.exclude(context)) {
            log.debug((Object)this.sm.getString("modcluster.context.start", (Object)context.getPath(), (Object)context.getParent().getName()));
            MCMPRequest request = this.requestFactory.createEnableRequest(context);
            this.mcmpHandler.sendRequest(request);
        }
    }

    @Override
    public void stopContext(Context context) {
        this.checkInit();
        if (!this.exclude(context)) {
            log.debug((Object)this.sm.getString("modcluster.context.stop", (Object)context.getPath(), (Object)context.getParent().getName()));
            MCMPRequest request = this.requestFactory.createStopRequest(context);
            this.mcmpHandler.sendRequest(request);
        }
    }

    @Override
    public void removeContext(Context context) {
        this.checkInit();
        if (!this.exclude(context) && Utils.getJvmRoute(context) != null) {
            log.debug((Object)this.sm.getString("modcluster.context.disable", (Object)context.getPath(), (Object)context.getParent().getName()));
            MCMPRequest request = this.requestFactory.createRemoveRequest(context);
            this.mcmpHandler.sendRequest(request);
        }
    }

    protected void removeAll(Engine engine) {
        if (engine.getJvmRoute() != null) {
            log.debug((Object)this.sm.getString("modcluster.engine.stop", (Object)engine.getName()));
            MCMPRequest request = this.requestFactory.createRemoveRequest(engine);
            this.mcmpHandler.sendRequest(request);
        }
    }

    @Override
    public void status(Engine engine) {
        this.checkInit();
        log.debug((Object)this.sm.getString("modcluster.engine.status", (Object)engine.getName()));
        this.mcmpHandler.status();
        int lbf = this.getLoadBalanceFactor();
        MCMPRequest request = this.requestFactory.createStatusRequest(engine.getJvmRoute(), lbf);
        this.mcmpHandler.sendRequest(request);
    }

    protected int getLoadBalanceFactor() {
        return this.loadBalanceFactorProvider.getLoadBalanceFactor();
    }

    protected void checkInit() {
        if (this.server == null) {
            throw new IllegalStateException(this.sm.getString("modcluster.error.uninitialized"));
        }
    }

    private boolean exclude(Context context) {
        Set<String> excludedPaths = this.excludedContextPaths.get(context.getParent().getName());
        return excludedPaths != null ? excludedPaths.contains(context.getPath()) : false;
    }
}

