/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.util.StringManager;
import org.apache.coyote.ProtocolHandler;
import org.apache.tomcat.util.IntrospectionUtils;
import org.jboss.logging.Logger;
import org.jboss.modcluster.Constants;
import org.jboss.modcluster.mcmp.MCMPHandler;
import org.jboss.modcluster.mcmp.MCMPURLEncoder;
import org.jboss.modcluster.mcmp.impl.MCMPJBURLEncoder;
import org.jboss.modcluster.mcmp.impl.MCMPTCURLEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    private static final String ROOT_CONTEXT = "ROOT";
    private static final String CONTEXT_DELIMITER = ",";
    private static final String HOST_CONTEXT_DELIMITER = ":";
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 8000;
    private static final Logger log = Logger.getLogger(Utils.class);
    private static final StringManager sm = StringManager.getManager((String)Constants.Package);
    private static final ServerType serverType = Utils.getServerType();

    private static ServerType getServerType() {
        for (Method method : Context.class.getMethods()) {
            if (!method.getName().equals("isStarted") || method.getParameterTypes().length != 0) continue;
            return ServerType.JBOSSWEB;
        }
        return ServerType.TOMCAT6;
    }

    public static Connector findProxyConnector(Connector[] connectors) {
        int highestMaxThreads = 0;
        Connector bestConnector = connectors[0];
        for (Connector connector : connectors) {
            if (Utils.isAJP(connector)) {
                return connector;
            }
            ProtocolHandler handler = connector.getProtocolHandler();
            if (Boolean.TRUE.equals(IntrospectionUtils.getProperty((Object)handler, (String)"reverseConnection"))) {
                return connector;
            }
            int maxThreads = (Integer)IntrospectionUtils.getProperty((Object)handler, (String)"maxThreads");
            if (maxThreads <= highestMaxThreads) continue;
            highestMaxThreads = maxThreads;
            bestConnector = connector;
        }
        return bestConnector;
    }

    public static boolean isAJP(Connector connector) {
        String protocol = connector.getProtocol();
        return protocol.startsWith("AJP") || protocol.startsWith("org.apache.coyote.ajp");
    }

    public static String getAddress(Connector connector) {
        Object address = IntrospectionUtils.getProperty((Object)connector.getProtocolHandler(), (String)"address");
        if (address == null) {
            return "127.0.0.1";
        }
        return address instanceof InetAddress ? ((InetAddress)address).getHostAddress() : (String)address;
    }

    public static String getJvmRoute(Context context) {
        return ((Engine)context.getParent().getParent()).getJvmRoute();
    }

    public static Set<String> getAliases(Context context) {
        return Utils.getAliases((Host)context.getParent());
    }

    public static Set<String> getAliases(Host host) {
        String name = host.getName();
        String[] aliases = host.findAliases();
        if (aliases.length == 0) {
            return Collections.singleton(name);
        }
        LinkedHashSet<String> hosts = new LinkedHashSet<String>();
        hosts.add(name);
        hosts.addAll(Arrays.asList(aliases));
        return hosts;
    }

    public static boolean isContextStarted(Context context) {
        return serverType == ServerType.TOMCAT6 ? true : context.isStarted();
    }

    public static MCMPURLEncoder createMCMPURLEncoder() {
        return serverType == ServerType.JBOSSWEB ? new MCMPJBURLEncoder() : new MCMPTCURLEncoder();
    }

    public static String defaultObjectNameDomain() {
        return serverType == ServerType.JBOSSWEB ? "jboss.web" : "Catalina";
    }

    public static void establishJvmRouteAndConnectorAddress(Engine engine, MCMPHandler mcmpHandler) throws IOException {
        Connector connector = Utils.findProxyConnector(engine.getService().findConnectors());
        InetAddress localAddress = (InetAddress)IntrospectionUtils.getProperty((Object)connector.getProtocolHandler(), (String)"address");
        if (!(engine.getJvmRoute() != null && localAddress != null || mcmpHandler.getProxyStates().isEmpty())) {
            if (localAddress == null) {
                localAddress = mcmpHandler.getLocalAddress();
                String hostAddress = localAddress != null ? localAddress.getHostAddress() : "127.0.0.1";
                IntrospectionUtils.setProperty((Object)connector.getProtocolHandler(), (String)"address", (String)hostAddress);
                log.info((Object)sm.getString("modcluster.util.address", (Object)hostAddress));
            }
            if (engine.getJvmRoute() == null) {
                String hostName = localAddress != null ? localAddress.getHostName() : "127.0.0.1";
                String jvmRoute = hostName + HOST_CONTEXT_DELIMITER + connector.getPort() + HOST_CONTEXT_DELIMITER + engine.getName();
                engine.setJvmRoute(jvmRoute);
                log.info((Object)sm.getString("modcluster.util.jvmRoute", (Object)engine.getName(), (Object)jvmRoute));
            }
        }
    }

    public static RuntimeException convertToUnchecked(Throwable t) {
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof RuntimeException) {
            return (RuntimeException)t;
        }
        return new RuntimeException(t.getMessage(), t);
    }

    public static InetSocketAddress parseSocketAddress(String addressPort) {
        try {
            return Utils.parseSocketAddress(addressPort, 0);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static List<InetSocketAddress> parseProxies(String proxyList) {
        if (proxyList == null || proxyList.length() == 0) {
            return Collections.emptyList();
        }
        String[] tokens = proxyList.split(CONTEXT_DELIMITER);
        ArrayList<InetSocketAddress> proxies = new ArrayList<InetSocketAddress>(tokens.length);
        for (String token : tokens) {
            try {
                InetSocketAddress addressPort = Utils.parseSocketAddress(token.trim(), 8000);
                proxies.add(addressPort);
            }
            catch (UnknownHostException e) {
                log.error((Object)sm.getString("modcluster.error.host.invalid", (Object)token), (Throwable)e);
            }
        }
        return proxies;
    }

    private static InetSocketAddress parseSocketAddress(String addressPort, int defaultPort) throws UnknownHostException {
        int pos = addressPort.indexOf(58);
        boolean colonExists = pos >= 0;
        String address = colonExists ? addressPort.substring(0, pos) : addressPort;
        int port = colonExists ? Integer.parseInt(addressPort.substring(pos + 1)) : defaultPort;
        InetAddress inetAddress = address != null && address.length() > 0 ? InetAddress.getByName(address) : null;
        return new InetSocketAddress(inetAddress, port);
    }

    public static Map<String, Set<String>> parseContexts(String contexts) {
        if (contexts == null) {
            return Collections.emptyMap();
        }
        String trimmedContexts = contexts.trim();
        if (trimmedContexts.length() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        for (String context : trimmedContexts.split(CONTEXT_DELIMITER)) {
            String[] parts = context.trim().split(HOST_CONTEXT_DELIMITER);
            if (parts.length > 2) {
                throw new IllegalArgumentException(trimmedContexts + " is not a valid value for excludedContexts");
            }
            String host = DEFAULT_HOST;
            String trimmedContext = parts[0].trim();
            if (parts.length == 2) {
                host = trimmedContext;
                trimmedContext = parts[1].trim();
            }
            String path = trimmedContext.equals(ROOT_CONTEXT) ? "" : "/" + trimmedContext;
            HashSet<String> paths = (HashSet<String>)map.get(host);
            if (paths == null) {
                paths = new HashSet<String>();
                map.put(host, paths);
            }
            paths.add(path);
        }
        return map;
    }

    public static Host findHost(Server server, String hostName) {
        String name = hostName != null ? hostName : DEFAULT_HOST;
        for (Service service : server.findServices()) {
            Container host = service.getContainer().findChild(name);
            if (host == null) continue;
            return (Host)host;
        }
        return null;
    }

    public static Host getHost(Server server, String hostName) {
        Host host = Utils.findHost(server, hostName);
        if (host == null) {
            throw new IllegalArgumentException(sm.getString("modcluster.error.host.notfound", (Object)hostName));
        }
        return host;
    }

    public static Context getContext(Host host, String path) {
        Container context = host.findChild(path);
        if (context == null) {
            throw new IllegalArgumentException(sm.getString("modcluster.error.context.notfound", (Object)host.getName(), (Object)path));
        }
        return (Context)context;
    }

    private Utils() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ServerType {
        JBOSSWEB,
        TOMCAT6;

    }
}

