/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.load.metric.impl;

import javax.management.AttributeNotFoundException;
import javax.management.JMException;
import javax.management.MalformedObjectNameException;
import org.jboss.logging.Logger;
import org.jboss.modcluster.load.metric.impl.MBeanLoadContext;
import org.jboss.modcluster.load.metric.impl.OperatingSystemLoadMetricSource;
import org.jboss.modcluster.load.metric.impl.SourcedLoadMetric;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemMemoryUsageLoadMetric
extends SourcedLoadMetric<MBeanLoadContext> {
    public static final String FREE_MEMORY = "FreePhysicalMemorySize";
    public static final String TOTAL_MEMORY = "TotalPhysicalMemorySize";
    private Logger logger = Logger.getLogger(this.getClass());

    public SystemMemoryUsageLoadMetric() throws MalformedObjectNameException {
        super(new OperatingSystemLoadMetricSource());
    }

    public SystemMemoryUsageLoadMetric(OperatingSystemLoadMetricSource source) {
        super(source);
    }

    @Override
    public double getLoad(MBeanLoadContext context) throws JMException {
        try {
            double free = context.getAttribute(FREE_MEMORY, Number.class).doubleValue();
            double total = context.getAttribute(TOTAL_MEMORY, Number.class).doubleValue();
            return free / total;
        }
        catch (AttributeNotFoundException e) {
            this.logger.warn((Object)(this.getClass().getSimpleName() + " requires com.sun.management.OperatingSystemMXBean."));
            this.setWeight(0);
            return 0.0;
        }
    }
}

