/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.mcmp.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPathParameters;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import javax.net.SocketFactory;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import org.apache.catalina.util.StringManager;
import org.jboss.logging.Logger;
import org.jboss.modcluster.config.SSLConfiguration;
import org.jboss.modcluster.mcmp.impl.JSSEKeyManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSSESocketFactory
extends SocketFactory {
    private static final StringManager sm = StringManager.getManager((String)"org.jboss.modcluster");
    static Logger log = Logger.getLogger(JSSESocketFactory.class);
    private SSLSocketFactory socketFactory = null;
    private String[] enabledCiphers;
    private SSLConfiguration config = null;

    public JSSESocketFactory(SSLConfiguration config) {
        this.config = config;
        try {
            SSLContext context = SSLContext.getInstance(this.config.getSslProtocol());
            KeyManager[] keyManagers = this.getKeyManagers();
            TrustManager[] trustManagers = this.getTrustManagers();
            context.init(keyManagers, trustManagers, new SecureRandom());
            this.socketFactory = context.getSocketFactory();
            String ciphers = this.config.getSslCiphers();
            this.enabledCiphers = ciphers != null ? JSSESocketFactory.getEnabled(ciphers, this.socketFactory.getSupportedCipherSuites()) : this.socketFactory.getDefaultCipherSuites();
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Socket createSocket() throws IOException {
        Socket socket = this.socketFactory.createSocket();
        this.initSocket(socket);
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        Socket socket = this.socketFactory.createSocket(host, port);
        this.initSocket(socket);
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        Socket socket = this.socketFactory.createSocket(address, port, localAddress, localPort);
        this.initSocket(socket);
        return socket;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException, UnknownHostException {
        Socket socket = this.socketFactory.createSocket(host, port, localAddress, localPort);
        this.initSocket(socket);
        return socket;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        Socket socket = this.socketFactory.createSocket(host, port);
        this.initSocket(socket);
        return socket;
    }

    public void handshake(Socket socket) throws IOException {
        if (!(socket instanceof SSLSocket)) {
            throw new IllegalArgumentException();
        }
        ((SSLSocket)socket).startHandshake();
    }

    private static String[] getEnabled(String requested, String[] supported) {
        if (requested == null) {
            return null;
        }
        HashSet<String> supportedSet = new HashSet<String>(Arrays.asList(supported));
        String[] tokens = requested.split(",");
        ArrayList<String> enabled = new ArrayList<String>(tokens.length);
        for (String token : tokens) {
            if ((token = token.trim()).length() <= 0 || !supportedSet.contains(token)) continue;
            enabled.add(token);
        }
        return !enabled.isEmpty() ? enabled.toArray(new String[enabled.size()]) : null;
    }

    private KeyStore getKeystore() throws IOException {
        return this.getStore(this.config.getSslKeyStoreType(), this.config.getSslKeyStoreProvider(), this.config.getSslKeyStore(), this.config.getSslKeyStorePass());
    }

    protected KeyStore getTrustStore() throws IOException {
        String truststoreProvider;
        String trustStore = this.config.getSslTrustStore();
        if (trustStore == null) {
            return null;
        }
        String truststorePassword = this.config.getSslTrustStorePassword();
        if (truststorePassword == null) {
            truststorePassword = this.config.getSslKeyStorePass();
        } else if (truststorePassword.equals("")) {
            truststorePassword = null;
        }
        String truststoreType = this.config.getSslTrustStoreType();
        if (truststoreType == null) {
            truststoreType = this.config.getSslKeyStoreType();
        }
        if ((truststoreProvider = this.config.getSslTrustStoreProvider()) == null) {
            truststoreProvider = this.config.getSslKeyStoreProvider();
        }
        return this.getStore(truststoreType, truststoreProvider, trustStore, truststorePassword);
    }

    private KeyStore getStore(String type, String provider, String path, String pass) throws IOException {
        InputStream istream = null;
        try {
            Object keyStoreFile;
            KeyStore ks;
            KeyStore keyStore = ks = provider == null ? KeyStore.getInstance(type) : KeyStore.getInstance(type, provider);
            if (!"PKCS11".equalsIgnoreCase(type) && !"".equals(path)) {
                keyStoreFile = new File(path);
                if (!((File)keyStoreFile).isAbsolute()) {
                    keyStoreFile = new File(System.getProperty("catalina.base"), path);
                }
                istream = new FileInputStream((File)keyStoreFile);
            }
            if (pass == null) {
                ks.load(istream, null);
            } else {
                ks.load(istream, pass.toCharArray());
            }
            keyStoreFile = ks;
            return keyStoreFile;
        }
        catch (IOException ioe) {
            log.error((Object)sm.getString("jsse.keystore_load_failed", (Object)type, (Object)path, (Object)ioe.getMessage()), (Throwable)ioe);
            throw ioe;
        }
        catch (GeneralSecurityException e) {
            String msg = sm.getString("jsse.keystore_load_failed", (Object)type, (Object)path, (Object)e.getMessage());
            log.error((Object)msg, (Throwable)e);
            throw new IOException(msg);
        }
        finally {
            if (istream != null) {
                try {
                    istream.close();
                }
                catch (IOException e) {
                    log.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    protected KeyManager[] getKeyManagers() throws GeneralSecurityException, IOException {
        KeyStore ks = this.getKeystore();
        String alias = this.config.getSslKeyAlias();
        if (alias != null && !ks.isKeyEntry(alias)) {
            throw new IOException(sm.getString("jsse.alias_no_key_entry", (Object)alias));
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(this.config.getSslCertificateEncodingAlgorithm());
        kmf.init(ks, this.config.getSslKeyStorePass().toCharArray());
        KeyManager[] kms = kmf.getKeyManagers();
        if (alias != null) {
            if ("JKS".equals(this.config.getSslKeyStoreType())) {
                alias = alias.toLowerCase();
            }
            for (int i = 0; i < kms.length; ++i) {
                kms[i] = new JSSEKeyManager((X509KeyManager)kms[i], alias);
            }
        }
        return kms;
    }

    protected TrustManager[] getTrustManagers() throws GeneralSecurityException, IOException {
        KeyStore trustStore = this.getTrustStore();
        if (trustStore == null) {
            return null;
        }
        String algorithm = this.config.getSslTrustAlgorithm();
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
        if (this.config.getSslCrlFile() == null) {
            tmf.init(trustStore);
            return tmf.getTrustManagers();
        }
        CertPathParameters params = this.getParameters(algorithm, this.config.getSslCrlFile(), trustStore);
        CertPathTrustManagerParameters mfp = new CertPathTrustManagerParameters(params);
        tmf.init(mfp);
        return tmf.getTrustManagers();
    }

    protected CertPathParameters getParameters(String algorithm, String crlf, KeyStore trustStore) throws GeneralSecurityException, IOException {
        if (!"PKIX".equalsIgnoreCase(algorithm)) {
            throw new CRLException("CRLs not supported for type: " + algorithm);
        }
        PKIXBuilderParameters params = new PKIXBuilderParameters(trustStore, (CertSelector)new X509CertSelector());
        Collection<? extends CRL> crls = this.getCRLs(crlf);
        CollectionCertStoreParameters csp = new CollectionCertStoreParameters(crls);
        CertStore store = CertStore.getInstance("Collection", csp);
        params.addCertStore(store);
        params.setRevocationEnabled(true);
        params.setMaxPathLength(this.config.getSslTrustMaxCertLength());
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<? extends CRL> getCRLs(String crlf) throws FileNotFoundException, GeneralSecurityException {
        File crlFile = new File(crlf);
        if (!crlFile.isAbsolute()) {
            crlFile = new File(System.getProperty("catalina.base"), crlf);
        }
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        FileInputStream is = new FileInputStream(crlFile);
        try {
            Collection<? extends CRL> collection = cf.generateCRLs(is);
            return collection;
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (Exception e) {
                log.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void initSocket(Socket ssocket) {
        String[] protocols;
        SSLSocket socket = (SSLSocket)ssocket;
        if (this.enabledCiphers != null) {
            socket.setEnabledCipherSuites(this.enabledCiphers);
        }
        if ((protocols = JSSESocketFactory.getEnabled(this.config.getSslProtocol(), socket.getSupportedProtocols())) != null) {
            socket.setEnabledProtocols(protocols);
        }
    }
}

